/*
 *	DP83815 Register #defines
 *
 *	Created: 12/10/02 
 *	By: Antonio Carpio
 *	E-Mail: BolivianTONE@nc.rr.com
 *
 *	This file is free to be used for anything by anyone at anytime
 *
 */


#ifndef _DP83815_REGISTER_DEFINITIONS_H_
#define _DP83815_REGISTER_DEFINITIONS_H_




#define REG_PMSCR	0x0044



#define REG_CR		0x0000
#define REG_CFG		0x0004
#define REG_MEAR	0x0008
#define REG_ISR		0x0010
#define REG_IMR		0x0014
#define REG_IER		0x0018
#define REG_TXDP	0x0020
#define REG_TXCFG	0x0024
#define REG_RXDP	0x0030
#define REG_RXCFG	0x0034
#define REG_CCSR	0x003c
#define REG_WCSR	0x0040
#define REG_RFCR	0x0048
#define REG_RFDR	0x004c
#define REG_MIBC	0x005c
#define REG_SRR		0x0058

#define REG_BMCR	0x0080

#define CR_RST	0x00000100
#define CR_SWI	0x00000080
#define CR_RXR	0x00000020
#define CR_TXR	0x00000010
#define CR_RXD	0x00000008
#define CR_RXE	0x00000004
#define CR_TXD	0x00000002
#define CR_TXE	0x00000001


#define TXCFG_CSI		0x80000000
#define TXCFG_HBI		0x40000000
#define TXCFG_MLB 		0x20000000
#define TXCFG_ATP		0x10000000

#define TXCFG_MXDMA_256	0x00700000
#define TXCFG_MXDMA_128	0x00600000
#define TXCFG_MXDMA_64	0x00500000
#define TXCFG_MXDMA_32	0x00400000
#define TXCFG_MXDMA_16	0x00300000
#define TXCFG_MXDMA_8	0x00200000
#define TXCFG_MXDMA_4	0x00100000
#define TXCFG_MXDMA_512	0x00000000
#define TXCFG_FLTH(a)	((a&0x0000001F)<<8)
#define TXCFG_DRTH(a)	((a&0x0000001F)<<0)

#define RXCFG_AEP		0x80000000
#define RXCFG_ARP		0x40000000
#define RXCFG_ATP		0x10000000
#define RXCFG_ALP		0x08000000

#define RXCFG_DRTH(a)	((a&0x0000001F)<<1)


#define DESC_OWN	0x80000000
#define DESC_MORE	0x40000000
#define DESC_INTR	0x20000000
#define DESC_CRC	0x10000000
#define DESC_OK		0x08000000
#define DESC_LENGTH	0x00000FFF

#define DESC_TXA	0x04000000
#define DESC_TFU	0x02000000
#define DESC_CRS	0x01000000
#define DESC_TD		0x00800000
#define DESC_ED		0x00400000
#define DESC_OWC	0x00200000
#define DESC_EC		0x00100000
#define DESC_CCNT	0x000F0000

#define DESC_RXA	0x04000000
#define DESC_RXO	0x02000000
#define DESC_DEST	0x01800000
#define DESC_LONG	0x00400000
#define DESC_RUNT	0x00200000
#define DESC_ISE	0x00100000
#define DESC_CRCE	0x00080000
#define DESC_FAE	0x00040000
#define DESC_LBP	0x00020000
#define DESC_COL	0x00010000





#define ISR_TXRCMP	0x02000000
#define ISR_RXRCMP	0x01000000
#define ISR_DPERR	0x00800000
#define ISR_SSERR	0x00400000
#define ISR_RMABT	0x00200000
#define ISR_RTABT	0x00100000
#define ISR_RXSOVR	0x00010000
#define ISR_HIBERR	0x00008000
#define ISR_PHY		0x00004000
#define ISR_PME		0x00002000
#define ISR_SWI		0x00001000
#define ISR_MIB		0x00000800
#define ISR_TXURN	0x00000400
#define ISR_TXIDLE	0x00000200
#define ISR_TXERR	0x00000100
#define	ISR_TXDESC	0x00000080
#define ISR_TXOK	0x00000040
#define ISR_RXORN	0x00000020
#define ISR_RXIDLE	0x00000010
#define ISR_RXEARLY	0x00000008
#define ISR_RXERR	0x00000004
#define ISR_RXDESC	0x00000002
#define ISR_RXOK	0x00000001

#define RFCR_RFEN	0x80000000
#define RFCR_AAB	0x40000000
#define RFCR_AAM	0x20000000
#define RFCR_AAU	0x10000000
#define RFCR_AARP	0x00400000

#define BMCR_ANE	0x1000
#define BMCR_ANR	0x0200


#endif