/*
 * @(#)ScriptGeneratorUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1;

import java.awt.Robot;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import net.sourceforge.groboutils.uicapture.v1.event.*;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.easymock.EasyMock;
import org.easymock.MockControl;


/**
 * Tests the ScriptGenerator class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:34 $
 * @since     Oct 3, 2002
 */
public class ScriptGeneratorUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = ScriptGeneratorUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public ScriptGeneratorUTest( String name )
    {
        super( name );
    }


    private MockControl scriptmakerControl;
    private IScriptMaker mockScriptmaker;

    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
        this.scriptmakerControl = EasyMock.controlFor( IScriptMaker.class );
        this.mockScriptmaker = (IScriptMaker)this.scriptmakerControl.getMock();
    }
    

    //-------------------------------------------------------------------------
    // Tests
    
    public void testInstantiation()
    {
        new ScriptGenerator( null, null, null, null );
    }
    
    
    public void testMouseWheelMovedNotStarted()
    {
        DOC.getIT().testsIssue( 618314 );
        
        // no method should be called in the scriptmaker.
        //this.mockScriptmaker.removeText("Text");
        //this.scriptmakerControl.setVoidCallable();
        
        this.scriptmakerControl.activate();
        ScriptGenerator sg = new ScriptGenerator( null, null,
            this.mockScriptmaker, "base" );
        MouseWheelCaptureEvent mwce = new MouseWheelCaptureEvent( 10 );
        
        
        sg.mouseWheelMoved( mwce );
        
        
        this.scriptmakerControl.verify();
    }
    
    
    
    


    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

