/*
 *  @(#)IPath.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1;


/**
 * An ordered set of transitions plus a start state, which can be iterated
 * through to discover a state-machine transition path.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:24 $
 * @since      June 12, 2002
 */
public interface IPath
{
    /**
     * Generate an iterator for this path.  The iterator will only return
     * transition elements.
     *
     * @return a new iterator for the path.
     */
    public IPathIterator iterator();
    
    
    /**
     * Retrieve the starting state for this path.
     *
     * @return the start state for the path, which can never be <tt>null</tt>.
     */
    public IState getStartState();
    
    
    /**
     * Returns the number of transitions in the path.  This is named "size" to
     * correspond to the <tt>java.util</tt>
     * container classes terminology.
     *
     * @return the path transition count.
     */
    public int size();
    
    
    /**
     * Returns the number of states visited in the path, which should
     * always equal <tt>size() + 2</tt>, due to the start and final states,
     * unless there are no transitions, in which case the depth is 1
     * (there must always be a start state).
     *
     * @return the depth of the path.
     */
    public int getDepth();
}

