/*
 * @(#)DirMetaDataIOUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.File;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.IAnalysisModule;


/**
 * Tests the DirMetaDataIO class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     January 22, 2003
 */
public class DirMetaDataIOUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = DirMetaDataIOUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public DirMetaDataIOUTest( String name )
    {
        super( name );
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        // fail( "Needs more tests." );
    }
    
    
    public void testGetAnalysisModuleSet1() throws IOException
    {
        // ensure that working off a non-empy file doesn't kill us
        File f = CCCreatorUtil.createNewDirectory();
        DirMetaDataIO dmd = new DirMetaDataIO( f );
        AnalysisModuleSet ams = dmd.getAnalysisModuleSet();
        assertEquals(
            "Somehow we created data from nothing.",
            0,
            ams.getAnalysisModuleCount() );
    }
    
    
    public void testPutAnalysisModuleSet1() throws IOException
    {
        // ensure that working off a brand-new file doesn't kill us.
        File f = CCCreatorUtil.createNewDirectory();
        AnalysisModuleSet ams = CCCreatorUtil.createAnalysisModuleSet( 4 );
        DirMetaDataIO dmd = new DirMetaDataIO( f );
        dmd.getAnalysisModuleSet();
        dmd.putAnalysisModuleSet( ams );
        AnalysisModuleSet ams2 = dmd.getAnalysisModuleSet();
        assertEquals(
            "Didn't recreate the four modules.",
            4,
            ams2.getAnalysisModuleCount() );
    }
    
    
    public void testPutAnalysisModuleSet2() throws IOException
    {
        // ensure that working off a brand-new file doesn't kill us.
        File f = CCCreatorUtil.createNewDirectory();
        IAnalysisModule am = CCCreatorUtil.createIAnalysisModule( "a", "u",
            "text/plain" );
        DirMetaDataIO dmd = new DirMetaDataIO( f );
        dmd.getAnalysisModuleSet();
        dmd.putAnalysisModuleSet( new AnalysisModuleSet(
            new IAnalysisModule[] { am } ) );
        AnalysisModuleSet ams = dmd.getAnalysisModuleSet();
        assertEquals(
            "Didn't recreate the one module.",
            1,
            ams.getAnalysisModuleCount() );
        assertTrue(
            "Bad module index.",
            ams.getAnalysisModuleIndex( am ) >= 0 );
        assertTrue(
            "Bad measure index.",
            ams.getMeasureIndex( "a" ) >= 0 );
    }
    
    
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();

       
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

