/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;

/**
 * This exception is used to indicate the use of the HTTP protocol was 
 * incorrect.
 */
public class HttpException
	extends IOException
{
	
	private static final long serialVersionUID = 3976891853888098317L;

	/**
	 * Construct a new HttpException with a message.
	 * @param message explaination
	 */
	public HttpException(String message) {
		super(message);
	}

	/**
	 * Construct a new HttpException with no message.
	 */
	public HttpException() {
		super();
	}

	/**
	 * Construct a new HttpException with cause.
	 */
	public HttpException(Exception e) {
		initCause(e);
	}
}
