/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.number.NamedTimeZone;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

public class FormatDate
extends SystemFunction {
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^,]*)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
    private static Pattern alphanumericPattern = Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");
    private static Pattern digitsPattern = Pattern.compile("\\p{Nd}*");

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        int numArgs = this.argument.length;
        if (numArgs != 2 && numArgs != 5) {
            throw new XPathException("Function " + this.getDisplayName() + " must have either two or five arguments", this);
        }
        super.checkArguments(visitor);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String cal;
        CalendarValue value = (CalendarValue)this.argument[0].evaluateItem(context);
        if (value == null) {
            return null;
        }
        String format = this.argument[1].evaluateItem(context).getStringValue();
        StringValue calendarVal = null;
        AtomicValue countryVal = null;
        AtomicValue languageVal = null;
        if (this.argument.length > 2) {
            languageVal = (StringValue)this.argument[2].evaluateItem(context);
            calendarVal = (StringValue)this.argument[3].evaluateItem(context);
            countryVal = (StringValue)this.argument[4].evaluateItem(context);
        }
        Configuration config = context.getConfiguration();
        String language = languageVal == null ? config.getDefaultLanguage() : languageVal.getStringValue();
        String country = countryVal == null ? config.getDefaultCountry() : countryVal.getStringValue();
        CharSequence result = FormatDate.formatDate(value, format, language, country, context);
        if (calendarVal != null && !(cal = calendarVal.getStringValue()).equals("AD") && !cal.equals("ISO")) {
            result = "[Calendar: AD]" + ((Object)result).toString();
        }
        return new StringValue(result);
    }

    private static CharSequence formatDate(CalendarValue value, String format, String language, String country, XPathContext context) throws XPathException {
        Numberer numberer = context.getConfiguration().makeNumberer(language, country);
        FastStringBuffer sb = new FastStringBuffer(64);
        if (numberer.getClass() == Numberer_en.class && !"en".equals(language)) {
            sb.append("[Language: en]");
        }
        int i = 0;
        while (true) {
            int close;
            if (i < format.length() && format.charAt(i) != '[') {
                sb.append(format.charAt(i));
                if (format.charAt(i) == ']' && (++i == format.length() || format.charAt(i) != ']')) {
                    XPathException e = new XPathException("Closing ']' in date picture must be written as ']]'");
                    e.setErrorCode("XTDE1340");
                    e.setXPathContext(context);
                    throw e;
                }
                ++i;
                continue;
            }
            if (i == format.length()) break;
            if (++i < format.length() && format.charAt(i) == '[') {
                sb.append('[');
                ++i;
                continue;
            }
            int n = close = i < format.length() ? format.indexOf("]", i) : -1;
            if (close == -1) {
                XPathException e = new XPathException("Date format contains a '[' with no matching ']'");
                e.setErrorCode("XTDE1340");
                e.setXPathContext(context);
                throw e;
            }
            String componentFormat = format.substring(i, close);
            sb.append(FormatDate.formatComponent(value, Whitespace.removeAllWhitespace(componentFormat), numberer, context));
            i = close + 1;
        }
        return sb;
    }

    private static CharSequence formatComponent(CalendarValue value, CharSequence specifier, Numberer numberer, XPathContext context) throws XPathException {
        boolean ignoreDate = value instanceof TimeValue;
        boolean ignoreTime = value instanceof DateValue;
        DateTimeValue dtvalue = value.toDateTime();
        Matcher matcher = componentPattern.matcher(specifier);
        if (!matcher.matches()) {
            XPathException error = new XPathException("Unrecognized date/time component [" + specifier + ']');
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        String component = matcher.group(1);
        String format = matcher.group(2);
        if (format == null) {
            format = "";
        }
        boolean defaultFormat = false;
        if ("".equals(format) || format.startsWith(",")) {
            defaultFormat = true;
            switch (component.charAt(0)) {
                case 'F': {
                    format = "Nn" + format;
                    break;
                }
                case 'P': {
                    format = 'n' + format;
                    break;
                }
                case 'C': 
                case 'E': {
                    format = 'N' + format;
                    break;
                }
                case 'm': 
                case 's': {
                    format = "01" + format;
                    break;
                }
                default: {
                    format = '1' + format;
                }
            }
        }
        switch (component.charAt(0)) {
            case 'Y': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a year component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                if (year < 0) {
                    year = 1 - year;
                }
                return FormatDate.formatNumber(component, year, format, defaultFormat, numberer, context);
            }
            case 'M': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a month component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte month = dtvalue.getMonth();
                return FormatDate.formatNumber(component, month, format, defaultFormat, numberer, context);
            }
            case 'D': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a day component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                byte day = dtvalue.getDay();
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'd': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain a day component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayWithinYear(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'W': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumber(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 'w': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): cannot obtain the week number from an xs:time value");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int week = DateValue.getWeekNumberWithinMonth(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, week, format, defaultFormat, numberer, context);
            }
            case 'H': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an hour component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(4);
                return FormatDate.formatNumber(component, (int)hour.longValue(), format, defaultFormat, numberer, context);
            }
            case 'h': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an hour component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value hour = (Int64Value)value.getComponent(4);
                int hr = (int)hour.longValue();
                if (hr > 12) {
                    hr -= 12;
                }
                if (hr == 0) {
                    hr = 12;
                }
                return FormatDate.formatNumber(component, hr, format, defaultFormat, numberer, context);
            }
            case 'm': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a minutes component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                Int64Value min = (Int64Value)value.getComponent(5);
                return FormatDate.formatNumber(component, (int)min.longValue(), format, defaultFormat, numberer, context);
            }
            case 's': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a seconds component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                IntegerValue sec = (IntegerValue)value.getComponent(12);
                return FormatDate.formatNumber(component, (int)sec.longValue(), format, defaultFormat, numberer, context);
            }
            case 'f': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain a fractional seconds component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int micros = (int)((Int64Value)value.getComponent(11)).longValue();
                return FormatDate.formatNumber(component, micros, format, defaultFormat, numberer, context);
            }
            case 'Z': {
                if (value.hasTimezone()) {
                    return FormatDate.getNamedTimeZone(value.toDateTime(), numberer.getCountry(), format);
                }
                return "";
            }
            case 'z': {
                if (value.hasTimezone()) {
                    int tz = value.getTimezoneInMinutes();
                    return "GMT" + (tz == 0 ? "" : (tz > 0 ? "+" : "-") + Math.abs(tz / 60) + (tz % 60 == 0 ? "" : ".5"));
                }
                return "";
            }
            case 'F': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain day-of-week component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int day = DateValue.getDayOfWeek(dtvalue.getYear(), dtvalue.getMonth(), dtvalue.getDay());
                return FormatDate.formatNumber(component, day, format, defaultFormat, numberer, context);
            }
            case 'P': {
                if (ignoreTime) {
                    XPathException error = new XPathException("In formatDate(): an xs:date value does not contain an am/pm component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int minuteOfDay = dtvalue.getHour() * 60 + dtvalue.getMinute();
                return FormatDate.formatNumber(component, minuteOfDay, format, defaultFormat, numberer, context);
            }
            case 'C': {
                return numberer.getCalendarName("AD");
            }
            case 'E': {
                if (ignoreDate) {
                    XPathException error = new XPathException("In formatTime(): an xs:time value does not contain an AD/BC component");
                    error.setErrorCode("XTDE1350");
                    error.setXPathContext(context);
                    throw error;
                }
                int year = dtvalue.getYear();
                return numberer.getEraName(year);
            }
        }
        XPathException e = new XPathException("Unknown formatDate/time component specifier '" + format.charAt(0) + '\'');
        e.setErrorCode("XTDE1340");
        e.setXPathContext(context);
        throw e;
    }

    private static CharSequence formatNumber(String component, int value, String format, boolean defaultFormat, Numberer numberer, XPathContext context) throws XPathException {
        Matcher matcher = formatPattern.matcher(format);
        if (!matcher.matches()) {
            XPathException error = new XPathException("Unrecognized format picture [" + component + format + ']');
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        String primary = matcher.group(1);
        String modifier = null;
        if (primary.endsWith("t")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "t";
        } else if (primary.endsWith("o")) {
            primary = primary.substring(0, primary.length() - 1);
            modifier = "o";
        }
        String letterValue = "t".equals(modifier) ? "traditional" : null;
        String ordinal = "o".equals(modifier) ? numberer.getOrdinalSuffixForDateTime(component) : null;
        String widths = matcher.group(2);
        if (!alphanumericPattern.matcher(primary).matches()) {
            XPathException error = new XPathException("In format picture at '" + primary + "', primary format must be alphanumeric");
            error.setErrorCode("XTDE1340");
            error.setXPathContext(context);
            throw error;
        }
        int min = 1;
        int max = Integer.MAX_VALUE;
        if (widths == null || "".equals(widths)) {
            int len;
            if (digitsPattern.matcher(primary).matches() && (len = StringValue.getStringLength(primary)) > 1) {
                min = len;
                max = len;
            }
        } else if (primary.equals("I") || primary.equals("i")) {
            min = 1;
            max = Integer.MAX_VALUE;
        } else {
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
            max = range[1];
            if (defaultFormat && primary.endsWith("1") && min != primary.length()) {
                FastStringBuffer sb = new FastStringBuffer(min + 1);
                for (int i = 1; i < min; ++i) {
                    sb.append('0');
                }
                sb.append('1');
                primary = sb.toString();
            }
        }
        if ("P".equals(component)) {
            if (!("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary))) {
                primary = "n";
            }
            if (max == Integer.MAX_VALUE) {
                max = 4;
            }
        } else if ("f".equals(component)) {
            String s;
            if (value == 0) {
                s = "0";
            } else {
                s = (1000000 + value + "").substring(1);
                if (s.length() > max) {
                    DecimalValue dec = new DecimalValue(new BigDecimal("0." + s));
                    s = (dec = (DecimalValue)dec.roundHalfToEven(max)).getStringValue();
                    s = s.length() > 2 ? s.substring(2) : "";
                }
            }
            while (s.length() < min) {
                s = s + '0';
            }
            while (s.length() > min && s.charAt(s.length() - 1) == '0') {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
        if ("N".equals(primary) || "n".equals(primary) || "Nn".equals(primary)) {
            String s = "";
            if ("M".equals(component)) {
                s = numberer.monthName(value, min, max);
            } else if ("F".equals(component)) {
                s = numberer.dayName(value, min, max);
            } else if ("P".equals(component)) {
                s = numberer.halfDayName(value, min, max);
            } else {
                primary = "1";
            }
            if ("N".equals(primary)) {
                return s.toUpperCase();
            }
            if ("n".equals(primary)) {
                return s.toLowerCase();
            }
            return s;
        }
        String s = numberer.format(value, primary, 0, ",", letterValue, ordinal);
        int len = StringValue.getStringLength(s);
        while (len < min) {
            s = ("00000000" + s).substring(s.length() + 8 - min);
            len = StringValue.getStringLength(s);
        }
        if (len > max && component.charAt(0) == 'Y') {
            s = len == s.length() ? s.substring(s.length() - max) : s.substring(s.length() - 2 * max);
        }
        return s;
    }

    private static int[] getWidths(String widths) throws XPathException {
        try {
            int min = -1;
            int max = -1;
            if (!"".equals(widths)) {
                Matcher widthMatcher = widthPattern.matcher(widths);
                if (widthMatcher.matches()) {
                    String smin = widthMatcher.group(1);
                    min = smin == null || "".equals(smin) || "*".equals(smin) ? 1 : Integer.parseInt(smin);
                    String smax = widthMatcher.group(3);
                    max = smax == null || "".equals(smax) || "*".equals(smax) ? Integer.MAX_VALUE : Integer.parseInt(smax);
                } else {
                    XPathException error = new XPathException("Unrecognized width specifier");
                    error.setErrorCode("XTDE1340");
                    throw error;
                }
            }
            if (min > max && max != -1) {
                XPathException e = new XPathException("Minimum width in date/time picture exceeds maximum width");
                e.setErrorCode("XTDE1340");
                throw e;
            }
            int[] result = new int[]{min, max};
            return result;
        }
        catch (NumberFormatException err) {
            XPathException e = new XPathException("Invalid integer used as width in date/time picture");
            e.setErrorCode("XTDE1340");
            throw e;
        }
    }

    private static String getNamedTimeZone(DateTimeValue value, String country, String format) throws XPathException {
        int min = 1;
        int comma = format.indexOf(44);
        if (comma > 0) {
            String widths = format.substring(comma);
            int[] range = FormatDate.getWidths(widths);
            min = range[0];
        }
        if (format.charAt(0) == 'N' || format.charAt(0) == 'n') {
            if (min <= 5) {
                String tzname = NamedTimeZone.getTimeZoneNameForDate(value, country);
                if (format.charAt(0) == 'n') {
                    tzname = tzname.toLowerCase();
                }
                return tzname;
            }
            return NamedTimeZone.getOlsenTimeZoneName(value, country);
        }
        FastStringBuffer sbz = new FastStringBuffer(8);
        value.appendTimezone(sbz);
        return sbz.toString();
    }
}

