/*
 * unity-webapps-action-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#include "unity-webapps-indicator-view.h"

#include "../unity-webapps-debug.h"

G_DEFINE_ABSTRACT_TYPE(UnityWebappsIndicatorView, unity_webapps_indicator_view, G_TYPE_OBJECT)

struct _UnityWebappsIndicatorViewPrivate {
  UnityWebappsIndicatorModel *model;
};

enum 
{
  PROP_0,
  PROP_INDICATOR_MODEL
};

enum {
  SERVER_RAISED,
  INDICATOR_RAISED,
  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

#define UNITY_WEBAPPS_INDICATOR_VIEW_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_INDICATOR_VIEW, UnityWebappsIndicatorViewPrivate))


static void
unity_webapps_indicator_view_finalize (GObject *object)
{

}

static void
unity_webapps_indicator_view_dispose (GObject *object)
{
  UnityWebappsIndicatorView *indicator_view;
  
  indicator_view = UNITY_WEBAPPS_INDICATOR_VIEW (object);
  
  if (indicator_view->priv->model)
    g_object_unref (G_OBJECT (indicator_view->priv->model));
}

static void
unity_webapps_indicator_view_get_property (GObject *object, guint prop_id,
					   GValue *value, GParamSpec *pspec)
{
  UnityWebappsIndicatorView *self;
  
  self = UNITY_WEBAPPS_INDICATOR_VIEW (object);
  
  switch (prop_id)
    {
    case PROP_INDICATOR_MODEL:
      g_value_set_object (value, self->priv->model);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
unity_webapps_indicator_view_indicator_added (UnityWebappsIndicatorModel *model,
					      const gchar *name,
					      gpointer user_data)
{
  UnityWebappsIndicatorView *view;
  
  view = (UnityWebappsIndicatorView *)user_data;
  
  unity_webapps_indicator_view_show_indicator (view, name);
}

static void
unity_webapps_indicator_view_indicator_removed (UnityWebappsIndicatorModel *model,
						const gchar *name,
						gpointer user_data)
{
  UnityWebappsIndicatorView *view;
  
  view = (UnityWebappsIndicatorView *)user_data;
  
  unity_webapps_indicator_view_clear_indicator (view, name);
}

static void
unity_webapps_indicator_view_indicator_property_changed (UnityWebappsIndicatorModel *model,
							 const gchar *indicator_name,
							 const gchar *property_name,
							 GVariant *value,
							 gboolean draw_attention, 
							 gpointer user_data)
{
  UnityWebappsIndicatorView *view;
  
  view = (UnityWebappsIndicatorView *)user_data;
  
  unity_webapps_indicator_view_set_indicator_property (view, indicator_name, property_name, value, draw_attention);
}

static void
unity_webapps_indicator_view_setup_model (UnityWebappsIndicatorView *self)
{
  g_signal_connect_object (self->priv->model,
			   "indicator-added",
			   G_CALLBACK (unity_webapps_indicator_view_indicator_added),
			   self, 0);
  g_signal_connect_object (self->priv->model,
			   "indicator-removed",
			   G_CALLBACK (unity_webapps_indicator_view_indicator_removed),
			   self, 0);
  g_signal_connect_object (self->priv->model,
			   "indicator-property-changed",
			   G_CALLBACK (unity_webapps_indicator_view_indicator_property_changed),
			   self, 0);
}

static void
unity_webapps_indicator_view_set_property (GObject *object, guint prop_id,
					   const GValue *value, GParamSpec *pspec)
{
  UnityWebappsIndicatorView *self;
  
  self = UNITY_WEBAPPS_INDICATOR_VIEW (object);
  
  switch (prop_id)
    {
    case PROP_INDICATOR_MODEL:
      g_return_if_fail (self->priv->model == NULL);
      self->priv->model = g_value_dup_object (value);

      unity_webapps_indicator_view_setup_model (self);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
unity_webapps_indicator_view_class_init (UnityWebappsIndicatorViewClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  object_class->finalize = unity_webapps_indicator_view_finalize;
  object_class->dispose = unity_webapps_indicator_view_dispose;
  
  object_class->get_property = unity_webapps_indicator_view_get_property;
  object_class->set_property = unity_webapps_indicator_view_set_property;
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsIndicatorViewPrivate));
  
  signals[SERVER_RAISED] = g_signal_new("server-raised",
					UNITY_WEBAPPS_TYPE_INDICATOR_VIEW,
					G_SIGNAL_RUN_LAST,
					0,
					NULL,
					NULL,
					NULL,
					G_TYPE_NONE,
					0);
  signals[INDICATOR_RAISED] = g_signal_new("indicator-raised",
					   UNITY_WEBAPPS_TYPE_INDICATOR_VIEW,
					   G_SIGNAL_RUN_LAST,
					   0,
					   NULL,
					   NULL,
					   NULL,
					   G_TYPE_NONE,
					   1,
					   G_TYPE_STRING);
					   
  
  g_object_class_install_property (object_class, PROP_INDICATOR_MODEL,
				   g_param_spec_object ("model",
							"Model",
							"The UnityWebappsIndicatorModel for the view",
							UNITY_WEBAPPS_TYPE_INDICATOR_MODEL,
							G_PARAM_READWRITE |
							G_PARAM_CONSTRUCT_ONLY |
							G_PARAM_STATIC_STRINGS));
}

static void
unity_webapps_indicator_view_init (UnityWebappsIndicatorView *view)
{
  view->priv = UNITY_WEBAPPS_INDICATOR_VIEW_GET_PRIVATE (view);
}

void
unity_webapps_indicator_view_show (UnityWebappsIndicatorView *self)
{
  g_return_if_fail (UNITY_WEBAPPS_IS_INDICATOR_VIEW (self));
  
  if (UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->show)
    {
      UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->show(self);
    }
}

void
unity_webapps_indicator_view_show_indicator (UnityWebappsIndicatorView *self, const gchar *name)
{
  g_return_if_fail (UNITY_WEBAPPS_IS_INDICATOR_VIEW (self));
  
  if (UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->show_indicator)
    {
      UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->show_indicator (self, name);
    }
}

void
unity_webapps_indicator_view_clear_indicator (UnityWebappsIndicatorView *self, const gchar *name)
{
  g_return_if_fail (UNITY_WEBAPPS_IS_INDICATOR_VIEW (self));

  if (UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->clear_indicator)
    {
      UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->clear_indicator (self, name);
    }
}

void 
unity_webapps_indicator_view_set_indicator_property (UnityWebappsIndicatorView *self, const gchar *indicator_name,
						     const gchar *property_name, GVariant *value, gboolean draw_attention)
{
  g_return_if_fail (UNITY_WEBAPPS_IS_INDICATOR_VIEW (self));

  if (UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->set_indicator_property)
    {
      UNITY_WEBAPPS_INDICATOR_VIEW_GET_CLASS (self)->set_indicator_property (self, indicator_name, property_name, value, draw_attention);
    }
}
