/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.ByteArrayOutputStream;

public final class MimeBase64Decoder {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private byte[] token = new byte[4];
    private byte[] bytes = new byte[3];
    private int token_length = 0;
    private static final byte NUL = 127;
    private static final byte EOF = 126;
    private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

    private void decode_token() {
        int n = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
        this.bytes[0] = (byte)(0xFF & n >> 16);
        this.bytes[1] = (byte)(0xFF & n >> 8);
        this.bytes[2] = (byte)(0xFF & n);
        this.out.write(this.bytes, 0, 3);
    }

    private final void decode_final_token() {
        byte by = this.token[0];
        byte by2 = this.token[1];
        byte by3 = this.token[2];
        byte by4 = this.token[3];
        int n = 0;
        if (by == 126) {
            by = 0;
            ++n;
        }
        if (by2 == 126) {
            by2 = 0;
            ++n;
        }
        if (by3 == 126) {
            by3 = 0;
            ++n;
        }
        if (by4 == 126) {
            by4 = 0;
            ++n;
        }
        int n2 = by << 18 | by2 << 12 | by3 << 6 | by4;
        this.out.write((byte)(n2 >> 16));
        if (n <= 1) {
            this.out.write((byte)(n2 >> 8 & 0xFF));
            if (n == 0) {
                this.out.write((byte)(n2 & 0xFF));
            }
        }
    }

    public final void translate(char[] cArray, int n, int n2) {
        if (this.token == null) {
            return;
        }
        int n3 = n;
        while (n3 < n + n2) {
            byte by = map[cArray[n3] & 0xFF];
            if (by == 126) {
                this.eof();
            } else if (by != 127) {
                this.token[this.token_length++] = by;
            }
            if (this.token_length == 4) {
                this.decode_token();
                this.token_length = 0;
            }
            ++n3;
        }
    }

    public final void translate(String string) {
        if (this.token == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            byte by = map[string.charAt(n2) & 0xFF];
            if (by == 126) {
                this.eof();
            } else if (by != 127) {
                this.token[this.token_length++] = by;
            }
            if (this.token_length == 4) {
                this.decode_token();
                this.token_length = 0;
            }
            ++n2;
        }
    }

    private void eof() {
        if (this.token != null && this.token_length != 0) {
            while (this.token_length < 4) {
                this.token[this.token_length++] = 126;
            }
            this.decode_final_token();
        }
        this.token_length = 0;
        this.token = new byte[4];
        this.bytes = new byte[3];
    }

    public byte[] getByteArray() {
        this.eof();
        return this.out.toByteArray();
    }
}

