/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicUserDefinedValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class CastableExpression
extends ComputedExpression {
    Expression source;
    AtomicType targetType;
    boolean allowEmpty;

    public CastableExpression(Expression expression, AtomicType atomicType, boolean bl) throws XPathException {
        this.source = expression;
        this.targetType = atomicType;
        this.allowEmpty = bl;
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        if (this.source instanceof Value) {
            return BooleanValue.get(this.effectiveBooleanValue(null));
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        SequenceType sequenceType = new SequenceType(Type.ATOMIC_TYPE, this.allowEmpty ? 768 : 512);
        RoleLocator roleLocator = new RoleLocator(2, "castable as", 0);
        this.source = TypeChecker.staticTypeCheck(this.source, sequenceType, false, roleLocator);
        if (this.source instanceof AtomicValue) {
            return BooleanValue.get(this.effectiveBooleanValue(null));
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }

    public int computeCardinality() {
        return 512;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue = (AtomicValue)this.source.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return this.allowEmpty;
            }
            AtomicValue atomicValue2 = atomicValue.convert(this.targetType.getBuiltInBaseType().getFingerprint());
            AtomicUserDefinedValue atomicUserDefinedValue = AtomicUserDefinedValue.makeValue(atomicValue2, this.targetType, false);
            return atomicUserDefinedValue != null;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "castable");
        this.source.display(n + 1, namePool);
        System.err.println(ExpressionTool.indent(n + 1) + "as " + this.targetType);
    }
}

