/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;

public class ConstElementValue
extends ElementValue {
    public static final String ENTRY_NAME = "ConstElement";
    private static final int LENGTH = 2;
    private int constValueIndex;

    protected ConstElementValue(int n) {
        super(n);
    }

    public int getConstValueIndex() {
        return this.constValueIndex;
    }

    public void setConstValueIndex(int n) {
        this.constValueIndex = n;
    }

    protected int getSpecificLength() {
        return 2;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.constValueIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.constValueIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "ConstElementValue with const_value_index " + this.constValueIndex);
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }
}

