/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class ProcessWrapper
extends Process {
    private final Process process;
    private final Pipe inPipe;
    private final Pipe outPipe;
    private final Pipe errPipe;
    private final ChannelPump inThread;
    private final ChannelPump outThread;
    private final ChannelPump errThread;

    public ProcessWrapper(Process process, boolean pipeStdin, boolean pipeStdout, boolean pipeStderr) throws IOException {
        this.process = process;
        if (pipeStdin) {
            this.inPipe = Pipe.open();
            this.inThread = new ChannelPump("stdin", this.inPipe.source(), Channels.newChannel(process.getOutputStream()));
            this.inThread.start();
        } else {
            this.inPipe = null;
            this.inThread = null;
        }
        if (pipeStdout) {
            this.outPipe = Pipe.open();
            this.outThread = new ChannelPump("stdout", Channels.newChannel(process.getInputStream()), this.outPipe.sink());
            this.outThread.start();
        } else {
            this.outPipe = null;
            this.outThread = null;
        }
        if (pipeStderr) {
            this.errPipe = Pipe.open();
            this.errThread = new ChannelPump("stderr", Channels.newChannel(process.getErrorStream()), this.errPipe.sink());
            this.errThread.start();
        } else {
            this.errPipe = null;
            this.errThread = null;
        }
    }

    public Channel getOutputChannel() {
        assert (this.inPipe != null);
        return this.inPipe.sink();
    }

    public Channel getInputChannel() {
        assert (this.outPipe != null);
        return this.outPipe.source();
    }

    public Channel getErrorChannel() {
        assert (this.errPipe != null);
        return this.errPipe.source();
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getErrorStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int waitFor() throws InterruptedException {
        int retVal = this.process.waitFor();
        if (this.inThread != null) {
            this.inThread.join();
        }
        if (this.outThread != null) {
            this.outThread.join();
        }
        if (this.errThread != null) {
            this.errThread.join();
        }
        return retVal;
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    @Override
    public void destroy() {
        this.process.destroy();
    }

    @Override
    public Process destroyForcibly() {
        return this.process.destroyForcibly();
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    static class ChannelPump
    extends Thread {
        private static final int BUF_SIZE = 8192;
        private final ReadableByteChannel source;
        private final WritableByteChannel sink;

        ChannelPump(String streamName, ReadableByteChannel source, WritableByteChannel sink) {
            super("ChannelPump-" + streamName);
            this.source = source;
            this.sink = sink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ByteBuffer buf = ByteBuffer.allocate(8192);
            try {
                block18: while (true) {
                    buf.clear();
                    int r = this.source.read(buf);
                    if (r == -1) {
                        return;
                    }
                    buf.flip();
                    while (true) {
                        if (!buf.hasRemaining()) continue block18;
                        this.sink.write(buf);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                try {
                    this.sink.close();
                }
                catch (IOException iOException) {}
                try {
                    this.source.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

