/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.AsPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNodeGen;
import com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.ToPrimitiveBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;

@GenerateUncached
@ImportStatic(value={JSConfig.class, Symbol.class})
public abstract class JSToPrimitiveNode
extends ToPrimitiveBaseNode {
    protected JSToPrimitiveNode() {
    }

    public final Object executeHintDefault(Object value) {
        return this.execute(value, Hint.Default);
    }

    public final Object executeHintNumber(Object value) {
        return this.execute(value, Hint.Number);
    }

    public final Object executeHintString(Object value) {
        return this.execute(value, Hint.String);
    }

    public abstract Object execute(Object var1, Hint var2);

    @Specialization
    protected static Object doJSObject(JSObject object, Hint hint, @Bind Node node, @Cached.Shared @Cached(value="createGetMethod(SYMBOL_TO_PRIMITIVE, getJSContext())", uncached="getNullNode()") PropertyGetNode getToPrimitive, @Cached.Shared @Cached InlinedConditionProfile exoticToPrimProfile, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callExoticToPrim, @Cached.Shared @Cached AsPrimitiveNode asPrimitiveNode, @Cached.Shared @Cached OrdinaryToPrimitiveNode ordinaryToPrimitiveNode) {
        Object result;
        Object exoticToPrim = JSToPrimitiveNode.getMethod(object, Symbol.SYMBOL_TO_PRIMITIVE, getToPrimitive);
        if (exoticToPrimProfile.profile(node, !JSRuntime.isNullOrUndefined(exoticToPrim))) {
            result = callExoticToPrim.executeCall(JSArguments.createOneArg((Object)object, exoticToPrim, hint.getHintName()));
        } else {
            result = ordinaryToPrimitiveNode.execute((Object)object, hint.getOrdinaryToPrimitiveHint());
            assert (IsPrimitiveNode.getUncached().executeBoolean(result)) : result;
        }
        return asPrimitiveNode.execute(node, result, hint);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected static Object doForeignObject(Object object, Hint hint, @Bind Node node, @CachedLibrary(value="object") InteropLibrary interop, @Cached.Shared @Cached InlinedConditionProfile exoticToPrimProfile, @Cached.Shared @Cached ForeignObjectPrototypeNode foreignObjectPrototypeNode, @Cached.Shared @Cached(value="createGetMethod(SYMBOL_TO_PRIMITIVE, getJSContext())", uncached="getNullNode()") PropertyGetNode getToPrimitive, @Cached.Shared @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callExoticToPrim, @Cached.Shared @Cached AsPrimitiveNode asPrimitiveNode, @Cached.Shared @Cached OrdinaryToPrimitiveNode ordinaryToPrimitiveNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        Object result;
        Object primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(object, null, interop, switchEncoding, node);
        if (primitive != null) {
            return primitive;
        }
        JSDynamicObject proto = foreignObjectPrototypeNode.execute(object);
        Object exoticToPrim = JSToPrimitiveNode.getPrototypeMethod(proto, object, Symbol.SYMBOL_TO_PRIMITIVE, getToPrimitive);
        if (exoticToPrimProfile.profile(node, !JSRuntime.isNullOrUndefined(exoticToPrim))) {
            result = callExoticToPrim.executeCall(JSArguments.createOneArg(object, exoticToPrim, hint.getHintName()));
        } else {
            Object maybeResult;
            JSRealm realm = JSRealm.get(node);
            TruffleLanguage.Env env = realm.getEnv();
            if (env.isHostObject(object) && (maybeResult = JSToPrimitiveNode.tryHostObjectToPrimitive(object, hint, interop)) != null) {
                return maybeResult;
            }
            result = ordinaryToPrimitiveNode.execute(object, hint.getOrdinaryToPrimitiveHint());
            assert (IsPrimitiveNode.getUncached().executeBoolean(result)) : result;
        }
        return asPrimitiveNode.execute(node, result, hint);
    }

    public static Object tryHostObjectToPrimitive(Object object, Hint hint, InteropLibrary interop) {
        if (hint != Hint.String && JavaScriptLanguage.get((Node)interop).getJSContext().isOptionNashornCompatibilityMode() && interop.isMemberInvocable(object, "doubleValue")) {
            try {
                return interop.invokeMember(object, "doubleValue", new Object[0]);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(object, (InteropException)e, "doubleValue()", (Node)interop);
            }
        }
        if (interop.isMetaObject(object)) {
            return JSToPrimitiveNode.javaClassToString(object, interop);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString javaClassToString(Object object, InteropLibrary interop) {
        try {
            String qualifiedName = InteropLibrary.getUncached().asString(interop.getMetaQualifiedName(object));
            if (JavaScriptLanguage.get((Node)interop).getJSContext().isOptionNashornCompatibilityMode() && qualifiedName.endsWith("[]")) {
                Object hostObject = JSRealm.get((Node)interop).getEnv().asHostObject(object);
                qualifiedName = ((Class)hostObject).getName();
            }
            return Strings.fromJavaString("class " + qualifiedName);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(object, (InteropException)((Object)e), "getTypeName", (Node)interop);
        }
    }

    static Object getMethod(JSDynamicObject obj, Object propertyKey, PropertyGetNode getNode) {
        if (getNode != null) {
            return getNode.getValue((Object)obj);
        }
        return JSObject.getMethod(obj, propertyKey);
    }

    static Object getPrototypeMethod(JSDynamicObject proto, Object receiver, Object propertyKey, PropertyGetNode getNode) {
        if (getNode != null) {
            return getNode.getValueOrUndefined((Object)proto, receiver);
        }
        return JSObject.getMethod(proto, receiver, propertyKey);
    }

    @NeverDefault
    public static JSToPrimitiveNode create() {
        return JSToPrimitiveNodeGen.create();
    }

    @NeverDefault
    public static JSToPrimitiveNode getUncached() {
        return JSToPrimitiveNodeGen.getUncached();
    }

    public static enum Hint {
        Default(Strings.HINT_DEFAULT),
        Number(Strings.HINT_NUMBER),
        String(Strings.HINT_STRING);

        private final TruffleString hintName;

        private Hint(TruffleString hintName) {
            this.hintName = hintName;
        }

        public TruffleString getHintName() {
            return this.hintName;
        }

        public Hint getOrdinaryToPrimitiveHint() {
            return this == String ? String : Number;
        }
    }
}

