\name{LandweberDeconvolutionImageFilter}
\alias{LandweberDeconvolutionImageFilter}
\title{LandweberDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Deconvolve an image using the Landweber deconvolution algorithm.
LandweberDeconvolutionImageFilter}
\details{
This filter implements the Landweber deconvolution algorithm as
defined in Bertero M and Boccacci P, "Introduction to Inverse
Problems in Imaging", 1998. The algorithm assumes that the input
image has been formed by a linear shift-invariant system with a known
kernel.
The Landweber algorithm converges to a solution that minimizes the sum
of squared errors \eqn{||f \otimes h - g||} where \eqn{f} is the estimate of the unblurred image, \eqn{\otimes} is the convolution operator, \eqn{h} is the blurring kernel, and \eqn{g} is the blurred input image. As such, it is best suited for images
that have zero-mean Gaussian white noise.
This is the base implementation of the Landweber algorithm. It may
produce results with negative values. For a version of this algorithm
that enforces a positivity constraint on each intermediate solution,
see ProjectedLandweberDeconvolutionImageFilter .
This code was adapted from the Insight Journal contribution:
"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://www.insight-journal.org/browse/publication/753
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Cory Quammen, The University of North Carolina at Chapel Hill
See:
IterativeDeconvolutionImageFilter
RichardsonLucyDeconvolutionImageFilter
ProjectedLandweberDeconvolutionImageFilter
LandweberDeconvolution for the procedural interface
itk::LandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.
LandweberDeconvolutionImageFilter}
%C++ includes: sitkLandweberDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{double GetAlpha() const:}{
Set/get relaxation factor.
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{int GetNumberOfIterations() const:}{
Get the number of iterations.
}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{ LandweberDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{Self SetAlpha(double Alpha):}{
Set/get relaxation factor.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetNumberOfIterations(int NumberOfIterations):}{
Set the number of iterations.
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LandweberDeconvolutionImageFilter():}{
Destructor
}
}
}
