/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateTenantResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateTenantRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateTenantRequest> {
    @Nullable
    private final String description;
    @Nonnull
    private final String tenant;
    public static final JsonpDeserializer<CreateTenantRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateTenantRequest::setupCreateTenantRequestDeserializer);
    public static final Endpoint<CreateTenantRequest, CreateTenantResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateTenantRequest, CreateTenantResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/tenants/");
        SimpleEndpoint.pathEncode(request.tenant, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateTenantResponse._DESERIALIZER);

    private CreateTenantRequest(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.tenant = ApiTypeHelper.requireNonNull(builder.tenant, this, "tenant");
    }

    public static CreateTenantRequest of(Function<Builder, ObjectBuilder<CreateTenantRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final String tenant() {
        return this.tenant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateTenantRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + this.tenant.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTenantRequest other = (CreateTenantRequest)o;
        return Objects.equals(this.description, other.description) && this.tenant.equals(other.tenant);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateTenantRequest> {
        @Nullable
        private String description;
        private String tenant;

        public Builder() {
        }

        private Builder(CreateTenantRequest o) {
            super(o);
            this.description = o.description;
            this.tenant = o.tenant;
        }

        private Builder(Builder o) {
            super(o);
            this.description = o.description;
            this.tenant = o.tenant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder tenant(String value) {
            this.tenant = value;
            return this;
        }

        @Override
        @Nonnull
        public CreateTenantRequest build() {
            this._checkSingleUse();
            return new CreateTenantRequest(this);
        }
    }
}

