/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.LeafGeoPointFieldData;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.script.expression.FieldDataBasedDoubleValuesSource;

final class GeoEmptyValueSource
extends FieldDataBasedDoubleValuesSource {
    GeoEmptyValueSource(IndexFieldData<?> fieldData) {
        super(fieldData);
    }

    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafGeoPointFieldData leafData = (LeafGeoPointFieldData)this.fieldData.load(leaf);
        final MultiGeoPointValues values = leafData.getGeoPointValues();
        return new DoubleValues(this){

            public double doubleValue() {
                return 1.0;
            }

            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + this.fieldData.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GeoEmptyValueSource other = (GeoEmptyValueSource)((Object)obj);
        return this.fieldData.equals((Object)other.fieldData);
    }

    public String toString() {
        return "empty: field(" + this.fieldData.getFieldName() + ")";
    }
}

