/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.security.OAuthFlows;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedOAuthFlow;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedOAuthFlows
implements ComposedChanged {
    private final OAuthFlows oldOAuthFlows;
    private final OAuthFlows newOAuthFlows;
    private ChangedOAuthFlow implicitOAuthFlow;
    private ChangedOAuthFlow passwordOAuthFlow;
    private ChangedOAuthFlow clientCredentialOAuthFlow;
    private ChangedOAuthFlow authorizationCodeOAuthFlow;
    private ChangedExtensions extensions;

    public ChangedOAuthFlows(OAuthFlows oldOAuthFlows, OAuthFlows newOAuthFlows) {
        this.oldOAuthFlows = oldOAuthFlows;
        this.newOAuthFlows = newOAuthFlows;
    }

    @Override
    public List<Changed> getChangedElements() {
        return Arrays.asList(this.implicitOAuthFlow, this.passwordOAuthFlow, this.clientCredentialOAuthFlow, this.authorizationCodeOAuthFlow, this.extensions);
    }

    @Override
    public DiffResult isCoreChanged() {
        return DiffResult.NO_CHANGES;
    }

    public OAuthFlows getOldOAuthFlows() {
        return this.oldOAuthFlows;
    }

    public OAuthFlows getNewOAuthFlows() {
        return this.newOAuthFlows;
    }

    public ChangedOAuthFlow getImplicitOAuthFlow() {
        return this.implicitOAuthFlow;
    }

    public ChangedOAuthFlow getPasswordOAuthFlow() {
        return this.passwordOAuthFlow;
    }

    public ChangedOAuthFlow getClientCredentialOAuthFlow() {
        return this.clientCredentialOAuthFlow;
    }

    public ChangedOAuthFlow getAuthorizationCodeOAuthFlow() {
        return this.authorizationCodeOAuthFlow;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedOAuthFlows setImplicitOAuthFlow(ChangedOAuthFlow implicitOAuthFlow) {
        this.implicitOAuthFlow = implicitOAuthFlow;
        return this;
    }

    public ChangedOAuthFlows setPasswordOAuthFlow(ChangedOAuthFlow passwordOAuthFlow) {
        this.passwordOAuthFlow = passwordOAuthFlow;
        return this;
    }

    public ChangedOAuthFlows setClientCredentialOAuthFlow(ChangedOAuthFlow clientCredentialOAuthFlow) {
        this.clientCredentialOAuthFlow = clientCredentialOAuthFlow;
        return this;
    }

    public ChangedOAuthFlows setAuthorizationCodeOAuthFlow(ChangedOAuthFlow authorizationCodeOAuthFlow) {
        this.authorizationCodeOAuthFlow = authorizationCodeOAuthFlow;
        return this;
    }

    public ChangedOAuthFlows setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedOAuthFlows that = (ChangedOAuthFlows)o;
        return Objects.equals(this.oldOAuthFlows, that.oldOAuthFlows) && Objects.equals(this.newOAuthFlows, that.newOAuthFlows) && Objects.equals(this.implicitOAuthFlow, that.implicitOAuthFlow) && Objects.equals(this.passwordOAuthFlow, that.passwordOAuthFlow) && Objects.equals(this.clientCredentialOAuthFlow, that.clientCredentialOAuthFlow) && Objects.equals(this.authorizationCodeOAuthFlow, that.authorizationCodeOAuthFlow) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldOAuthFlows, this.newOAuthFlows, this.implicitOAuthFlow, this.passwordOAuthFlow, this.clientCredentialOAuthFlow, this.authorizationCodeOAuthFlow, this.extensions);
    }

    public String toString() {
        return "ChangedOAuthFlows(oldOAuthFlows=" + this.getOldOAuthFlows() + ", newOAuthFlows=" + this.getNewOAuthFlows() + ", implicitOAuthFlow=" + this.getImplicitOAuthFlow() + ", passwordOAuthFlow=" + this.getPasswordOAuthFlow() + ", clientCredentialOAuthFlow=" + this.getClientCredentialOAuthFlow() + ", authorizationCodeOAuthFlow=" + this.getAuthorizationCodeOAuthFlow() + ", extensions=" + this.getExtensions() + ")";
    }
}

