/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Increase the image size by padding with replicants of the input image
value.


WrapPadImageFilter changes the image bounds of an image. Added pixels are filled in with
a wrapped replica of the input image. For instance, if the output
image needs a pixel that is two pixels to the left of the
LargestPossibleRegion of the input image, the value assigned will be
from the pixel two pixels inside the right boundary of the
LargestPossibleRegion. The image bounds of the output must be
specified.

Visual explanation of padding regions.

This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.


See:
 MirrorPadImageFilter , ConstantPadImageFilter

 itk::simple::WrapPad for the procedural interface

 itk::WrapPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkWrapPadImageFilter.h
*/
public class WrapPadImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected WrapPadImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.WrapPadImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(WrapPadImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(WrapPadImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::WrapPadImageFilter::~WrapPadImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_WrapPadImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::WrapPadImageFilter::WrapPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  WrapPadImageFilter() {
    this(SimpleITKJNI.new_WrapPadImageFilter(), true);
  }

  /**
Self&amp; itk::simple::WrapPadImageFilter::SetPadLowerBound(std::vector&lt; unsigned int &gt; PadLowerBound)
*/
public  void setPadLowerBound(VectorUInt32 PadLowerBound) {
    SimpleITKJNI.WrapPadImageFilter_setPadLowerBound(swigCPtr, this, VectorUInt32.getCPtr(PadLowerBound), PadLowerBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::WrapPadImageFilter::GetPadLowerBound() const
*/
public  VectorUInt32 getPadLowerBound() {
    return new VectorUInt32(SimpleITKJNI.WrapPadImageFilter_getPadLowerBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::WrapPadImageFilter::SetPadUpperBound(std::vector&lt; unsigned int &gt; PadUpperBound)
*/
public  void setPadUpperBound(VectorUInt32 PadUpperBound) {
    SimpleITKJNI.WrapPadImageFilter_setPadUpperBound(swigCPtr, this, VectorUInt32.getCPtr(PadUpperBound), PadUpperBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::WrapPadImageFilter::GetPadUpperBound() const
*/
public  VectorUInt32 getPadUpperBound() {
    return new VectorUInt32(SimpleITKJNI.WrapPadImageFilter_getPadUpperBound(swigCPtr, this), true);
  }

  /**
std::string itk::simple::WrapPadImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.WrapPadImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::WrapPadImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.WrapPadImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::WrapPadImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.WrapPadImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
