/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPSDES;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPSDESPacket
extends RTCPPacket {
    public RTCPSDES[] sdes;

    public RTCPSDESPacket(RTCPPacket parent) {
        super(parent);
        this.type = 202;
    }

    public RTCPSDESPacket(RTCPSDES[] sdes) {
        this.sdes = sdes;
        if (sdes.length > 31) {
            throw new IllegalArgumentException("Too many SDESs");
        }
    }

    public String toString() {
        return "\tRTCP SDES Packet:\n" + RTCPSDES.toString(this.sdes);
    }

    public int calcLength() {
        int len = 4;
        int i = 0;
        while (i < this.sdes.length) {
            int sublen = 5;
            int j = 0;
            while (j < this.sdes[i].items.length) {
                sublen += 2 + this.sdes[i].items[j].data.length;
                ++j;
            }
            sublen = sublen + 3 & 0xFFFFFFFC;
            len += sublen;
            ++i;
        }
        return len;
    }

    void assemble(DataOutputStream out) throws IOException {
        out.writeByte(128 + this.sdes.length);
        out.writeByte(202);
        out.writeShort(this.calcLength() - 4 >> 2);
        int i = 0;
        while (i < this.sdes.length) {
            out.writeInt(this.sdes[i].ssrc);
            int sublen = 0;
            int j = 0;
            while (j < this.sdes[i].items.length) {
                out.writeByte(this.sdes[i].items[j].type);
                out.writeByte(this.sdes[i].items[j].data.length);
                out.write(this.sdes[i].items[j].data);
                sublen += 2 + this.sdes[i].items[j].data.length;
                ++j;
            }
            int j2 = (sublen + 4 & 0xFFFFFFFC) - sublen;
            while (j2 > 0) {
                out.writeByte(0);
                --j2;
            }
            ++i;
        }
    }
}

