/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public final class Ray {
    public float ox;
    public float oy;
    public float oz;
    public float dx;
    public float dy;
    public float dz;
    private float tMin;
    private float tMax;
    private static final float EPSILON = 0.0f;

    private Ray() {
    }

    public Ray(float f, float f2, float f3, float f4, float f5, float f6) {
        this.ox = f;
        this.oy = f2;
        this.oz = f3;
        this.dx = f4;
        this.dy = f5;
        this.dz = f6;
        float f7 = 1.0f / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        this.dx *= f7;
        this.dy *= f7;
        this.dz *= f7;
        this.tMin = 0.0f;
        this.tMax = Float.POSITIVE_INFINITY;
    }

    public Ray(Point3 point3, Vector3 vector3) {
        this.ox = point3.x;
        this.oy = point3.y;
        this.oz = point3.z;
        this.dx = vector3.x;
        this.dy = vector3.y;
        this.dz = vector3.z;
        float f = 1.0f / (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy + this.dz * this.dz);
        this.dx *= f;
        this.dy *= f;
        this.dz *= f;
        this.tMin = 0.0f;
        this.tMax = Float.POSITIVE_INFINITY;
    }

    public Ray(Point3 point3, Point3 point32) {
        this.ox = point3.x;
        this.oy = point3.y;
        this.oz = point3.z;
        this.dx = point32.x - this.ox;
        this.dy = point32.y - this.oy;
        this.dz = point32.z - this.oz;
        this.tMin = 0.0f;
        float f = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy + this.dz * this.dz);
        float f2 = 1.0f / f;
        this.dx *= f2;
        this.dy *= f2;
        this.dz *= f2;
        this.tMax = f - 0.0f;
    }

    public Ray transform(Matrix4 matrix4) {
        if (matrix4 == null) {
            return this;
        }
        Ray ray = new Ray();
        ray.ox = matrix4.transformPX(this.ox, this.oy, this.oz);
        ray.oy = matrix4.transformPY(this.ox, this.oy, this.oz);
        ray.oz = matrix4.transformPZ(this.ox, this.oy, this.oz);
        ray.dx = matrix4.transformVX(this.dx, this.dy, this.dz);
        ray.dy = matrix4.transformVY(this.dx, this.dy, this.dz);
        ray.dz = matrix4.transformVZ(this.dx, this.dy, this.dz);
        ray.tMin = this.tMin;
        ray.tMax = this.tMax;
        return ray;
    }

    public void normalize() {
        float f = 1.0f / (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy + this.dz * this.dz);
        this.dx *= f;
        this.dy *= f;
        this.dz *= f;
    }

    public final float getMin() {
        return this.tMin;
    }

    public final float getMax() {
        return this.tMax;
    }

    public final Vector3 getDirection() {
        return new Vector3(this.dx, this.dy, this.dz);
    }

    public final boolean isInside(float f) {
        return this.tMin < f && f < this.tMax;
    }

    public final Point3 getPoint(Point3 point3) {
        point3.x = this.ox + this.tMax * this.dx;
        point3.y = this.oy + this.tMax * this.dy;
        point3.z = this.oz + this.tMax * this.dz;
        return point3;
    }

    public final float dot(Vector3 vector3) {
        return this.dx * vector3.x + this.dy * vector3.y + this.dz * vector3.z;
    }

    public final float dot(float f, float f2, float f3) {
        return this.dx * f + this.dy * f2 + this.dz * f3;
    }

    public final void setMax(float f) {
        this.tMax = f;
    }

    public void setMinMax(float f, float f2) {
        this.tMin = f;
        this.tMax = f2;
    }
}

