info = {
    "name": "th",
    "date_order": "DMY",
    "january": [
        "มกราคม",
        "มค",
        "เดือนมกราคม",
        "มกรา"
    ],
    "february": [
        "กพ",
        "กุมภาพันธ์",
        "เดือนกุมภาพันธ์",
        "กุมภา"
    ],
    "march": [
        "มีค",
        "มีนาคม",
        "เดือนมีนาคม",
        "มีนา"
    ],
    "april": [
        "เมย",
        "เมษายน",
        "เมษา",
        "เดือนเมษายน"
    ],
    "may": [
        "พค",
        "พฤษภาคม",
        "เดือนพฤษภาคม",
        "พฤษภา"
    ],
    "june": [
        "มิถุนายน",
        "มิย",
        "เดือนมิถุนายน",
        "มิถุนา"
    ],
    "july": [
        "กค",
        "กรกฎาคม",
        "เดือนกรกฏาคม",
        "กรกฎา"
    ],
    "august": [
        "สค",
        "สิงหาคม",
        "สิงหา",
        "เดือนสิงหาคม"
    ],
    "september": [
        "กย",
        "กันยายน",
        "กันยา",
        "เดือนกันยายน"
    ],
    "october": [
        "ตค",
        "ตุลาคม",
        "เดือนตุลาคม",
        "ตุลา"
    ],
    "november": [
        "พย",
        "พฤศจิกายน",
        "เดือนพฤศจิกายน",
        "พฤศจิ"
    ],
    "december": [
        "ธค",
        "ธันวาคม",
        "เดือนธันวาคม",
        "ธันวา"
    ],
    "monday": [
        "จ",
        "วันจันทร์",
        "จันทร์",
        "วันจันทร์ที่"
    ],
    "tuesday": [
        "วันอังคาร",
        "อ",
        "อังคาร",
        "วันอังคารที่"
    ],
    "wednesday": [
        "พ",
        "วันพุธ",
        "พุธ",
        "วันพุธที่"
    ],
    "thursday": [
        "พฤ",
        "วันพฤหัสบดี",
        "พฤหัสบดี",
        "พฤหัส",
        "วันพฤหัสบดีที่"
    ],
    "friday": [
        "วันศุกร์",
        "ศ",
        "ศุกร์",
        "วันศุกร์ที่"
    ],
    "saturday": [
        "วันเสาร์",
        "ส",
        "เสาร์",
        "วันเสาร์ที่"
    ],
    "sunday": [
        "วันอาทิตย์",
        "อา",
        "อาทิตย์",
        "วันอาทิตย์ที่"
    ],
    "am": [
        "ก่อนเที่ยง"
    ],
    "pm": [
        "หลังเที่ยง"
    ],
    "year": [
        "ปี"
    ],
    "month": [
        "เดือน"
    ],
    "week": [
        "สัปดาห์"
    ],
    "day": [
        "วัน"
    ],
    "hour": [
        "ชม",
        "ชั่วโมง"
    ],
    "minute": [
        "น",
        "นาที"
    ],
    "second": [
        "วิ",
        "วินาที"
    ],
    "relative-type": {
        "0 day ago": [
            "วันนี้"
        ],
        "0 hour ago": [
            "ชั่วโมงนี้"
        ],
        "0 minute ago": [
            "นาทีนี้"
        ],
        "0 month ago": [
            "เดือนนี้"
        ],
        "0 second ago": [
            "ขณะนี้"
        ],
        "0 week ago": [
            "สัปดาห์นี้"
        ],
        "0 year ago": [
            "ปีนี้"
        ],
        "1 day ago": [
            "เมื่อวาน"
        ],
        "1 month ago": [
            "เดือนที่แล้ว"
        ],
        "1 week ago": [
            "สัปดาห์ที่แล้ว"
        ],
        "1 year ago": [
            "ปีที่แล้ว"
        ],
        "in 1 day": [
            "พรุ่งนี้"
        ],
        "in 1 month": [
            "เดือนหน้า"
        ],
        "in 1 week": [
            "สัปดาห์หน้า"
        ],
        "in 1 year": [
            "ปีหน้า"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) วันที่ผ่านมา",
            "(\\d+) วันที่แล้ว"
        ],
        "\\1 hour ago": [
            "(\\d+) ชม ที่แล้ว",
            "(\\d+) ชั่วโมงที่ผ่านมา"
        ],
        "\\1 minute ago": [
            "(\\d+) นาทีที่ผ่านมา",
            "(\\d+) นาทีที่แล้ว"
        ],
        "\\1 month ago": [
            "(\\d+) เดือนที่ผ่านมา",
            "(\\d+) เดือนที่แล้ว"
        ],
        "\\1 second ago": [
            "(\\d+) วินาทีที่ผ่านมา",
            "(\\d+) วินาทีที่แล้ว"
        ],
        "\\1 week ago": [
            "(\\d+) สัปดาห์ที่ผ่านมา",
            "(\\d+) สัปดาห์ที่แล้ว"
        ],
        "\\1 year ago": [
            "(\\d+) ปีที่แล้ว"
        ],
        "in \\1 day": [
            "ใน (\\d+) วัน",
            "ในอีก (\\d+) วัน"
        ],
        "in \\1 hour": [
            "ใน (\\d+) ชม",
            "ในอีก (\\d+) ชั่วโมง"
        ],
        "in \\1 minute": [
            "ใน (\\d+) นาที",
            "ในอีก (\\d+) นาที"
        ],
        "in \\1 month": [
            "ใน (\\d+) เดือน",
            "ในอีก (\\d+) เดือน"
        ],
        "in \\1 second": [
            "ใน (\\d+) วินาที",
            "ในอีก (\\d+) วินาที"
        ],
        "in \\1 week": [
            "ใน (\\d+) สัปดาห์",
            "ในอีก (\\d+) สัปดาห์"
        ],
        "in \\1 year": [
            "ใน (\\d+) ปี",
            "ในอีก (\\d+) ปี"
        ]
    },
    "locale_specific": {},
    "sentence_splitter_group": 5,
    "skip": [
        "น.",
        "เมื่อ ",
        "เวลา",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "ago": [
        "แต่ก่อน",
        "มาแล้ว",
        "ก่อน"
    ],
    "in": [
        "ใน"
    ],
    "simplifications": [
        {
            "วันนี้": "0 วัน"
        },
        {
            "เมื่อวานนี้": "1 วัน"
        },
        {
            "1 วันที่แล้ว": "1 วัน"
        },
        {
            "เมื่อวานซืน": "2 วัน"
        },
        {
            "2 วันที่แล้ว": "2 วัน"
        },
        {
            "เมื่อสักครู่นี้": "0 วินาที"
        }
    ]
}
