/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.TemporarySelectorClosedException;
import com.sun.corba.ee.impl.transport.TemporarySelectorStateClosed;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.TemporarySelectorState;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

@Transport
public class TemporarySelectorStateOpen
implements TemporarySelectorState {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;

    @Override
    @Transport
    public int select(Selector theSelector, long theTimeout) throws IOException {
        if (theSelector.isOpen()) {
            if (theTimeout <= 0L) {
                throw wrapper.temporarySelectorSelectTimeoutLessThanOne(theSelector, theTimeout);
            }
        } else {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        int result = theSelector.select(theTimeout);
        return result;
    }

    @Override
    @Transport
    public SelectionKey registerChannel(Selector theSelector, SelectableChannel theSelectableChannel, int theOps) throws IOException {
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        SelectionKey key = theSelectableChannel.register(theSelector, theOps);
        return key;
    }

    @Override
    @Transport
    public TemporarySelectorState cancelKeyAndFlushSelector(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        if (theSelectionKey != null) {
            theSelectionKey.cancel();
        }
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        theSelector.selectNow();
        return this;
    }

    @Override
    @Transport
    public TemporarySelectorState close(Selector theSelector) throws IOException {
        theSelector.close();
        return new TemporarySelectorStateClosed();
    }

    @Override
    @Transport
    public TemporarySelectorState removeSelectedKey(Selector theSelector, SelectionKey theSelectionKey) throws IOException {
        if (!theSelector.isOpen()) {
            throw new TemporarySelectorClosedException("Selector " + theSelector.toString() + " is closed.");
        }
        theSelector.selectedKeys().remove(theSelectionKey);
        return this;
    }
}

