/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxesDrawer;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs;
import net.sourceforge.plantuml.sequencediagram.teoz.Step;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class LiveBoxes {
    private final Rose skin;
    private final ISkinParam skinParam;
    private final Map<Double, Double> delays = new TreeMap<Double, Double>();
    private final Participant p;
    private final List<Event> events;
    private final Map<Event, Double> eventsStep = new HashMap<Event, Double>();

    public LiveBoxes(Participant p, List<Event> events, Rose skin, ISkinParam skinParam) {
        this.p = p;
        this.events = events;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    public void addStep(Event event, double y) {
        if (event.dealWith(this.p)) {
            if (event instanceof LifeEvent && ((LifeEvent)event).isDeactivate() && this.eventsStep.containsValue(y)) {
                y += 5.0;
            }
            this.eventsStep.put(event, y);
            event.setY(y);
        }
    }

    public Participant getParticipant() {
        return this.p;
    }

    public int getLevelAt(Event event, EventsHistoryMode mode) {
        return this.getLevelAtInternal(event, mode);
    }

    private int getLevelAtInternal(Event event, EventsHistoryMode mode) {
        int level = 0;
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event current = it.next();
            if (current instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)current;
                if (le.getParticipant() == this.p && le.isActivate()) {
                    ++level;
                }
                if (le.getParticipant() == this.p && le.isDeactivateOrDestroy()) {
                    level = Math.max(0, level - 1);
                }
            }
            if (event != current) continue;
            if (current instanceof AbstractMessage) {
                Event next;
                boolean seenActivate = false;
                boolean seenDeactivate = false;
                while (it.hasNext() && ((next = this.nextButSkippingNotes(it)) instanceof LifeEvent || next instanceof AbstractMessage)) {
                    LifeEvent le;
                    AbstractMessage msg;
                    boolean sameMessage;
                    if (!(next instanceof LifeEvent) || !(sameMessage = (msg = (AbstractMessage)current) == (le = (LifeEvent)next).getMessage() || le.getMessage() != null && le.getMessage().isParallelWith(msg))) continue;
                    if (mode != EventsHistoryMode.IGNORE_FUTURE_ACTIVATE && le.isActivate() && msg.dealWith(this.p) && le.getParticipant() == this.p) {
                        seenActivate = true;
                        if (seenDeactivate) break;
                        ++level;
                    }
                    if (mode != EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE || !le.isDeactivateOrDestroy() || !msg.dealWith(this.p) || le.getParticipant() != this.p) continue;
                    seenDeactivate = true;
                    if (seenActivate) break;
                    level = Math.max(0, level - 1);
                }
            }
            if (level < 0) {
                return 0;
            }
            return level;
        }
        throw new IllegalArgumentException();
    }

    private boolean isNextEventADestroy(Event event) {
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event next;
            Event current = it.next();
            if (event != current) continue;
            if (current instanceof Message && (next = this.nextButSkippingNotes(it)) instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)next;
                return le.isDestroy(this.p);
            }
            return false;
        }
        return false;
    }

    private Fashion getActivateColor(Event event) {
        LifeEvent le;
        if (event instanceof LifeEvent && (le = (LifeEvent)event).isActivate()) {
            return le.getSpecificColors();
        }
        Iterator<Event> it = this.events.iterator();
        while (it.hasNext()) {
            Event current = it.next();
            if (event != current) continue;
            if (current instanceof Message || current instanceof MessageExo) {
                Event next = this.nextButSkippingNotes(it);
                while (next instanceof LifeEvent && ((LifeEvent)next).getMessage() == current) {
                    LifeEvent le2 = (LifeEvent)next;
                    if (le2.isActivate() && le2.getParticipant() == this.p) {
                        return le2.getSpecificColors();
                    }
                    next = this.nextButSkippingNotes(it);
                }
            }
            return null;
        }
        return null;
    }

    private Event nextButSkippingNotes(Iterator<Event> it) {
        Event next;
        do {
            if (it.hasNext()) continue;
            return null;
        } while ((next = it.next()) instanceof Note);
        return next;
    }

    public Stairs getStairs(double createY, double totalHeight) {
        Stairs stair = new Stairs();
        int indent = 0;
        AbstractMessage lastMessage = null;
        Double position = null;
        boolean seenActivate = false;
        boolean seenDeactivate = false;
        for (Event event : this.events) {
            if (event instanceof Note) {
                lastMessage = null;
                seenActivate = false;
                seenDeactivate = false;
            }
            Double potentialPosition = this.eventsStep.get(event);
            if (position == null || lastMessage == null) {
                position = potentialPosition;
            } else if (event instanceof LifeEvent) {
                LifeEvent le = (LifeEvent)event;
                if (!le.dealWith(this.p)) continue;
                if (le.getMessage() == null || !le.getMessage().isParallelWith(lastMessage)) {
                    position = potentialPosition;
                } else if (le.isActivate() && seenDeactivate || le.isDeactivate() && seenActivate) {
                    position = potentialPosition;
                }
                seenActivate |= le.isActivate();
                seenDeactivate |= le.isDeactivate();
            } else {
                position = potentialPosition;
            }
            if (event instanceof AbstractMessage) {
                if (((AbstractMessage)event).isParallelWith(lastMessage)) continue;
                seenActivate = false;
                seenDeactivate = false;
                lastMessage = (AbstractMessage)event;
            }
            if (position == null) continue;
            assert (position <= totalHeight) : "position=" + position + " totalHeight=" + totalHeight;
            indent = this.getLevelAt(event, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
            Fashion activateColor = this.getActivateColor(event);
            Step step = new Step(Math.max(createY, position), this.isNextEventADestroy(event), indent, activateColor);
            stair.addStep(step);
        }
        stair.addStep(new Step(totalHeight, false, indent, null));
        return stair;
    }

    private boolean isActivateAnDeactivate(Event event) {
        if (event instanceof AbstractMessage) {
            AbstractMessage msg = (AbstractMessage)event;
            return msg.isActivate() && msg.isDeactivate();
        }
        return false;
    }

    public int getMaxValue() {
        int max = 0;
        int level = 0;
        for (Event current : this.events) {
            if (!(current instanceof LifeEvent)) continue;
            LifeEvent le = (LifeEvent)current;
            if (le.getParticipant() == this.p && le.isActivate()) {
                ++level;
            }
            if (level > max) {
                max = level;
            }
            if (le.getParticipant() != this.p || !le.isDeactivateOrDestroy()) continue;
            --level;
        }
        return max;
    }

    public double getMaxPosition(StringBounder stringBounder) {
        int max = this.getMaxValue();
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(new SimpleContext2D(true), this.skin, this.skinParam, this.delays);
        return drawer.getWidth(stringBounder) / 2.0 * (double)max;
    }

    public void drawBoxes(UGraphic ug, Context2D context, double createY, double endY) {
        Stairs stairs = this.getStairs(createY, endY);
        int max = stairs.getMaxIndent();
        if (max == 0) {
            this.drawDestroys(ug, stairs, context);
        }
        for (int i = 1; i <= max; ++i) {
            this.drawOneLevel(ug, i, stairs, context);
        }
    }

    private void drawDestroys(UGraphic ug, Stairs stairs, Context2D context) {
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(context, this.skin, this.skinParam, this.delays);
        for (Step yposition : stairs.getSteps()) {
            drawer.drawDestroyIfNeeded(ug, yposition);
        }
    }

    private void drawOneLevel(UGraphic ug, int levelToDraw, Stairs stairs, Context2D context) {
        LiveBoxesDrawer drawer = new LiveBoxesDrawer(context, this.skin, this.skinParam, this.delays);
        ug = ug.apply(UTranslate.dx((double)(levelToDraw - 1) * drawer.getWidth(ug.getStringBounder()) / 2.0));
        boolean pending = true;
        Iterator<Step> it = stairs.getSteps().iterator();
        while (it.hasNext()) {
            Step yposition = it.next();
            int indent = yposition.getIndent();
            if (pending && indent == levelToDraw) {
                drawer.addStart(yposition.getValue(), yposition.getColors());
                pending = false;
                continue;
            }
            if (pending || it.hasNext() && indent >= levelToDraw) continue;
            drawer.doDrawing(ug, yposition.getValue());
            drawer.drawDestroyIfNeeded(ug, yposition);
            pending = true;
        }
    }

    public void delayOn(double y, double height) {
        this.delays.put(y, height);
    }
}

