/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "nextWindowStartTime", "Ljava/time/Instant;", "nextWindowEndTime", "(Ljava/time/Instant;Ljava/time/Instant;)V", "getNextWindowEndTime", "()Ljava/time/Instant;", "getNextWindowStartTime", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
public final class ContinuousMetadata
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant nextWindowStartTime;
    @NotNull
    private final Instant nextWindowEndTime;
    @NotNull
    private static final String NEXT_WINDOW_START_TIME_FIELD = "next_window_start_time";
    @NotNull
    private static final String NEXT_WINDOW_START_TIME_FIELD_IN_MILLIS = "next_window_start_time_in_millis";
    @NotNull
    private static final String NEXT_WINDOW_END_TIME_FIELD = "next_window_end_time";
    @NotNull
    private static final String NEXT_WINDOW_END_TIME_FIELD_IN_MILLIS = "next_window_end_time_in_millis";

    public ContinuousMetadata(@NotNull Instant nextWindowStartTime, @NotNull Instant nextWindowEndTime) {
        Intrinsics.checkNotNullParameter((Object)nextWindowStartTime, (String)"nextWindowStartTime");
        Intrinsics.checkNotNullParameter((Object)nextWindowEndTime, (String)"nextWindowEndTime");
        this.nextWindowStartTime = nextWindowStartTime;
        this.nextWindowEndTime = nextWindowEndTime;
    }

    @NotNull
    public final Instant getNextWindowStartTime() {
        return this.nextWindowStartTime;
    }

    @NotNull
    public final Instant getNextWindowEndTime() {
        return this.nextWindowEndTime;
    }

    public ContinuousMetadata(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        Instant instant2 = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"sin.readInstant()");
        this(instant, instant2);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().timeField(NEXT_WINDOW_START_TIME_FIELD, NEXT_WINDOW_START_TIME_FIELD_IN_MILLIS, this.nextWindowStartTime.toEpochMilli()).timeField(NEXT_WINDOW_END_TIME_FIELD, NEXT_WINDOW_END_TIME_FIELD_IN_MILLIS, this.nextWindowEndTime.toEpochMilli()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026i())\n        .endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInstant(this.nextWindowStartTime);
        out.writeInstant(this.nextWindowEndTime);
    }

    @NotNull
    public final Instant component1() {
        return this.nextWindowStartTime;
    }

    @NotNull
    public final Instant component2() {
        return this.nextWindowEndTime;
    }

    @NotNull
    public final ContinuousMetadata copy(@NotNull Instant nextWindowStartTime, @NotNull Instant nextWindowEndTime) {
        Intrinsics.checkNotNullParameter((Object)nextWindowStartTime, (String)"nextWindowStartTime");
        Intrinsics.checkNotNullParameter((Object)nextWindowEndTime, (String)"nextWindowEndTime");
        return new ContinuousMetadata(nextWindowStartTime, nextWindowEndTime);
    }

    public static /* synthetic */ ContinuousMetadata copy$default(ContinuousMetadata continuousMetadata, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            instant = continuousMetadata.nextWindowStartTime;
        }
        if ((n & 2) != 0) {
            instant2 = continuousMetadata.nextWindowEndTime;
        }
        return continuousMetadata.copy(instant, instant2);
    }

    @NotNull
    public String toString() {
        return "ContinuousMetadata(nextWindowStartTime=" + this.nextWindowStartTime + ", nextWindowEndTime=" + this.nextWindowEndTime + ")";
    }

    public int hashCode() {
        int result2 = this.nextWindowStartTime.hashCode();
        result2 = result2 * 31 + this.nextWindowEndTime.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContinuousMetadata)) {
            return false;
        }
        ContinuousMetadata continuousMetadata = (ContinuousMetadata)other;
        if (!Intrinsics.areEqual((Object)this.nextWindowStartTime, (Object)continuousMetadata.nextWindowStartTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.nextWindowEndTime, (Object)continuousMetadata.nextWindowEndTime);
    }

    @JvmStatic
    @NotNull
    public static final ContinuousMetadata parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata$Companion;", "", "()V", "NEXT_WINDOW_END_TIME_FIELD", "", "NEXT_WINDOW_END_TIME_FIELD_IN_MILLIS", "NEXT_WINDOW_START_TIME_FIELD", "NEXT_WINDOW_START_TIME_FIELD_IN_MILLIS", "parse", "Lorg/opensearch/indexmanagement/rollup/model/ContinuousMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nRollupMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMetadata.kt\norg/opensearch/indexmanagement/rollup/model/ContinuousMetadata$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ContinuousMetadata parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Instant windowStartTime = null;
            Instant windowEndTime = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)ContinuousMetadata.NEXT_WINDOW_START_TIME_FIELD)) {
                    windowStartTime = OpenSearchExtensionsKt.instant(xcp);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)ContinuousMetadata.NEXT_WINDOW_END_TIME_FIELD)) continue;
                windowEndTime = OpenSearchExtensionsKt.instant(xcp);
            }
            Instant instant = windowStartTime;
            if (instant == null) {
                boolean $i$a$-requireNotNull-ContinuousMetadata$Companion$parse$32 = false;
                String $i$a$-requireNotNull-ContinuousMetadata$Companion$parse$32 = "Next window start time must not be null for a continuous job";
                throw new IllegalArgumentException($i$a$-requireNotNull-ContinuousMetadata$Companion$parse$32.toString());
            }
            Instant instant2 = windowEndTime;
            if (instant2 == null) {
                Instant instant3 = instant;
                boolean bl = false;
                Instant instant4 = instant3;
                String string = "Next window end time must not be null for a continuous job";
                throw new IllegalArgumentException(string.toString());
            }
            Instant instant5 = instant2;
            Instant instant6 = instant;
            return new ContinuousMetadata(instant6, instant5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

