# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_mqttui_global_optspecs
	string join \n payload-size-limit= b/broker= u/username= password= i/client-id= client-cert= client-key= insecure h/help V/version
end

function __fish_mqttui_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_mqttui_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_mqttui_using_subcommand
	set -l cmd (__fish_mqttui_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c mqttui -n "__fish_mqttui_needs_command" -l payload-size-limit -d 'Truncate the payloads stored to the given size' -r -f
complete -c mqttui -n "__fish_mqttui_needs_command" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_needs_command" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_needs_command" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_needs_command" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_needs_command" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_needs_command" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_needs_command" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_needs_command" -s V -l version -d 'Print version'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "clean-retained" -d 'Clean retained messages from the broker'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "c" -d 'Clean retained messages from the broker'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "clean" -d 'Clean retained messages from the broker'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "log" -d 'Log values from subscribed topics to stdout'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "l" -d 'Log values from subscribed topics to stdout'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "read-one" -d 'Wait for the first message on the given topic(s) and return its payload to stdout'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "r" -d 'Wait for the first message on the given topic(s) and return its payload to stdout'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "read" -d 'Wait for the first message on the given topic(s) and return its payload to stdout'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "publish" -d 'Publish a value quickly'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "p" -d 'Publish a value quickly'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "pub" -d 'Publish a value quickly'
complete -c mqttui -n "__fish_mqttui_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l timeout -d 'When there is no message received for the given time the operation is considered done' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l dry-run -d 'Dont clean topics, only log them'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean-retained" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l timeout -d 'When there is no message received for the given time the operation is considered done' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l dry-run -d 'Dont clean topics, only log them'
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand c" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l timeout -d 'When there is no message received for the given time the operation is considered done' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l dry-run -d 'Dont clean topics, only log them'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand clean" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s j -l json -d 'Output incoming packages as newline-delimited JSON'
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s v -l verbose -d 'Show full MQTT communication'
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand log" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s j -l json -d 'Output incoming packages as newline-delimited JSON'
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s v -l verbose -d 'Show full MQTT communication'
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand l" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s r -l ignore-retained -d 'Do not return on a retained message on connection, wait for another message to arrive'
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s p -l pretty -d 'Parse the payload and print it in a human readable pretty form'
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand read-one" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s r -l ignore-retained -d 'Do not return on a retained message on connection, wait for another message to arrive'
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s p -l pretty -d 'Parse the payload and print it in a human readable pretty form'
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand r" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s r -l ignore-retained -d 'Do not return on a retained message on connection, wait for another message to arrive'
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s p -l pretty -d 'Parse the payload and print it in a human readable pretty form'
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand read" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s r -l retain -d 'Publish the MQTT message retained'
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s v -l verbose -d 'Show full MQTT communication'
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand publish" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s r -l retain -d 'Publish the MQTT message retained'
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s v -l verbose -d 'Show full MQTT communication'
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand p" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s b -l broker -d 'URL which represents how to connect to the MQTT broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s u -l username -d 'Username to access the mqtt broker' -r -f -a "(__fish_complete_users)"
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -l password -d 'Password to access the mqtt broker' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s i -l client-id -d 'Specify the client id to connect with' -r -f
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -l client-cert -d 'Path to the TLS client certificate file' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -l client-key -d 'Path to the TLS client private key' -r -F
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s r -l retain -d 'Publish the MQTT message retained'
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s v -l verbose -d 'Show full MQTT communication'
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -l insecure -d 'Allow insecure TLS connections'
complete -c mqttui -n "__fish_mqttui_using_subcommand pub" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c mqttui -n "__fish_mqttui_using_subcommand help; and not __fish_seen_subcommand_from clean-retained log read-one publish help" -f -a "clean-retained" -d 'Clean retained messages from the broker'
complete -c mqttui -n "__fish_mqttui_using_subcommand help; and not __fish_seen_subcommand_from clean-retained log read-one publish help" -f -a "log" -d 'Log values from subscribed topics to stdout'
complete -c mqttui -n "__fish_mqttui_using_subcommand help; and not __fish_seen_subcommand_from clean-retained log read-one publish help" -f -a "read-one" -d 'Wait for the first message on the given topic(s) and return its payload to stdout'
complete -c mqttui -n "__fish_mqttui_using_subcommand help; and not __fish_seen_subcommand_from clean-retained log read-one publish help" -f -a "publish" -d 'Publish a value quickly'
complete -c mqttui -n "__fish_mqttui_using_subcommand help; and not __fish_seen_subcommand_from clean-retained log read-one publish help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
