/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.FrameworkWiringImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.framework.wiring.FrameworkWiring;

public class SystemBundle
extends BundleImpl
implements Framework {
    private static final String BOOT_CLASSPATH_FILE = "boot_cp";
    private String exportPackageString;
    private String provideCapabilityString;
    private volatile FrameworkEvent stopEvent = null;
    private Thread shutdownThread = null;
    private final Object lock = new Object();
    boolean bootClassPathHasChanged;
    private FrameworkWiringImpl fwWiring;
    private TreeMap<BundleImpl, BundleActivator> extensions = new TreeMap();

    SystemBundle(FrameworkContext fw) {
        super(fw);
    }

    @Override
    public void init() throws BundleException {
        this.init(new FrameworkListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(FrameworkListener ... listeners) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        Object object = this.lock;
        synchronized (object) {
            this.waitOnOperation(this.lock, "Framework.init", true);
            switch (this.state) {
                case 2: {
                    this.state = 4;
                }
                case 4: {
                    break;
                }
                case 8: 
                case 32: {
                    return;
                }
                default: {
                    throw new IllegalStateException("INTERNAL ERROR, Illegal state, " + this.state);
                }
            }
            this.doInit(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int options) throws BundleException {
        List<String> bundlesToStart = null;
        Object object = this.lock;
        synchronized (object) {
            this.waitOnOperation(this.lock, "Framework.start", true);
            switch (this.state) {
                case 2: 
                case 4: {
                    this.doInit(new FrameworkListener[0]);
                }
                case 8: {
                    this.operation = 1;
                    break;
                }
                case 32: {
                    return;
                }
                default: {
                    throw new IllegalStateException("INTERNAL ERROR, Illegal state, " + this.state);
                }
            }
            if (this.fwCtx.startLevelController == null) {
                bundlesToStart = this.fwCtx.storage.getStartOnLaunchBundles();
            }
        }
        if (this.fwCtx.startLevelController != null) {
            this.fwCtx.startLevelController.open();
        } else {
            Iterator<String> i = bundlesToStart.iterator();
            while (i.hasNext()) {
                BundleImpl b = (BundleImpl)this.fwCtx.bundles.getBundle(i.next());
                try {
                    int autostartSetting = b.current().archive.getAutostartSetting();
                    int option = 1;
                    if (2 == autostartSetting) {
                        option |= 2;
                    }
                    b.start(option);
                }
                catch (BundleException be) {
                    this.fwCtx.frameworkError(b, (Throwable)be, new FrameworkListener[0]);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.state = 32;
            this.operation = 0;
            this.lock.notifyAll();
            this.fwCtx.listeners.frameworkEvent(new FrameworkEvent(1, this, null), new FrameworkListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if ((6 & this.state) == 0) {
                long st;
                this.stopEvent = null;
                do {
                    st = Util.timeMillis();
                    try {
                        this.lock.wait(timeout);
                        if (this.stopEvent == null) continue;
                        break;
                    }
                    catch (InterruptedException _ignore) {
                        // empty catch block
                    }
                } while (timeout <= 0L || (timeout -= Util.timeMillis() - st) > 0L);
                if (this.stopEvent == null) {
                    return new FrameworkEvent(512, this, null);
                }
            } else if (this.stopEvent == null) {
                this.stopEvent = new FrameworkEvent(64, this, null);
            }
            return this.stopEvent;
        }
    }

    @Override
    public void stop(int options) throws BundleException {
        this.secure.checkExecuteAdminPerm(this);
        this.secure.callShutdown(this, false);
    }

    @Override
    public void update(InputStream in) throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.secure.callShutdown(this, true);
    }

    @Override
    public void uninstall() throws BundleException {
        this.secure.checkLifecycleAdminPerm(this);
        throw new BundleException("Uninstall of System bundle is not allowed", 2);
    }

    @Override
    public boolean hasPermission(Object permission) {
        return true;
    }

    @Override
    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        this.secure.checkMetadataAdminPerm(this);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Bundle-SymbolicName", this.getSymbolicName());
        headers.put("Bundle-Name", this.location);
        headers.put("Export-Package", this.exportPackageString);
        headers.put("Bundle-Version", this.getVersion().toString());
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-RequiredExecutionEnvironment", this.fwCtx.props.getProperty("org.osgi.framework.executionenvironment"));
        headers.put("Bundle-Icon", "icon.png;size=32,icon64.png;size=64");
        headers.put("Bundle-Vendor", "Knopflerfish");
        headers.put("Bundle-Description", "Knopflerfish System Bundle");
        headers.put("Provide-Capability", this.provideCapabilityString);
        return headers;
    }

    @Override
    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return null;
    }

    @Override
    public URL getEntry(String name) {
        if (this.secure.okResourceAdminPerm(this)) {
            return this.getClassLoader().getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        return null;
    }

    @Override
    public <A> A adapt(Class<A> type) {
        this.secure.checkAdaptPerm(this, type);
        Object res = null;
        if (FrameworkWiring.class.equals(type)) {
            res = this.fwWiring;
        } else if (FrameworkStartLevel.class.equals(type)) {
            if (this.fwCtx.startLevelController != null) {
                res = this.fwCtx.startLevelController.frameworkStartLevel();
            }
        } else if (Framework.class.equals(type)) {
            res = this;
        } else if (FrameworkStartLevelDTO.class.equals(type)) {
            if (this.fwCtx.startLevelController != null) {
                res = this.fwCtx.startLevelController.frameworkStartLevel().getDTO();
            }
        } else {
            res = FrameworkDTO.class.equals(type) ? this.getFrameworkDTO() : this.adaptSecure(type);
        }
        return (A)res;
    }

    @Override
    ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    void systemShuttingdown(boolean restart) throws BundleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemShuttingdownDone(FrameworkEvent fe) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 2) {
                this.state = 4;
                this.operation = 0;
                this.lock.notifyAll();
            }
            this.stopEvent = fe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void attachExtension(BundleGeneration extension) throws BundleException {
        if (extension.isBootClassPathExtension()) {
            if (this.getClassLoader() != null) throw new BundleException("Bootclasspath extension can not be dynamicly activated", 1);
            this.current().attachFragment(extension, false);
            return;
        }
        if (this.extensions.containsKey(extension.bundle)) {
            throw new BundleException("Framework extension updates can not be resolved", 7);
        }
        try {
            this.addClassPathURL(new URL("file:" + extension.archive.getJarLocation()));
        }
        catch (Exception e) {
            throw new BundleException("Framework extension could not be dynamicly activated", 1, e);
        }
        this.current().attachFragment(extension, false);
        this.extensions.put(extension.bundle, this.handleExtensionActivator(extension));
    }

    void readLocalization(String locale, Hashtable<String, String> localization_entries, String baseName) {
        Vector fragments = (Vector)this.current().fragments.clone();
        if (fragments == null) {
            return;
        }
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if (!locale.equals("")) {
            locale = "_" + locale;
        }
        while (true) {
            String l = baseName + locale + ".properties";
            for (int i = fragments.size() - 1; i >= 0; --i) {
                BundleGeneration bg = (BundleGeneration)fragments.get(i);
                Hashtable<String, String> tmp = bg.archive.getLocalizationEntries(l);
                if (tmp == null) continue;
                localization_entries.putAll(tmp);
                return;
            }
            int pos = locale.lastIndexOf(95);
            if (pos == -1) break;
            locale = locale.substring(0, pos);
        }
    }

    void initSystemBundle() {
        String epc;
        String extraPkgs;
        this.bundleContext = new BundleContextImpl(this);
        StringBuffer sp = new StringBuffer(this.fwCtx.props.getProperty("org.osgi.framework.system.packages"));
        if (sp.length() == 0) {
            String sysPkgFile = this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.file");
            if (sysPkgFile.length() != 0) {
                this.addSysPackagesFromFile(sp, sysPkgFile, null);
            } else {
                sp.append(this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.base"));
                if (sp.length() == 0) {
                    if (FWProps.androidApiLevel >= 0) {
                        this.addSysPackagesFromResource(sp, "android_packages.txt", new Version(FWProps.androidApiLevel, 0, 0));
                    } else {
                        Version jv;
                        block21: {
                            String jver = this.fwCtx.props.getProperty("org.knopflerfish.framework.system.packages.version");
                            jv = new Version(1, 7, 0);
                            if (jver == null) {
                                if (FWProps.javaVersionMajor >= 0) {
                                    int minor = FWProps.javaVersionMinor > 0 ? FWProps.javaVersionMinor : 0;
                                    jv = new Version(FWProps.javaVersionMajor, minor, 0);
                                } else if (this.fwCtx.debug.framework) {
                                    this.fwCtx.debug.println("No built in list of Java packages to be exported by the system bundle for JRE with unknown version, using the list for " + jv);
                                }
                            } else {
                                try {
                                    jv = new Version(jver);
                                }
                                catch (IllegalArgumentException _ignore) {
                                    if (!this.fwCtx.debug.framework) break block21;
                                    this.fwCtx.debug.println("No built in list of Java packages to be exported by the system bundle for JRE with version '" + jver + "', using the list for " + jv);
                                }
                            }
                        }
                        this.addSysPackagesFromResource(sp, "packages.txt", jv);
                    }
                } else if (sp.charAt(sp.length() - 1) == ',') {
                    sp.deleteCharAt(sp.length() - 1);
                }
                this.addSysPackagesFromResource(sp, "exports", null);
            }
        }
        if ((extraPkgs = this.fwCtx.props.getProperty("org.osgi.framework.system.packages.extra")).length() > 0) {
            sp.append(",").append(extraPkgs);
        }
        this.exportPackageString = sp.toString();
        sp.setLength(0);
        sp.append(this.fwCtx.props.getProperty("org.osgi.framework.system.capabilities"));
        if (sp.length() == 0) {
            this.addSysCapabilitiesFromEE(sp);
        }
        if ((epc = this.fwCtx.props.getProperty("org.osgi.framework.system.capabilities.extra")).length() > 0) {
            if (sp.length() > 0) {
                sp.append(',');
            }
            sp.append(epc);
        }
        this.provideCapabilityString = sp.toString();
        BundleGeneration gen = new BundleGeneration(this, this.exportPackageString, this.provideCapabilityString);
        this.generations.add(gen);
        gen.bpkgs.registerPackages();
        try {
            gen.bpkgs.resolvePackages(null);
        }
        catch (BundleException _ignore) {
            // empty catch block
        }
        gen.setWired();
        this.fwWiring = new FrameworkWiringImpl(this.fwCtx);
        this.state = 8;
    }

    void uninitSystemBundle() {
        this.bundleContext.invalidate();
        this.bundleContext = null;
        if (!this.bootClassPathHasChanged) {
            for (BundleGeneration bg : this.fwCtx.bundles.getFragmentBundles(this.current())) {
                if (!bg.isBootClassPathExtension() || !bg.bundle.extensionNeedsRestart()) continue;
                this.bootClassPathHasChanged = true;
                break;
            }
        }
        this.exportPackageString = null;
        this.provideCapabilityString = null;
        this.generations.clear();
        this.fwWiring = null;
    }

    BundleCapabilityImpl getNativeCapability() {
        return this.current().getDeclaredCapabilities().get("osgi.native").get(0);
    }

    void extensionCallStart(BundleImpl b) {
        if (b != null) {
            this.callBundleActivatorStart(b);
        } else {
            BundleImpl[] bs;
            for (BundleImpl be : bs = this.extensions.keySet().toArray(new BundleImpl[this.extensions.size()])) {
                this.callBundleActivatorStart(be);
            }
        }
    }

    private void doInit(FrameworkListener ... listeners) throws BundleException {
        this.bootClassPathHasChanged = false;
        this.fwCtx.init(listeners);
    }

    private void addSysPackagesFromFile(StringBuffer sp, String sysPkgFile, Version guard) {
        File f;
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("Will add system packages from file " + sysPkgFile);
        }
        if (!(f = new File(new File(sysPkgFile).getAbsolutePath())).exists() || !f.isFile()) {
            throw new IllegalArgumentException("Could not add system bundle package exports from '" + sysPkgFile + "', file not found.");
        }
        try {
            this.addSysPackagesFromStream(sp, new FileReader(f), guard);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read " + sysPkgFile + ": " + e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to parse " + sysPkgFile + ": " + e);
        }
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("\treading from " + f.getAbsolutePath());
        }
    }

    private void addSysPackagesFromResource(StringBuffer sp, String sysPkgResource, Version guard) {
        URL url;
        if (this.fwCtx.debug.resolver) {
            this.fwCtx.debug.println("Will add system packages from resource " + sysPkgResource);
        }
        if (null == (url = SystemBundle.class.getResource(sysPkgResource))) {
            url = SystemBundle.class.getResource("/" + sysPkgResource);
        }
        if (null != url) {
            try {
                this.addSysPackagesFromStream(sp, new InputStreamReader(url.openStream()), guard);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read resource " + sysPkgResource + ": " + e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to parse resource " + sysPkgResource + ": " + e);
            }
            if (this.fwCtx.debug.resolver) {
                this.fwCtx.debug.println("\treading from " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSysPackagesFromStream(StringBuffer sp, Reader reader, Version guard) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(reader);
            String line = in.readLine();
            while (line != null) {
                block13: {
                    block14: {
                        if ((line = line.trim()).length() <= 0 || line.startsWith("#")) break block13;
                        int idx = line.lastIndexOf(33);
                        if (idx == -1) break block14;
                        if (!new VersionRange(line.substring(idx + 1)).includes(guard)) break block13;
                        line = line.substring(0, idx);
                    }
                    if (sp.length() > 0) {
                        sp.append(",");
                    }
                    sp.append(line);
                }
                line = in.readLine();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception _ignore) {}
        }
    }

    private void addSysCapabilitiesFromEE(StringBuffer sp) {
        HashMap<String, SortedSet<Version>> eeNameVersions = new HashMap<String, SortedSet<Version>>();
        String fwEE = this.fwCtx.props.getProperty("org.osgi.framework.executionenvironment");
        if (fwEE != null && fwEE.length() > 0) {
            String[] ees;
            block8: for (String ee : ees = Util.splitwords(fwEE, ",")) {
                String[] n1n2 = Util.splitwords(ee, "/");
                switch (n1n2.length) {
                    case 1: {
                        String[] nv = Util.splitwords(ee, "-");
                        if (nv.length == 2) {
                            try {
                                Version v = new Version(nv[1]);
                                this.addSysCapabilityEE(eeNameVersions, nv[0], v);
                            }
                            catch (Exception e) {
                                this.addSysCapabilityEE(eeNameVersions, ee, null);
                            }
                            continue block8;
                        }
                        this.addSysCapabilityEE(eeNameVersions, ee, null);
                        continue block8;
                    }
                    case 2: {
                        String[] n1v = Util.splitwords(n1n2[0], "-");
                        String[] n2v = Util.splitwords(n1n2[1], "-");
                        try {
                            Version v1 = n1v.length == 2 ? new Version(n1v[1]) : null;
                            Version v2 = n2v.length == 2 ? new Version(n2v[1]) : null;
                            String n = n1v[0] + "/" + n2v[0];
                            if (v1 != null && v2 != null && v1.equals(v2)) {
                                this.addSysCapabilityEE(eeNameVersions, n, v1);
                                continue block8;
                            }
                            if (v1 != null && v2 == null) {
                                this.addSysCapabilityEE(eeNameVersions, n, v1);
                                continue block8;
                            }
                            if (v1 == null && v2 != null) {
                                this.addSysCapabilityEE(eeNameVersions, n, v2);
                                continue block8;
                            }
                            this.addSysCapabilityEE(eeNameVersions, ee, null);
                        }
                        catch (Exception e) {
                            this.addSysCapabilityEE(eeNameVersions, ee, null);
                        }
                        continue block8;
                    }
                    default: {
                        this.addSysCapabilityEE(eeNameVersions, ee, null);
                    }
                }
            }
        }
        this.addSysCapabilityForEE(sp, eeNameVersions);
    }

    private void addSysCapabilityEE(Map<String, SortedSet<Version>> eeNameVersions, String name, Version v) {
        SortedSet<Version> versions;
        if ("J2SE".equals(name)) {
            name = "JavaSE";
        }
        if ((versions = eeNameVersions.get(name)) == null) {
            versions = new TreeSet<Version>();
            eeNameVersions.put(name, versions);
        }
        if (v != null) {
            versions.add(v);
        }
    }

    private void addSysCapabilityForEE(StringBuffer sb, Map<String, SortedSet<Version>> eeNameVersions) {
        for (Map.Entry<String, SortedSet<Version>> entry : eeNameVersions.entrySet()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("osgi.ee");
            sb.append(';');
            sb.append("osgi.ee");
            sb.append('=');
            sb.append(entry.getKey());
            if (entry.getValue().isEmpty()) continue;
            sb.append(";version:List<Version>=\"");
            for (Version v : entry.getValue()) {
                sb.append(v.toString());
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, '\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(final boolean restart) {
        Object object = this.lock;
        synchronized (object) {
            boolean wasActive = false;
            switch (this.state) {
                case 2: 
                case 4: {
                    this.shutdownDone(false);
                    break;
                }
                case 32: {
                    wasActive = true;
                }
                case 8: {
                    if (this.shutdownThread != null) break;
                    try {
                        final boolean wa = wasActive;
                        this.shutdownThread = new Thread(this.fwCtx.threadGroup, "Framework shutdown"){

                            @Override
                            public void run() {
                                SystemBundle.this.shutdown0(restart, wa);
                            }
                        };
                        this.shutdownThread.setDaemon(false);
                        this.shutdownThread.start();
                    }
                    catch (Exception e) {
                        this.systemShuttingdownDone(new FrameworkEvent(2, this, e));
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown0(boolean restart, boolean wasActive) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.waitOnOperation(this.lock, "Framework." + (restart ? "update" : "stop"), true);
                this.operation = 2;
                this.state = 16;
            }
            this.fwCtx.listeners.bundleChanged(new BundleEvent(256, this));
            if (wasActive) {
                this.stopAllBundles();
                this.saveClasspaths();
            }
            this.extensionCallStop();
            object = this.lock;
            synchronized (object) {
                this.fwCtx.uninit();
                this.shutdownThread = null;
                this.shutdownDone(restart);
            }
            if (restart) {
                if (wasActive) {
                    this.start();
                } else {
                    this.init();
                }
            }
        }
        catch (Exception e) {
            this.shutdownThread = null;
            this.systemShuttingdownDone(new FrameworkEvent(2, this, e));
        }
    }

    private void shutdownDone(boolean restart) {
        int t = this.bootClassPathHasChanged ? 256 : (restart ? 128 : 64);
        this.systemShuttingdownDone(new FrameworkEvent(t, this, null));
    }

    private void stopAllBundles() {
        if (this.fwCtx.startLevelController != null) {
            this.fwCtx.startLevelController.shutdown();
        }
        List<BundleImpl> activeBundles = this.fwCtx.bundles.getActiveBundles();
        for (int i = activeBundles.size() - 1; i >= 0; --i) {
            BundleImpl b = activeBundles.get(i);
            try {
                if ((0x28 & b.getState()) == 0) continue;
                b.stop(1);
                continue;
            }
            catch (BundleException be) {
                this.fwCtx.frameworkError(b, (Throwable)be, new FrameworkListener[0]);
            }
        }
        for (BundleImpl bundleImpl : this.fwCtx.bundles.getBundles()) {
            BundleImpl b = bundleImpl;
            if (b.getBundleId() == 0L) continue;
            b.setStateInstalled(false);
            b.purge();
        }
    }

    private void saveClasspaths() {
        block6: {
            StringBuffer bootClasspath = new StringBuffer();
            Iterator<BundleGeneration> i$ = this.fwCtx.bundles.getFragmentBundles(this.current()).iterator();
            while (i$.hasNext()) {
                BundleGeneration bundleGeneration;
                BundleGeneration ebg = bundleGeneration = i$.next();
                String path = ebg.archive.getJarLocation();
                if (!ebg.isBootClassPathExtension()) continue;
                if (bootClasspath.length() > 0) {
                    bootClasspath.append(File.pathSeparator);
                }
                bootClasspath.append(path);
            }
            try {
                File bcpf = new File(Util.getFrameworkDir(this.fwCtx), BOOT_CLASSPATH_FILE);
                if (bootClasspath.length() > 0) {
                    this.saveStringBuffer(bcpf, bootClasspath);
                } else {
                    bcpf.delete();
                }
            }
            catch (IOException e) {
                if (!this.fwCtx.debug.errors) break block6;
                this.fwCtx.debug.println("Could not save classpath " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStringBuffer(File f, StringBuffer content) throws IOException {
        PrintStream out = null;
        try {
            out = new PrintStream(new FileOutputStream(f));
            out.println(content.toString());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void addClassPathURL(URL url) throws Exception {
        ClassLoader cl = this.getClassLoader();
        Method m = Util.getMethod(cl.getClass(), "addURL", new Class[]{URL.class});
        if (m == null) {
            throw new NoSuchMethodException("addURL");
        }
        m.invoke((Object)cl, url);
    }

    private BundleActivator handleExtensionActivator(BundleGeneration extension) throws BundleException {
        String extActivatorName = extension.archive.getAttribute("ExtensionBundle-Activator");
        String string = extActivatorName = null != extActivatorName ? extActivatorName.trim() : null;
        if (null != extActivatorName && extActivatorName.length() > 0) {
            this.fwCtx.log("Create bundle activator for extension: " + extension.symbolicName + ":" + extension.version + " using: " + extActivatorName);
            try {
                Class<?> c = Class.forName(extActivatorName);
                return (BundleActivator)c.newInstance();
            }
            catch (Throwable t) {
                String msg = "Failed to instanciate extension activator " + extActivatorName + ", " + extension.bundle;
                this.fwCtx.log(msg, t);
                throw new BundleException(msg, 5, t);
            }
        }
        return null;
    }

    private void callBundleActivatorStart(BundleImpl b) {
        BundleActivator ba = this.extensions.get(b);
        if (ba != null) {
            if (this.fwCtx.debug.framework) {
                this.fwCtx.debug.println("Call extension bundle start: " + b);
            }
            try {
                ba.start(this.bundleContext);
            }
            catch (Throwable t) {
                this.extensions.put(b, null);
                String msg = "Failed to start framework extension, " + b;
                this.fwCtx.frameworkError(b, (Throwable)new BundleException(msg, 5, t), new FrameworkListener[0]);
            }
        }
    }

    private void extensionCallStop() {
        BundleImpl[] bs = this.extensions.keySet().toArray(new BundleImpl[this.extensions.size()]);
        for (int i = bs.length - 1; i >= 0; --i) {
            BundleActivator ba;
            if (this.fwCtx.debug.framework) {
                this.fwCtx.debug.println("Call extension bundle stop: " + bs[i]);
            }
            if ((ba = this.extensions.get(bs[i])) == null) continue;
            try {
                ba.stop(this.bundleContext);
                continue;
            }
            catch (Throwable t) {
                String msg = "Failed to stop framework extension, " + bs[i];
                this.fwCtx.frameworkError(bs[i], (Throwable)new BundleException(msg, 5, t), new FrameworkListener[0]);
            }
        }
        this.extensions.clear();
    }

    private FrameworkDTO getFrameworkDTO() {
        FrameworkDTO res = new FrameworkDTO();
        res.bundles = new ArrayList<BundleDTO>();
        for (BundleImpl bundleImpl : this.fwCtx.bundles.getBundles()) {
            res.bundles.add(bundleImpl.getDTO());
        }
        res.properties = this.fwCtx.props.getFWProperties();
        res.services = new ArrayList<ServiceReferenceDTO>();
        for (ServiceRegistrationImpl serviceRegistrationImpl : this.fwCtx.services.getAllRegistered()) {
            ServiceReferenceDTO srdto = serviceRegistrationImpl.getDTO();
            if (srdto == null) continue;
            res.services.add(srdto);
        }
        return res;
    }
}

