﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/backup/model/CalculatedLifecycle.h>
#include <aws/backup/model/Lifecycle.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {
class UpdateRecoveryPointLifecycleResult {
 public:
  AWS_BACKUP_API UpdateRecoveryPointLifecycleResult() = default;
  AWS_BACKUP_API UpdateRecoveryPointLifecycleResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BACKUP_API UpdateRecoveryPointLifecycleResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An ARN that uniquely identifies a backup vault; for example,
   * <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.</p>
   */
  inline const Aws::String& GetBackupVaultArn() const { return m_backupVaultArn; }
  template <typename BackupVaultArnT = Aws::String>
  void SetBackupVaultArn(BackupVaultArnT&& value) {
    m_backupVaultArnHasBeenSet = true;
    m_backupVaultArn = std::forward<BackupVaultArnT>(value);
  }
  template <typename BackupVaultArnT = Aws::String>
  UpdateRecoveryPointLifecycleResult& WithBackupVaultArn(BackupVaultArnT&& value) {
    SetBackupVaultArn(std::forward<BackupVaultArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for
   * example,
   * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.</p>
   */
  inline const Aws::String& GetRecoveryPointArn() const { return m_recoveryPointArn; }
  template <typename RecoveryPointArnT = Aws::String>
  void SetRecoveryPointArn(RecoveryPointArnT&& value) {
    m_recoveryPointArnHasBeenSet = true;
    m_recoveryPointArn = std::forward<RecoveryPointArnT>(value);
  }
  template <typename RecoveryPointArnT = Aws::String>
  UpdateRecoveryPointLifecycleResult& WithRecoveryPointArn(RecoveryPointArnT&& value) {
    SetRecoveryPointArn(std::forward<RecoveryPointArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The lifecycle defines when a protected resource is transitioned to cold
   * storage and when it expires. Backup transitions and expires backups
   * automatically according to the lifecycle that you define.</p> <p>Backups
   * transitioned to cold storage must be stored in cold storage for a minimum of 90
   * days. Therefore, the “retention” setting must be 90 days greater than the
   * “transition to cold after days” setting. The “transition to cold after days”
   * setting cannot be changed after a backup has been transitioned to cold.</p>
   * <p>Resource types that can transition to cold storage are listed in the <a
   * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource">Feature
   * availability by resource</a> table. Backup ignores this expression for other
   * resource types.</p>
   */
  inline const Lifecycle& GetLifecycle() const { return m_lifecycle; }
  template <typename LifecycleT = Lifecycle>
  void SetLifecycle(LifecycleT&& value) {
    m_lifecycleHasBeenSet = true;
    m_lifecycle = std::forward<LifecycleT>(value);
  }
  template <typename LifecycleT = Lifecycle>
  UpdateRecoveryPointLifecycleResult& WithLifecycle(LifecycleT&& value) {
    SetLifecycle(std::forward<LifecycleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code>
   * and <code>MoveToColdStorageAt</code> timestamps.</p>
   */
  inline const CalculatedLifecycle& GetCalculatedLifecycle() const { return m_calculatedLifecycle; }
  template <typename CalculatedLifecycleT = CalculatedLifecycle>
  void SetCalculatedLifecycle(CalculatedLifecycleT&& value) {
    m_calculatedLifecycleHasBeenSet = true;
    m_calculatedLifecycle = std::forward<CalculatedLifecycleT>(value);
  }
  template <typename CalculatedLifecycleT = CalculatedLifecycle>
  UpdateRecoveryPointLifecycleResult& WithCalculatedLifecycle(CalculatedLifecycleT&& value) {
    SetCalculatedLifecycle(std::forward<CalculatedLifecycleT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateRecoveryPointLifecycleResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_backupVaultArn;
  bool m_backupVaultArnHasBeenSet = false;

  Aws::String m_recoveryPointArn;
  bool m_recoveryPointArnHasBeenSet = false;

  Lifecycle m_lifecycle;
  bool m_lifecycleHasBeenSet = false;

  CalculatedLifecycle m_calculatedLifecycle;
  bool m_calculatedLifecycleHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
