package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstallCaptcha invokes the sas.DescribeInstallCaptcha API synchronously
func (client *Client) DescribeInstallCaptcha(request *DescribeInstallCaptchaRequest) (response *DescribeInstallCaptchaResponse, err error) {
	response = CreateDescribeInstallCaptchaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstallCaptchaWithChan invokes the sas.DescribeInstallCaptcha API asynchronously
func (client *Client) DescribeInstallCaptchaWithChan(request *DescribeInstallCaptchaRequest) (<-chan *DescribeInstallCaptchaResponse, <-chan error) {
	responseChan := make(chan *DescribeInstallCaptchaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstallCaptcha(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstallCaptchaWithCallback invokes the sas.DescribeInstallCaptcha API asynchronously
func (client *Client) DescribeInstallCaptchaWithCallback(request *DescribeInstallCaptchaRequest, callback func(response *DescribeInstallCaptchaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstallCaptchaResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstallCaptcha(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstallCaptchaRequest is the request struct for api DescribeInstallCaptcha
type DescribeInstallCaptchaRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
	Deadline string `position:"Query" name:"Deadline"`
}

// DescribeInstallCaptchaResponse is the response struct for api DescribeInstallCaptcha
type DescribeInstallCaptchaResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	CaptchaCode string `json:"CaptchaCode" xml:"CaptchaCode"`
	Deadline    int    `json:"Deadline" xml:"Deadline"`
}

// CreateDescribeInstallCaptchaRequest creates a request to invoke DescribeInstallCaptcha API
func CreateDescribeInstallCaptchaRequest() (request *DescribeInstallCaptchaRequest) {
	request = &DescribeInstallCaptchaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeInstallCaptcha", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstallCaptchaResponse creates a response to parse from DescribeInstallCaptcha response
func CreateDescribeInstallCaptchaResponse() (response *DescribeInstallCaptchaResponse) {
	response = &DescribeInstallCaptchaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
