package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDataDispatchEnablingState invokes the linkwan.UpdateDataDispatchEnablingState API synchronously
func (client *Client) UpdateDataDispatchEnablingState(request *UpdateDataDispatchEnablingStateRequest) (response *UpdateDataDispatchEnablingStateResponse, err error) {
	response = CreateUpdateDataDispatchEnablingStateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDataDispatchEnablingStateWithChan invokes the linkwan.UpdateDataDispatchEnablingState API asynchronously
func (client *Client) UpdateDataDispatchEnablingStateWithChan(request *UpdateDataDispatchEnablingStateRequest) (<-chan *UpdateDataDispatchEnablingStateResponse, <-chan error) {
	responseChan := make(chan *UpdateDataDispatchEnablingStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDataDispatchEnablingState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDataDispatchEnablingStateWithCallback invokes the linkwan.UpdateDataDispatchEnablingState API asynchronously
func (client *Client) UpdateDataDispatchEnablingStateWithCallback(request *UpdateDataDispatchEnablingStateRequest, callback func(response *UpdateDataDispatchEnablingStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDataDispatchEnablingStateResponse
		var err error
		defer close(result)
		response, err = client.UpdateDataDispatchEnablingState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDataDispatchEnablingStateRequest is the request struct for api UpdateDataDispatchEnablingState
type UpdateDataDispatchEnablingStateRequest struct {
	*requests.RpcRequest
	DataDispatchEnabled requests.Boolean `position:"Query" name:"DataDispatchEnabled"`
	NodeGroupId         string           `position:"Query" name:"NodeGroupId"`
	ApiProduct          string           `position:"Body" name:"ApiProduct"`
	ApiRevision         string           `position:"Body" name:"ApiRevision"`
}

// UpdateDataDispatchEnablingStateResponse is the response struct for api UpdateDataDispatchEnablingState
type UpdateDataDispatchEnablingStateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateDataDispatchEnablingStateRequest creates a request to invoke UpdateDataDispatchEnablingState API
func CreateUpdateDataDispatchEnablingStateRequest() (request *UpdateDataDispatchEnablingStateRequest) {
	request = &UpdateDataDispatchEnablingStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateDataDispatchEnablingState", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDataDispatchEnablingStateResponse creates a response to parse from UpdateDataDispatchEnablingState response
func CreateUpdateDataDispatchEnablingStateResponse() (response *UpdateDataDispatchEnablingStateResponse) {
	response = &UpdateDataDispatchEnablingStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
