package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupSummary invokes the hbase.DescribeBackupSummary API synchronously
func (client *Client) DescribeBackupSummary(request *DescribeBackupSummaryRequest) (response *DescribeBackupSummaryResponse, err error) {
	response = CreateDescribeBackupSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupSummaryWithChan invokes the hbase.DescribeBackupSummary API asynchronously
func (client *Client) DescribeBackupSummaryWithChan(request *DescribeBackupSummaryRequest) (<-chan *DescribeBackupSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupSummaryWithCallback invokes the hbase.DescribeBackupSummary API asynchronously
func (client *Client) DescribeBackupSummaryWithCallback(request *DescribeBackupSummaryRequest, callback func(response *DescribeBackupSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupSummaryRequest is the request struct for api DescribeBackupSummary
type DescribeBackupSummaryRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeBackupSummaryResponse is the response struct for api DescribeBackupSummary
type DescribeBackupSummaryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Incr      Incr   `json:"Incr" xml:"Incr"`
	Full      Full   `json:"Full" xml:"Full"`
}

// CreateDescribeBackupSummaryRequest creates a request to invoke DescribeBackupSummary API
func CreateDescribeBackupSummaryRequest() (request *DescribeBackupSummaryRequest) {
	request = &DescribeBackupSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeBackupSummary", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupSummaryResponse creates a response to parse from DescribeBackupSummary response
func CreateDescribeBackupSummaryResponse() (response *DescribeBackupSummaryResponse) {
	response = &DescribeBackupSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
