package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDtsServiceLog invokes the dts.DescribeDtsServiceLog API synchronously
func (client *Client) DescribeDtsServiceLog(request *DescribeDtsServiceLogRequest) (response *DescribeDtsServiceLogResponse, err error) {
	response = CreateDescribeDtsServiceLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDtsServiceLogWithChan invokes the dts.DescribeDtsServiceLog API asynchronously
func (client *Client) DescribeDtsServiceLogWithChan(request *DescribeDtsServiceLogRequest) (<-chan *DescribeDtsServiceLogResponse, <-chan error) {
	responseChan := make(chan *DescribeDtsServiceLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDtsServiceLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDtsServiceLogWithCallback invokes the dts.DescribeDtsServiceLog API asynchronously
func (client *Client) DescribeDtsServiceLogWithCallback(request *DescribeDtsServiceLogRequest, callback func(response *DescribeDtsServiceLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDtsServiceLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeDtsServiceLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDtsServiceLogRequest is the request struct for api DescribeDtsServiceLog
type DescribeDtsServiceLogRequest struct {
	*requests.RpcRequest
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	DtsJobId   string           `position:"Query" name:"DtsJobId"`
	Keyword    string           `position:"Query" name:"Keyword"`
	SubJobType string           `position:"Query" name:"SubJobType"`
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeDtsServiceLogResponse is the response struct for api DescribeDtsServiceLog
type DescribeDtsServiceLogResponse struct {
	*responses.BaseResponse
	HttpStatusCode     int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId          string              `json:"RequestId" xml:"RequestId"`
	ErrCode            string              `json:"ErrCode" xml:"ErrCode"`
	Success            bool                `json:"Success" xml:"Success"`
	PageRecordCount    int                 `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount   int64               `json:"TotalRecordCount" xml:"TotalRecordCount"`
	ErrMessage         string              `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage     string              `json:"DynamicMessage" xml:"DynamicMessage"`
	PageNumber         int                 `json:"PageNumber" xml:"PageNumber"`
	DynamicCode        string              `json:"DynamicCode" xml:"DynamicCode"`
	ServiceLogContexts []ServiceLogContext `json:"ServiceLogContexts" xml:"ServiceLogContexts"`
}

// CreateDescribeDtsServiceLogRequest creates a request to invoke DescribeDtsServiceLog API
func CreateDescribeDtsServiceLogRequest() (request *DescribeDtsServiceLogRequest) {
	request = &DescribeDtsServiceLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDtsServiceLog", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDtsServiceLogResponse creates a response to parse from DescribeDtsServiceLog response
func CreateDescribeDtsServiceLogResponse() (response *DescribeDtsServiceLogResponse) {
	response = &DescribeDtsServiceLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
