package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceAdmin invokes the cloudcallcenter.ModifyInstanceAdmin API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyinstanceadmin.html
func (client *Client) ModifyInstanceAdmin(request *ModifyInstanceAdminRequest) (response *ModifyInstanceAdminResponse, err error) {
	response = CreateModifyInstanceAdminResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceAdminWithChan invokes the cloudcallcenter.ModifyInstanceAdmin API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyinstanceadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceAdminWithChan(request *ModifyInstanceAdminRequest) (<-chan *ModifyInstanceAdminResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceAdminResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceAdmin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceAdminWithCallback invokes the cloudcallcenter.ModifyInstanceAdmin API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyinstanceadmin.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyInstanceAdminWithCallback(request *ModifyInstanceAdminRequest, callback func(response *ModifyInstanceAdminResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceAdminResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceAdmin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceAdminRequest is the request struct for api ModifyInstanceAdmin
type ModifyInstanceAdminRequest struct {
	*requests.RpcRequest
	RemoveUserRamId  string    `position:"Query" name:"RemoveUserRamId"`
	NewAddUserDetail string    `position:"Query" name:"NewAddUserDetail"`
	InstanceId       string    `position:"Query" name:"InstanceId"`
	AdminList        *[]string `position:"Query" name:"AdminList"  type:"Repeated"`
}

// ModifyInstanceAdminResponse is the response struct for api ModifyInstanceAdmin
type ModifyInstanceAdminResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateModifyInstanceAdminRequest creates a request to invoke ModifyInstanceAdmin API
func CreateModifyInstanceAdminRequest() (request *ModifyInstanceAdminRequest) {
	request = &ModifyInstanceAdminRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyInstanceAdmin", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceAdminResponse creates a response to parse from ModifyInstanceAdmin response
func CreateModifyInstanceAdminResponse() (response *ModifyInstanceAdminResponse) {
	response = &ModifyInstanceAdminResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
