/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyChain;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.MonomorphicCallSite;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.TypeConverter;
import org.jruby.util.collections.DoubleObject;
import org.jruby.util.collections.SingleBoolean;
import org.jruby.util.collections.SingleDouble;
import org.jruby.util.collections.SingleInt;
import org.jruby.util.collections.SingleLong;
import org.jruby.util.collections.SingleObject;
import org.jruby.util.func.ObjectObjectIntFunction;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    private static final int SORT_MAX = 1;
    private static final int SORT_MIN = -1;

    public static RubyModule createEnumerableModule(Ruby runtime2) {
        RubyModule enumModule = runtime2.defineModule("Enumerable");
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(ThreadContext context, IRubyObject self2, Signature signature, BlockCallback callback) {
        return RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, signature, callback);
    }

    public static IRubyObject callEach(ThreadContext context, CallSite each2, IRubyObject self2, Signature signature, BlockCallback callback) {
        return each2.call(context, self2, self2, CallBlock.newCallClosure(context, self2, signature, callback));
    }

    public static IRubyObject callEach(ThreadContext context, CallSite each2, IRubyObject self2, BlockCallback callback) {
        return each2.call(context, self2, self2, CallBlock.newCallClosure(context, self2, Signature.OPTIONAL, callback));
    }

    public static IRubyObject callEach(ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject[] args2, Signature signature, BlockCallback callback) {
        return each2.call(context, self2, self2, args2, CallBlock.newCallClosure(context, self2, signature, callback));
    }

    public static IRubyObject callEach(ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject arg0, Signature signature, BlockCallback callback) {
        return each2.call(context, self2, self2, arg0, CallBlock.newCallClosure(context, self2, signature, callback));
    }

    public static IRubyObject each(ThreadContext context, CallSite site, IRubyObject self2, BlockBody body) {
        return site.call(context, self2, self2, new Block(body, context.currentBinding(self2, Visibility.PUBLIC)));
    }

    private static void checkContext(ThreadContext firstContext, ThreadContext secondContext, String name2) {
        if (firstContext != secondContext) {
            throw secondContext.runtime.newThreadError("Enumerable#" + name2 + " cannot be parallelized");
        }
    }

    @JRubyMethod(name={"count"})
    public static IRubyObject count(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.countCommon(context, RubyEnumerable.eachSite(context), self2, block);
    }

    private static IRubyObject countCommon(ThreadContext context, CallSite each2, IRubyObject self2, final Block block) {
        Ruby runtime2 = context.runtime;
        final SingleInt result2 = new SingleInt();
        if (block.isGiven()) {
            RubyEnumerable.each(context, each2, self2, new JavaInternalBlockBody(runtime2, context, "Enumerable#count", block.getSignature()){

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    if (block.yield(context1, value2).isTrue()) {
                        ++result2.i;
                    }
                    return context1.nil;
                }
            });
        } else {
            RubyEnumerable.each(context, each2, self2, new JavaInternalBlockBody(runtime2, context, "Enumerable#count", Signature.NO_ARGUMENTS){

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    ++result2.i;
                    return context1.nil;
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    ++result2.i;
                    return context1.nil;
                }
            });
        }
        return RubyFixnum.newFixnum(runtime2, result2.i);
    }

    @JRubyMethod(name={"count"})
    public static IRubyObject count(ThreadContext context, IRubyObject self2, final IRubyObject methodArg, Block block) {
        Ruby runtime2 = context.runtime;
        final SingleInt result2 = new SingleInt();
        if (block.isGiven()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, context, "Enumerable#count", Signature.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
            }

            @Override
            public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                if (value2.equals(methodArg)) {
                    ++result2.i;
                }
                return context1.nil;
            }
        });
        return RubyFixnum.newFixnum(runtime2, result2.i);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "cycle", RubyEnumerable::cycleSize);
        }
        return RubyEnumerable.cycleCommon(context, self2, -1L, block);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return RubyEnumerable.cycle(context, self2, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "cycle", new IRubyObject[]{arg2}, RubyEnumerable::cycleSize);
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.nil;
        }
        return RubyEnumerable.cycleCommon(context, self2, times2, block);
    }

    private static IRubyObject cycleCommon(ThreadContext context, IRubyObject self2, long nv, final Block block) {
        Ruby runtime2 = context.runtime;
        final ArrayList result2 = new ArrayList();
        RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, Signature.OPTIONAL){

            @Override
            public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                return this.doYield(context1, null, RubyEnumerable.packEnumValues(context1, args2));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject doYield(ThreadContext context1, Block unused2, IRubyObject args2) {
                List list2 = result2;
                synchronized (list2) {
                    result2.add(args2);
                }
                block.yield(context1, args2);
                return context1.nil;
            }
        });
        int length2 = result2.size();
        if (length2 == 0) {
            return context.nil;
        }
        while (nv < 0L || 0L < --nv) {
            for (int i2 = 0; i2 < length2; ++i2) {
                block.yield(context, (IRubyObject)result2.get(i2));
            }
        }
        return context.nil;
    }

    private static IRubyObject cycleSize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject size2;
        Ruby runtime2 = context.runtime;
        long mul = 0L;
        IRubyObject n = runtime2.getNil();
        if (args2 != null && args2.length > 0 && !(n = args2[0]).isNil()) {
            mul = n.convertToInteger().getLongValue();
        }
        if ((size2 = RubyEnumerable.size(context, self2, args2)) == null || size2.isNil() || size2.equals(RubyFixnum.zero(runtime2))) {
            return size2;
        }
        if (n == null || n.isNil()) {
            return RubyFloat.newFloat(runtime2, Double.POSITIVE_INFINITY);
        }
        if (mul <= 0L) {
            return RubyFixnum.zero(runtime2);
        }
        return RubyEnumerable.sites((ThreadContext)context).cycle_op_mul.call(context, size2, size2, mul);
    }

    @JRubyMethod(name={"take"})
    public static IRubyObject take(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime2 = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime2.newArgumentError("attempt to take negative size");
        }
        if (len == 0L) {
            return runtime2.newEmptyArray();
        }
        final RubyArray result2 = runtime2.newArray();
        try {
            RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, Signature.OPTIONAL){
                long i;
                {
                    super(runtime2, signature);
                    this.i = len;
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(value2);
                        if (--this.i == 0L) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                    }
                    return context1.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"take_while"})
    public static IRubyObject take_while(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "take_while");
        }
        Ruby runtime2 = context.runtime;
        RubyArray result2 = runtime2.newArray();
        try {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block unused2) -> {
                IRubyObject val;
                IRubyObject larg;
                boolean ary = false;
                switch (largs.length) {
                    case 0: {
                        larg = ctx.nil;
                        break;
                    }
                    case 1: {
                        larg = largs[0];
                        break;
                    }
                    default: {
                        larg = RubyArray.newArrayMayCopy(ctx.runtime, largs);
                        ary = true;
                    }
                }
                IRubyObject iRubyObject = val = ary ? block.yieldArray(ctx, larg, null) : block.yield(ctx, larg);
                if (!val.isTrue()) {
                    throw JumpException.SPECIAL_JUMP;
                }
                RubyArray rubyArray = result2;
                synchronized (rubyArray) {
                    result2.append(larg);
                }
                return ctx.nil;
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"drop"})
    public static IRubyObject drop(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime2 = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime2.newArgumentError("attempt to drop negative size");
        }
        final RubyArray result2 = runtime2.newArray();
        try {
            RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, Signature.OPTIONAL){
                long i;
                {
                    super(runtime2, signature);
                    this.i = len;
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        if (this.i == 0L) {
                            result2.append(value2);
                        } else {
                            --this.i;
                        }
                    }
                    return context1.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject drop_while(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "drop_while");
        }
        Ruby runtime2 = context.runtime;
        final RubyArray result2 = runtime2.newArray();
        try {
            RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, context, "Enumerable#drop_while", Signature.OPTIONAL){
                boolean memo;
                {
                    super(runtime2, originalContext, methodName, signature);
                    this.memo = false;
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    if (!this.memo && !block.yield(context1, value2).isTrue()) {
                        this.memo = true;
                    }
                    if (this.memo) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(value2);
                        }
                    }
                    return context1.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2) {
        final SingleObject<IRubyObject> holder = new SingleObject<IRubyObject>(context.nil);
        try {
            RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(context.runtime, context, "Enumerable#first", Signature.OPTIONAL){

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    holder.object = value2;
                    throw JumpException.SPECIAL_JUMP;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return (IRubyObject)holder.object;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2, IRubyObject num) {
        Ruby runtime2 = context.runtime;
        final long firstCount = RubyNumeric.num2long(num);
        if (firstCount == 0L) {
            return runtime2.newEmptyArray();
        }
        if (firstCount < 0L) {
            throw runtime2.newArgumentError("attempt to take negative size");
        }
        final RubyArray result2 = RubyArray.newArray(runtime2, firstCount);
        try {
            RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, new JavaInternalBlockBody(runtime2, context, "Enumerable#first", Signature.OPTIONAL){
                private long iter;
                {
                    super(runtime2, originalContext, methodName, signature);
                    this.iter = firstCount;
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.yield(context1, RubyEnumerable.packEnumValues(context1, args2));
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject value2) {
                    result2.append(value2);
                    if (this.iter-- == 1L) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return context1.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject tally(ThreadContext context, IRubyObject self2) {
        RubyHash result2 = RubyHash.newHash(context.runtime);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.NO_ARGUMENTS, (BlockCallback)new TallyCallback(result2));
        return result2;
    }

    @JRubyMethod
    public static IRubyObject tally(ThreadContext context, IRubyObject self2, IRubyObject hashArg) {
        RubyHash result2 = (RubyHash)TypeConverter.convertToType(hashArg, context.runtime.getHash(), "to_hash");
        result2.checkFrozen();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.NO_ARGUMENTS, (BlockCallback)new TallyCallback(result2));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"})
    public static IRubyObject to_a(ThreadContext context, IRubyObject self2) {
        RubyArray result2 = context.runtime.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (BlockCallback)new AppendBlockCallback(result2));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, keywords=true)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        Ruby runtime2 = context.runtime;
        RubyArray result2 = runtime2.newArray();
        Helpers.invoke(context, self2, "each", arg2, CallBlock.newCallClosure(context, self2, Signature.OPTIONAL, new AppendBlockCallback(result2)));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, keywords=true)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        RubyArray result2 = runtime2.newArray();
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(context, self2, Signature.OPTIONAL, new AppendBlockCallback(result2)));
        return result2;
    }

    @JRubyMethod(name={"to_h"}, rest=true)
    public static IRubyObject to_h(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyHash result2 = RubyHash.newHash(runtime2);
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(context, self2, Signature.OPTIONAL, new PutKeyValueCallback(result2, block)));
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort(ThreadContext context, IRubyObject self2, Block block) {
        RubyArray result2 = context.runtime.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (BlockCallback)new AppendBlockCallback(result2));
        result2.sort_bang(context, block);
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort_by(ThreadContext context, IRubyObject self2, final Block block) {
        DoubleObject[] valuesAndCriteria;
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "sort_by", RubyEnumerable::size);
        }
        CachingCallSite each2 = RubyEnumerable.eachSite(context);
        if (self2 instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self2;
            final DoubleObject[] valuesAndCriteriaArray = new DoubleObject[selfArray.size()];
            RubyEnumerable.each(context, each2, self2, new JavaInternalBlockBody(runtime2, Signature.OPTIONAL){
                final AtomicInteger i;
                {
                    super(runtime2, signature);
                    this.i = new AtomicInteger(0);
                }

                @Override
                public IRubyObject yield(ThreadContext context1, IRubyObject[] args2) {
                    return this.doYield(context1, null, RubyEnumerable.packEnumValues(context1, args2));
                }

                @Override
                protected IRubyObject doYield(ThreadContext context1, Block unused2, IRubyObject value2) {
                    valuesAndCriteriaArray[this.i.getAndIncrement()] = new DoubleObject<IRubyObject, IRubyObject>(value2, block.yield(context1, value2));
                    return context1.nil;
                }
            });
            valuesAndCriteria = valuesAndCriteriaArray;
        } else {
            final ArrayList valuesAndCriteriaList = new ArrayList();
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext context1, IRubyObject[] args2, Block unused2) {
                    return this.call(context1, RubyEnumerable.packEnumValues(context1, args2), unused2);
                }

                @Override
                public IRubyObject call(ThreadContext context1, IRubyObject arg2, Block unused2) {
                    valuesAndCriteriaList.add(new DoubleObject<IRubyObject, IRubyObject>(arg2, block.yield(context1, arg2)));
                    return context1.nil;
                }
            });
            valuesAndCriteria = valuesAndCriteriaList.toArray(new DoubleObject[valuesAndCriteriaList.size()]);
        }
        Arrays.sort(valuesAndCriteria, (o1, o2) -> RubyComparable.cmpint(context, Helpers.invokedynamic(context, (IRubyObject)o1.object2, MethodNames.OP_CMP, (IRubyObject)o2.object2), (IRubyObject)o1.object2, (IRubyObject)o2.object2));
        IRubyObject[] dstArray = new IRubyObject[valuesAndCriteria.length];
        for (int i2 = 0; i2 < dstArray.length; ++i2) {
            dstArray[i2] = (IRubyObject)valuesAndCriteria[i2].object1;
        }
        return RubyArray.newArrayMayCopy(runtime2, dstArray);
    }

    @JRubyMethod
    public static IRubyObject grep(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.grep(context, self2, pattern, block, true);
    }

    @JRubyMethod(name={"grep_v"})
    public static IRubyObject inverseGrep(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.grep(context, self2, pattern, block, false);
    }

    private static IRubyObject grep(ThreadContext context, IRubyObject self2, final IRubyObject pattern, final Block block, final boolean isPresent) {
        Ruby runtime2 = context.runtime;
        final RubyArray result2 = runtime2.newArray();
        CachingCallSite each2 = RubyEnumerable.eachSite(context);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, new BlockCallback(){
                final MonomorphicCallSite site = new MonomorphicCallSite("===");

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] args2, Block unused2) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, args2), unused2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject arg2, Block unused2) {
                    if (this.site.call(ctx, pattern, pattern, arg2).isTrue() == isPresent) {
                        IRubyObject value2 = block.yield(ctx, arg2);
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(value2);
                        }
                    }
                    return ctx.nil;
                }
            });
        } else if (pattern instanceof RubyRegexp && pattern.getMetaClass().checkMethodBasicDefinition("===")) {
            RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] args2, Block unused2) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, args2), unused2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject arg2, Block unused2) {
                    IRubyObject converted;
                    IRubyObject iRubyObject = converted = arg2 instanceof RubySymbol ? arg2 : TypeConverter.checkStringType(ctx.runtime, arg2);
                    if (((RubyRegexp)pattern).match_p(ctx, converted).isTrue() == isPresent) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(arg2);
                        }
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, new BlockCallback(){
                final MonomorphicCallSite site = new MonomorphicCallSite("===");

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] args2, Block unused2) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, args2), unused2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject arg2, Block unused2) {
                    if (this.site.call(ctx, pattern, pattern, arg2).isTrue() == isPresent) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(arg2);
                        }
                    }
                    return ctx.nil;
                }
            });
        }
        return result2;
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
    }

    public static IRubyObject detectCommon(ThreadContext context, CallSite each2, IRubyObject self2, Block block) {
        return RubyEnumerable.detectCommon(context, each2, self2, null, block);
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        return RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, ifnone, block);
    }

    public static IRubyObject detectCommon(final ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject ifnone, final Block block) {
        Ruby runtime2 = context.runtime;
        final SingleObject<Object> result2 = new SingleObject<Object>(null);
        try {
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    RubyEnumerable.checkContext(context, ctx, "detect/find");
                    if (block.yield(ctx, larg).isTrue()) {
                        result2.object = larg;
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return (IRubyObject)result2.object;
        }
        return ifnone != null && !ifnone.isNil() ? RubyEnumerable.sites((ThreadContext)context).detect_call.call(context, ifnone, ifnone) : runtime2.getNil();
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, null, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect");
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, null, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find");
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, RubyEnumerable.eachSite(context), self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find", ifnone);
    }

    @JRubyMethod(name={"find_index"})
    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, RubyEnumerable.eachSite(context), self2, block, block.getSignature()) : RubyEnumerator.enumeratorize(context.runtime, self2, "find_index");
    }

    @JRubyMethod(name={"find_index"})
    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, IRubyObject cond, Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).find_index(context, cond);
        }
        return RubyEnumerable.find_indexCommon(context, RubyEnumerable.eachSite(context), self2, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, Block block, Signature callbackArity) {
        return RubyEnumerable.find_indexCommon(context, RubyEnumerable.eachSite(context), self2, block, callbackArity);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, CallSite each2, IRubyObject self2, Block block, Signature callbackArity) {
        Ruby runtime2 = context.runtime;
        SingleLong result2 = new SingleLong();
        try {
            RubyEnumerable.callEach(context, each2, self2, callbackArity, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                if (block.yieldValues(ctx, largs).isTrue()) {
                    throw JumpException.SPECIAL_JUMP;
                }
                ++result2.l;
                return ctx.nil;
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime2, result2.l);
        }
        return context.nil;
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, IRubyObject cond) {
        return RubyEnumerable.find_indexCommon(context, RubyEnumerable.eachSite(context), self2, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, CallSite each2, IRubyObject self2, final IRubyObject cond) {
        Ruby runtime2 = context.runtime;
        final SingleLong result2 = new SingleLong(0L);
        try {
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    if (RubyObject.equalInternal(ctx, larg, cond)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    ++result2.l;
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime2, result2.l);
        }
        return context.nil;
    }

    public static IRubyObject selectCommon(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable::size);
        }
        final RubyArray result2 = context.runtime.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject select(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.selectCommon(context, self2, block, "select");
    }

    @JRubyMethod(alias={"filter"})
    public static IRubyObject find_all(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.selectCommon(context, self2, block, "find_all");
    }

    @JRubyMethod
    public static IRubyObject reject(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "reject", RubyEnumerable::size);
        }
        final RubyArray result2 = context.runtime.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg) {
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod(name={"collect"})
    public static IRubyObject collect(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon(context, self2, block, "collect");
    }

    @JRubyMethod(name={"map"})
    public static IRubyObject map(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon(context, self2, block, "map");
    }

    private static IRubyObject collectCommon(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            final RubyArray result2 = runtime2.newArray();
            RubyEnumerable.eachSite(context).call(context, self2, self2, CallBlock19.newCallClosure(self2, runtime2.getEnumerable(), block.getSignature(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayMayCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject val = ary ? block.yieldArray(ctx, larg, null) : block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(val);
                    }
                    return ctx.nil;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    IRubyObject val = block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(val);
                    }
                    return ctx.nil;
                }
            }, context));
            return result2;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable::size);
    }

    @JRubyMethod
    public static IRubyObject filter_map(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            final RubyArray result2 = runtime2.newArray();
            RubyEnumerable.eachSite(context).call(context, self2, self2, CallBlock19.newCallClosure(self2, runtime2.getEnumerable(), block.getSignature(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject val;
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayMayCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject iRubyObject = val = ary ? block.yieldArray(ctx, larg, null) : block.yield(ctx, larg);
                    if (val.isTrue()) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(val);
                        }
                    }
                    return ctx.nil;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    IRubyObject val = block.yield(ctx, larg);
                    if (val.isTrue()) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(val);
                        }
                    }
                    return ctx.nil;
                }
            }, context));
            return result2;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, "filter_map", RubyEnumerable::size);
    }

    @JRubyMethod(name={"flat_map"})
    public static IRubyObject flat_map(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon(context, self2, block, "flat_map");
    }

    @JRubyMethod(name={"collect_concat"})
    public static IRubyObject collect_concat(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon(context, self2, block, "collect_concat");
    }

    private static IRubyObject flatMapCommon(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        if (block.isGiven()) {
            final RubyArray ary = context.runtime.newArray();
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, block.getSignature(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    IRubyObject i2 = block.yield(ctx, larg);
                    IRubyObject tmp = i2.checkArrayType();
                    RubyArray rubyArray = ary;
                    synchronized (rubyArray) {
                        if (tmp.isNil()) {
                            ary.append(i2);
                        } else {
                            ary.concat(ctx, tmp);
                        }
                    }
                    return ctx.nil;
                }
            });
            return ary;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, self2, methodName, RubyEnumerable::size);
    }

    @JRubyMethod
    public static IRubyObject sum(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        return RubyEnumerable.sumCommon(context, self2, zero, block);
    }

    @JRubyMethod
    public static IRubyObject sum(ThreadContext context, IRubyObject self2, IRubyObject init, Block block) {
        return RubyEnumerable.sumCommon(context, self2, init, block);
    }

    public static IRubyObject sumCommon(ThreadContext context, IRubyObject self2, IRubyObject init, Block block) {
        return RubyEnumerable.sumCommon(context, RubyEnumerable.eachSite(context), self2, init, block);
    }

    public static IRubyObject sumCommon(ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject init, final Block block) {
        final SingleObject<IRubyObject> result2 = new SingleObject<IRubyObject>(init);
        final SingleDouble memo = new SingleDouble(0.0);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    result2.object = RubyEnumerable.sumAdd(ctx, (IRubyObject)result2.object, block.yield(ctx, larg), memo);
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    result2.object = RubyEnumerable.sumAdd(ctx, (IRubyObject)result2.object, larg, memo);
                    return ctx.nil;
                }
            });
        }
        if (result2.object instanceof RubyFloat) {
            return ((RubyFloat)result2.object).op_plus(context, memo.d);
        }
        return (IRubyObject)result2.object;
    }

    public static IRubyObject sumAdd(ThreadContext context, IRubyObject lhs, IRubyObject rhs, SingleDouble c) {
        boolean floats = false;
        double f = 0.0;
        double x = 0.0;
        if (lhs instanceof RubyFloat) {
            if (rhs instanceof RubyFloat) {
                f = ((RubyFloat)lhs).value;
                x = ((RubyFloat)rhs).value;
                floats = true;
            } else if (rhs instanceof RubyFixnum) {
                f = ((RubyFloat)lhs).value;
                x = ((RubyFixnum)rhs).value;
                floats = true;
            } else if (rhs instanceof RubyBignum) {
                f = ((RubyFloat)lhs).value;
                x = ((RubyBignum)rhs).getDoubleValue();
                floats = true;
            } else if (rhs instanceof RubyRational) {
                f = ((RubyFloat)lhs).getValue();
                x = ((RubyRational)rhs).getDoubleValue(context);
                floats = true;
            }
        } else if (rhs instanceof RubyFloat) {
            if (lhs instanceof RubyFixnum) {
                c.d = 0.0;
                f = ((RubyFixnum)lhs).value;
                x = ((RubyFloat)rhs).value;
                floats = true;
            } else if (lhs instanceof RubyBignum) {
                c.d = 0.0;
                f = ((RubyBignum)lhs).getDoubleValue();
                x = ((RubyFloat)rhs).value;
                floats = true;
            } else if (lhs instanceof RubyRational) {
                c.d = 0.0;
                f = ((RubyRational)lhs).getDoubleValue();
                x = ((RubyFloat)rhs).value;
                floats = true;
            }
        }
        if (!floats) {
            return RubyEnumerable.sites((ThreadContext)context).sum_op_plus.call(context, lhs, lhs, rhs);
        }
        Ruby runtime2 = context.runtime;
        if (Double.isNaN(f)) {
            return lhs;
        }
        if (Double.isNaN(x)) {
            return lhs;
        }
        if (Double.isInfinite(x)) {
            if (Double.isInfinite(f) && Math.signum(x) != Math.signum(f)) {
                return new RubyFloat(runtime2, Double.NaN);
            }
            return rhs;
        }
        if (Double.isInfinite(f)) {
            return lhs;
        }
        double t = f + x;
        c.d = Math.abs(f) >= Math.abs(x) ? (c.d += f - t + x) : (c.d += x - t + f);
        f = t;
        return new RubyFloat(runtime2, f);
    }

    public static IRubyObject injectCommon(ThreadContext context, IRubyObject self2, IRubyObject init, Block block) {
        Ruby runtime2 = context.runtime;
        SingleObject<IRubyObject> result2 = new SingleObject<IRubyObject>(init);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
            RubyEnumerable.checkContext(context, ctx, "inject");
            result2.object = result2.object == null ? larg : block.yieldArray(ctx, runtime2.newArray((IRubyObject)result2.object, larg), null);
            return ctx.nil;
        });
        return result2.object == null ? context.nil : (IRubyObject)result2.object;
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.injectCommon(context, self2, null, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.injectCommon(context, self2, arg2, block) : RubyEnumerable.inject(context, self2, null, arg2, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, final IRubyObject self2, IRubyObject init, IRubyObject method2, Block block) {
        Ruby runtime2 = context.runtime;
        if (block.isGiven()) {
            runtime2.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        final String methodId = method2.asJavaString();
        final SingleObject<IRubyObject> result2 = new SingleObject<IRubyObject>(init);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){
            final MonomorphicCallSite site;
            {
                this.site = new MonomorphicCallSite(methodId);
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                result2.object = result2.object == null ? larg : this.site.call(ctx, self2, (IRubyObject)result2.object, larg);
                return ctx.nil;
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg) {
                result2.object = result2.object == null ? larg : this.site.call(ctx, self2, (IRubyObject)result2.object, larg);
                return ctx.nil;
            }
        });
        return result2.object == null ? context.nil : (IRubyObject)result2.object;
    }

    @JRubyMethod
    public static IRubyObject partition(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyArray arr_true = runtime2.newArray();
        RubyArray arr_false = runtime2.newArray();
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "partition", RubyEnumerable::size);
        }
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
            if (block.yield(ctx, larg).isTrue()) {
                RubyArray rubyArray = arr_true;
                synchronized (rubyArray) {
                    arr_true.append(larg);
                }
            }
            RubyArray rubyArray = arr_false;
            synchronized (rubyArray) {
                arr_false.append(larg);
            }
            return ctx.nil;
        });
        return runtime2.newArray((IRubyObject)arr_true, (IRubyObject)arr_false);
    }

    static IRubyObject packEnumValues(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return RubyArray.newArrayMayCopy(context.runtime, args2);
    }

    public static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self2, Block block, IRubyObject[] args2) {
        RubyEnumerable.callEach(context, (CallSite)RubyEnumerable.eachSite(context), self2, args2, Signature.OPTIONAL, (BlockCallback)new EachWithIndex(block));
        return self2;
    }

    private static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self2, Block block, IRubyObject arg0) {
        RubyEnumerable.callEach(context, (CallSite)RubyEnumerable.eachSite(context), self2, arg0, Signature.OPTIONAL, (BlockCallback)new EachWithIndex(block));
        return self2;
    }

    public static IRubyObject each_with_objectCommon(ThreadContext context, IRubyObject self2, final Block block, final IRubyObject arg2) {
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), arg2);
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                return block.call(ctx, larg, arg2);
            }
        });
        return arg2;
    }

    @JRubyMethod(name={"each_with_index"})
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.each_with_index(context, self2, IRubyObject.NULL_ARRAY, block);
    }

    @JRubyMethod(name={"each_with_index"})
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self2, block, arg0) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_with_index", Helpers.arrayOf(arg0), RubyEnumerable::size);
    }

    @JRubyMethod(name={"each_with_index"}, rest=true)
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self2, block, args2) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_with_index", args2, RubyEnumerable::size);
    }

    @JRubyMethod(required=1)
    public static IRubyObject each_with_object(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon(context, self2, block, arg2) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_with_object", new IRubyObject[]{arg2}, RubyEnumerable::size);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject each_entry(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, self2, args2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_entry", args2, RubyEnumerable::size);
    }

    public static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self2, IRubyObject arg0, final Block block) {
        RubyEnumerable.callEach(context, (CallSite)RubyEnumerable.eachSite(context), self2, arg0, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yield(ctx, RubyEnumerable.packEnumValues(ctx, largs));
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                return block.yield(ctx, larg);
            }
        });
        return self2;
    }

    public static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self2, IRubyObject[] args2, final Block block) {
        RubyEnumerable.callEach(context, (CallSite)RubyEnumerable.eachSite(context), self2, args2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yield(ctx, RubyEnumerable.packEnumValues(ctx, largs));
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                return block.yield(ctx, larg);
            }
        });
        return self2;
    }

    @JRubyMethod(name={"each_slice"})
    public static IRubyObject each_slice(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_sliceCommon(context, self2, size2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_slice", new IRubyObject[]{arg2}, RubyEnumerable::eachSliceSize);
    }

    static IRubyObject each_sliceCommon(ThreadContext context, IRubyObject self2, int size2, Block block) {
        Ruby runtime2 = context.runtime;
        if (size2 <= 0) {
            throw runtime2.newArgumentError("invalid slice size");
        }
        SingleObject<RubyArray> result2 = new SingleObject<RubyArray>(runtime2.newArray(size2));
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            ((RubyArray)result2.object).append(RubyEnumerable.packEnumValues(ctx, largs));
            if (((RubyArray)result2.object).size() == size2) {
                block.yield(ctx, (IRubyObject)result2.object);
                result2.object = runtime2.newArray(size2);
            }
            return ctx.nil;
        });
        if (((RubyArray)result2.object).size() > 0) {
            block.yield(context, (IRubyObject)result2.object);
        }
        return self2;
    }

    private static IRubyObject eachSliceSize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
        long sliceSize = ((RubyNumeric)args2[0]).getLongValue();
        if (sliceSize <= 0L) {
            throw runtime2.newArgumentError("invalid slice size");
        }
        IRubyObject size2 = RubyEnumerable.size(context, self2, args2);
        if (size2 == null || size2.isNil()) {
            return runtime2.getNil();
        }
        IRubyObject n = RubyEnumerable.sites((ThreadContext)context).each_slice_op_plus.call(context, size2, size2, sliceSize - 1L);
        return RubyEnumerable.sites((ThreadContext)context).each_slice_op_div.call(context, n, n, sliceSize);
    }

    @JRubyMethod(name={"each_cons"})
    public static IRubyObject each_cons(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        int size2 = (int)RubyNumeric.num2long(arg2);
        if (size2 <= 0) {
            throw context.runtime.newArgumentError("invalid size");
        }
        return block.isGiven() ? RubyEnumerable.each_consCommon(context, self2, size2, block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "each_cons", new IRubyObject[]{arg2}, RubyEnumerable::eachConsSize);
    }

    static IRubyObject each_consCommon(ThreadContext context, IRubyObject self2, int size2, Block block) {
        RubyArray result2 = context.runtime.newArray(size2);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            if (result2.size() == size2) {
                result2.shift(ctx);
            }
            result2.append(RubyEnumerable.packEnumValues(ctx, largs));
            if (result2.size() == size2) {
                block.yield(ctx, result2.aryDup());
            }
            return ctx.nil;
        });
        return self2;
    }

    private static IRubyObject eachConsSize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        RubyFixnum zero;
        Ruby runtime2 = context.runtime;
        assert (args2 != null && args2.length > 0 && args2[0] instanceof RubyNumeric);
        long consSize = ((RubyNumeric)args2[0]).getLongValue();
        if (consSize <= 0L) {
            throw runtime2.newArgumentError("invalid size");
        }
        IRubyObject size2 = ((RubyEnumerator.SizeFn<IRubyObject>)RubyEnumerable::size).size(context, self2, args2);
        if (size2 == null || size2.isNil()) {
            return runtime2.getNil();
        }
        IRubyObject n = RubyEnumerable.sites((ThreadContext)context).each_cons_op_plus.call(context, size2, size2, 1L - consSize);
        return RubyComparable.cmpint(context, RubyEnumerable.sites((ThreadContext)context).each_cons_op_cmp.call(context, n, n, (IRubyObject)(zero = RubyFixnum.zero(runtime2))), n, zero) == -1 ? zero : n;
    }

    @JRubyMethod
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2), block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "reverse_each", RubyEnumerable::size);
    }

    @JRubyMethod(rest=true)
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2, args2), block) : RubyEnumerator.enumeratorizeWithSize(context, self2, "reverse_each", args2, RubyEnumerable::size);
    }

    private static IRubyObject reverse_eachInternal(ThreadContext context, IRubyObject self2, IRubyObject obj, Block block) {
        ((RubyArray)obj).reverse_each(context, block);
        return self2;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1)
    public static IRubyObject include_p(final ThreadContext context, IRubyObject self2, final IRubyObject arg2) {
        try {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    RubyEnumerable.checkContext(context, ctx, "include?/member?");
                    if (RubyObject.equalInternal(ctx, larg, arg2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return context.tru;
        }
        return context.fals;
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtent(context, self2, "max", 1, block);
    }

    @JRubyMethod
    public static IRubyObject max(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        RubyArray sorted = (RubyArray)RubyEnumerable.sort(context, self2, block);
        if (arg2.isNil()) {
            return sorted.last();
        }
        return ((RubyArray)sorted.last(arg2)).reverse();
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtent(context, self2, "min", -1, block);
    }

    @JRubyMethod
    public static IRubyObject min(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        RubyArray sorted = (RubyArray)RubyEnumerable.sort(context, self2, block);
        if (arg2.isNil()) {
            return sorted.first();
        }
        return sorted.first(arg2);
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtentBy(context, self2, "max", 1, block);
    }

    @JRubyMethod
    public static IRubyObject max_by(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2 == context.nil) {
            return RubyEnumerable.singleExtentBy(context, self2, "max", 1, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "max_by", RubyEnumerable::size);
        }
        RubyArray sorted = (RubyArray)RubyEnumerable.sort_by(context, self2, block);
        return ((RubyArray)sorted.last(arg2)).reverse();
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.singleExtentBy(context, self2, "min", -1, block);
    }

    @JRubyMethod
    public static IRubyObject min_by(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2 == context.nil) {
            return RubyEnumerable.singleExtentBy(context, self2, "min", -1, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "min_by", RubyEnumerable::size);
        }
        RubyArray sorted = (RubyArray)RubyEnumerable.sort_by(context, self2, block);
        return sorted.first(arg2);
    }

    private static IRubyObject singleExtent(ThreadContext context, IRubyObject self2, String op, int sortDirection, Block block) {
        Ruby runtime2 = context.runtime;
        SingleObject<Object> result2 = new SingleObject<Object>(null);
        Signature signature = block.isGiven() ? block.getSignature() : Signature.ONE_REQUIRED;
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, signature, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
            RubyEnumerable.checkContext(context, ctx, op + "{}");
            if (result2.object == null || block.isGiven() && RubyComparable.cmpint(ctx, block.yieldArray(ctx, runtime2.newArray(larg, (IRubyObject)result2.object), null), larg, (IRubyObject)result2.object) * sortDirection > 0 || !block.isGiven() && RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, (IRubyObject)result2.object), larg, (IRubyObject)result2.object) * sortDirection > 0) {
                result2.object = larg;
            }
            return ctx.nil;
        });
        return result2.object == null ? context.nil : (IRubyObject)result2.object;
    }

    private static IRubyObject singleExtentBy(final ThreadContext context, IRubyObject self2, final String op, final int sortDirection, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, op, RubyEnumerable::size);
        }
        final SingleObject<IRubyObject> result2 = new SingleObject<IRubyObject>(context.nil);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, op);
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) * sortDirection > 0) {
                    this.memo = v;
                    result2.object = larg;
                }
                return ctx.nil;
            }
        });
        return (IRubyObject)result2.object;
    }

    @JRubyMethod
    public static IRubyObject minmax(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime2 = context.runtime;
        DoubleObject<Object, Object> result2 = new DoubleObject<Object, Object>(null, null);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, block.getSignature(), (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                RubyEnumerable.checkContext(context, ctx, "minmax");
                IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                if (result2.object1 == null) {
                    result2.object2 = arg2;
                    result2.object1 = result2.object2;
                } else {
                    if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime2.newArray(arg2, (IRubyObject)result2.object1)), arg2, (IRubyObject)result2.object1) < 0) {
                        result2.object1 = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime2.newArray(arg2, (IRubyObject)result2.object2)), arg2, (IRubyObject)result2.object2) > 0) {
                        result2.object2 = arg2;
                    }
                }
                return ctx.nil;
            });
        } else {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                DoubleObject doubleObject = result2;
                synchronized (doubleObject) {
                    if (result2.object1 == null) {
                        result2.object2 = arg2;
                        result2.object1 = result2.object2;
                    } else {
                        if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, (IRubyObject)result2.object1), arg2, (IRubyObject)result2.object1) < 0) {
                            result2.object1 = arg2;
                        }
                        if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, (IRubyObject)result2.object2), arg2, (IRubyObject)result2.object2) > 0) {
                            result2.object2 = arg2;
                        }
                    }
                }
                return ctx.nil;
            });
        }
        if (result2.object1 == null) {
            IRubyObject nil = context.nil;
            return RubyArray.newArray(runtime2, nil, nil);
        }
        return RubyArray.newArray(runtime2, (IRubyObject)result2.object1, (IRubyObject)result2.object2);
    }

    @JRubyMethod
    public static IRubyObject minmax_by(final ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "minmax_by", RubyEnumerable::size);
        }
        final DoubleObject<IRubyObject, IRubyObject> result2 = new DoubleObject<IRubyObject, IRubyObject>(context.nil, context.nil);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, new BlockCallback(){
            IRubyObject minMemo = null;
            IRubyObject maxMemo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyEnumerable.checkContext(context, ctx, "minmax_by");
                IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject v = block.yield(ctx, arg2);
                if (this.minMemo == null) {
                    this.minMemo = this.maxMemo = v;
                    result2.object2 = arg2;
                    result2.object1 = result2.object2;
                } else {
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.minMemo), v, this.minMemo) < 0) {
                        this.minMemo = v;
                        result2.object1 = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.maxMemo), v, this.maxMemo) > 0) {
                        this.maxMemo = v;
                        result2.object2 = arg2;
                    }
                }
                return ctx.nil;
            }
        });
        return RubyArray.newArray(context.runtime, (IRubyObject)result2.object1, (IRubyObject)result2.object2);
    }

    @JRubyMethod(name={"none?"})
    public static IRubyObject none_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.none_pCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
    }

    @JRubyMethod(name={"none?"})
    public static IRubyObject none_p(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return RubyEnumerable.none_pCommon(context, RubyEnumerable.eachSite(context), self2, arg2, block);
    }

    public static IRubyObject none_pCommon(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.none_pCommon(context, RubyEnumerable.eachSite(context), self2, pattern, block);
    }

    public static IRubyObject none_pCommon(ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject pattern, Block block) {
        boolean patternGiven;
        ThreadContext localContext = context;
        boolean bl = patternGiven = pattern != null;
        if (block.isGiven() && patternGiven) {
            context.runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        try {
            if (block.isGiven() && !patternGiven) {
                RubyEnumerable.callEach(context, each2, self2, block.getSignature(), (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "none?");
                    if (block.yieldValues(ctx, largs).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                });
            } else if (patternGiven) {
                CallSite none_op_eqq = RubyEnumerable.sites((ThreadContext)context).none_op_eqq;
                RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "none?");
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (none_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                });
            } else {
                RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "none?");
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (larg.isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return context.fals;
        }
        return context.tru;
    }

    @JRubyMethod(name={"one?"})
    public static IRubyObject one_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.one_pCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
    }

    @JRubyMethod(name={"one?"})
    public static IRubyObject one_p(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return RubyEnumerable.one_pCommon(context, RubyEnumerable.eachSite(context), self2, arg2, block);
    }

    public static IRubyObject one_pCommon(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.one_pCommon(context, RubyEnumerable.eachSite(context), self2, pattern, block);
    }

    public static IRubyObject one_pCommon(ThreadContext context, CallSite each2, IRubyObject self2, IRubyObject pattern, Block block) {
        boolean patternGiven;
        ThreadContext localContext = context;
        SingleBoolean result2 = new SingleBoolean(false);
        boolean bl = patternGiven = pattern != null;
        if (block.isGiven() && patternGiven) {
            context.runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        try {
            if (block.isGiven() && !patternGiven) {
                RubyEnumerable.callEach(context, each2, self2, block.getSignature(), (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "one?");
                    if (block.yieldValues(ctx, largs).isTrue()) {
                        if (result2.b) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        result2.b = true;
                    }
                    return ctx.nil;
                });
            } else if (patternGiven) {
                CallSite one_op_eqq = RubyEnumerable.sites((ThreadContext)context).one_op_eqq;
                RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "one?");
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (one_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                        if (result2.b) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        result2.b = true;
                    }
                    return ctx.nil;
                });
            } else {
                RubyEnumerable.callEach(context, each2, self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, ctx, "one?");
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (larg.isTrue()) {
                        if (result2.b) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        result2.b = true;
                    }
                    return ctx.nil;
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return context.fals;
        }
        return result2.b ? context.tru : context.fals;
    }

    @JRubyMethod(name={"all?"})
    public static IRubyObject all_p(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).all_p(context, null, block);
        }
        return RubyEnumerable.all_pCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
    }

    @JRubyMethod(name={"all?"})
    public static IRubyObject all_p(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).all_p(context, arg2, block);
        }
        return RubyEnumerable.all_pCommon(context, RubyEnumerable.eachSite(context), self2, arg2, block);
    }

    public static IRubyObject all_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return RubyEnumerable.all_p(context, self2, block);
            }
            case 1: {
                return RubyEnumerable.all_p(context, self2, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    public static IRubyObject all_pCommon(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.all_pCommon(context, RubyEnumerable.eachSite(context), self2, pattern, block);
    }

    public static IRubyObject all_pCommon(final ThreadContext localContext, CallSite each2, IRubyObject self2, final IRubyObject pattern, Block block) {
        boolean patternGiven;
        boolean bl = patternGiven = pattern != null;
        if (block.isGiven() && patternGiven) {
            localContext.runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        try {
            if (block.isGiven() && !patternGiven) {
                RubyEnumerable.callEach(localContext, each2, self2, block.getSignature(), (ThreadContext context, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, context, "all?");
                    if (!block.yieldValues(context, largs).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return context.nil;
                });
            } else if (patternGiven) {
                final CallSite all_op_eqq = RubyEnumerable.sites((ThreadContext)localContext).all_op_eqq;
                RubyEnumerable.callEach(localContext, each2, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, context, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(context, largs);
                        if (!all_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject larg) {
                        RubyEnumerable.checkContext(localContext, context, "all?");
                        if (!all_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(localContext, each2, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, context, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(context, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject larg) {
                        RubyEnumerable.checkContext(localContext, localContext, "all?");
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return localContext.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return localContext.fals;
        }
        return localContext.tru;
    }

    @JRubyMethod(name={"any?"})
    public static IRubyObject any_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.any_pCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
    }

    @JRubyMethod(name={"any?"})
    public static IRubyObject any_p(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return RubyEnumerable.any_pCommon(context, RubyEnumerable.eachSite(context), self2, arg2, block);
    }

    public static IRubyObject any_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return RubyEnumerable.any_pCommon(context, RubyEnumerable.eachSite(context), self2, null, block);
            }
            case 1: {
                return RubyEnumerable.any_pCommon(context, RubyEnumerable.eachSite(context), self2, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self2, IRubyObject pattern, Block block) {
        return RubyEnumerable.any_pCommon(context, RubyEnumerable.eachSite(context), self2, pattern, block);
    }

    public static IRubyObject any_pCommon(final ThreadContext localContext, CallSite site, IRubyObject self2, final IRubyObject pattern, Block block) {
        boolean patternGiven;
        boolean bl = patternGiven = pattern != null;
        if (block.isGiven() && patternGiven) {
            localContext.runtime.getWarnings().warning(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        try {
            if (block.isGiven() && !patternGiven) {
                RubyEnumerable.callEach(localContext, site, self2, block.getSignature(), (ThreadContext context, IRubyObject[] largs, Block blk) -> {
                    RubyEnumerable.checkContext(localContext, context, "any?");
                    if (block.yieldValues(context, largs).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return context.nil;
                });
            } else if (patternGiven) {
                final CallSite any_op_eqq = RubyEnumerable.sites((ThreadContext)localContext).any_op_eqq;
                RubyEnumerable.callEach(localContext, site, self2, Signature.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, context, "any?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(context, largs);
                        if (any_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject larg) {
                        RubyEnumerable.checkContext(localContext, context, "any?");
                        if (any_op_eqq.call(context, pattern, pattern, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(localContext, site, self2, Signature.OPTIONAL, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(localContext, context, "any?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(context, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject larg) {
                        RubyEnumerable.checkContext(localContext, context, "any?");
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return context.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return localContext.tru;
        }
        return localContext.fals;
    }

    @JRubyMethod(name={"zip"})
    public static IRubyObject zip(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.zipCommon(context, self2, IRubyObject.NULL_ARRAY, block);
    }

    @JRubyMethod(name={"zip"})
    public static IRubyObject zip(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return RubyEnumerable.zipCommon(context, self2, arg0, block);
    }

    @JRubyMethod(name={"zip"}, rest=true)
    public static IRubyObject zip(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self2, args2, block);
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.runtime;
        RubyClass Array2 = runtime2.getArray();
        boolean hasUncoercible = false;
        IRubyObject newArg = TypeConverter.convertToType(arg0, Array2, "to_ary", false);
        if (newArg.isNil()) {
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            RubySymbol each2 = runtime2.newSymbol("each");
            if (!arg0.respondsTo("each")) {
                throw context.runtime.newTypeError("wrong argument type " + arg0.getMetaClass() + " (must respond to :each)");
            }
            newArg = RubyEnumerable.sites((ThreadContext)context).to_enum.call(context, arg0, arg0, (IRubyObject)each2);
            return RubyEnumerable.zipCommonEnum(context, self2, newArg, block);
        }
        return RubyEnumerable.zipCommonAry(context, self2, newArg, block);
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyClass Array2 = runtime2.getArray();
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        boolean hasUncoercible = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = TypeConverter.convertToType(args2[i2], Array2, "to_ary", false);
            if (!newArgs[i2].isNil()) continue;
            hasUncoercible = true;
            break;
        }
        if (hasUncoercible) {
            RubySymbol each2 = runtime2.newSymbol("each");
            for (int i3 = 0; i3 < args2.length; ++i3) {
                if (!args2[i3].respondsTo("each")) {
                    throw context.runtime.newTypeError("wrong argument type " + args2[i3].getMetaClass() + " (must respond to :each)");
                }
                newArgs[i3] = RubyEnumerable.sites((ThreadContext)context).to_enum.call(context, args2[i3], args2[i3], (IRubyObject)each2);
            }
            return RubyEnumerable.zipCommonEnum(context, self2, newArgs, block);
        }
        return RubyEnumerable.zipCommonAry(context, self2, newArgs, block);
    }

    public static IRubyObject zipCommonAry(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self2, args2, block, (ThreadContext ctx, IRubyObject elt, int i2) -> ((RubyArray)elt).entry(i2));
    }

    public static IRubyObject zipCommonAry(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return RubyEnumerable.zipCommon(context, self2, arg0, block, (ThreadContext ctx, IRubyObject elt, int i2) -> ((RubyArray)elt).entry(i2));
    }

    public static IRubyObject zipCommonEnum(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self2, args2, block, (ThreadContext ctx, IRubyObject elt, int i2) -> RubyEnumerable.zipEnumNext(ctx, elt));
    }

    public static IRubyObject zipCommonEnum(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return RubyEnumerable.zipCommon(context, self2, arg0, block, (ThreadContext ctx, IRubyObject elt, int i2) -> RubyEnumerable.zipEnumNext(ctx, elt));
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block, ObjectObjectIntFunction<ThreadContext, IRubyObject, IRubyObject> nextElement) {
        Ruby runtime2 = context.runtime;
        int len = args2.length + 1;
        AtomicInteger ix = new AtomicInteger(0);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, (ThreadContext ctx, IRubyObject[] largs, Block unused2) -> {
                RubyArray array2 = RubyArray.newBlankArrayInternal(runtime2, len);
                int myIx = ix.getAndIncrement();
                array2.eltInternalSet(0, RubyEnumerable.packEnumValues(ctx, largs));
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array2.eltInternalSet(i2 + 1, (IRubyObject)nextElement.apply(context, args2[i2], myIx));
                }
                array2.realLength = len;
                block.yield(ctx, array2);
                return ctx.nil;
            });
            return context.nil;
        }
        RubyArray zip2 = runtime2.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block unused2) -> {
            RubyArray array2 = RubyArray.newBlankArrayInternal(runtime2, len);
            int myIx = ix.getAndIncrement();
            array2.eltInternalSet(0, RubyEnumerable.packEnumValues(ctx, largs));
            int j = args2.length;
            for (int i2 = 0; i2 < j; ++i2) {
                array2.eltInternalSet(i2 + 1, (IRubyObject)nextElement.apply(context, args2[i2], myIx));
            }
            array2.realLength = len;
            RubyArray rubyArray = zip2;
            synchronized (rubyArray) {
                zip2.append(array2);
            }
            return ctx.nil;
        });
        return zip2;
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block, ObjectObjectIntFunction<ThreadContext, IRubyObject, IRubyObject> nextElement) {
        AtomicInteger ix = new AtomicInteger(0);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, (ThreadContext ctx, IRubyObject[] largs, Block unused2) -> {
                int myIx = ix.getAndIncrement();
                RubyArray array2 = RubyArray.newArray(ctx.runtime, RubyEnumerable.packEnumValues(ctx, largs), (IRubyObject)nextElement.apply(ctx, arg0, myIx));
                block.yield(ctx, array2);
                return ctx.nil;
            });
            return context.nil;
        }
        RubyArray zip2 = context.runtime.newArray();
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.ONE_REQUIRED, (ThreadContext ctx, IRubyObject[] largs, Block unused2) -> {
            int myIx = ix.getAndIncrement();
            RubyArray array2 = RubyArray.newArray(ctx.runtime, RubyEnumerable.packEnumValues(ctx, largs), (IRubyObject)nextElement.apply(ctx, arg0, myIx));
            RubyArray rubyArray = zip2;
            synchronized (rubyArray) {
                zip2.append(array2);
            }
            return ctx.nil;
        });
        return zip2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject takeItems(ThreadContext context, IRubyObject enumerable) {
        RubyArray array2;
        RubyArray rubyArray = array2 = context.runtime.newArray();
        synchronized (rubyArray) {
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), enumerable, Signature.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    array2.append(larg);
                    return larg;
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg) {
                    array2.append(larg);
                    return larg;
                }
            });
        }
        return array2;
    }

    public static IRubyObject zipEnumNext(ThreadContext context, IRubyObject arg2) {
        if (arg2.isNil()) {
            return context.nil;
        }
        Ruby runtime2 = context.runtime;
        IRubyObject oldExc = runtime2.getGlobalVariables().get("$!");
        try {
            return RubyEnumerable.sites((ThreadContext)context).zip_next.call(context, arg2, arg2);
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == runtime2.getStopIteration()) {
                runtime2.getGlobalVariables().set("$!", oldExc);
                return context.nil;
            }
            throw re;
        }
    }

    @JRubyMethod
    public static IRubyObject group_by(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "group_by", RubyEnumerable::size);
        }
        RubyHash result2 = new RubyHash(runtime2);
        RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, Signature.OPTIONAL, (ThreadContext ctx, IRubyObject[] largs, Block blk) -> {
            IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
            IRubyObject key2 = block.yield(ctx, larg);
            RubyHash rubyHash = result2;
            synchronized (rubyHash) {
                RubyArray curr = (RubyArray)result2.fastARef(key2);
                if (curr == null) {
                    curr = runtime2.newArray();
                    result2.fastASet(key2, curr);
                }
                curr.append(larg);
            }
            return ctx.nil;
        });
        return result2;
    }

    @JRubyMethod(rest=true)
    public static IRubyObject chain(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject[] enums = new IRubyObject[args2.length + 1];
        enums[0] = self2;
        System.arraycopy(args2, 0, enums, 1, args2.length);
        return RubyChain.newChain(context, enums);
    }

    @JRubyMethod
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, self2, "chunk", RubyEnumerable::size);
        }
        IRubyObject enumerator = runtime2.getEnumerator().allocate();
        enumerator.getInternalVariables().setInternalVariable("chunk_enumerable", self2);
        enumerator.getInternalVariables().setInternalVariable("chunk_categorize", RubyProc.newProc(runtime2, block, block.type == Block.Type.LAMBDA ? block.type : Block.Type.PROC));
        Helpers.invoke(context, enumerator, "initialize", CallBlock.newCallClosure(context, self2, Signature.ONE_ARGUMENT, new ChunkedBlockCallback(runtime2, enumerator)));
        return enumerator;
    }

    @JRubyMethod
    public static IRubyObject uniq(ThreadContext context, IRubyObject self2, final Block block) {
        final RubyHash hash2 = new RubyHash(context.runtime, 12, false);
        CachingCallSite each2 = RubyEnumerable.eachSite(context);
        if (block.isGiven()) {
            RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject obj, Block blk) {
                    IRubyObject key2 = block.yield(ctx, obj);
                    if (hash2.getEntry(key2) == RubyHash.NO_ENTRY) {
                        hash2.internalPut(key2, obj);
                    }
                    return obj;
                }
            });
            return hash2.values(context);
        }
        RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject obj, Block blk) {
                hash2.internalPut(obj, obj);
                return obj;
            }
        });
        return hash2.keys(context);
    }

    @JRubyMethod
    public static IRubyObject compact(ThreadContext context, IRubyObject self2) {
        final RubyArray array2 = RubyArray.newEmptyArray(context.runtime);
        CachingCallSite each2 = RubyEnumerable.eachSite(context);
        RubyEnumerable.callEach(context, each2, self2, Signature.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return this.call(ctx, RubyEnumerable.packEnumValues(ctx, largs), blk);
            }

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject obj, Block blk) {
                if (!obj.isNil()) {
                    array2.append(obj);
                }
                return obj;
            }
        });
        return array2;
    }

    static IRubyObject size(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        IRubyObject size2 = self2.checkCallMethod(context, RubyEnumerable.sites((ThreadContext)context).size_checked);
        return size2 == null ? context.nil : size2;
    }

    @Deprecated
    public static IRubyObject callEach(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Signature signature, BlockCallback callback) {
        return RubyEnumerable.callEach(context, (CallSite)RubyEnumerable.eachSite(context), self2, args2, signature, callback);
    }

    @Deprecated
    public static IRubyObject callEach(ThreadContext context, IRubyObject self2, BlockCallback callback) {
        return RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), self2, callback);
    }

    @Deprecated
    public static IRubyObject each(ThreadContext context, IRubyObject self2, BlockBody body) {
        return RubyEnumerable.each(context, RubyEnumerable.eachSite(context), self2, body);
    }

    protected static CachingCallSite eachSite(ThreadContext context) {
        return RubyEnumerable.sites((ThreadContext)context).each;
    }

    private static JavaSites.EnumerableSites sites(ThreadContext context) {
        return context.sites.Enumerable;
    }

    public static final class TallyCallback
    implements BlockCallback {
        private final RubyHash result;

        TallyCallback(RubyHash result2) {
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            IRubyObject value2 = largs.length == 0 ? context.nil : (largs.length == 1 ? largs[0] : RubyArray.newArrayNoCopy(context.runtime, largs));
            IRubyObject count2 = this.result.fastARef(value2);
            if (count2 == null) {
                this.result.fastASet(value2, RubyFixnum.one(context.runtime));
            } else if (count2 instanceof RubyFixnum) {
                this.result.fastASetSmall(value2, ((RubyInteger)count2).succ(context));
            } else {
                TypeConverter.checkType(context, count2, context.runtime.getBignum());
                this.result.fastASetSmall(value2, ((RubyBignum)count2).op_plus(context, 1L));
            }
            return context.nil;
        }
    }

    public static final class PutKeyValueCallback
    implements BlockCallback {
        private final RubyHash result;
        private final Block block;

        @Deprecated
        public PutKeyValueCallback(Ruby runtime2, RubyHash result2) {
            this.result = result2;
            this.block = Block.NULL_BLOCK;
        }

        @Deprecated
        public PutKeyValueCallback(Ruby runtime2, RubyHash result2, Block block) {
            this.result = result2;
            this.block = block;
        }

        PutKeyValueCallback(RubyHash result2) {
            this.result = result2;
            this.block = Block.NULL_BLOCK;
        }

        PutKeyValueCallback(RubyHash result2, Block block) {
            this.result = result2;
            this.block = block;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            IRubyObject value2;
            Ruby runtime2 = context.runtime;
            boolean blockGiven = this.block.isGiven();
            switch (largs.length) {
                case 0: {
                    value2 = blockGiven ? this.block.yield(context, context.nil) : context.nil;
                    break;
                }
                case 1: {
                    value2 = blockGiven ? this.block.yield(context, largs[0]) : largs[0];
                    break;
                }
                default: {
                    RubyArray v = RubyArray.newArrayMayCopy(runtime2, largs);
                    value2 = blockGiven ? this.block.yield(context, v) : v;
                }
            }
            this.callImpl(runtime2, value2);
            return context.nil;
        }

        private void callImpl(Ruby runtime2, IRubyObject value2) {
            IRubyObject ary = TypeConverter.checkArrayType(runtime2, value2);
            if (ary.isNil()) {
                throw runtime2.newTypeError("wrong element type " + value2.getType().getName() + " (expected array)");
            }
            RubyArray array2 = (RubyArray)ary;
            if (array2.size() != 2) {
                throw runtime2.newArgumentError("element has wrong array length (expected 2, was " + array2.size() + ")");
            }
            this.result.fastASetCheckString(runtime2, (IRubyObject)array2.eltOk(0L), (IRubyObject)array2.eltOk(1L));
        }
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private final RubyArray result;

        @Deprecated
        public AppendBlockCallback(Ruby runtime2, RubyArray result2) {
            this.result = result2;
        }

        AppendBlockCallback(RubyArray result2) {
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            this.result.append(RubyEnumerable.packEnumValues(context, args2));
            return context.nil;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
            this.result.append(arg2);
            return context.nil;
        }
    }

    public static final class ChunkedBlockCallback
    implements BlockCallback {
        private final Ruby runtime;
        private final IRubyObject enumerator;

        public ChunkedBlockCallback(Ruby runtime2, IRubyObject enumerator) {
            this.runtime = runtime2;
            this.enumerator = enumerator;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            InternalVariables variables = this.enumerator.getInternalVariables();
            IRubyObject enumerable = (IRubyObject)variables.getInternalVariable("chunk_enumerable");
            RubyProc categorize = (RubyProc)variables.getInternalVariable("chunk_categorize");
            IRubyObject yielder = RubyEnumerable.packEnumValues(context, args2);
            ChunkArg arg2 = new ChunkArg(context);
            RubySymbol alone = this.runtime.newSymbol("_alone");
            RubySymbol separator = this.runtime.newSymbol("_separator");
            JavaSites.EnumerableSites sites = RubyEnumerable.sites(context);
            CallSite chunk_call = sites.chunk_call;
            CallSite chunk_op_lshift = sites.chunk_op_lshift;
            RubyEnumerable.callEach(context, RubyEnumerable.eachSite(context), enumerable, Signature.OPTIONAL, (ctx, largs, blk) -> {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject v = categorize.getBlock().getSignature().arityValue() == 1 ? chunk_call.call(ctx, (IRubyObject)categorize, (IRubyObject)categorize, larg) : chunk_call.call(ctx, (IRubyObject)categorize, (IRubyObject)categorize, largs);
                if (v == alone) {
                    if (!arg2.prev_value.isNil()) {
                        chunk_op_lshift.call(ctx, yielder, yielder, (IRubyObject)this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                        arg2.prev_value = arg2.prev_elts = ctx.nil;
                    }
                    chunk_op_lshift.call(ctx, yielder, yielder, (IRubyObject)this.runtime.newArray(v, (IRubyObject)this.runtime.newArray(larg)));
                } else if (v.isNil() || v == separator) {
                    if (!arg2.prev_value.isNil()) {
                        chunk_op_lshift.call(ctx, yielder, yielder, (IRubyObject)this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                        arg2.prev_value = arg2.prev_elts = ctx.nil;
                    }
                } else {
                    if (v instanceof RubySymbol && v.toString().charAt(0) == '_') {
                        throw this.runtime.newRuntimeError("symbol begins with an underscore is reserved");
                    }
                    if (arg2.prev_value.isNil()) {
                        arg2.prev_value = v;
                        arg2.prev_elts = this.runtime.newArray(larg);
                    } else if (arg2.prev_value.equals(v)) {
                        ((RubyArray)arg2.prev_elts).append(larg);
                    } else {
                        chunk_op_lshift.call(ctx, yielder, yielder, (IRubyObject)this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                        arg2.prev_value = v;
                        arg2.prev_elts = this.runtime.newArray(larg);
                    }
                }
                return ctx.nil;
            });
            if (!arg2.prev_elts.isNil()) {
                chunk_op_lshift.call(context, yielder, yielder, (IRubyObject)this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
            }
            return context.nil;
        }
    }

    private static final class ChunkArg {
        IRubyObject prev_value;
        IRubyObject prev_elts;

        ChunkArg(ThreadContext context) {
            this.prev_elts = this.prev_value = context.nil;
        }
    }

    static class EachWithIndex
    implements BlockCallback {
        private int index;
        private final Block block;

        EachWithIndex(Block block, int index2) {
            this.block = block;
            this.index = index2;
        }

        EachWithIndex(Block block) {
            this.block = block;
            this.index = 0;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            return this.block.call(context, RubyEnumerable.packEnumValues(context, iargs), context.runtime.newFixnum(this.index++));
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject iarg, Block block) {
            return this.block.call(context, iarg, context.runtime.newFixnum(this.index++));
        }
    }
}

