(define-library (pingala prosody-test)
  (export run-tests)
  (import (scheme base) (scheme write) (scheme process-context)
          (pingala prosody))
  (begin
    ;; test utils
    (define failed? #f)
    (define (fail expr expected res)
      (set! failed? #t)
      (display "FAIL: ")
      (write expr)
      (display ": expected: ")
      (write expected)
      (display " but got: ")
      (write res)
      (newline))
    (define (test-exit) (exit (not failed?)))
    (define-syntax test
      (syntax-rules ()
        ((test expected expr)
         (let ((res expr))
           (if (not (equal? res expected))
               (fail 'expr expected res))))))
    ;; tests
    (define (run-tests)
      (test "ma" (ganas 0))
      (test "bha" (ganas 6))
      (test "L-L-H" (ganas-pattern "sa"))
      (test "L-L-H" (ganas-pattern 3))
      (test "H-L-L" (ganas-pattern "bha"))
      (test-exit))))
