# -*- make -*-

DOTNET-OUTPUT   :=

DOTNET-PROJECT  :=

.PHONY: all
all:

.PHONY: find-rm-bin
find-rm-bin:
	$(FIND) . -type d -name "bin" -exec $(RM) {} +

.PHONY: find-rm-obj
find-rm-obj:
	$(FIND) . -type d -name "bin" -exec $(RM) {} +

.PHONY: clean
clean:
	$(MAKE) find-rm-bin
	$(MAKE) find-rm-obj

	-$(DOTNET) clean							\
		--verbosity quiet						\
		-maxCpuCount:1							\
		$(DOTNET-PROJECT)

.PHONY: restore
restore:
	$(DOTNET) restore							\
		--verbosity normal						\
		-maxCpuCount:1							\
		$(DOTNET-PROJECT)

.PHONY: build
build: restore
build:
	$(DOTNET) build								\
		--configuration Release					\
		--no-restore							\
		--no-self-contained						\
		--output $(DOTNET-OUTPUT)				\
		--verbosity quiet						\
		-maxCpuCount:1							\
		$(DOTNET-PROJECT)

.PHONY: test
test: restore
test:
	$(DOTNET) test								\
		--configuration Debug					\
		--no-restore							\
		--verbosity quiet						\
		--logger "console;verbosity=detailed"	\
		-maxCpuCount:1							\
		$(DOTNET-PROJECT)
