/*
 * This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
 * Copyright (c) 2023, Maciej Barć <xgqt@riseup.net>
 * Licensed under the GNU GPL v2 License
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
 */

using System.CommandLine;
using System.CommandLine.Parsing;

namespace Gentoo.DotNet.GentooDotnetInfo.Action
{

    public class CommandLineAction
    {

        private readonly string[] _cliArguments;

        private readonly RootCommand _rootCommand;

        public CommandLineAction(string[] cliArguments)
        {
            _cliArguments = cliArguments;

            _rootCommand = new RootCommand()
            {
                Name = "gentoo-dotnet-info",
                Description = ".NET information tool for Gentoo",
            };

            _rootCommand.SetHandler(OnRootHandle);
        }

        private void OnRootHandle()
        {
            GentooDotnetInfoAction gentooDotnetInfoAction = new();

            gentooDotnetInfoAction.Write();
        }

        public int Run()
        {
            return _rootCommand.Invoke(_cliArguments);
        }

    }

}
