// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllTCPRequestRuleFrontendOKCode is the HTTP code returned for type GetAllTCPRequestRuleFrontendOK
const GetAllTCPRequestRuleFrontendOKCode int = 200

/*
GetAllTCPRequestRuleFrontendOK Successful operation

swagger:response getAllTcpRequestRuleFrontendOK
*/
type GetAllTCPRequestRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.TCPRequestRules `json:"body,omitempty"`
}

// NewGetAllTCPRequestRuleFrontendOK creates GetAllTCPRequestRuleFrontendOK with default headers values
func NewGetAllTCPRequestRuleFrontendOK() *GetAllTCPRequestRuleFrontendOK {

	return &GetAllTCPRequestRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Tcp request rule frontend o k response
func (o *GetAllTCPRequestRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllTCPRequestRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Tcp request rule frontend o k response
func (o *GetAllTCPRequestRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Tcp request rule frontend o k response
func (o *GetAllTCPRequestRuleFrontendOK) WithPayload(payload models.TCPRequestRules) *GetAllTCPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Tcp request rule frontend o k response
func (o *GetAllTCPRequestRuleFrontendOK) SetPayload(payload models.TCPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.TCPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllTCPRequestRuleFrontendDefault General Error

swagger:response getAllTcpRequestRuleFrontendDefault
*/
type GetAllTCPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllTCPRequestRuleFrontendDefault creates GetAllTCPRequestRuleFrontendDefault with default headers values
func NewGetAllTCPRequestRuleFrontendDefault(code int) *GetAllTCPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllTCPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) WithStatusCode(code int) *GetAllTCPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllTCPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllTCPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all TCP request rule frontend default response
func (o *GetAllTCPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllTCPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
