// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceServerPeerOKCode is the HTTP code returned for type ReplaceServerPeerOK
const ReplaceServerPeerOKCode int = 200

/*
ReplaceServerPeerOK Server replaced

swagger:response replaceServerPeerOK
*/
type ReplaceServerPeerOK struct {

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewReplaceServerPeerOK creates ReplaceServerPeerOK with default headers values
func NewReplaceServerPeerOK() *ReplaceServerPeerOK {

	return &ReplaceServerPeerOK{}
}

// WithPayload adds the payload to the replace server peer o k response
func (o *ReplaceServerPeerOK) WithPayload(payload *models.Server) *ReplaceServerPeerOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace server peer o k response
func (o *ReplaceServerPeerOK) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceServerPeerOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceServerPeerAcceptedCode is the HTTP code returned for type ReplaceServerPeerAccepted
const ReplaceServerPeerAcceptedCode int = 202

/*
ReplaceServerPeerAccepted Configuration change accepted and reload requested

swagger:response replaceServerPeerAccepted
*/
type ReplaceServerPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewReplaceServerPeerAccepted creates ReplaceServerPeerAccepted with default headers values
func NewReplaceServerPeerAccepted() *ReplaceServerPeerAccepted {

	return &ReplaceServerPeerAccepted{}
}

// WithReloadID adds the reloadId to the replace server peer accepted response
func (o *ReplaceServerPeerAccepted) WithReloadID(reloadID string) *ReplaceServerPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace server peer accepted response
func (o *ReplaceServerPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace server peer accepted response
func (o *ReplaceServerPeerAccepted) WithPayload(payload *models.Server) *ReplaceServerPeerAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace server peer accepted response
func (o *ReplaceServerPeerAccepted) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceServerPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceServerPeerBadRequestCode is the HTTP code returned for type ReplaceServerPeerBadRequest
const ReplaceServerPeerBadRequestCode int = 400

/*
ReplaceServerPeerBadRequest Bad request

swagger:response replaceServerPeerBadRequest
*/
type ReplaceServerPeerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceServerPeerBadRequest creates ReplaceServerPeerBadRequest with default headers values
func NewReplaceServerPeerBadRequest() *ReplaceServerPeerBadRequest {

	return &ReplaceServerPeerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace server peer bad request response
func (o *ReplaceServerPeerBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceServerPeerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace server peer bad request response
func (o *ReplaceServerPeerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace server peer bad request response
func (o *ReplaceServerPeerBadRequest) WithPayload(payload *models.Error) *ReplaceServerPeerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace server peer bad request response
func (o *ReplaceServerPeerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceServerPeerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceServerPeerNotFoundCode is the HTTP code returned for type ReplaceServerPeerNotFound
const ReplaceServerPeerNotFoundCode int = 404

/*
ReplaceServerPeerNotFound The specified resource was not found

swagger:response replaceServerPeerNotFound
*/
type ReplaceServerPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceServerPeerNotFound creates ReplaceServerPeerNotFound with default headers values
func NewReplaceServerPeerNotFound() *ReplaceServerPeerNotFound {

	return &ReplaceServerPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace server peer not found response
func (o *ReplaceServerPeerNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceServerPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace server peer not found response
func (o *ReplaceServerPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace server peer not found response
func (o *ReplaceServerPeerNotFound) WithPayload(payload *models.Error) *ReplaceServerPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace server peer not found response
func (o *ReplaceServerPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceServerPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceServerPeerDefault General Error

swagger:response replaceServerPeerDefault
*/
type ReplaceServerPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceServerPeerDefault creates ReplaceServerPeerDefault with default headers values
func NewReplaceServerPeerDefault(code int) *ReplaceServerPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceServerPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace server peer default response
func (o *ReplaceServerPeerDefault) WithStatusCode(code int) *ReplaceServerPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace server peer default response
func (o *ReplaceServerPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace server peer default response
func (o *ReplaceServerPeerDefault) WithConfigurationVersion(configurationVersion string) *ReplaceServerPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace server peer default response
func (o *ReplaceServerPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace server peer default response
func (o *ReplaceServerPeerDefault) WithPayload(payload *models.Error) *ReplaceServerPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace server peer default response
func (o *ReplaceServerPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceServerPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
