// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package ring

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetRingsOKCode is the HTTP code returned for type GetRingsOK
const GetRingsOKCode int = 200

/*
GetRingsOK Successful operation

swagger:response getRingsOK
*/
type GetRingsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Rings `json:"body,omitempty"`
}

// NewGetRingsOK creates GetRingsOK with default headers values
func NewGetRingsOK() *GetRingsOK {

	return &GetRingsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get rings o k response
func (o *GetRingsOK) WithConfigurationVersion(configurationVersion string) *GetRingsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get rings o k response
func (o *GetRingsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get rings o k response
func (o *GetRingsOK) WithPayload(payload models.Rings) *GetRingsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get rings o k response
func (o *GetRingsOK) SetPayload(payload models.Rings) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRingsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Rings{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetRingsDefault General Error

swagger:response getRingsDefault
*/
type GetRingsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetRingsDefault creates GetRingsDefault with default headers values
func NewGetRingsDefault(code int) *GetRingsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetRingsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get rings default response
func (o *GetRingsDefault) WithStatusCode(code int) *GetRingsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get rings default response
func (o *GetRingsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get rings default response
func (o *GetRingsDefault) WithConfigurationVersion(configurationVersion string) *GetRingsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get rings default response
func (o *GetRingsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get rings default response
func (o *GetRingsDefault) WithPayload(payload *models.Error) *GetRingsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get rings default response
func (o *GetRingsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetRingsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
