// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package mailers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteMailersSectionAcceptedCode is the HTTP code returned for type DeleteMailersSectionAccepted
const DeleteMailersSectionAcceptedCode int = 202

/*
DeleteMailersSectionAccepted Configuration change accepted and reload requested

swagger:response deleteMailersSectionAccepted
*/
type DeleteMailersSectionAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteMailersSectionAccepted creates DeleteMailersSectionAccepted with default headers values
func NewDeleteMailersSectionAccepted() *DeleteMailersSectionAccepted {

	return &DeleteMailersSectionAccepted{}
}

// WithReloadID adds the reloadId to the delete mailers section accepted response
func (o *DeleteMailersSectionAccepted) WithReloadID(reloadID string) *DeleteMailersSectionAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete mailers section accepted response
func (o *DeleteMailersSectionAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteMailersSectionAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteMailersSectionNoContentCode is the HTTP code returned for type DeleteMailersSectionNoContent
const DeleteMailersSectionNoContentCode int = 204

/*
DeleteMailersSectionNoContent Mailers deleted

swagger:response deleteMailersSectionNoContent
*/
type DeleteMailersSectionNoContent struct {
}

// NewDeleteMailersSectionNoContent creates DeleteMailersSectionNoContent with default headers values
func NewDeleteMailersSectionNoContent() *DeleteMailersSectionNoContent {

	return &DeleteMailersSectionNoContent{}
}

// WriteResponse to the client
func (o *DeleteMailersSectionNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteMailersSectionNotFoundCode is the HTTP code returned for type DeleteMailersSectionNotFound
const DeleteMailersSectionNotFoundCode int = 404

/*
DeleteMailersSectionNotFound The specified resource was not found

swagger:response deleteMailersSectionNotFound
*/
type DeleteMailersSectionNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteMailersSectionNotFound creates DeleteMailersSectionNotFound with default headers values
func NewDeleteMailersSectionNotFound() *DeleteMailersSectionNotFound {

	return &DeleteMailersSectionNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete mailers section not found response
func (o *DeleteMailersSectionNotFound) WithConfigurationVersion(configurationVersion string) *DeleteMailersSectionNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete mailers section not found response
func (o *DeleteMailersSectionNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete mailers section not found response
func (o *DeleteMailersSectionNotFound) WithPayload(payload *models.Error) *DeleteMailersSectionNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete mailers section not found response
func (o *DeleteMailersSectionNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteMailersSectionNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteMailersSectionDefault General Error

swagger:response deleteMailersSectionDefault
*/
type DeleteMailersSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteMailersSectionDefault creates DeleteMailersSectionDefault with default headers values
func NewDeleteMailersSectionDefault(code int) *DeleteMailersSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteMailersSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete mailers section default response
func (o *DeleteMailersSectionDefault) WithStatusCode(code int) *DeleteMailersSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete mailers section default response
func (o *DeleteMailersSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete mailers section default response
func (o *DeleteMailersSectionDefault) WithConfigurationVersion(configurationVersion string) *DeleteMailersSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete mailers section default response
func (o *DeleteMailersSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete mailers section default response
func (o *DeleteMailersSectionDefault) WithPayload(payload *models.Error) *DeleteMailersSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete mailers section default response
func (o *DeleteMailersSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteMailersSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
