package com.fasterxml.jackson.dataformat.xml.tofix;

import org.junit.jupiter.api.Test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.fasterxml.jackson.dataformat.xml.XmlTestUtil;
import com.fasterxml.jackson.dataformat.xml.testutil.failure.JacksonTestFailureExpected;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.fail;

public class VerifyRootLocalName247Test extends XmlTestUtil
{
    // [dataformat-xml#247]
    static class Root {
        public int value;
    }

    /*
    /**********************************************************************
    /* Test methods
    /**********************************************************************
     */

    private final ObjectMapper MAPPER = newMapper();

    // [dataformat-xml#247]
    @JacksonTestFailureExpected
    @Test
    public void testRootNameValidation247() throws Exception
    {
        Root root = MAPPER
                .readerFor(Root.class)
// 16-Nov-2020, tatu: no time to implement for 2.12, hopefully next version?
//                .with(FromXmlParser.Feature.ENFORCE_VALID_ROOT_NAME)
                .readValue("<Root><value>42</value></Root>");
        assertEquals(42, root.value);

        // so far so good. But why no validation for root local name?
        try {
            MAPPER.readValue("<Boot><value>42</value></Boot>", Root.class);
            fail("Should not allow wrong local name!");
        } catch (JsonProcessingException e) {
            verifyException(e, "Foobar");
        }
    }
}
