/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.colormgr.ColorManager;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.awt.Color;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ColorProperty
extends JETAProperty
implements Externalizable {
    static final long serialVersionUID = -4907629297184715948L;
    public static final int VERSION = 2;
    public static final String CONSTANT_COLOR = "constant";
    public static final String DEFAULT_COLOR = "default";
    private Color m_constant_color = Color.black;
    private String m_color_key = "constant";
    private int m_brightness = 0;
    private float m_brightness_factor = 0.7f;
    public static final float DEFAULT_FACTOR = 0.7f;
    public static final String PROPERTY_ID = "dyncolor";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColorProperty() {
        super(PROPERTY_ID);
    }

    public ColorProperty(Color color) {
        super(PROPERTY_ID);
        this.m_constant_color = color;
        this.m_color_key = CONSTANT_COLOR;
    }

    public ColorProperty(String string) {
        super(PROPERTY_ID);
        this.m_color_key = string;
        if (!$assertionsDisabled && CONSTANT_COLOR.equals(string)) {
            throw new AssertionError();
        }
    }

    private Color brighter(Color color, float f) {
        if ((double)f < 0.01) {
            f = 0.01f;
        } else if ((double)f > 1.0) {
            f = 1.0f;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(1.0 / (1.0 - (double)f));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((float)n / f), 255), Math.min((int)((float)n2 / f), 255), Math.min((int)((float)n3 / f), 255));
    }

    public Color darker(Color color, float f) {
        return new Color(Math.max((int)((float)color.getRed() * f), 0), Math.max((int)((float)color.getGreen() * f), 0), Math.max((int)((float)color.getBlue() * f), 0));
    }

    public Color getColor() {
        Color color = Color.white;
        if (this.isConstant()) {
            color = this.m_constant_color;
        } else {
            ColorManager colorManager = (ColorManager)JETARegistry.lookup("jeta.color.manager");
            if (colorManager != null) {
                color = colorManager.getColor(this.m_color_key, null);
            }
        }
        if (color == null) {
            color = Color.white;
        }
        color = this.modifyBrightness(color);
        return color;
    }

    public int getBrightness() {
        return this.m_brightness;
    }

    public float getBrightnessFactor() {
        return this.m_brightness_factor;
    }

    public String getColorKey() {
        return this.m_color_key;
    }

    public Color getConstantColor() {
        return this.m_constant_color;
    }

    private Color modifyBrightness(Color color) {
        for (int i = 0; i < Math.abs(this.m_brightness); ++i) {
            if (this.m_brightness > 0) {
                color = this.brighter(color, this.m_brightness_factor);
                continue;
            }
            if (this.m_brightness >= 0) continue;
            color = this.darker(color, this.m_brightness_factor);
        }
        return color;
    }

    public void setBrightness(int n) {
        this.m_brightness = n;
    }

    public void setBrightnessFactor(float f) {
        this.m_brightness_factor = f;
    }

    public void setColorKey(String string) {
        this.m_color_key = string;
    }

    public boolean isConstant() {
        return CONSTANT_COLOR.equalsIgnoreCase(this.m_color_key);
    }

    public void setConstantColor(Color color) {
        this.m_constant_color = color;
        this.m_color_key = CONSTANT_COLOR;
    }

    public void setValue(Object object) {
        if (object instanceof ColorProperty) {
            ColorProperty colorProperty = (ColorProperty)object;
            this.m_color_key = colorProperty.m_color_key;
            this.m_constant_color = colorProperty.m_constant_color;
            this.m_brightness = colorProperty.m_brightness;
            this.m_brightness_factor = colorProperty.m_brightness_factor;
        } else if (object != null && !$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void updateBean(JETABean jETABean) {
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_color_key = (String)objectInput.readObject();
        this.m_constant_color = (Color)objectInput.readObject();
        if (n > 1) {
            this.m_brightness = objectInput.readInt();
            this.m_brightness_factor = objectInput.readFloat();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(2);
        objectOutput.writeObject(this.m_color_key);
        objectOutput.writeObject(this.m_constant_color);
        objectOutput.writeInt(this.m_brightness);
        objectOutput.writeFloat(this.m_brightness_factor);
    }

    static {
        $assertionsDisabled = !ColorProperty.class.desiredAssertionStatus();
    }
}

