## RabbitMQ 3.7.12

RabbitMQ `3.7.12` is a maintenance release. It focuses on bug fixes and
minor usability improvements. This release [**requires Erlang/OTP 20.3**](https://www.rabbitmq.com/which-erlang.html) or later.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories)
explains what package repositories and tools can be used to provision latest patch versions of
Erlang `20.3.x` and `21.x`.

### Compatibility Notes

#### Minimum Required Erlang Version

This release requires Erlang/OTP 20.3 or later.

#### `rabbitmqctl shutdown` Behavior with Remote Nodes

In earlier releases, when `rabbitmqctl shutdown` was used against a remote node, it would successfully
shut down the node but won't actually wait for its termination because the pid file path
reported by the remote node is not available locally. This is because `rabbitmqctl shutdown` was
meant to be used as a `rabbitmqctl stop` alternative that doesn't require the caller to know the
pid file path.

Starting with this version, `rabbitmqctl shutdown` will refuse to run against a remote node
by default. If the earlier behavior is desired and expected, it can be restored by passing `--no-wait`:

``` shell
# will refuse to run against a remote node in --wait mode as of 3.7.12
# and --wait is on by default
rabbitmqctl shutdown -n rabbit@hostname.different.from.local --longnames

# behaves the same way as in 3.7.0 through 3.7.11
rabbitmqctl shutdown -n rabbit@hostname.different.from.local --longnames --no-wait
```

#### `inet_dist_listen_min` and `inet_dist_listen_max` in New Style Configuration

`inet_dist_listen_min` and `inet_dist_listen_max` were **removed from new style configuration**.
They wouldn't have any effect due to how configuration translation is performed.
Use `advanced.config` or the `RABBITMQ_DIST_PORT` env variable to configure these settings:

``` erlang
[
 {kernel, [
   {inet_dist_listen_min, 33672},
   {inet_dist_listen_max, 33672}
 ]},
 {rabbit, [
   %% ...
 ]}
].
```

Note that some runtime parameters, e.g. `net_ticktime`, can be set via new style configuration.
This change is specific to the distirbution port settings.

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * When a node was configured to allow for unlimited frame size, an empty message published
   via HTTP API resulted in an infinite recursion loop in the parser.

   GitHub issue: [rabbitmq/rabbitmq-common#299](https://github.com/rabbitmq/rabbitmq-common/issues/299)

 * `inet_dist_listen_min` and `inet_dist_listen_max` were **removed from new style configuration**.
   They wouldn't have any effect due to how configuration translation is performed.
   Use `advanced.config` or the `RABBITMQ_DIST_PORT` env variable to configure these settings:

    ``` erlang
    [
      {kernel, [
        {inet_dist_listen_min, 33672},
        {inet_dist_listen_max, 33672}
      ]},
      {rabbit, [
        %% ...
      ]}
    ].
    ```

   Note that some runtime parameters, e.g. `net_ticktime`, can be set via new style configuration.
   This change is specific to the distirbution port settings.

   Contributed by [Gabriele Santomaggio](https://github.com/Gsantomaggio).

   GitHub issue: [rabbitmq/rabbitmq-server#1881](https://github.com/rabbitmq/rabbitmq-server/pull/1881)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl` and other CLI tools could fail when used with nodes using long node names.

   GitHub issue: [rabbitmq/rabbitmq-cli#311](https://github.com/rabbitmq/rabbitmq-cli/issues/311)

 * `rabbitmqctl --help` now exits with exit code of 0. `rabbitmqctl` (no arguments) uses code
   64 (`EX_USAGE`).

   GitHub issue: [rabbitmq/rabbitmq-cli#307](https://github.com/rabbitmq/rabbitmq-cli/issues/307)

#### Enhancements

 * `rabbitmqctl shutdown` now requires the user to opt in and provide `--no-wait`
   to be used with remote nodes. There are no behavior changes when the command is invoked
   against a locally running node. See also the compatibility note to this release.

   GitHub issue: [rabbitmq/rabbitmq-cli#309](https://github.com/rabbitmq/rabbitmq-cli/pull/309)


### Management Plugin

#### Bug Fixes

 * Large HTTP API request bodies (e.g. importing a large [definition file](https://www.rabbitmq.com/backup.html#rabbitmq-definitions))
   were not guaranteed to be fully consumed before parsing.

   GitHub issue: [rabbitmq/rabbitmq-management#657](https://github.com/rabbitmq/rabbitmq-management/issues/657)

 * `management_db_cache_multiplier` configuration setting was ignored due to a typo.

   Contributed by [Josh Soref](https://github.com/jsoref).

   GitHub issue: [rabbitmq/rabbitmq-management#659](https://github.com/rabbitmq/rabbitmq-management/pull/659)


### MQTT Plugin

#### Enhancements

 * When a retained message is published, its topic is now correctly translated
   to use MQTT topic separators (a slash) regardless of the internal representation.

   Contributed by [Ryan Sandbach](https://github.com/rsandbach).

   GitHub issue: [rabbitmq/rabbitmq-mqtt#175](https://github.com/rabbitmq/rabbitmq-mqtt/issues/175)

 * When a client sent a duplicate `CONNECT` frame (tried to "reauthenticate"), connection failed
   [with a scary looking exception](https://groups.google.com/d/msg/rabbitmq-users/1MBdymMAZzw/HQLDwI_8GAAJ).

   Now the frame is ignored (reauthentication is therefore still impossible) and a warning is logged
   but the connection is kept open.

   Kudos to Grigory Starinkin for confirming our original hypothesis and providing the steps
   to reproduce.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#179](https://github.com/rabbitmq/rabbitmq-mqtt/issues/179).

#### Bug Fixes

 * Clearer and shorter log messages when a socket write fails.

   GitHub issue: [rabbitmq/rabbitmq-mqtt#178](https://github.com/rabbitmq/rabbitmq-mqtt/pull/178)


### LDAP Plugin

#### Enhancements

 * The plugin now uses its own [logging sink](https://www.rabbitmq.com/logging.html#advanced-configuration), which makes it possible to direct
   all LDAP logs to a separate file.

   Contributed by [Yury Alioshinov](https://github.com/Haster2004).

   GitHub issue: [rabbitmq/rabbitmq-auth-backend-ldap#105](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/pull/105)


## Shovel Plugin

#### Bug Fixes

 * Configurating a Shovel with a valid AMQP 1.0 destination could fail with an exception.

   GitHub issue: [rabbitmq/rabbitmq-shovel#50](https://github.com/rabbitmq/rabbitmq-shovel/issues/50)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.12.tar.gz`.
