package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// AppsClient is the composite Swagger for WebSite Management Client
type AppsClient struct {
	ManagementClient
}

// NewAppsClient creates an instance of the AppsClient client.
func NewAppsClient(subscriptionID string) AppsClient {
	return NewAppsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppsClientWithBaseURI creates an instance of the AppsClient client.
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return AppsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddPremierAddOn updates a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name.
// premierAddOn is a JSON representation of the edited premier add-on.
func (client AppsClient) AddPremierAddOn(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AddPremierAddOn")
	}

	req, err := client.AddPremierAddOnPreparer(resourceGroupName, name, premierAddOnName, premierAddOn)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnPreparer prepares the AddPremierAddOn request.
func (client AppsClient) AddPremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddPremierAddOnSender sends the AddPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AddPremierAddOnResponder handles the response to the AddPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPremierAddOnSlot updates a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name.
// premierAddOn is a JSON representation of the edited premier add-on. slot is
// name of the deployment slot. If a slot is not specified, the API will update
// the named add-on for the production slot.
func (client AppsClient) AddPremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AddPremierAddOnSlot")
	}

	req, err := client.AddPremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, premierAddOn, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnSlotPreparer prepares the AddPremierAddOnSlot request.
func (client AppsClient) AddPremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddPremierAddOnSlotSender sends the AddPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AddPremierAddOnSlotResponder handles the response to the AddPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostname analyze a custom hostname.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app hostName is custom hostname
func (client AppsClient) AnalyzeCustomHostname(resourceGroupName string, name string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AnalyzeCustomHostname")
	}

	req, err := client.AnalyzeCustomHostnamePreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnamePreparer prepares the AnalyzeCustomHostname request.
func (client AppsClient) AnalyzeCustomHostnamePreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AnalyzeCustomHostnameSender sends the AnalyzeCustomHostname request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AnalyzeCustomHostnameResponder handles the response to the AnalyzeCustomHostname request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostnameSlot analyze a custom hostname.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot. hostName is custom hostname
func (client AppsClient) AnalyzeCustomHostnameSlot(resourceGroupName string, name string, slot string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot")
	}

	req, err := client.AnalyzeCustomHostnameSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnameSlotPreparer prepares the AnalyzeCustomHostnameSlot request.
func (client AppsClient) AnalyzeCustomHostnameSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AnalyzeCustomHostnameSlotSender sends the AnalyzeCustomHostnameSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// AnalyzeCustomHostnameSlotResponder handles the response to the AnalyzeCustomHostnameSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameSlotResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigToProduction applies the configuration settings from the
// target slot onto the current slot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example.
func (client AppsClient) ApplySlotConfigToProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ApplySlotConfigToProduction")
	}

	req, err := client.ApplySlotConfigToProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigToProductionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigToProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigToProductionPreparer prepares the ApplySlotConfigToProduction request.
func (client AppsClient) ApplySlotConfigToProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigToProductionSender sends the ApplySlotConfigToProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigToProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ApplySlotConfigToProductionResponder handles the response to the ApplySlotConfigToProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigToProductionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ApplySlotConfigurationSlot applies the configuration settings from the
// target slot onto the current slot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example. slot is name of the source slot.
// If a slot is not specified, the production slot is used as the source slot.
func (client AppsClient) ApplySlotConfigurationSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ApplySlotConfigurationSlot")
	}

	req, err := client.ApplySlotConfigurationSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigurationSlotPreparer prepares the ApplySlotConfigurationSlot request.
func (client AppsClient) ApplySlotConfigurationSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigurationSlotSender sends the ApplySlotConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ApplySlotConfigurationSlotResponder handles the response to the ApplySlotConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Backup creates a backup of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is backup configuration. You can
// use the JSON response from the POST action as input here.
func (client AppsClient) Backup(resourceGroupName string, name string, request BackupRequest) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Backup")
	}

	req, err := client.BackupPreparer(resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure sending request")
		return
	}

	result, err = client.BackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure responding to request")
	}

	return
}

// BackupPreparer prepares the Backup request.
func (client AppsClient) BackupPreparer(resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSender sends the Backup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// BackupResponder handles the response to the Backup request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSlot creates a backup of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is backup configuration. You can
// use the JSON response from the POST action as input here. slot is name of
// the deployment slot. If a slot is not specified, the API will create a
// backup for the production slot.
func (client AppsClient) BackupSlot(resourceGroupName string, name string, request BackupRequest, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "BackupSlot")
	}

	req, err := client.BackupSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.BackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure responding to request")
	}

	return
}

// BackupSlotPreparer prepares the BackupSlot request.
func (client AppsClient) BackupSlotPreparer(resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSlotSender sends the BackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// BackupSlotResponder handles the response to the BackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeployment create a deployment for an app, a specific deployment slot,
// and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is iD of an existing deployment.
// deployment is deployment details.
func (client AppsClient) CreateDeployment(resourceGroupName string, name string, ID string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateDeployment")
	}

	req, err := client.CreateDeploymentPreparer(resourceGroupName, name, ID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentPreparer prepares the CreateDeployment request.
func (client AppsClient) CreateDeploymentPreparer(resourceGroupName string, name string, ID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSender sends the CreateDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateDeploymentResponder handles the response to the CreateDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeploymentSlot create a deployment for an app, a specific deployment
// slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is iD of an existing deployment. slot
// is name of the deployment slot. If a slot is not specified, the API creates
// a deployment for the production slot. deployment is deployment details.
func (client AppsClient) CreateDeploymentSlot(resourceGroupName string, name string, ID string, slot string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateDeploymentSlot")
	}

	req, err := client.CreateDeploymentSlotPreparer(resourceGroupName, name, ID, slot, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentSlotPreparer prepares the CreateDeploymentSlot request.
func (client AppsClient) CreateDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSlotSender sends the CreateDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateDeploymentSlotResponder handles the response to the CreateDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeployment create a deployment for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is iD of an existing deployment.
// instanceID is iD of a specific scaled-out instance. This is the value of the
// name property in the JSON response from "GET api/sites/{siteName}/instances"
// deployment is deployment details.
func (client AppsClient) CreateInstanceDeployment(resourceGroupName string, name string, ID string, instanceID string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateInstanceDeployment")
	}

	req, err := client.CreateInstanceDeploymentPreparer(resourceGroupName, name, ID, instanceID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateInstanceDeploymentPreparer prepares the CreateInstanceDeployment request.
func (client AppsClient) CreateInstanceDeploymentPreparer(resourceGroupName string, name string, ID string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateInstanceDeploymentSender sends the CreateInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateInstanceDeploymentResponder handles the response to the CreateInstanceDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeploymentSlot create a deployment for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is iD of an existing deployment. slot
// is name of the deployment slot. If a slot is not specified, the API creates
// a deployment for the production slot. instanceID is iD of a specific
// scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances" deployment is deployment
// details.
func (client AppsClient) CreateInstanceDeploymentSlot(resourceGroupName string, name string, ID string, slot string, instanceID string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateInstanceDeploymentSlot")
	}

	req, err := client.CreateInstanceDeploymentSlotPreparer(resourceGroupName, name, ID, slot, instanceID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateInstanceDeploymentSlotPreparer prepares the CreateInstanceDeploymentSlot request.
func (client AppsClient) CreateInstanceDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateInstanceDeploymentSlotSender sends the CreateInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateInstanceDeploymentSlotResponder handles the response to the CreateInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates a new web, mobile, or API app in an existing resource
// group, or updates an existing app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is unique name of the app to create or update. To create or
// update a deployment slot, use the {slot} parameter. siteEnvelope is a JSON
// representation of the app properties. See example. skipDNSRegistration is if
// true web app hostname is not registered with DNS on creation. This parameter
// is
// only used for app creation skipCustomDomainVerification is if true, custom
// (non *.azurewebsites.net) domains associated with web app are not verified.
// forceDNSRegistration is if true, web app hostname is force registered with
// DNS TTLInSeconds is time to live in seconds for web app's default domain
// name
func (client AppsClient) CreateOrUpdate(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Site
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, name, siteEnvelope, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppsClient) CreateOrUpdatePreparer(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}
	if skipCustomDomainVerification != nil {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", *skipCustomDomainVerification)
	}
	if forceDNSRegistration != nil {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", *forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfiguration updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteConfig is jSON representation of a
// SiteConfig object. See example.
func (client AppsClient) CreateOrUpdateConfiguration(resourceGroupName string, name string, siteConfig SiteConfigResource) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteConfig,
			Constraints: []validation.Constraint{{Target: "siteConfig.SiteConfig", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateConfiguration")
	}

	req, err := client.CreateOrUpdateConfigurationPreparer(resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationPreparer prepares the CreateOrUpdateConfiguration request.
func (client AppsClient) CreateOrUpdateConfigurationPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateConfigurationSender sends the CreateOrUpdateConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateConfigurationResponder handles the response to the CreateOrUpdateConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfigurationSlot updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteConfig is jSON representation of a
// SiteConfig object. See example. slot is name of the deployment slot. If a
// slot is not specified, the API will update configuration for the production
// slot.
func (client AppsClient) CreateOrUpdateConfigurationSlot(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteConfig,
			Constraints: []validation.Constraint{{Target: "siteConfig.SiteConfig", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteConfig.SiteConfig.Push.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot")
	}

	req, err := client.CreateOrUpdateConfigurationSlotPreparer(resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationSlotPreparer prepares the CreateOrUpdateConfigurationSlot request.
func (client AppsClient) CreateOrUpdateConfigurationSlotPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateConfigurationSlotSender sends the CreateOrUpdateConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateConfigurationSlotResponder handles the response to the CreateOrUpdateConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifier creates a domain ownership
// identifier for web app, or updates an existing ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier")
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierPreparer prepares the CreateOrUpdateDomainOwnershipIdentifier request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateDomainOwnershipIdentifierSender sends the CreateOrUpdateDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateDomainOwnershipIdentifierResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlot creates a domain ownership
// identifier for web app, or updates an existing ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties. slot is name of the
// deployment slot. If a slot is not specified, the API will delete the binding
// for the production slot.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot")
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlotPreparer prepares the CreateOrUpdateDomainOwnershipIdentifierSlot request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateDomainOwnershipIdentifierSlotSender sends the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateDomainOwnershipIdentifierSlotResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBinding creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. hostName is hostname in the hostname
// binding. hostNameBinding is binding details. This is the JSON representation
// of a HostNameBinding object.
func (client AppsClient) CreateOrUpdateHostNameBinding(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding")
	}

	req, err := client.CreateOrUpdateHostNameBindingPreparer(resourceGroupName, name, hostName, hostNameBinding)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingPreparer prepares the CreateOrUpdateHostNameBinding request.
func (client AppsClient) CreateOrUpdateHostNameBindingPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHostNameBindingSender sends the CreateOrUpdateHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateHostNameBindingResponder handles the response to the CreateOrUpdateHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBindingSlot creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. hostName is hostname in the hostname
// binding. hostNameBinding is binding details. This is the JSON representation
// of a HostNameBinding object. slot is name of the deployment slot. If a slot
// is not specified, the API will create a binding for the production slot.
func (client AppsClient) CreateOrUpdateHostNameBindingSlot(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot")
	}

	req, err := client.CreateOrUpdateHostNameBindingSlotPreparer(resourceGroupName, name, hostName, hostNameBinding, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingSlotPreparer prepares the CreateOrUpdateHostNameBindingSlot request.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHostNameBindingSlotSender sends the CreateOrUpdateHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateHostNameBindingSlotResponder handles the response to the CreateOrUpdateHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnection creates a new Hybrid Connection using a
// Service Bus relay.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection connectionEnvelope is the details of the hybrid connection
func (client AppsClient) CreateOrUpdateHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHybridConnection")
	}

	req, err := client.CreateOrUpdateHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionPreparer prepares the CreateOrUpdateHybridConnection request.
func (client AppsClient) CreateOrUpdateHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHybridConnectionSender sends the CreateOrUpdateHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateHybridConnectionResponder handles the response to the CreateOrUpdateHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnectionSlot creates a new Hybrid Connection using a
// Service Bus relay.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection connectionEnvelope is the details of the hybrid connection slot
// is the name of the slot for the web app.
func (client AppsClient) CreateOrUpdateHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot")
	}

	req, err := client.CreateOrUpdateHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionSlotPreparer prepares the CreateOrUpdateHybridConnectionSlot request.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHybridConnectionSlotSender sends the CreateOrUpdateHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateHybridConnectionSlotResponder handles the response to the CreateOrUpdateHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnection creates a new hybrid connection
// configuration (PUT), or updates an existing one (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration. connectionEnvelope is details of the hybrid
// connection configuration.
func (client AppsClient) CreateOrUpdateRelayServiceConnection(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection")
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionPreparer(resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionPreparer prepares the CreateOrUpdateRelayServiceConnection request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateRelayServiceConnectionSender sends the CreateOrUpdateRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateRelayServiceConnectionResponder handles the response to the CreateOrUpdateRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnectionSlot creates a new hybrid connection
// configuration (PUT), or updates an existing one (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration. connectionEnvelope is details of the hybrid
// connection configuration. slot is name of the deployment slot. If a slot is
// not specified, the API will create or update a hybrid connection for the
// production slot.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot")
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionSlotPreparer prepares the CreateOrUpdateRelayServiceConnectionSlot request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateRelayServiceConnectionSlotSender sends the CreateOrUpdateRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateRelayServiceConnectionSlotResponder handles the response to the CreateOrUpdateRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSlot creates a new web, mobile, or API app in an existing
// resource group, or updates an existing app. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is unique name of the app to create or update. To create or
// update a deployment slot, use the {slot} parameter. siteEnvelope is a JSON
// representation of the app properties. See example. slot is name of the
// deployment slot to create or update. By default, this API attempts to create
// or modify the production slot. skipDNSRegistration is if true web app
// hostname is not registered with DNS on creation. This parameter is
// only used for app creation skipCustomDomainVerification is if true, custom
// (non *.azurewebsites.net) domains associated with web app are not verified.
// forceDNSRegistration is if true, web app hostname is force registered with
// DNS TTLInSeconds is time to live in seconds for web app's default domain
// name
func (client AppsClient) CreateOrUpdateSlot(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.SiteConfig.Push.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Site
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSlotPreparer(resourceGroupName, name, siteEnvelope, slot, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSlotPreparer prepares the CreateOrUpdateSlot request.
func (client AppsClient) CreateOrUpdateSlotPreparer(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}
	if skipCustomDomainVerification != nil {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", *skipCustomDomainVerification)
	}
	if forceDNSRegistration != nil {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", *forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSlotSender sends the CreateOrUpdateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSlotResponder handles the response to the CreateOrUpdateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControl updates the source control configuration of an
// app. This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteSourceControl is jSON representation
// of a SiteSourceControl object. See example.
func (client AppsClient) CreateOrUpdateSourceControl(resourceGroupName string, name string, siteSourceControl SiteSourceControl, cancel <-chan struct{}) (<-chan SiteSourceControl, <-chan error) {
	resultChan := make(chan SiteSourceControl, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSourceControl")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteSourceControl
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSourceControlPreparer(resourceGroupName, name, siteSourceControl, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSourceControlSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSourceControlResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSourceControlPreparer prepares the CreateOrUpdateSourceControl request.
func (client AppsClient) CreateOrUpdateSourceControlPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSourceControlSender sends the CreateOrUpdateSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSourceControlResponder handles the response to the CreateOrUpdateSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControlSlot updates the source control configuration of
// an app. This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteSourceControl is jSON representation
// of a SiteSourceControl object. See example. slot is name of the deployment
// slot. If a slot is not specified, the API will update the source control
// configuration for the production slot.
func (client AppsClient) CreateOrUpdateSourceControlSlot(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string, cancel <-chan struct{}) (<-chan SiteSourceControl, <-chan error) {
	resultChan := make(chan SiteSourceControl, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteSourceControl
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSourceControlSlotPreparer(resourceGroupName, name, siteSourceControl, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSourceControlSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSourceControlSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSourceControlSlotPreparer prepares the CreateOrUpdateSourceControlSlot request.
func (client AppsClient) CreateOrUpdateSourceControlSlotPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSourceControlSlotSender sends the CreateOrUpdateSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSourceControlSlotResponder handles the response to the CreateOrUpdateSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnection adds a Virtual Network connection to an app or
// slot (PUT) or updates the connection properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of an existing Virtual
// Network. connectionEnvelope is properties of the Virtual Network connection.
// See example.
func (client AppsClient) CreateOrUpdateVnetConnection(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnection")
	}

	req, err := client.CreateOrUpdateVnetConnectionPreparer(resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionPreparer prepares the CreateOrUpdateVnetConnection request.
func (client AppsClient) CreateOrUpdateVnetConnectionPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionSender sends the CreateOrUpdateVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateVnetConnectionResponder handles the response to the CreateOrUpdateVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGateway adds a gateway to a connected Virtual
// Network (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary". connectionEnvelope is the properties to update this gateway with.
func (client AppsClient) CreateOrUpdateVnetConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway")
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewayPreparer prepares the CreateOrUpdateVnetConnectionGateway request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionGatewaySender sends the CreateOrUpdateVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateVnetConnectionGatewayResponder handles the response to the CreateOrUpdateVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGatewaySlot adds a gateway to a connected
// Virtual Network (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary". connectionEnvelope is the properties to update this gateway with.
// slot is name of the deployment slot. If a slot is not specified, the API
// will add or update a gateway for the production slot's Virtual Network.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot")
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewaySlotPreparer prepares the CreateOrUpdateVnetConnectionGatewaySlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionGatewaySlotSender sends the CreateOrUpdateVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateVnetConnectionGatewaySlotResponder handles the response to the CreateOrUpdateVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionSlot adds a Virtual Network connection to an app
// or slot (PUT) or updates the connection properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of an existing Virtual
// Network. connectionEnvelope is properties of the Virtual Network connection.
// See example. slot is name of the deployment slot. If a slot is not
// specified, the API will add or update connections for the production slot.
func (client AppsClient) CreateOrUpdateVnetConnectionSlot(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot")
	}

	req, err := client.CreateOrUpdateVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionSlotPreparer prepares the CreateOrUpdateVnetConnectionSlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionSlotSender sends the CreateOrUpdateVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateOrUpdateVnetConnectionSlotResponder handles the response to the CreateOrUpdateVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a web, mobile, or API app, or one of the deployment slots.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app to delete. deleteMetrics is if true, web
// app metrics are also deleted deleteEmptyServerFarm is specify true if the
// App Service plan will be empty after app deletion and you want to delete the
// empty App Service plan. By default, the empty App Service plan is not
// deleted. skipDNSRegistration is if true, DNS registration is skipped
func (client AppsClient) Delete(resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppsClient) DeletePreparer(resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackup deletes a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup.
func (client AppsClient) DeleteBackup(resourceGroupName string, name string, backupID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackup")
	}

	req, err := client.DeleteBackupPreparer(resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupPreparer prepares the DeleteBackup request.
func (client AppsClient) DeleteBackupPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSender sends the DeleteBackup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupResponder handles the response to the DeleteBackup request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfiguration deletes the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) DeleteBackupConfiguration(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupConfiguration")
	}

	req, err := client.DeleteBackupConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationPreparer prepares the DeleteBackupConfiguration request.
func (client AppsClient) DeleteBackupConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupConfigurationSender sends the DeleteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupConfigurationResponder handles the response to the DeleteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfigurationSlot deletes the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will delete the backup configuration for the
// production slot.
func (client AppsClient) DeleteBackupConfigurationSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupConfigurationSlot")
	}

	req, err := client.DeleteBackupConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationSlotPreparer prepares the DeleteBackupConfigurationSlot request.
func (client AppsClient) DeleteBackupConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupConfigurationSlotSender sends the DeleteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupConfigurationSlotResponder handles the response to the DeleteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupSlot deletes a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup. slot is name
// of the deployment slot. If a slot is not specified, the API will delete a
// backup of the production slot.
func (client AppsClient) DeleteBackupSlot(resourceGroupName string, name string, backupID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupSlot")
	}

	req, err := client.DeleteBackupSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupSlotPreparer prepares the DeleteBackupSlot request.
func (client AppsClient) DeleteBackupSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSlotSender sends the DeleteBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteBackupSlotResponder handles the response to the DeleteBackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeployment delete a deployment by its ID for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID.
func (client AppsClient) DeleteDeployment(resourceGroupName string, name string, ID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDeployment")
	}

	req, err := client.DeleteDeploymentPreparer(resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentPreparer prepares the DeleteDeployment request.
func (client AppsClient) DeleteDeploymentPreparer(resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSender sends the DeleteDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDeploymentResponder handles the response to the DeleteDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeploymentSlot delete a deployment by its ID for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. slot is name of the
// deployment slot. If a slot is not specified, the API deletes a deployment
// for the production slot.
func (client AppsClient) DeleteDeploymentSlot(resourceGroupName string, name string, ID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDeploymentSlot")
	}

	req, err := client.DeleteDeploymentSlotPreparer(resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentSlotPreparer prepares the DeleteDeploymentSlot request.
func (client AppsClient) DeleteDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSlotSender sends the DeleteDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDeploymentSlotResponder handles the response to the DeleteDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifier deletes a domain ownership identifier for a
// web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier.
func (client AppsClient) DeleteDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier")
	}

	req, err := client.DeleteDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierPreparer prepares the DeleteDomainOwnershipIdentifier request.
func (client AppsClient) DeleteDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDomainOwnershipIdentifierSender sends the DeleteDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDomainOwnershipIdentifierResponder handles the response to the DeleteDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifierSlot deletes a domain ownership identifier
// for a web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. slot is name of the deployment slot. If a slot
// is not specified, the API will delete the binding for the production slot.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot")
	}

	req, err := client.DeleteDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierSlotPreparer prepares the DeleteDomainOwnershipIdentifierSlot request.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDomainOwnershipIdentifierSlotSender sends the DeleteDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteDomainOwnershipIdentifierSlotResponder handles the response to the DeleteDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBinding deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. hostName is hostname in the hostname
// binding.
func (client AppsClient) DeleteHostNameBinding(resourceGroupName string, name string, hostName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHostNameBinding")
	}

	req, err := client.DeleteHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingPreparer prepares the DeleteHostNameBinding request.
func (client AppsClient) DeleteHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHostNameBindingSender sends the DeleteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteHostNameBindingResponder handles the response to the DeleteHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBindingSlot deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will delete the binding for the production
// slot. hostName is hostname in the hostname binding.
func (client AppsClient) DeleteHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHostNameBindingSlot")
	}

	req, err := client.DeleteHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingSlotPreparer prepares the DeleteHostNameBindingSlot request.
func (client AppsClient) DeleteHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHostNameBindingSlotSender sends the DeleteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteHostNameBindingSlotResponder handles the response to the DeleteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnection removes a Hybrid Connection from this site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection
func (client AppsClient) DeleteHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHybridConnection")
	}

	req, err := client.DeleteHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionPreparer prepares the DeleteHybridConnection request.
func (client AppsClient) DeleteHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHybridConnectionSender sends the DeleteHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteHybridConnectionResponder handles the response to the DeleteHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnectionSlot removes a Hybrid Connection from this site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection slot is the name of the slot for the web app.
func (client AppsClient) DeleteHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHybridConnectionSlot")
	}

	req, err := client.DeleteHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionSlotPreparer prepares the DeleteHybridConnectionSlot request.
func (client AppsClient) DeleteHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHybridConnectionSlotSender sends the DeleteHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteHybridConnectionSlotResponder handles the response to the DeleteHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceDeployment delete a deployment by its ID for an app, a
// specific deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. instanceID is iD of a
// specific scaled-out instance. This is the value of the name property in the
// JSON response from "GET api/sites/{siteName}/instances"
func (client AppsClient) DeleteInstanceDeployment(resourceGroupName string, name string, ID string, instanceID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteInstanceDeployment")
	}

	req, err := client.DeleteInstanceDeploymentPreparer(resourceGroupName, name, ID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceDeploymentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceDeploymentPreparer prepares the DeleteInstanceDeployment request.
func (client AppsClient) DeleteInstanceDeploymentPreparer(resourceGroupName string, name string, ID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceDeploymentSender sends the DeleteInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteInstanceDeploymentResponder handles the response to the DeleteInstanceDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceDeploymentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceDeploymentSlot delete a deployment by its ID for an app, a
// specific deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. slot is name of the
// deployment slot. If a slot is not specified, the API deletes a deployment
// for the production slot. instanceID is iD of a specific scaled-out instance.
// This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances"
func (client AppsClient) DeleteInstanceDeploymentSlot(resourceGroupName string, name string, ID string, slot string, instanceID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteInstanceDeploymentSlot")
	}

	req, err := client.DeleteInstanceDeploymentSlotPreparer(resourceGroupName, name, ID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceDeploymentSlotPreparer prepares the DeleteInstanceDeploymentSlot request.
func (client AppsClient) DeleteInstanceDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceDeploymentSlotSender sends the DeleteInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteInstanceDeploymentSlotResponder handles the response to the DeleteInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceDeploymentSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOn delete a premier add-on from an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name.
func (client AppsClient) DeletePremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePremierAddOn")
	}

	req, err := client.DeletePremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnPreparer prepares the DeletePremierAddOn request.
func (client AppsClient) DeletePremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePremierAddOnSender sends the DeletePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeletePremierAddOnResponder handles the response to the DeletePremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOnSlot delete a premier add-on from an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name. slot is
// name of the deployment slot. If a slot is not specified, the API will delete
// the named add-on for the production slot.
func (client AppsClient) DeletePremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePremierAddOnSlot")
	}

	req, err := client.DeletePremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnSlotPreparer prepares the DeletePremierAddOnSlot request.
func (client AppsClient) DeletePremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePremierAddOnSlotSender sends the DeletePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeletePremierAddOnSlotResponder handles the response to the DeletePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnection deletes a relay service connection by its name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration.
func (client AppsClient) DeleteRelayServiceConnection(resourceGroupName string, name string, entityName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteRelayServiceConnection")
	}

	req, err := client.DeleteRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionPreparer prepares the DeleteRelayServiceConnection request.
func (client AppsClient) DeleteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteRelayServiceConnectionSender sends the DeleteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteRelayServiceConnectionResponder handles the response to the DeleteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnectionSlot deletes a relay service connection by its
// name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration. slot is name of the deployment slot. If a slot is
// not specified, the API will delete a hybrid connection for the production
// slot.
func (client AppsClient) DeleteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot")
	}

	req, err := client.DeleteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionSlotPreparer prepares the DeleteRelayServiceConnectionSlot request.
func (client AppsClient) DeleteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteRelayServiceConnectionSlotSender sends the DeleteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteRelayServiceConnectionSlotResponder handles the response to the DeleteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSlot deletes a web, mobile, or API app, or one of the deployment
// slots.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app to delete. slot is name of the deployment
// slot to delete. By default, the API deletes the production slot.
// deleteMetrics is if true, web app metrics are also deleted
// deleteEmptyServerFarm is specify true if the App Service plan will be empty
// after app deletion and you want to delete the empty App Service plan. By
// default, the empty App Service plan is not deleted. skipDNSRegistration is
// if true, DNS registration is skipped
func (client AppsClient) DeleteSlot(resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSlot")
	}

	req, err := client.DeleteSlotPreparer(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSlotPreparer prepares the DeleteSlot request.
func (client AppsClient) DeleteSlotPreparer(resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSlotSender sends the DeleteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSlotResponder handles the response to the DeleteSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControl deletes the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) DeleteSourceControl(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSourceControl")
	}

	req, err := client.DeleteSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlPreparer prepares the DeleteSourceControl request.
func (client AppsClient) DeleteSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSourceControlSender sends the DeleteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSourceControlResponder handles the response to the DeleteSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControlSlot deletes the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will delete the source control configuration
// for the production slot.
func (client AppsClient) DeleteSourceControlSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSourceControlSlot")
	}

	req, err := client.DeleteSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlSlotPreparer prepares the DeleteSourceControlSlot request.
func (client AppsClient) DeleteSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSourceControlSlotSender sends the DeleteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteSourceControlSlotResponder handles the response to the DeleteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnection deletes a connection from an app (or deployment slot to
// a named virtual network.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the virtual network.
func (client AppsClient) DeleteVnetConnection(resourceGroupName string, name string, vnetName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteVnetConnection")
	}

	req, err := client.DeleteVnetConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionPreparer prepares the DeleteVnetConnection request.
func (client AppsClient) DeleteVnetConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteVnetConnectionSender sends the DeleteVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteVnetConnectionResponder handles the response to the DeleteVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnectionSlot deletes a connection from an app (or deployment
// slot to a named virtual network.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the virtual network.
// slot is name of the deployment slot. If a slot is not specified, the API
// will delete the connection for the production slot.
func (client AppsClient) DeleteVnetConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteVnetConnectionSlot")
	}

	req, err := client.DeleteVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionSlotPreparer prepares the DeleteVnetConnectionSlot request.
func (client AppsClient) DeleteVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteVnetConnectionSlotSender sends the DeleteVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteVnetConnectionSlotResponder handles the response to the DeleteVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DiscoverRestore discovers an existing app backup that can be restored from a
// blob in Azure storage.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is a RestoreRequest object that
// includes Azure storage URL and blog name for discovery of backup.
func (client AppsClient) DiscoverRestore(resourceGroupName string, name string, request RestoreRequest) (result RestoreRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DiscoverRestore")
	}

	req, err := client.DiscoverRestorePreparer(resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverRestoreSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverRestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", resp, "Failure responding to request")
	}

	return
}

// DiscoverRestorePreparer prepares the DiscoverRestore request.
func (client AppsClient) DiscoverRestorePreparer(resourceGroupName string, name string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverRestoreSender sends the DiscoverRestore request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverRestoreSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DiscoverRestoreResponder handles the response to the DiscoverRestore request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverRestoreResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverRestoreSlot discovers an existing app backup that can be restored
// from a blob in Azure storage.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is a RestoreRequest object that
// includes Azure storage URL and blog name for discovery of backup. slot is
// name of the deployment slot. If a slot is not specified, the API will
// perform discovery for the production slot.
func (client AppsClient) DiscoverRestoreSlot(resourceGroupName string, name string, request RestoreRequest, slot string) (result RestoreRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DiscoverRestoreSlot")
	}

	req, err := client.DiscoverRestoreSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverRestoreSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverRestoreSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", resp, "Failure responding to request")
	}

	return
}

// DiscoverRestoreSlotPreparer prepares the DiscoverRestoreSlot request.
func (client AppsClient) DiscoverRestoreSlotPreparer(resourceGroupName string, name string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverRestoreSlotSender sends the DiscoverRestoreSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverRestoreSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DiscoverRestoreSlotResponder handles the response to the DiscoverRestoreSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverRestoreSlotResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPassword generates a new publishing password for an
// app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GenerateNewSitePublishingPassword(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GenerateNewSitePublishingPassword")
	}

	req, err := client.GenerateNewSitePublishingPasswordPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordPreparer prepares the GenerateNewSitePublishingPassword request.
func (client AppsClient) GenerateNewSitePublishingPasswordPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSender sends the GenerateNewSitePublishingPassword request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GenerateNewSitePublishingPasswordResponder handles the response to the GenerateNewSitePublishingPassword request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GenerateNewSitePublishingPasswordSlot generates a new publishing password
// for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API generate a new publishing password for the
// production slot.
func (client AppsClient) GenerateNewSitePublishingPasswordSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot")
	}

	req, err := client.GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordSlotPreparer prepares the GenerateNewSitePublishingPasswordSlot request.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSlotSender sends the GenerateNewSitePublishingPasswordSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GenerateNewSitePublishingPasswordSlotResponder handles the response to the GenerateNewSitePublishingPasswordSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the details of a web, mobile, or API app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) Get(resourceGroupName string, name string) (result Site, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppsClient) GetPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettings gets the Authentication/Authorization settings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GetAuthSettings(resourceGroupName string, name string) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetAuthSettings")
	}

	req, err := client.GetAuthSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsPreparer prepares the GetAuthSettings request.
func (client AppsClient) GetAuthSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetAuthSettingsSender sends the GetAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetAuthSettingsResponder handles the response to the GetAuthSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettingsSlot gets the Authentication/Authorization settings of an
// app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the settings for the production
// slot.
func (client AppsClient) GetAuthSettingsSlot(resourceGroupName string, name string, slot string) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetAuthSettingsSlot")
	}

	req, err := client.GetAuthSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsSlotPreparer prepares the GetAuthSettingsSlot request.
func (client AppsClient) GetAuthSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetAuthSettingsSlotSender sends the GetAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetAuthSettingsSlotResponder handles the response to the GetAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfiguration gets the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GetBackupConfiguration(resourceGroupName string, name string) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupConfiguration")
	}

	req, err := client.GetBackupConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationPreparer prepares the GetBackupConfiguration request.
func (client AppsClient) GetBackupConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupConfigurationSender sends the GetBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetBackupConfigurationResponder handles the response to the GetBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfigurationSlot gets the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the backup configuration for the
// production slot.
func (client AppsClient) GetBackupConfigurationSlot(resourceGroupName string, name string, slot string) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupConfigurationSlot")
	}

	req, err := client.GetBackupConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationSlotPreparer prepares the GetBackupConfigurationSlot request.
func (client AppsClient) GetBackupConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupConfigurationSlotSender sends the GetBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetBackupConfigurationSlotResponder handles the response to the GetBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatus gets a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup.
func (client AppsClient) GetBackupStatus(resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupStatus")
	}

	req, err := client.GetBackupStatusPreparer(resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusPreparer prepares the GetBackupStatus request.
func (client AppsClient) GetBackupStatusPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupStatusSender sends the GetBackupStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetBackupStatusResponder handles the response to the GetBackupStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatusSlot gets a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup. slot is name
// of the deployment slot. If a slot is not specified, the API will get a
// backup of the production slot.
func (client AppsClient) GetBackupStatusSlot(resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupStatusSlot")
	}

	req, err := client.GetBackupStatusSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusSlotPreparer prepares the GetBackupStatusSlot request.
func (client AppsClient) GetBackupStatusSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupStatusSlotSender sends the GetBackupStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetBackupStatusSlotResponder handles the response to the GetBackupStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfiguration gets the configuration of an app, such as platform version
// and bitness, default documents, virtual applications, Always On, etc.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GetConfiguration(resourceGroupName string, name string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfiguration")
	}

	req, err := client.GetConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationPreparer prepares the GetConfiguration request.
func (client AppsClient) GetConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSender sends the GetConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetConfigurationResponder handles the response to the GetConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSlot gets the configuration of an app, such as platform
// version and bitness, default documents, virtual applications, Always On,
// etc.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will return configuration for the production
// slot.
func (client AppsClient) GetConfigurationSlot(resourceGroupName string, name string, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSlot")
	}

	req, err := client.GetConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSlotPreparer prepares the GetConfigurationSlot request.
func (client AppsClient) GetConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSlotSender sends the GetConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetConfigurationSlotResponder handles the response to the GetConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshot gets a snapshot of the configuration of an app at a
// previous point in time.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. snapshotID is the ID of the snapshot to
// read.
func (client AppsClient) GetConfigurationSnapshot(resourceGroupName string, name string, snapshotID string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSnapshot")
	}

	req, err := client.GetConfigurationSnapshotPreparer(resourceGroupName, name, snapshotID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotPreparer prepares the GetConfigurationSnapshot request.
func (client AppsClient) GetConfigurationSnapshotPreparer(resourceGroupName string, name string, snapshotID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSnapshotSender sends the GetConfigurationSnapshot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetConfigurationSnapshotResponder handles the response to the GetConfigurationSnapshot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshotSlot gets a snapshot of the configuration of an app
// at a previous point in time.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. snapshotID is the ID of the snapshot to
// read. slot is name of the deployment slot. If a slot is not specified, the
// API will return configuration for the production slot.
func (client AppsClient) GetConfigurationSnapshotSlot(resourceGroupName string, name string, snapshotID string, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSnapshotSlot")
	}

	req, err := client.GetConfigurationSnapshotSlotPreparer(resourceGroupName, name, snapshotID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotSlotPreparer prepares the GetConfigurationSnapshotSlot request.
func (client AppsClient) GetConfigurationSnapshotSlotPreparer(resourceGroupName string, name string, snapshotID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSnapshotSlotSender sends the GetConfigurationSnapshotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetConfigurationSnapshotSlotResponder handles the response to the GetConfigurationSnapshotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployment get a deployment by its ID for an app, a specific deployment
// slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID.
func (client AppsClient) GetDeployment(resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDeployment")
	}

	req, err := client.GetDeploymentPreparer(resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentPreparer prepares the GetDeployment request.
func (client AppsClient) GetDeploymentPreparer(resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSender sends the GetDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentResponder handles the response to the GetDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentSlot get a deployment by its ID for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. slot is name of the
// deployment slot. If a slot is not specified, the API gets a deployment for
// the production slot.
func (client AppsClient) GetDeploymentSlot(resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDeploymentSlot")
	}

	req, err := client.GetDeploymentSlotPreparer(resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentSlotPreparer prepares the GetDeploymentSlot request.
func (client AppsClient) GetDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSlotSender sends the GetDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDeploymentSlotResponder handles the response to the GetDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfiguration gets the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GetDiagnosticLogsConfiguration(resourceGroupName string, name string) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration")
	}

	req, err := client.GetDiagnosticLogsConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationPreparer prepares the GetDiagnosticLogsConfiguration request.
func (client AppsClient) GetDiagnosticLogsConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDiagnosticLogsConfigurationSender sends the GetDiagnosticLogsConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDiagnosticLogsConfigurationResponder handles the response to the GetDiagnosticLogsConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfigurationSlot gets the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the logging configuration for the
// production slot.
func (client AppsClient) GetDiagnosticLogsConfigurationSlot(resourceGroupName string, name string, slot string) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot")
	}

	req, err := client.GetDiagnosticLogsConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationSlotPreparer prepares the GetDiagnosticLogsConfigurationSlot request.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDiagnosticLogsConfigurationSlotSender sends the GetDiagnosticLogsConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDiagnosticLogsConfigurationSlotResponder handles the response to the GetDiagnosticLogsConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifier get domain ownership identifier for web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier.
func (client AppsClient) GetDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDomainOwnershipIdentifier")
	}

	req, err := client.GetDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierPreparer prepares the GetDomainOwnershipIdentifier request.
func (client AppsClient) GetDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDomainOwnershipIdentifierSender sends the GetDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDomainOwnershipIdentifierResponder handles the response to the GetDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifierSlot get domain ownership identifier for web
// app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. slot is name of the deployment slot. If a slot
// is not specified, the API will delete the binding for the production slot.
func (client AppsClient) GetDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot")
	}

	req, err := client.GetDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierSlotPreparer prepares the GetDomainOwnershipIdentifierSlot request.
func (client AppsClient) GetDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDomainOwnershipIdentifierSlotSender sends the GetDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetDomainOwnershipIdentifierSlotResponder handles the response to the GetDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBinding get the named hostname binding for an app (or deployment
// slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. hostName is hostname in the hostname
// binding.
func (client AppsClient) GetHostNameBinding(resourceGroupName string, name string, hostName string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHostNameBinding")
	}

	req, err := client.GetHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingPreparer prepares the GetHostNameBinding request.
func (client AppsClient) GetHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostNameBindingSender sends the GetHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostNameBindingResponder handles the response to the GetHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBindingSlot get the named hostname binding for an app (or
// deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API the named binding for the production slot.
// hostName is hostname in the hostname binding.
func (client AppsClient) GetHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHostNameBindingSlot")
	}

	req, err := client.GetHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingSlotPreparer prepares the GetHostNameBindingSlot request.
func (client AppsClient) GetHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostNameBindingSlotSender sends the GetHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHostNameBindingSlotResponder handles the response to the GetHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnection retrieves a specific Service Bus Hybrid Connection used
// by this Web App.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection
func (client AppsClient) GetHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHybridConnection")
	}

	req, err := client.GetHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPreparer prepares the GetHybridConnection request.
func (client AppsClient) GetHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionSender sends the GetHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHybridConnectionResponder handles the response to the GetHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnectionSlot retrieves a specific Service Bus Hybrid Connection
// used by this Web App.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection slot is the name of the slot for the web app.
func (client AppsClient) GetHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHybridConnectionSlot")
	}

	req, err := client.GetHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionSlotPreparer prepares the GetHybridConnectionSlot request.
func (client AppsClient) GetHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionSlotSender sends the GetHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetHybridConnectionSlotResponder handles the response to the GetHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeployment get a deployment by its ID for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. instanceID is iD of a
// specific scaled-out instance. This is the value of the name property in the
// JSON response from "GET api/sites/{siteName}/instances"
func (client AppsClient) GetInstanceDeployment(resourceGroupName string, name string, ID string, instanceID string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceDeployment")
	}

	req, err := client.GetInstanceDeploymentPreparer(resourceGroupName, name, ID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeployment", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentPreparer prepares the GetInstanceDeployment request.
func (client AppsClient) GetInstanceDeploymentPreparer(resourceGroupName string, name string, ID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentSender sends the GetInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentResponder handles the response to the GetInstanceDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeploymentSlot get a deployment by its ID for an app, a specific
// deployment slot, and/or a specific scaled-out instance.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. ID is deployment ID. slot is name of the
// deployment slot. If a slot is not specified, the API gets a deployment for
// the production slot. instanceID is iD of a specific scaled-out instance.
// This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances"
func (client AppsClient) GetInstanceDeploymentSlot(resourceGroupName string, name string, ID string, slot string, instanceID string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceDeploymentSlot")
	}

	req, err := client.GetInstanceDeploymentSlotPreparer(resourceGroupName, name, ID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceDeploymentSlotPreparer prepares the GetInstanceDeploymentSlot request.
func (client AppsClient) GetInstanceDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceDeploymentSlotSender sends the GetInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetInstanceDeploymentSlotResponder handles the response to the GetInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatus returns the status of MySql in app migration, if one
// is active, and whether or not MySql in app is enabled
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app
func (client AppsClient) GetMigrateMySQLStatus(resourceGroupName string, name string) (result MigrateMySQLStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMigrateMySQLStatus")
	}

	req, err := client.GetMigrateMySQLStatusPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusPreparer prepares the GetMigrateMySQLStatus request.
func (client AppsClient) GetMigrateMySQLStatusPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMigrateMySQLStatusSender sends the GetMigrateMySQLStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMigrateMySQLStatusResponder handles the response to the GetMigrateMySQLStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatusSlot returns the status of MySql in app migration, if
// one is active, and whether or not MySql in app is enabled
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of the deployment slot
func (client AppsClient) GetMigrateMySQLStatusSlot(resourceGroupName string, name string, slot string) (result MigrateMySQLStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot")
	}

	req, err := client.GetMigrateMySQLStatusSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusSlotPreparer prepares the GetMigrateMySQLStatusSlot request.
func (client AppsClient) GetMigrateMySQLStatusSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMigrateMySQLStatusSlotSender sends the GetMigrateMySQLStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetMigrateMySQLStatusSlotResponder handles the response to the GetMigrateMySQLStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusSlotResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOn gets a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name.
func (client AppsClient) GetPremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPremierAddOn")
	}

	req, err := client.GetPremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnPreparer prepares the GetPremierAddOn request.
func (client AppsClient) GetPremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPremierAddOnSender sends the GetPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetPremierAddOnResponder handles the response to the GetPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOnSlot gets a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. premierAddOnName is add-on name. slot is
// name of the deployment slot. If a slot is not specified, the API will get
// the named add-on for the production slot.
func (client AppsClient) GetPremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPremierAddOnSlot")
	}

	req, err := client.GetPremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnSlotPreparer prepares the GetPremierAddOnSlot request.
func (client AppsClient) GetPremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPremierAddOnSlotSender sends the GetPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetPremierAddOnSlotResponder handles the response to the GetPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnection gets a hybrid connection configuration by its
// name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection.
func (client AppsClient) GetRelayServiceConnection(resourceGroupName string, name string, entityName string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetRelayServiceConnection")
	}

	req, err := client.GetRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionPreparer prepares the GetRelayServiceConnection request.
func (client AppsClient) GetRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetRelayServiceConnectionSender sends the GetRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetRelayServiceConnectionResponder handles the response to the GetRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnectionSlot gets a hybrid connection configuration by its
// name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection. slot is name of the deployment slot. If a slot is not specified,
// the API will get a hybrid connection for the production slot.
func (client AppsClient) GetRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetRelayServiceConnectionSlot")
	}

	req, err := client.GetRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionSlotPreparer prepares the GetRelayServiceConnectionSlot request.
func (client AppsClient) GetRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetRelayServiceConnectionSlotSender sends the GetRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetRelayServiceConnectionSlotResponder handles the response to the GetRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetResourceHealthMetadata gets the category of ResourceHealthMetadata to use
// for the given site
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app
func (client AppsClient) GetResourceHealthMetadata(resourceGroupName string, name string) (result ResourceHealthMetadata, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetResourceHealthMetadata")
	}

	req, err := client.GetResourceHealthMetadataPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourceHealthMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.GetResourceHealthMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadata", resp, "Failure responding to request")
	}

	return
}

// GetResourceHealthMetadataPreparer prepares the GetResourceHealthMetadata request.
func (client AppsClient) GetResourceHealthMetadataPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resourceHealthMetadata", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetResourceHealthMetadataSender sends the GetResourceHealthMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetResourceHealthMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResourceHealthMetadataResponder handles the response to the GetResourceHealthMetadata request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResourceHealthMetadataResponder(resp *http.Response) (result ResourceHealthMetadata, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetResourceHealthMetadataSlot gets the category of ResourceHealthMetadata to
// use for the given site
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot.
func (client AppsClient) GetResourceHealthMetadataSlot(resourceGroupName string, name string, slot string) (result ResourceHealthMetadata, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetResourceHealthMetadataSlot")
	}

	req, err := client.GetResourceHealthMetadataSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourceHealthMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetResourceHealthMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetResourceHealthMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// GetResourceHealthMetadataSlotPreparer prepares the GetResourceHealthMetadataSlot request.
func (client AppsClient) GetResourceHealthMetadataSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resourceHealthMetadata", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetResourceHealthMetadataSlotSender sends the GetResourceHealthMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetResourceHealthMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResourceHealthMetadataSlotResponder handles the response to the GetResourceHealthMetadataSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResourceHealthMetadataSlotResponder(resp *http.Response) (result ResourceHealthMetadata, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlag gets web app's event logs.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app
func (client AppsClient) GetSitePhpErrorLogFlag(resourceGroupName string, name string) (result SitePhpErrorLogFlag, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSitePhpErrorLogFlag")
	}

	req, err := client.GetSitePhpErrorLogFlagPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagPreparer prepares the GetSitePhpErrorLogFlag request.
func (client AppsClient) GetSitePhpErrorLogFlagPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePhpErrorLogFlagSender sends the GetSitePhpErrorLogFlag request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSitePhpErrorLogFlagResponder handles the response to the GetSitePhpErrorLogFlag request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlagSlot gets web app's event logs.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot.
func (client AppsClient) GetSitePhpErrorLogFlagSlot(resourceGroupName string, name string, slot string) (result SitePhpErrorLogFlag, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot")
	}

	req, err := client.GetSitePhpErrorLogFlagSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagSlotPreparer prepares the GetSitePhpErrorLogFlagSlot request.
func (client AppsClient) GetSitePhpErrorLogFlagSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePhpErrorLogFlagSlotSender sends the GetSitePhpErrorLogFlagSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSitePhpErrorLogFlagSlotResponder handles the response to the GetSitePhpErrorLogFlagSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagSlotResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlot gets the details of a web, mobile, or API app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. By
// default, this API returns the production slot.
func (client AppsClient) GetSlot(resourceGroupName string, name string, slot string) (result Site, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSlot")
	}

	req, err := client.GetSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure responding to request")
	}

	return
}

// GetSlotPreparer prepares the GetSlot request.
func (client AppsClient) GetSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSlotSender sends the GetSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSlotResponder handles the response to the GetSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControl gets the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) GetSourceControl(resourceGroupName string, name string) (result SiteSourceControl, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSourceControl")
	}

	req, err := client.GetSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlPreparer prepares the GetSourceControl request.
func (client AppsClient) GetSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSourceControlSender sends the GetSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSourceControlResponder handles the response to the GetSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControlSlot gets the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the source control configuration for
// the production slot.
func (client AppsClient) GetSourceControlSlot(resourceGroupName string, name string, slot string) (result SiteSourceControl, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSourceControlSlot")
	}

	req, err := client.GetSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlSlotPreparer prepares the GetSourceControlSlot request.
func (client AppsClient) GetSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSourceControlSlotSender sends the GetSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetSourceControlSlotResponder handles the response to the GetSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnection gets a virtual network the app (or deployment slot) is
// connected to by name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the virtual network.
func (client AppsClient) GetVnetConnection(resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnection")
	}

	req, err := client.GetVnetConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionPreparer prepares the GetVnetConnection request.
func (client AppsClient) GetVnetConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionSender sends the GetVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetConnectionResponder handles the response to the GetVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGateway gets an app's Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary".
func (client AppsClient) GetVnetConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionGateway")
	}

	req, err := client.GetVnetConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewayPreparer prepares the GetVnetConnectionGateway request.
func (client AppsClient) GetVnetConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionGatewaySender sends the GetVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetConnectionGatewayResponder handles the response to the GetVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGatewaySlot gets an app's Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary". slot is name of the deployment slot. If a slot is not specified,
// the API will get a gateway for the production slot's Virtual Network.
func (client AppsClient) GetVnetConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot")
	}

	req, err := client.GetVnetConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewaySlotPreparer prepares the GetVnetConnectionGatewaySlot request.
func (client AppsClient) GetVnetConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionGatewaySlotSender sends the GetVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetConnectionGatewaySlotResponder handles the response to the GetVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionSlot gets a virtual network the app (or deployment slot) is
// connected to by name.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the virtual network.
// slot is name of the deployment slot. If a slot is not specified, the API
// will get the named virtual network for the production slot.
func (client AppsClient) GetVnetConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionSlot")
	}

	req, err := client.GetVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionSlotPreparer prepares the GetVnetConnectionSlot request.
func (client AppsClient) GetVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionSlotSender sends the GetVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetVnetConnectionSlotResponder handles the response to the GetVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneable shows whether an app can be cloned to another resource group or
// subscription.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) IsCloneable(resourceGroupName string, name string) (result SiteCloneability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "IsCloneable")
	}

	req, err := client.IsCloneablePreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure responding to request")
	}

	return
}

// IsCloneablePreparer prepares the IsCloneable request.
func (client AppsClient) IsCloneablePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsCloneableSender sends the IsCloneable request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// IsCloneableResponder handles the response to the IsCloneable request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneableSlot shows whether an app can be cloned to another resource group
// or subscription.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. By
// default, this API returns information on the production slot.
func (client AppsClient) IsCloneableSlot(resourceGroupName string, name string, slot string) (result SiteCloneability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "IsCloneableSlot")
	}

	req, err := client.IsCloneableSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure responding to request")
	}

	return
}

// IsCloneableSlotPreparer prepares the IsCloneableSlot request.
func (client AppsClient) IsCloneableSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsCloneableSlotSender sends the IsCloneableSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// IsCloneableSlotResponder handles the response to the IsCloneableSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableSlotResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all apps for a subscription.
func (client AppsClient) List() (result AppCollection, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppsClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppsClient) ListResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client AppsClient) ListNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListApplicationSettings gets the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListApplicationSettings(resourceGroupName string, name string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListApplicationSettings")
	}

	req, err := client.ListApplicationSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsPreparer prepares the ListApplicationSettings request.
func (client AppsClient) ListApplicationSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListApplicationSettingsSender sends the ListApplicationSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListApplicationSettingsResponder handles the response to the ListApplicationSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListApplicationSettingsSlot gets the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the application settings for the
// production slot.
func (client AppsClient) ListApplicationSettingsSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListApplicationSettingsSlot")
	}

	req, err := client.ListApplicationSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsSlotPreparer prepares the ListApplicationSettingsSlot request.
func (client AppsClient) ListApplicationSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListApplicationSettingsSlotSender sends the ListApplicationSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListApplicationSettingsSlotResponder handles the response to the ListApplicationSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackups gets existing backups of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListBackups(resourceGroupName string, name string) (result BackupItemCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackups")
	}

	req, err := client.ListBackupsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure responding to request")
	}

	return
}

// ListBackupsPreparer prepares the ListBackups request.
func (client AppsClient) ListBackupsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupsSender sends the ListBackups request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBackupsResponder handles the response to the ListBackups request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListBackupsNextResults(lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.BackupItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure sending next results request")
	}

	result, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure responding to next results request")
	}

	return
}

// ListBackupsSlot gets existing backups of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get backups of the production slot.
func (client AppsClient) ListBackupsSlot(resourceGroupName string, name string, slot string) (result BackupItemCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupsSlot")
	}

	req, err := client.ListBackupsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupsSlotPreparer prepares the ListBackupsSlot request.
func (client AppsClient) ListBackupsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupsSlotSender sends the ListBackupsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBackupsSlotResponder handles the response to the ListBackupsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsSlotResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListBackupsSlotNextResults(lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.BackupItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListBackupStatusSecrets gets status of a web app backup that may be in
// progress, including secrets associated with the backup, such as the Azure
// Storage SAS URL. Also can be used to update the SAS URL for the backup if a
// new URL is passed in the request body.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app backupID is id of backup request is
// information on backup request
func (client AppsClient) ListBackupStatusSecrets(resourceGroupName string, name string, backupID string, request BackupRequest) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupStatusSecrets")
	}

	req, err := client.ListBackupStatusSecretsPreparer(resourceGroupName, name, backupID, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsPreparer prepares the ListBackupStatusSecrets request.
func (client AppsClient) ListBackupStatusSecretsPreparer(resourceGroupName string, name string, backupID string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupStatusSecretsSender sends the ListBackupStatusSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBackupStatusSecretsResponder handles the response to the ListBackupStatusSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupStatusSecretsSlot gets status of a web app backup that may be in
// progress, including secrets associated with the backup, such as the Azure
// Storage SAS URL. Also can be used to update the SAS URL for the backup if a
// new URL is passed in the request body.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app backupID is id of backup request is
// information on backup request slot is name of web app slot. If not specified
// then will default to production slot.
func (client AppsClient) ListBackupStatusSecretsSlot(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupStatusSecretsSlot")
	}

	req, err := client.ListBackupStatusSecretsSlotPreparer(resourceGroupName, name, backupID, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsSlotPreparer prepares the ListBackupStatusSecretsSlot request.
func (client AppsClient) ListBackupStatusSecretsSlotPreparer(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupStatusSecretsSlotSender sends the ListBackupStatusSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBackupStatusSecretsSlotResponder handles the response to the ListBackupStatusSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup gets all web, mobile, and API apps in the specified
// resource group.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. includeSlots is specify <strong>true</strong> to include deployment
// slots in results. The default is false, which only gives you the production
// slot of all apps.
func (client AppsClient) ListByResourceGroup(resourceGroupName string, includeSlots *bool) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListByResourceGroup")
	}

	req, err := client.ListByResourceGroupPreparer(resourceGroupName, includeSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppsClient) ListByResourceGroupPreparer(resourceGroupName string, includeSlots *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if includeSlots != nil {
		queryParameters["includeSlots"] = autorest.Encode("query", *includeSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppsClient) ListByResourceGroupResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppsClient) ListByResourceGroupNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListConfigurations list the configurations of an app
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListConfigurations(resourceGroupName string, name string) (result SiteConfigResourceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurations")
	}

	req, err := client.ListConfigurationsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsPreparer prepares the ListConfigurations request.
func (client AppsClient) ListConfigurationsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationsSender sends the ListConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConfigurationsResponder handles the response to the ListConfigurations request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListConfigurationsNextResults(lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.SiteConfigResourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure sending next results request")
	}

	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure responding to next results request")
	}

	return
}

// ListConfigurationSnapshotInfo gets a list of web app configuration snapshots
// identifiers. Each element of the list contains a timestamp and the ID of the
// snapshot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListConfigurationSnapshotInfo(resourceGroupName string, name string) (result ListSiteConfigurationSnapshotInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationSnapshotInfo")
	}

	req, err := client.ListConfigurationSnapshotInfoPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationSnapshotInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoPreparer prepares the ListConfigurationSnapshotInfo request.
func (client AppsClient) ListConfigurationSnapshotInfoPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationSnapshotInfoSender sends the ListConfigurationSnapshotInfo request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConfigurationSnapshotInfoResponder handles the response to the ListConfigurationSnapshotInfo request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoResponder(resp *http.Response) (result ListSiteConfigurationSnapshotInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationSnapshotInfoSlot gets a list of web app configuration
// snapshots identifiers. Each element of the list contains a timestamp and the
// ID of the snapshot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will return configuration for the production
// slot.
func (client AppsClient) ListConfigurationSnapshotInfoSlot(resourceGroupName string, name string, slot string) (result ListSiteConfigurationSnapshotInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot")
	}

	req, err := client.ListConfigurationSnapshotInfoSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationSnapshotInfoSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoSlotPreparer prepares the ListConfigurationSnapshotInfoSlot request.
func (client AppsClient) ListConfigurationSnapshotInfoSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationSnapshotInfoSlotSender sends the ListConfigurationSnapshotInfoSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConfigurationSnapshotInfoSlotResponder handles the response to the ListConfigurationSnapshotInfoSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoSlotResponder(resp *http.Response) (result ListSiteConfigurationSnapshotInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsSlot list the configurations of an app
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will return configuration for the production
// slot.
func (client AppsClient) ListConfigurationsSlot(resourceGroupName string, name string, slot string) (result SiteConfigResourceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationsSlot")
	}

	req, err := client.ListConfigurationsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsSlotPreparer prepares the ListConfigurationsSlot request.
func (client AppsClient) ListConfigurationsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationsSlotSender sends the ListConfigurationsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConfigurationsSlotResponder handles the response to the ListConfigurationsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsSlotResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListConfigurationsSlotNextResults(lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.SiteConfigResourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListConnectionStrings gets the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListConnectionStrings(resourceGroupName string, name string) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConnectionStrings")
	}

	req, err := client.ListConnectionStringsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsPreparer prepares the ListConnectionStrings request.
func (client AppsClient) ListConnectionStringsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConnectionStringsSender sends the ListConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConnectionStringsResponder handles the response to the ListConnectionStrings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConnectionStringsSlot gets the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the connection settings for the
// production slot.
func (client AppsClient) ListConnectionStringsSlot(resourceGroupName string, name string, slot string) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConnectionStringsSlot")
	}

	req, err := client.ListConnectionStringsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsSlotPreparer prepares the ListConnectionStringsSlot request.
func (client AppsClient) ListConnectionStringsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConnectionStringsSlotSender sends the ListConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListConnectionStringsSlotResponder handles the response to the ListConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeployments list deployments for an app, or a deployment slot, or for an
// instance of a scaled-out app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListDeployments(resourceGroupName string, name string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeployments")
	}

	req, err := client.ListDeploymentsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsPreparer prepares the ListDeployments request.
func (client AppsClient) ListDeploymentsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentsSender sends the ListDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListDeploymentsResponder handles the response to the ListDeployments request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDeploymentsNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure sending next results request")
	}

	result, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure responding to next results request")
	}

	return
}

// ListDeploymentsSlot list deployments for an app, or a deployment slot, or
// for an instance of a scaled-out app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API returns deployments for the production slot.
func (client AppsClient) ListDeploymentsSlot(resourceGroupName string, name string, slot string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeploymentsSlot")
	}

	req, err := client.ListDeploymentsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsSlotPreparer prepares the ListDeploymentsSlot request.
func (client AppsClient) ListDeploymentsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentsSlotSender sends the ListDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListDeploymentsSlotResponder handles the response to the ListDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDeploymentsSlotNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListDomainOwnershipIdentifiers lists ownership identifiers for domain
// associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListDomainOwnershipIdentifiers(resourceGroupName string, name string) (result IdentifierCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers")
	}

	req, err := client.ListDomainOwnershipIdentifiersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure sending request")
		return
	}

	result, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersPreparer prepares the ListDomainOwnershipIdentifiers request.
func (client AppsClient) ListDomainOwnershipIdentifiersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDomainOwnershipIdentifiersSender sends the ListDomainOwnershipIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListDomainOwnershipIdentifiersResponder handles the response to the ListDomainOwnershipIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDomainOwnershipIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDomainOwnershipIdentifiersNextResults(lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.IdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure sending next results request")
	}

	result, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure responding to next results request")
	}

	return
}

// ListDomainOwnershipIdentifiersSlot lists ownership identifiers for domain
// associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will delete the binding for the production
// slot.
func (client AppsClient) ListDomainOwnershipIdentifiersSlot(resourceGroupName string, name string, slot string) (result IdentifierCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot")
	}

	req, err := client.ListDomainOwnershipIdentifiersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersSlotPreparer prepares the ListDomainOwnershipIdentifiersSlot request.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDomainOwnershipIdentifiersSlotSender sends the ListDomainOwnershipIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListDomainOwnershipIdentifiersSlotResponder handles the response to the ListDomainOwnershipIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDomainOwnershipIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotNextResults(lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.IdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListHostNameBindings get hostname bindings for an app or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListHostNameBindings(resourceGroupName string, name string) (result HostNameBindingCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHostNameBindings")
	}

	req, err := client.ListHostNameBindingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsPreparer prepares the ListHostNameBindings request.
func (client AppsClient) ListHostNameBindingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHostNameBindingsSender sends the ListHostNameBindings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHostNameBindingsResponder handles the response to the ListHostNameBindings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindingsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListHostNameBindingsNextResults(lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.HostNameBindingCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure sending next results request")
	}

	result, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure responding to next results request")
	}

	return
}

// ListHostNameBindingsSlot get hostname bindings for an app or a deployment
// slot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API gets hostname bindings for the production
// slot.
func (client AppsClient) ListHostNameBindingsSlot(resourceGroupName string, name string, slot string) (result HostNameBindingCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHostNameBindingsSlot")
	}

	req, err := client.ListHostNameBindingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsSlotPreparer prepares the ListHostNameBindingsSlot request.
func (client AppsClient) ListHostNameBindingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHostNameBindingsSlotSender sends the ListHostNameBindingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHostNameBindingsSlotResponder handles the response to the ListHostNameBindingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsSlotResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindingsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListHostNameBindingsSlotNextResults(lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.HostNameBindingCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListHybridConnectionKeys gets the send key name and value for a Hybrid
// Connection.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection
func (client AppsClient) ListHybridConnectionKeys(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionKeys")
	}

	req, err := client.ListHybridConnectionKeysPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysPreparer prepares the ListHybridConnectionKeys request.
func (client AppsClient) ListHybridConnectionKeysPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionKeysSender sends the ListHybridConnectionKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHybridConnectionKeysResponder handles the response to the ListHybridConnectionKeys request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionKeysResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionKeysSlot gets the send key name and value for a Hybrid
// Connection.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection slot is the name of the slot for the web app.
func (client AppsClient) ListHybridConnectionKeysSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionKeysSlot")
	}

	req, err := client.ListHybridConnectionKeysSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysSlotPreparer prepares the ListHybridConnectionKeysSlot request.
func (client AppsClient) ListHybridConnectionKeysSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionKeysSlotSender sends the ListHybridConnectionKeysSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionKeysSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHybridConnectionKeysSlotResponder handles the response to the ListHybridConnectionKeysSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionKeysSlotResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnections retrieves all Service Bus Hybrid Connections used by
// this Web App.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app
func (client AppsClient) ListHybridConnections(resourceGroupName string, name string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnections")
	}

	req, err := client.ListHybridConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsPreparer prepares the ListHybridConnections request.
func (client AppsClient) ListHybridConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionsSender sends the ListHybridConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHybridConnectionsResponder handles the response to the ListHybridConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionsSlot retrieves all Service Bus Hybrid Connections used
// by this Web App.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app slot is the name of the slot for
// the web app.
func (client AppsClient) ListHybridConnectionsSlot(resourceGroupName string, name string, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionsSlot")
	}

	req, err := client.ListHybridConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsSlotPreparer prepares the ListHybridConnectionsSlot request.
func (client AppsClient) ListHybridConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionsSlotSender sends the ListHybridConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListHybridConnectionsSlotResponder handles the response to the ListHybridConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceDeployments list deployments for an app, or a deployment slot,
// or for an instance of a scaled-out app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. instanceID is the ID of a specific
// scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances"
func (client AppsClient) ListInstanceDeployments(resourceGroupName string, name string, instanceID string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceDeployments")
	}

	req, err := client.ListInstanceDeploymentsPreparer(resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", resp, "Failure responding to request")
	}

	return
}

// ListInstanceDeploymentsPreparer prepares the ListInstanceDeployments request.
func (client AppsClient) ListInstanceDeploymentsPreparer(resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceDeploymentsSender sends the ListInstanceDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListInstanceDeploymentsResponder handles the response to the ListInstanceDeployments request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceDeploymentsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceDeploymentsNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeployments", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceDeploymentsSlot list deployments for an app, or a deployment
// slot, or for an instance of a scaled-out app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API returns deployments for the production slot.
// instanceID is the ID of a specific scaled-out instance. This is the value of
// the name property in the JSON response from "GET
// api/sites/{siteName}/instances"
func (client AppsClient) ListInstanceDeploymentsSlot(resourceGroupName string, name string, slot string, instanceID string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceDeploymentsSlot")
	}

	req, err := client.ListInstanceDeploymentsSlotPreparer(resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceDeploymentsSlotPreparer prepares the ListInstanceDeploymentsSlot request.
func (client AppsClient) ListInstanceDeploymentsSlotPreparer(resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceDeploymentsSlotSender sends the ListInstanceDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListInstanceDeploymentsSlotResponder handles the response to the ListInstanceDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceDeploymentsSlotNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceDeploymentsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceIdentifiers gets all scale-out instances of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListInstanceIdentifiers(resourceGroupName string, name string) (result AppInstanceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceIdentifiers")
	}

	req, err := client.ListInstanceIdentifiersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersPreparer prepares the ListInstanceIdentifiers request.
func (client AppsClient) ListInstanceIdentifiersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceIdentifiersSender sends the ListInstanceIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListInstanceIdentifiersResponder handles the response to the ListInstanceIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceIdentifiersNextResults(lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.AppInstanceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceIdentifiersSlot gets all scale-out instances of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API gets the production slot instances.
func (client AppsClient) ListInstanceIdentifiersSlot(resourceGroupName string, name string, slot string) (result AppInstanceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceIdentifiersSlot")
	}

	req, err := client.ListInstanceIdentifiersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersSlotPreparer prepares the ListInstanceIdentifiersSlot request.
func (client AppsClient) ListInstanceIdentifiersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceIdentifiersSlotSender sends the ListInstanceIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListInstanceIdentifiersSlotResponder handles the response to the ListInstanceIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersSlotResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceIdentifiersSlotNextResults(lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.AppInstanceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListMetadata gets the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListMetadata(resourceGroupName string, name string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetadata")
	}

	req, err := client.ListMetadataPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure responding to request")
	}

	return
}

// ListMetadataPreparer prepares the ListMetadata request.
func (client AppsClient) ListMetadataPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetadataSender sends the ListMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetadataResponder handles the response to the ListMetadata request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetadataSlot gets the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the metadata for the production
// slot.
func (client AppsClient) ListMetadataSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetadataSlot")
	}

	req, err := client.ListMetadataSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetadataSlotPreparer prepares the ListMetadataSlot request.
func (client AppsClient) ListMetadataSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetadataSlotSender sends the ListMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetadataSlotResponder handles the response to the ListMetadataSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitions gets all metric definitions of an app (or deployment
// slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListMetricDefinitions(resourceGroupName string, name string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricDefinitions")
	}

	req, err := client.ListMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsPreparer prepares the ListMetricDefinitions request.
func (client AppsClient) ListMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionsSender sends the ListMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricDefinitionsResponder handles the response to the ListMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricDefinitionsSlot gets all metric definitions of an app (or
// deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get metric definitions of the production
// slot.
func (client AppsClient) ListMetricDefinitionsSlot(resourceGroupName string, name string, slot string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricDefinitionsSlot")
	}

	req, err := client.ListMetricDefinitionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsSlotPreparer prepares the ListMetricDefinitionsSlot request.
func (client AppsClient) ListMetricDefinitionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionsSlotSender sends the ListMetricDefinitionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricDefinitionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricDefinitionsSlotResponder handles the response to the ListMetricDefinitionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricDefinitionsSlotResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitionsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricDefinitionsSlotNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListMetrics gets performance metrics of an app (or deployment slot, if
// specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. details is specify "true" to include
// metric details in the response. It is "false" by default. filter is return
// only metrics specified in the filter (using OData syntax). For example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime
// eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and
// timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetrics")
	}

	req, err := client.ListMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppsClient) ListMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricsSlot gets performance metrics of an app (or deployment slot, if
// specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get metrics of the production slot.
// details is specify "true" to include metric details in the response. It is
// "false" by default. filter is return only metrics specified in the filter
// (using OData syntax). For example: $filter=(name.value eq 'Metric1' or
// name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
// eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListMetricsSlot(resourceGroupName string, name string, slot string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricsSlot")
	}

	req, err := client.ListMetricsSlotPreparer(resourceGroupName, name, slot, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetricsSlotPreparer prepares the ListMetricsSlot request.
func (client AppsClient) ListMetricsSlotPreparer(resourceGroupName string, name string, slot string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSlotSender sends the ListMetricsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListMetricsSlotResponder handles the response to the ListMetricsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricsSlotResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricsSlotNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListNetworkFeatures gets all network features used by the app (or deployment
// slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. view is the type of view. This can either
// be "summary" or "detailed".
func (client AppsClient) ListNetworkFeatures(resourceGroupName string, name string, view string) (result NetworkFeatures, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListNetworkFeatures")
	}

	req, err := client.ListNetworkFeaturesPreparer(resourceGroupName, name, view)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesPreparer prepares the ListNetworkFeatures request.
func (client AppsClient) ListNetworkFeaturesPreparer(resourceGroupName string, name string, view string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListNetworkFeaturesSender sends the ListNetworkFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListNetworkFeaturesResponder handles the response to the ListNetworkFeatures request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNetworkFeaturesSlot gets all network features used by the app (or
// deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. view is the type of view. This can either
// be "summary" or "detailed". slot is name of the deployment slot. If a slot
// is not specified, the API will get network features for the production slot.
func (client AppsClient) ListNetworkFeaturesSlot(resourceGroupName string, name string, view string, slot string) (result NetworkFeatures, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListNetworkFeaturesSlot")
	}

	req, err := client.ListNetworkFeaturesSlotPreparer(resourceGroupName, name, view, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesSlotPreparer prepares the ListNetworkFeaturesSlot request.
func (client AppsClient) ListNetworkFeaturesSlotPreparer(resourceGroupName string, name string, view string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListNetworkFeaturesSlotSender sends the ListNetworkFeaturesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListNetworkFeaturesSlotResponder handles the response to the ListNetworkFeaturesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesSlotResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCounters gets perfmon counters for web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app filter is return only usages/metrics
// specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(startTime eq '2014-01-01T00:00:00Z' and endTime eq
// '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCounters(resourceGroupName string, name string, filter string) (result PerfMonCounterCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPerfMonCounters")
	}

	req, err := client.ListPerfMonCountersPreparer(resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure sending request")
		return
	}

	result, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersPreparer prepares the ListPerfMonCounters request.
func (client AppsClient) ListPerfMonCountersPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPerfMonCountersSender sends the ListPerfMonCounters request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPerfMonCountersResponder handles the response to the ListPerfMonCounters request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCountersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPerfMonCountersNextResults(lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.PerfMonCounterCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure sending next results request")
	}

	result, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure responding to next results request")
	}

	return
}

// ListPerfMonCountersSlot gets perfmon counters for web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot. **** CURRENTLY UNUSED *****
// filter is return only usages/metrics specified in the filter. Filter
// conforms to odata syntax. Example: $filter=(startTime eq
// '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain
// eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCountersSlot(resourceGroupName string, name string, slot string, filter string) (result PerfMonCounterCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPerfMonCountersSlot")
	}

	req, err := client.ListPerfMonCountersSlotPreparer(resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersSlotPreparer prepares the ListPerfMonCountersSlot request.
func (client AppsClient) ListPerfMonCountersSlotPreparer(resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPerfMonCountersSlotSender sends the ListPerfMonCountersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPerfMonCountersSlotResponder handles the response to the ListPerfMonCountersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersSlotResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCountersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPerfMonCountersSlotNextResults(lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.PerfMonCounterCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListPremierAddOns gets the premier add-ons of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListPremierAddOns(resourceGroupName string, name string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPremierAddOns")
	}

	req, err := client.ListPremierAddOnsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsPreparer prepares the ListPremierAddOns request.
func (client AppsClient) ListPremierAddOnsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPremierAddOnsSender sends the ListPremierAddOns request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPremierAddOnsResponder handles the response to the ListPremierAddOns request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPremierAddOnsSlot gets the premier add-ons of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the premier add-ons for the
// production slot.
func (client AppsClient) ListPremierAddOnsSlot(resourceGroupName string, name string, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPremierAddOnsSlot")
	}

	req, err := client.ListPremierAddOnsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsSlotPreparer prepares the ListPremierAddOnsSlot request.
func (client AppsClient) ListPremierAddOnsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPremierAddOnsSlotSender sends the ListPremierAddOnsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPremierAddOnsSlotResponder handles the response to the ListPremierAddOnsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingCredentials gets the Git/FTP publishing credentials of an app.
// This method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListPublishingCredentials(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan User, <-chan error) {
	resultChan := make(chan User, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingCredentials")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result User
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ListPublishingCredentialsPreparer(resourceGroupName, name, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", nil, "Failure preparing request")
			return
		}

		resp, err := client.ListPublishingCredentialsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", resp, "Failure sending request")
			return
		}

		result, err = client.ListPublishingCredentialsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ListPublishingCredentialsPreparer prepares the ListPublishingCredentials request.
func (client AppsClient) ListPublishingCredentialsPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListPublishingCredentialsSender sends the ListPublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingCredentialsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListPublishingCredentialsResponder handles the response to the ListPublishingCredentials request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingCredentialsResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingCredentialsSlot gets the Git/FTP publishing credentials of an
// app. This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling and
// any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get the publishing credentials for the
// production slot.
func (client AppsClient) ListPublishingCredentialsSlot(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan User, <-chan error) {
	resultChan := make(chan User, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingCredentialsSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result User
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ListPublishingCredentialsSlotPreparer(resourceGroupName, name, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.ListPublishingCredentialsSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", resp, "Failure sending request")
			return
		}

		result, err = client.ListPublishingCredentialsSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ListPublishingCredentialsSlotPreparer prepares the ListPublishingCredentialsSlot request.
func (client AppsClient) ListPublishingCredentialsSlotPreparer(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListPublishingCredentialsSlotSender sends the ListPublishingCredentialsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingCredentialsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListPublishingCredentialsSlotResponder handles the response to the ListPublishingCredentialsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingCredentialsSlotResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingProfileXMLWithSecrets gets the publishing profile for an app
// (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. publishingProfileOptions is specifies
// publishingProfileOptions for publishing profile. For example, use {"format":
// "FileZilla3"} to get a FileZilla publishing profile.
func (client AppsClient) ListPublishingProfileXMLWithSecrets(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions) (result ReadCloser, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets")
	}

	req, err := client.ListPublishingProfileXMLWithSecretsPreparer(resourceGroupName, name, publishingProfileOptions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublishingProfileXMLWithSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublishingProfileXMLWithSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", resp, "Failure responding to request")
	}

	return
}

// ListPublishingProfileXMLWithSecretsPreparer prepares the ListPublishingProfileXMLWithSecrets request.
func (client AppsClient) ListPublishingProfileXMLWithSecretsPreparer(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml", pathParameters),
		autorest.WithJSON(publishingProfileOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublishingProfileXMLWithSecretsSender sends the ListPublishingProfileXMLWithSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPublishingProfileXMLWithSecretsResponder handles the response to the ListPublishingProfileXMLWithSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingProfileXMLWithSecretsResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingProfileXMLWithSecretsSlot gets the publishing profile for an
// app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. publishingProfileOptions is specifies
// publishingProfileOptions for publishing profile. For example, use {"format":
// "FileZilla3"} to get a FileZilla publishing profile. slot is name of the
// deployment slot. If a slot is not specified, the API will get the publishing
// profile for the production slot.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlot(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, slot string) (result ReadCloser, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot")
	}

	req, err := client.ListPublishingProfileXMLWithSecretsSlotPreparer(resourceGroupName, name, publishingProfileOptions, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublishingProfileXMLWithSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublishingProfileXMLWithSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListPublishingProfileXMLWithSecretsSlotPreparer prepares the ListPublishingProfileXMLWithSecretsSlot request.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotPreparer(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml", pathParameters),
		autorest.WithJSON(publishingProfileOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublishingProfileXMLWithSecretsSlotSender sends the ListPublishingProfileXMLWithSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListPublishingProfileXMLWithSecretsSlotResponder handles the response to the ListPublishingProfileXMLWithSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRelayServiceConnections gets hybrid connections configured for an app
// (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListRelayServiceConnections(resourceGroupName string, name string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListRelayServiceConnections")
	}

	req, err := client.ListRelayServiceConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRelayServiceConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListRelayServiceConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", resp, "Failure responding to request")
	}

	return
}

// ListRelayServiceConnectionsPreparer prepares the ListRelayServiceConnections request.
func (client AppsClient) ListRelayServiceConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRelayServiceConnectionsSender sends the ListRelayServiceConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListRelayServiceConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRelayServiceConnectionsResponder handles the response to the ListRelayServiceConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListRelayServiceConnectionsResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRelayServiceConnectionsSlot gets hybrid connections configured for an
// app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get hybrid connections for the
// production slot.
func (client AppsClient) ListRelayServiceConnectionsSlot(resourceGroupName string, name string, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot")
	}

	req, err := client.ListRelayServiceConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRelayServiceConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListRelayServiceConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListRelayServiceConnectionsSlotPreparer prepares the ListRelayServiceConnectionsSlot request.
func (client AppsClient) ListRelayServiceConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRelayServiceConnectionsSlotSender sends the ListRelayServiceConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListRelayServiceConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListRelayServiceConnectionsSlotResponder handles the response to the ListRelayServiceConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListRelayServiceConnectionsSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePushSettings gets the Push settings associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app
func (client AppsClient) ListSitePushSettings(resourceGroupName string, name string) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSitePushSettings")
	}

	req, err := client.ListSitePushSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePushSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePushSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", resp, "Failure responding to request")
	}

	return
}

// ListSitePushSettingsPreparer prepares the ListSitePushSettings request.
func (client AppsClient) ListSitePushSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePushSettingsSender sends the ListSitePushSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSitePushSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePushSettingsResponder handles the response to the ListSitePushSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSitePushSettingsResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePushSettingsSlot gets the Push settings associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot.
func (client AppsClient) ListSitePushSettingsSlot(resourceGroupName string, name string, slot string) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSitePushSettingsSlot")
	}

	req, err := client.ListSitePushSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePushSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePushSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSitePushSettingsSlotPreparer prepares the ListSitePushSettingsSlot request.
func (client AppsClient) ListSitePushSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePushSettingsSlotSender sends the ListSitePushSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSitePushSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSitePushSettingsSlotResponder handles the response to the ListSitePushSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSitePushSettingsSlotResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotConfigurationNames gets the names of app settings and connection
// strings that stick to the slot (not swapped).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListSlotConfigurationNames(resourceGroupName string, name string) (result SlotConfigNamesResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotConfigurationNames")
	}

	req, err := client.ListSlotConfigurationNamesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotConfigurationNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotConfigurationNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", resp, "Failure responding to request")
	}

	return
}

// ListSlotConfigurationNamesPreparer prepares the ListSlotConfigurationNames request.
func (client AppsClient) ListSlotConfigurationNamesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotConfigurationNamesSender sends the ListSlotConfigurationNames request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotConfigurationNamesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSlotConfigurationNamesResponder handles the response to the ListSlotConfigurationNames request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotConfigurationNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesFromProduction get the difference in configuration
// settings between two web app slots.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example.
func (client AppsClient) ListSlotDifferencesFromProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SlotDifferenceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotDifferencesFromProduction")
	}

	req, err := client.ListSlotDifferencesFromProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure responding to request")
	}

	return
}

// ListSlotDifferencesFromProductionPreparer prepares the ListSlotDifferencesFromProduction request.
func (client AppsClient) ListSlotDifferencesFromProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotDifferencesFromProductionSender sends the ListSlotDifferencesFromProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotDifferencesFromProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSlotDifferencesFromProductionResponder handles the response to the ListSlotDifferencesFromProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotDifferencesFromProductionResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesFromProductionNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotDifferencesFromProductionNextResults(lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.SlotDifferenceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure responding to next results request")
	}

	return
}

// ListSlotDifferencesSlot get the difference in configuration settings between
// two web app slots.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example. slot is name of the source slot.
// If a slot is not specified, the production slot is used as the source slot.
func (client AppsClient) ListSlotDifferencesSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SlotDifferenceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotDifferencesSlot")
	}

	req, err := client.ListSlotDifferencesSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSlotDifferencesSlotPreparer prepares the ListSlotDifferencesSlot request.
func (client AppsClient) ListSlotDifferencesSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotDifferencesSlotSender sends the ListSlotDifferencesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotDifferencesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSlotDifferencesSlotResponder handles the response to the ListSlotDifferencesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotDifferencesSlotResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotDifferencesSlotNextResults(lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.SlotDifferenceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListSlots gets an app's deployment slots.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListSlots(resourceGroupName string, name string) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlots")
	}

	req, err := client.ListSlotsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure responding to request")
	}

	return
}

// ListSlotsPreparer prepares the ListSlots request.
func (client AppsClient) ListSlotsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotsSender sends the ListSlots request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSlotsResponder handles the response to the ListSlots request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotsNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure responding to next results request")
	}

	return
}

// ListSnapshots returns all Snapshots to the user.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is website Name
func (client AppsClient) ListSnapshots(resourceGroupName string, name string) (result SnapshotCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSnapshots")
	}

	req, err := client.ListSnapshotsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure sending request")
		return
	}

	result, err = client.ListSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure responding to request")
	}

	return
}

// ListSnapshotsPreparer prepares the ListSnapshots request.
func (client AppsClient) ListSnapshotsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSnapshotsSender sends the ListSnapshots request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSnapshotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSnapshotsResponder handles the response to the ListSnapshots request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSnapshotsResponder(resp *http.Response) (result SnapshotCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSnapshotsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSnapshotsNextResults(lastResults SnapshotCollection) (result SnapshotCollection, err error) {
	req, err := lastResults.SnapshotCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure sending next results request")
	}

	result, err = client.ListSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure responding to next results request")
	}

	return
}

// ListSnapshotsSlot returns all Snapshots to the user.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is website Name slot is website Slot
func (client AppsClient) ListSnapshotsSlot(resourceGroupName string, name string, slot string) (result SnapshotCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSnapshotsSlot")
	}

	req, err := client.ListSnapshotsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSnapshotsSlotPreparer prepares the ListSnapshotsSlot request.
func (client AppsClient) ListSnapshotsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSnapshotsSlotSender sends the ListSnapshotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSnapshotsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSnapshotsSlotResponder handles the response to the ListSnapshotsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSnapshotsSlotResponder(resp *http.Response) (result SnapshotCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSnapshotsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSnapshotsSlotNextResults(lastResults SnapshotCollection) (result SnapshotCollection, err error) {
	req, err := lastResults.SnapshotCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListUsages gets the quota usage information of an app (or deployment slot,
// if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. filter is return only information
// specified in the filter (using OData syntax). For example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime
// eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and
// timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListUsages(resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListUsages")
	}

	req, err := client.ListUsagesPreparer(resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client AppsClient) ListUsagesPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client AppsClient) ListUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsagesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListUsagesNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure sending next results request")
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure responding to next results request")
	}

	return
}

// ListUsagesSlot gets the quota usage information of an app (or deployment
// slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get quota information of the production
// slot. filter is return only information specified in the filter (using OData
// syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
// 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq
// '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListUsagesSlot(resourceGroupName string, name string, slot string, filter string) (result CsmUsageQuotaCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListUsagesSlot")
	}

	req, err := client.ListUsagesSlotPreparer(resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure responding to request")
	}

	return
}

// ListUsagesSlotPreparer prepares the ListUsagesSlot request.
func (client AppsClient) ListUsagesSlotPreparer(resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSlotSender sends the ListUsagesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListUsagesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListUsagesSlotResponder handles the response to the ListUsagesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListUsagesSlotResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsagesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListUsagesSlotNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListVnetConnections gets the virtual networks the app (or deployment slot)
// is connected to.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ListVnetConnections(resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListVnetConnections")
	}

	req, err := client.ListVnetConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", resp, "Failure responding to request")
	}

	return
}

// ListVnetConnectionsPreparer prepares the ListVnetConnections request.
func (client AppsClient) ListVnetConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVnetConnectionsSender sends the ListVnetConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListVnetConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListVnetConnectionsResponder handles the response to the ListVnetConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListVnetConnectionsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListVnetConnectionsSlot gets the virtual networks the app (or deployment
// slot) is connected to.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will get virtual network connections for the
// production slot.
func (client AppsClient) ListVnetConnectionsSlot(resourceGroupName string, name string, slot string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListVnetConnectionsSlot")
	}

	req, err := client.ListVnetConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListVnetConnectionsSlotPreparer prepares the ListVnetConnectionsSlot request.
func (client AppsClient) ListVnetConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVnetConnectionsSlotSender sends the ListVnetConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListVnetConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListVnetConnectionsSlotResponder handles the response to the ListVnetConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListVnetConnectionsSlotResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateMySQL migrates a local (in-app) MySql database to a remote MySql
// database. This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app migrationRequestEnvelope is mySql migration
// options
func (client AppsClient) MigrateMySQL(resourceGroupName string, name string, migrationRequestEnvelope MigrateMySQLRequest, cancel <-chan struct{}) (<-chan Operation, <-chan error) {
	resultChan := make(chan Operation, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "MigrateMySQL")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Operation
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.MigrateMySQLPreparer(resourceGroupName, name, migrationRequestEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateMySQL", nil, "Failure preparing request")
			return
		}

		resp, err := client.MigrateMySQLSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateMySQL", resp, "Failure sending request")
			return
		}

		result, err = client.MigrateMySQLResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateMySQL", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// MigrateMySQLPreparer prepares the MigrateMySQL request.
func (client AppsClient) MigrateMySQLPreparer(resourceGroupName string, name string, migrationRequestEnvelope MigrateMySQLRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql", pathParameters),
		autorest.WithJSON(migrationRequestEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// MigrateMySQLSender sends the MigrateMySQL request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) MigrateMySQLSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// MigrateMySQLResponder handles the response to the MigrateMySQL request. The method always
// closes the http.Response Body.
func (client AppsClient) MigrateMySQLResponder(resp *http.Response) (result Operation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MigrateStorage restores a web app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// subscriptionName is azure subscription resourceGroupName is name of the
// resource group to which the resource belongs. name is name of web app
// migrationOptions is migration migrationOptions
func (client AppsClient) MigrateStorage(subscriptionName string, resourceGroupName string, name string, migrationOptions StorageMigrationOptions, cancel <-chan struct{}) (<-chan StorageMigrationResponse, <-chan error) {
	resultChan := make(chan StorageMigrationResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "MigrateStorage")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result StorageMigrationResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.MigrateStoragePreparer(subscriptionName, resourceGroupName, name, migrationOptions, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateStorage", nil, "Failure preparing request")
			return
		}

		resp, err := client.MigrateStorageSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateStorage", resp, "Failure sending request")
			return
		}

		result, err = client.MigrateStorageResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "MigrateStorage", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// MigrateStoragePreparer prepares the MigrateStorage request.
func (client AppsClient) MigrateStoragePreparer(subscriptionName string, resourceGroupName string, name string, migrationOptions StorageMigrationOptions, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":      APIVersion,
		"subscriptionName": autorest.Encode("query", subscriptionName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate", pathParameters),
		autorest.WithJSON(migrationOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// MigrateStorageSender sends the MigrateStorage request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) MigrateStorageSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// MigrateStorageResponder handles the response to the MigrateStorage request. The method always
// closes the http.Response Body.
func (client AppsClient) MigrateStorageResponder(resp *http.Response) (result StorageMigrationResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Recover recovers a deleted web app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app recoveryEntity is snapshot data used for
// web app recovery. Snapshot information can be obtained by calling
// GetDeletedSites or GetSiteSnapshots API.
func (client AppsClient) Recover(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, cancel <-chan struct{}) (<-chan RecoverResponse, <-chan error) {
	resultChan := make(chan RecoverResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "Recover")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result RecoverResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.RecoverPreparer(resourceGroupName, name, recoveryEntity, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Recover", nil, "Failure preparing request")
			return
		}

		resp, err := client.RecoverSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Recover", resp, "Failure sending request")
			return
		}

		result, err = client.RecoverResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Recover", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// RecoverPreparer prepares the Recover request.
func (client AppsClient) RecoverPreparer(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RecoverSender sends the Recover request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RecoverSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RecoverResponder handles the response to the Recover request. The method always
// closes the http.Response Body.
func (client AppsClient) RecoverResponder(resp *http.Response) (result RecoverResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RecoverSiteConfigurationSnapshot reverts the configuration of an app to a
// previous snapshot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. snapshotID is the ID of the snapshot to
// read.
func (client AppsClient) RecoverSiteConfigurationSnapshot(resourceGroupName string, name string, snapshotID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshot")
	}

	req, err := client.RecoverSiteConfigurationSnapshotPreparer(resourceGroupName, name, snapshotID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RecoverSiteConfigurationSnapshotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshot", resp, "Failure sending request")
		return
	}

	result, err = client.RecoverSiteConfigurationSnapshotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshot", resp, "Failure responding to request")
	}

	return
}

// RecoverSiteConfigurationSnapshotPreparer prepares the RecoverSiteConfigurationSnapshot request.
func (client AppsClient) RecoverSiteConfigurationSnapshotPreparer(resourceGroupName string, name string, snapshotID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RecoverSiteConfigurationSnapshotSender sends the RecoverSiteConfigurationSnapshot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RecoverSiteConfigurationSnapshotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RecoverSiteConfigurationSnapshotResponder handles the response to the RecoverSiteConfigurationSnapshot request. The method always
// closes the http.Response Body.
func (client AppsClient) RecoverSiteConfigurationSnapshotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RecoverSiteConfigurationSnapshotSlot reverts the configuration of an app to
// a previous snapshot.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. snapshotID is the ID of the snapshot to
// read. slot is name of the deployment slot. If a slot is not specified, the
// API will return configuration for the production slot.
func (client AppsClient) RecoverSiteConfigurationSnapshotSlot(resourceGroupName string, name string, snapshotID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshotSlot")
	}

	req, err := client.RecoverSiteConfigurationSnapshotSlotPreparer(resourceGroupName, name, snapshotID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshotSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RecoverSiteConfigurationSnapshotSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshotSlot", resp, "Failure sending request")
		return
	}

	result, err = client.RecoverSiteConfigurationSnapshotSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSiteConfigurationSnapshotSlot", resp, "Failure responding to request")
	}

	return
}

// RecoverSiteConfigurationSnapshotSlotPreparer prepares the RecoverSiteConfigurationSnapshotSlot request.
func (client AppsClient) RecoverSiteConfigurationSnapshotSlotPreparer(resourceGroupName string, name string, snapshotID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}/recover", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RecoverSiteConfigurationSnapshotSlotSender sends the RecoverSiteConfigurationSnapshotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RecoverSiteConfigurationSnapshotSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RecoverSiteConfigurationSnapshotSlotResponder handles the response to the RecoverSiteConfigurationSnapshotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) RecoverSiteConfigurationSnapshotSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RecoverSlot recovers a deleted web app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app recoveryEntity is snapshot data used for
// web app recovery. Snapshot information can be obtained by calling
// GetDeletedSites or GetSiteSnapshots API. slot is name of web app slot. If
// not specified then will default to production slot.
func (client AppsClient) RecoverSlot(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string, cancel <-chan struct{}) (<-chan RecoverResponse, <-chan error) {
	resultChan := make(chan RecoverResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "RecoverSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result RecoverResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.RecoverSlotPreparer(resourceGroupName, name, recoveryEntity, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.RecoverSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSlot", resp, "Failure sending request")
			return
		}

		result, err = client.RecoverSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RecoverSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// RecoverSlotPreparer prepares the RecoverSlot request.
func (client AppsClient) RecoverSlotPreparer(resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RecoverSlotSender sends the RecoverSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RecoverSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RecoverSlotResponder handles the response to the RecoverSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) RecoverSlotResponder(resp *http.Response) (result RecoverResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResetProductionSlotConfig resets the configuration settings of the current
// slot if they were previously modified by calling the API with POST.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) ResetProductionSlotConfig(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ResetProductionSlotConfig")
	}

	req, err := client.ResetProductionSlotConfigPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetProductionSlotConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetProductionSlotConfigSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetProductionSlotConfig", resp, "Failure sending request")
		return
	}

	result, err = client.ResetProductionSlotConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetProductionSlotConfig", resp, "Failure responding to request")
	}

	return
}

// ResetProductionSlotConfigPreparer prepares the ResetProductionSlotConfig request.
func (client AppsClient) ResetProductionSlotConfigPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ResetProductionSlotConfigSender sends the ResetProductionSlotConfig request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ResetProductionSlotConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ResetProductionSlotConfigResponder handles the response to the ResetProductionSlotConfig request. The method always
// closes the http.Response Body.
func (client AppsClient) ResetProductionSlotConfigResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ResetSlotConfigurationSlot resets the configuration settings of the current
// slot if they were previously modified by calling the API with POST.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API resets configuration settings for the
// production slot.
func (client AppsClient) ResetSlotConfigurationSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ResetSlotConfigurationSlot")
	}

	req, err := client.ResetSlotConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetSlotConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetSlotConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetSlotConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ResetSlotConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ResetSlotConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// ResetSlotConfigurationSlotPreparer prepares the ResetSlotConfigurationSlot request.
func (client AppsClient) ResetSlotConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ResetSlotConfigurationSlotSender sends the ResetSlotConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ResetSlotConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ResetSlotConfigurationSlotResponder handles the response to the ResetSlotConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ResetSlotConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Restart restarts an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. softRestart is specify true to apply the
// configuration settings and restarts the app only if necessary. By default,
// the API always restarts and reprovisions the app. synchronous is specify
// true to block until the app is restarted. By default, it is set to false,
// and the API responds immediately (asynchronous).
func (client AppsClient) Restart(resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Restart")
	}

	req, err := client.RestartPreparer(resourceGroupName, name, softRestart, synchronous)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Restart", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Restart", resp, "Failure sending request")
		return
	}

	result, err = client.RestartResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Restart", resp, "Failure responding to request")
	}

	return
}

// RestartPreparer prepares the Restart request.
func (client AppsClient) RestartPreparer(resourceGroupName string, name string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RestartSender sends the Restart request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RestartSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RestartResponder handles the response to the Restart request. The method always
// closes the http.Response Body.
func (client AppsClient) RestartResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RestartSlot restarts an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will restart the production slot. softRestart
// is specify true to apply the configuration settings and restarts the app
// only if necessary. By default, the API always restarts and reprovisions the
// app. synchronous is specify true to block until the app is restarted. By
// default, it is set to false, and the API responds immediately
// (asynchronous).
func (client AppsClient) RestartSlot(resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "RestartSlot")
	}

	req, err := client.RestartSlotPreparer(resourceGroupName, name, slot, softRestart, synchronous)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RestartSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RestartSlot", resp, "Failure sending request")
		return
	}

	result, err = client.RestartSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "RestartSlot", resp, "Failure responding to request")
	}

	return
}

// RestartSlotPreparer prepares the RestartSlot request.
func (client AppsClient) RestartSlotPreparer(resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RestartSlotSender sends the RestartSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RestartSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// RestartSlotResponder handles the response to the RestartSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) RestartSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Restore restores a specific backup to another app (or deployment slot, if
// specified). This method may poll for completion. Polling can be canceled by
// passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup. request is
// information on restore request
func (client AppsClient) Restore(resourceGroupName string, name string, backupID string, request RestoreRequest, cancel <-chan struct{}) (<-chan RestoreResponse, <-chan error) {
	resultChan := make(chan RestoreResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "Restore")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result RestoreResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.RestorePreparer(resourceGroupName, name, backupID, request, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Restore", nil, "Failure preparing request")
			return
		}

		resp, err := client.RestoreSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Restore", resp, "Failure sending request")
			return
		}

		result, err = client.RestoreResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "Restore", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// RestorePreparer prepares the Restore request.
func (client AppsClient) RestorePreparer(resourceGroupName string, name string, backupID string, request RestoreRequest, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RestoreSender sends the Restore request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RestoreSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RestoreResponder handles the response to the Restore request. The method always
// closes the http.Response Body.
func (client AppsClient) RestoreResponder(resp *http.Response) (result RestoreResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestoreSlot restores a specific backup to another app (or deployment slot,
// if specified). This method may poll for completion. Polling can be canceled
// by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. backupID is iD of the backup. request is
// information on restore request slot is name of the deployment slot. If a
// slot is not specified, the API will restore a backup of the production slot.
func (client AppsClient) RestoreSlot(resourceGroupName string, name string, backupID string, request RestoreRequest, slot string, cancel <-chan struct{}) (<-chan RestoreResponse, <-chan error) {
	resultChan := make(chan RestoreResponse, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "RestoreSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result RestoreResponse
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.RestoreSlotPreparer(resourceGroupName, name, backupID, request, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RestoreSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.RestoreSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RestoreSlot", resp, "Failure sending request")
			return
		}

		result, err = client.RestoreSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "RestoreSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// RestoreSlotPreparer prepares the RestoreSlot request.
func (client AppsClient) RestoreSlotPreparer(resourceGroupName string, name string, backupID string, request RestoreRequest, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RestoreSlotSender sends the RestoreSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) RestoreSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RestoreSlotResponder handles the response to the RestoreSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) RestoreSlotResponder(resp *http.Response) (result RestoreResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Start starts an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) Start(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Start")
	}

	req, err := client.StartPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Start", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Start", resp, "Failure sending request")
		return
	}

	result, err = client.StartResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Start", resp, "Failure responding to request")
	}

	return
}

// StartPreparer prepares the Start request.
func (client AppsClient) StartPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartSender sends the Start request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StartSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartResponder handles the response to the Start request. The method always
// closes the http.Response Body.
func (client AppsClient) StartResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StartSlot starts an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will start the production slot.
func (client AppsClient) StartSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StartSlot")
	}

	req, err := client.StartSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StartSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartSlot", resp, "Failure responding to request")
	}

	return
}

// StartSlotPreparer prepares the StartSlot request.
func (client AppsClient) StartSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartSlotSender sends the StartSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StartSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartSlotResponder handles the response to the StartSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) StartSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StartWebSiteNetworkTrace start capturing network packets for the site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app. durationInSeconds is the duration
// to keep capturing in seconds. maxFrameLength is the maximum frame length in
// bytes (Optional). sasURL is the Blob URL to store capture file.
func (client AppsClient) StartWebSiteNetworkTrace(resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StartWebSiteNetworkTrace")
	}

	req, err := client.StartWebSiteNetworkTracePreparer(resourceGroupName, name, durationInSeconds, maxFrameLength, sasURL)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTrace", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartWebSiteNetworkTraceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTrace", resp, "Failure sending request")
		return
	}

	result, err = client.StartWebSiteNetworkTraceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTrace", resp, "Failure responding to request")
	}

	return
}

// StartWebSiteNetworkTracePreparer prepares the StartWebSiteNetworkTrace request.
func (client AppsClient) StartWebSiteNetworkTracePreparer(resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if durationInSeconds != nil {
		queryParameters["durationInSeconds"] = autorest.Encode("query", *durationInSeconds)
	}
	if maxFrameLength != nil {
		queryParameters["maxFrameLength"] = autorest.Encode("query", *maxFrameLength)
	}
	if len(sasURL) > 0 {
		queryParameters["sasUrl"] = autorest.Encode("query", sasURL)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartWebSiteNetworkTraceSender sends the StartWebSiteNetworkTrace request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StartWebSiteNetworkTraceSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartWebSiteNetworkTraceResponder handles the response to the StartWebSiteNetworkTrace request. The method always
// closes the http.Response Body.
func (client AppsClient) StartWebSiteNetworkTraceResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StartWebSiteNetworkTraceSlot start capturing network packets for the site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app. slot is the name of the slot for
// this web app. durationInSeconds is the duration to keep capturing in
// seconds. maxFrameLength is the maximum frame length in bytes (Optional).
// sasURL is the Blob URL to store capture file.
func (client AppsClient) StartWebSiteNetworkTraceSlot(resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StartWebSiteNetworkTraceSlot")
	}

	req, err := client.StartWebSiteNetworkTraceSlotPreparer(resourceGroupName, name, slot, durationInSeconds, maxFrameLength, sasURL)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTraceSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartWebSiteNetworkTraceSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTraceSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StartWebSiteNetworkTraceSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StartWebSiteNetworkTraceSlot", resp, "Failure responding to request")
	}

	return
}

// StartWebSiteNetworkTraceSlotPreparer prepares the StartWebSiteNetworkTraceSlot request.
func (client AppsClient) StartWebSiteNetworkTraceSlotPreparer(resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if durationInSeconds != nil {
		queryParameters["durationInSeconds"] = autorest.Encode("query", *durationInSeconds)
	}
	if maxFrameLength != nil {
		queryParameters["maxFrameLength"] = autorest.Encode("query", *maxFrameLength)
	}
	if len(sasURL) > 0 {
		queryParameters["sasUrl"] = autorest.Encode("query", sasURL)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StartWebSiteNetworkTraceSlotSender sends the StartWebSiteNetworkTraceSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StartWebSiteNetworkTraceSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StartWebSiteNetworkTraceSlotResponder handles the response to the StartWebSiteNetworkTraceSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) StartWebSiteNetworkTraceSlotResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Stop stops an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) Stop(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Stop")
	}

	req, err := client.StopPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Stop", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Stop", resp, "Failure sending request")
		return
	}

	result, err = client.StopResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Stop", resp, "Failure responding to request")
	}

	return
}

// StopPreparer prepares the Stop request.
func (client AppsClient) StopPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopSender sends the Stop request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StopSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopResponder handles the response to the Stop request. The method always
// closes the http.Response Body.
func (client AppsClient) StopResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StopSlot stops an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will stop the production slot.
func (client AppsClient) StopSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StopSlot")
	}

	req, err := client.StopSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StopSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopSlot", resp, "Failure responding to request")
	}

	return
}

// StopSlotPreparer prepares the StopSlot request.
func (client AppsClient) StopSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopSlotSender sends the StopSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StopSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopSlotResponder handles the response to the StopSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) StopSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// StopWebSiteNetworkTrace stop ongoing capturing network packets for the site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app.
func (client AppsClient) StopWebSiteNetworkTrace(resourceGroupName string, name string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StopWebSiteNetworkTrace")
	}

	req, err := client.StopWebSiteNetworkTracePreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTrace", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopWebSiteNetworkTraceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTrace", resp, "Failure sending request")
		return
	}

	result, err = client.StopWebSiteNetworkTraceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTrace", resp, "Failure responding to request")
	}

	return
}

// StopWebSiteNetworkTracePreparer prepares the StopWebSiteNetworkTrace request.
func (client AppsClient) StopWebSiteNetworkTracePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopWebSiteNetworkTraceSender sends the StopWebSiteNetworkTrace request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StopWebSiteNetworkTraceSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopWebSiteNetworkTraceResponder handles the response to the StopWebSiteNetworkTrace request. The method always
// closes the http.Response Body.
func (client AppsClient) StopWebSiteNetworkTraceResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopWebSiteNetworkTraceSlot stop ongoing capturing network packets for the
// site.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app. slot is the name of the slot for
// this web app.
func (client AppsClient) StopWebSiteNetworkTraceSlot(resourceGroupName string, name string, slot string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "StopWebSiteNetworkTraceSlot")
	}

	req, err := client.StopWebSiteNetworkTraceSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTraceSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopWebSiteNetworkTraceSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTraceSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StopWebSiteNetworkTraceSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "StopWebSiteNetworkTraceSlot", resp, "Failure responding to request")
	}

	return
}

// StopWebSiteNetworkTraceSlotPreparer prepares the StopWebSiteNetworkTraceSlot request.
func (client AppsClient) StopWebSiteNetworkTraceSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// StopWebSiteNetworkTraceSlotSender sends the StopWebSiteNetworkTraceSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) StopWebSiteNetworkTraceSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// StopWebSiteNetworkTraceSlotResponder handles the response to the StopWebSiteNetworkTraceSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) StopWebSiteNetworkTraceSlotResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SwapSlotSlot swaps two deployment slots of an app. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument.
// The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example. slot is name of the source slot.
// If a slot is not specified, the production slot is used as the source slot.
func (client AppsClient) SwapSlotSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "SwapSlotSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.SwapSlotSlotPreparer(resourceGroupName, name, slotSwapEntity, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.SwapSlotSlotSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotSlot", resp, "Failure sending request")
			return
		}

		result, err = client.SwapSlotSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// SwapSlotSlotPreparer prepares the SwapSlotSlot request.
func (client AppsClient) SwapSlotSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SwapSlotSlotSender sends the SwapSlotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SwapSlotSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SwapSlotSlotResponder handles the response to the SwapSlotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) SwapSlotSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SwapSlotWithProduction swaps two deployment slots of an app. This method may
// poll for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotSwapEntity is jSON object that
// contains the target slot name. See example.
func (client AppsClient) SwapSlotWithProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "SwapSlotWithProduction")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result autorest.Response
		defer func() {
			resultChan <- result
			errChan <- err
			close(resultChan)
			close(errChan)
		}()
		req, err := client.SwapSlotWithProductionPreparer(resourceGroupName, name, slotSwapEntity, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotWithProduction", nil, "Failure preparing request")
			return
		}

		resp, err := client.SwapSlotWithProductionSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotWithProduction", resp, "Failure sending request")
			return
		}

		result, err = client.SwapSlotWithProductionResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "SwapSlotWithProduction", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// SwapSlotWithProductionPreparer prepares the SwapSlotWithProduction request.
func (client AppsClient) SwapSlotWithProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SwapSlotWithProductionSender sends the SwapSlotWithProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SwapSlotWithProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SwapSlotWithProductionResponder handles the response to the SwapSlotWithProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) SwapSlotWithProductionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SyncFunctionTriggers syncs function trigger metadata to the scale controller
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app.
func (client AppsClient) SyncFunctionTriggers(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "SyncFunctionTriggers")
	}

	req, err := client.SyncFunctionTriggersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggers", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncFunctionTriggersSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggers", resp, "Failure sending request")
		return
	}

	result, err = client.SyncFunctionTriggersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggers", resp, "Failure responding to request")
	}

	return
}

// SyncFunctionTriggersPreparer prepares the SyncFunctionTriggers request.
func (client AppsClient) SyncFunctionTriggersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/syncfunctiontriggers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncFunctionTriggersSender sends the SyncFunctionTriggers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SyncFunctionTriggersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncFunctionTriggersResponder handles the response to the SyncFunctionTriggers request. The method always
// closes the http.Response Body.
func (client AppsClient) SyncFunctionTriggersResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SyncFunctionTriggersSlot syncs function trigger metadata to the scale
// controller
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slot is name of the deployment slot. If a
// slot is not specified, the API will restore a backup of the production slot.
func (client AppsClient) SyncFunctionTriggersSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "SyncFunctionTriggersSlot")
	}

	req, err := client.SyncFunctionTriggersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncFunctionTriggersSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.SyncFunctionTriggersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncFunctionTriggersSlot", resp, "Failure responding to request")
	}

	return
}

// SyncFunctionTriggersSlotPreparer prepares the SyncFunctionTriggersSlot request.
func (client AppsClient) SyncFunctionTriggersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/syncfunctiontriggers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncFunctionTriggersSlotSender sends the SyncFunctionTriggersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SyncFunctionTriggersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncFunctionTriggersSlotResponder handles the response to the SyncFunctionTriggersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) SyncFunctionTriggersSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SyncRepository sync web app repository.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app
func (client AppsClient) SyncRepository(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "SyncRepository")
	}

	req, err := client.SyncRepositoryPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepository", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncRepositorySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepository", resp, "Failure sending request")
		return
	}

	result, err = client.SyncRepositoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepository", resp, "Failure responding to request")
	}

	return
}

// SyncRepositoryPreparer prepares the SyncRepository request.
func (client AppsClient) SyncRepositoryPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncRepositorySender sends the SyncRepository request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SyncRepositorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncRepositoryResponder handles the response to the SyncRepository request. The method always
// closes the http.Response Body.
func (client AppsClient) SyncRepositoryResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// SyncRepositorySlot sync web app repository.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app slot is name of web app slot. If not
// specified then will default to production slot.
func (client AppsClient) SyncRepositorySlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "SyncRepositorySlot")
	}

	req, err := client.SyncRepositorySlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepositorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncRepositorySlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepositorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.SyncRepositorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "SyncRepositorySlot", resp, "Failure responding to request")
	}

	return
}

// SyncRepositorySlotPreparer prepares the SyncRepositorySlot request.
func (client AppsClient) SyncRepositorySlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// SyncRepositorySlotSender sends the SyncRepositorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) SyncRepositorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// SyncRepositorySlotResponder handles the response to the SyncRepositorySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) SyncRepositorySlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateApplicationSettings replaces the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. appSettings is application settings of the
// app.
func (client AppsClient) UpdateApplicationSettings(resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateApplicationSettings")
	}

	req, err := client.UpdateApplicationSettingsPreparer(resourceGroupName, name, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateApplicationSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateApplicationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateApplicationSettingsPreparer prepares the UpdateApplicationSettings request.
func (client AppsClient) UpdateApplicationSettingsPreparer(resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateApplicationSettingsSender sends the UpdateApplicationSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateApplicationSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateApplicationSettingsResponder handles the response to the UpdateApplicationSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateApplicationSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateApplicationSettingsSlot replaces the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. appSettings is application settings of the
// app. slot is name of the deployment slot. If a slot is not specified, the
// API will update the application settings for the production slot.
func (client AppsClient) UpdateApplicationSettingsSlot(resourceGroupName string, name string, appSettings StringDictionary, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateApplicationSettingsSlot")
	}

	req, err := client.UpdateApplicationSettingsSlotPreparer(resourceGroupName, name, appSettings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateApplicationSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateApplicationSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateApplicationSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateApplicationSettingsSlotPreparer prepares the UpdateApplicationSettingsSlot request.
func (client AppsClient) UpdateApplicationSettingsSlotPreparer(resourceGroupName string, name string, appSettings StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateApplicationSettingsSlotSender sends the UpdateApplicationSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateApplicationSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateApplicationSettingsSlotResponder handles the response to the UpdateApplicationSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateApplicationSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateAuthSettings updates the Authentication / Authorization settings
// associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app siteAuthSettings is auth settings
// associated with web app
func (client AppsClient) UpdateAuthSettings(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateAuthSettings")
	}

	req, err := client.UpdateAuthSettingsPreparer(resourceGroupName, name, siteAuthSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateAuthSettingsPreparer prepares the UpdateAuthSettings request.
func (client AppsClient) UpdateAuthSettingsPreparer(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateAuthSettingsSender sends the UpdateAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateAuthSettingsResponder handles the response to the UpdateAuthSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateAuthSettingsSlot updates the Authentication / Authorization settings
// associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app siteAuthSettings is auth settings
// associated with web app slot is name of web app slot. If not specified then
// will default to production slot.
func (client AppsClient) UpdateAuthSettingsSlot(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateAuthSettingsSlot")
	}

	req, err := client.UpdateAuthSettingsSlotPreparer(resourceGroupName, name, siteAuthSettings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateAuthSettingsSlotPreparer prepares the UpdateAuthSettingsSlot request.
func (client AppsClient) UpdateAuthSettingsSlotPreparer(resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateAuthSettingsSlotSender sends the UpdateAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateAuthSettingsSlotResponder handles the response to the UpdateAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateBackupConfiguration updates the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is edited backup configuration.
func (client AppsClient) UpdateBackupConfiguration(resourceGroupName string, name string, request BackupRequest) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateBackupConfiguration")
	}

	req, err := client.UpdateBackupConfigurationPreparer(resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// UpdateBackupConfigurationPreparer prepares the UpdateBackupConfiguration request.
func (client AppsClient) UpdateBackupConfigurationPreparer(resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateBackupConfigurationSender sends the UpdateBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateBackupConfigurationResponder handles the response to the UpdateBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateBackupConfigurationSlot updates the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. request is edited backup configuration.
// slot is name of the deployment slot. If a slot is not specified, the API
// will update the backup configuration for the production slot.
func (client AppsClient) UpdateBackupConfigurationSlot(resourceGroupName string, name string, request BackupRequest, slot string) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateBackupConfigurationSlot")
	}

	req, err := client.UpdateBackupConfigurationSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateBackupConfigurationSlotPreparer prepares the UpdateBackupConfigurationSlot request.
func (client AppsClient) UpdateBackupConfigurationSlotPreparer(resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateBackupConfigurationSlotSender sends the UpdateBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateBackupConfigurationSlotResponder handles the response to the UpdateBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateConfiguration updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteConfig is jSON representation of a
// SiteConfig object. See example.
func (client AppsClient) UpdateConfiguration(resourceGroupName string, name string, siteConfig SiteConfigResource) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateConfiguration")
	}

	req, err := client.UpdateConfigurationPreparer(resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfiguration", resp, "Failure responding to request")
	}

	return
}

// UpdateConfigurationPreparer prepares the UpdateConfiguration request.
func (client AppsClient) UpdateConfigurationPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateConfigurationSender sends the UpdateConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateConfigurationResponder handles the response to the UpdateConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateConfigurationSlot updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteConfig is jSON representation of a
// SiteConfig object. See example. slot is name of the deployment slot. If a
// slot is not specified, the API will update configuration for the production
// slot.
func (client AppsClient) UpdateConfigurationSlot(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateConfigurationSlot")
	}

	req, err := client.UpdateConfigurationSlotPreparer(resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateConfigurationSlotPreparer prepares the UpdateConfigurationSlot request.
func (client AppsClient) UpdateConfigurationSlotPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateConfigurationSlotSender sends the UpdateConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateConfigurationSlotResponder handles the response to the UpdateConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateConnectionStrings replaces the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. connectionStrings is connection strings of
// the app or deployment slot. See example.
func (client AppsClient) UpdateConnectionStrings(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateConnectionStrings")
	}

	req, err := client.UpdateConnectionStringsPreparer(resourceGroupName, name, connectionStrings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// UpdateConnectionStringsPreparer prepares the UpdateConnectionStrings request.
func (client AppsClient) UpdateConnectionStringsPreparer(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateConnectionStringsSender sends the UpdateConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateConnectionStringsResponder handles the response to the UpdateConnectionStrings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateConnectionStringsSlot replaces the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. connectionStrings is connection strings of
// the app or deployment slot. See example. slot is name of the deployment
// slot. If a slot is not specified, the API will update the connection
// settings for the production slot.
func (client AppsClient) UpdateConnectionStringsSlot(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateConnectionStringsSlot")
	}

	req, err := client.UpdateConnectionStringsSlotPreparer(resourceGroupName, name, connectionStrings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateConnectionStringsSlotPreparer prepares the UpdateConnectionStringsSlot request.
func (client AppsClient) UpdateConnectionStringsSlotPreparer(resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateConnectionStringsSlotSender sends the UpdateConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateConnectionStringsSlotResponder handles the response to the UpdateConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDiagnosticLogsConfig updates the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteLogsConfig is a SiteLogsConfig JSON
// object that contains the logging configuration to change in the "properties"
// property.
func (client AppsClient) UpdateDiagnosticLogsConfig(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteLogsConfig,
			Constraints: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs.AzureTableStorage", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs.AzureTableStorage.SasURL", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
									{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.InclusiveMinimum, Rule: 25, Chain: nil},
								}},
							}},
						}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateDiagnosticLogsConfig")
	}

	req, err := client.UpdateDiagnosticLogsConfigPreparer(resourceGroupName, name, siteLogsConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateDiagnosticLogsConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfig", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateDiagnosticLogsConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfig", resp, "Failure responding to request")
	}

	return
}

// UpdateDiagnosticLogsConfigPreparer prepares the UpdateDiagnosticLogsConfig request.
func (client AppsClient) UpdateDiagnosticLogsConfigPreparer(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateDiagnosticLogsConfigSender sends the UpdateDiagnosticLogsConfig request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateDiagnosticLogsConfigSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateDiagnosticLogsConfigResponder handles the response to the UpdateDiagnosticLogsConfig request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateDiagnosticLogsConfigResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDiagnosticLogsConfigSlot updates the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. siteLogsConfig is a SiteLogsConfig JSON
// object that contains the logging configuration to change in the "properties"
// property. slot is name of the deployment slot. If a slot is not specified,
// the API will update the logging configuration for the production slot.
func (client AppsClient) UpdateDiagnosticLogsConfigSlot(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteLogsConfig,
			Constraints: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs.AzureTableStorage", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.ApplicationLogs.AzureTableStorage.SasURL", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.InclusiveMaximum, Rule: 100, Chain: nil},
									{Target: "siteLogsConfig.SiteLogsConfigProperties.HTTPLogs.FileSystem.RetentionInMb", Name: validation.InclusiveMinimum, Rule: 25, Chain: nil},
								}},
							}},
						}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateDiagnosticLogsConfigSlot")
	}

	req, err := client.UpdateDiagnosticLogsConfigSlotPreparer(resourceGroupName, name, siteLogsConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateDiagnosticLogsConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateDiagnosticLogsConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDiagnosticLogsConfigSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateDiagnosticLogsConfigSlotPreparer prepares the UpdateDiagnosticLogsConfigSlot request.
func (client AppsClient) UpdateDiagnosticLogsConfigSlotPreparer(resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateDiagnosticLogsConfigSlotSender sends the UpdateDiagnosticLogsConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateDiagnosticLogsConfigSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateDiagnosticLogsConfigSlotResponder handles the response to the UpdateDiagnosticLogsConfigSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateDiagnosticLogsConfigSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDomainOwnershipIdentifier creates a domain ownership identifier for
// web app, or updates an existing ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties.
func (client AppsClient) UpdateDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifier")
	}

	req, err := client.UpdateDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// UpdateDomainOwnershipIdentifierPreparer prepares the UpdateDomainOwnershipIdentifier request.
func (client AppsClient) UpdateDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateDomainOwnershipIdentifierSender sends the UpdateDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateDomainOwnershipIdentifierResponder handles the response to the UpdateDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateDomainOwnershipIdentifierSlot creates a domain ownership identifier
// for web app, or updates an existing ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. domainOwnershipIdentifierName is name of
// domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties. slot is name of the
// deployment slot. If a slot is not specified, the API will delete the binding
// for the production slot.
func (client AppsClient) UpdateDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifierSlot")
	}

	req, err := client.UpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateDomainOwnershipIdentifierSlotPreparer prepares the UpdateDomainOwnershipIdentifierSlot request.
func (client AppsClient) UpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateDomainOwnershipIdentifierSlotSender sends the UpdateDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateDomainOwnershipIdentifierSlotResponder handles the response to the UpdateDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHybridConnection creates a new Hybrid Connection using a Service Bus
// relay.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection connectionEnvelope is the details of the hybrid connection
func (client AppsClient) UpdateHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateHybridConnection")
	}

	req, err := client.UpdateHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnection", resp, "Failure responding to request")
	}

	return
}

// UpdateHybridConnectionPreparer prepares the UpdateHybridConnection request.
func (client AppsClient) UpdateHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateHybridConnectionSender sends the UpdateHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateHybridConnectionResponder handles the response to the UpdateHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHybridConnectionSlot creates a new Hybrid Connection using a Service
// Bus relay.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is the name of the web app namespaceName is the namespace for
// this hybrid connection relayName is the relay name for this hybrid
// connection connectionEnvelope is the details of the hybrid connection slot
// is the name of the slot for the web app.
func (client AppsClient) UpdateHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateHybridConnectionSlot")
	}

	req, err := client.UpdateHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateHybridConnectionSlotPreparer prepares the UpdateHybridConnectionSlot request.
func (client AppsClient) UpdateHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateHybridConnectionSlotSender sends the UpdateHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateHybridConnectionSlotResponder handles the response to the UpdateHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateMetadata replaces the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. metadata is edited metadata of the app or
// deployment slot. See example.
func (client AppsClient) UpdateMetadata(resourceGroupName string, name string, metadata StringDictionary) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateMetadata")
	}

	req, err := client.UpdateMetadataPreparer(resourceGroupName, name, metadata)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadata", resp, "Failure responding to request")
	}

	return
}

// UpdateMetadataPreparer prepares the UpdateMetadata request.
func (client AppsClient) UpdateMetadataPreparer(resourceGroupName string, name string, metadata StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateMetadataSender sends the UpdateMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateMetadataResponder handles the response to the UpdateMetadata request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateMetadataSlot replaces the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. metadata is edited metadata of the app or
// deployment slot. See example. slot is name of the deployment slot. If a slot
// is not specified, the API will update the metadata for the production slot.
func (client AppsClient) UpdateMetadataSlot(resourceGroupName string, name string, metadata StringDictionary, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateMetadataSlot")
	}

	req, err := client.UpdateMetadataSlotPreparer(resourceGroupName, name, metadata, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateMetadataSlotPreparer prepares the UpdateMetadataSlot request.
func (client AppsClient) UpdateMetadataSlotPreparer(resourceGroupName string, name string, metadata StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateMetadataSlotSender sends the UpdateMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateMetadataSlotResponder handles the response to the UpdateMetadataSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRelayServiceConnection creates a new hybrid connection configuration
// (PUT), or updates an existing one (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration. connectionEnvelope is details of the hybrid
// connection configuration.
func (client AppsClient) UpdateRelayServiceConnection(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateRelayServiceConnection")
	}

	req, err := client.UpdateRelayServiceConnectionPreparer(resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// UpdateRelayServiceConnectionPreparer prepares the UpdateRelayServiceConnection request.
func (client AppsClient) UpdateRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateRelayServiceConnectionSender sends the UpdateRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateRelayServiceConnectionResponder handles the response to the UpdateRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRelayServiceConnectionSlot creates a new hybrid connection
// configuration (PUT), or updates an existing one (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. entityName is name of the hybrid
// connection configuration. connectionEnvelope is details of the hybrid
// connection configuration. slot is name of the deployment slot. If a slot is
// not specified, the API will create or update a hybrid connection for the
// production slot.
func (client AppsClient) UpdateRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateRelayServiceConnectionSlot")
	}

	req, err := client.UpdateRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateRelayServiceConnectionSlotPreparer prepares the UpdateRelayServiceConnectionSlot request.
func (client AppsClient) UpdateRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateRelayServiceConnectionSlotSender sends the UpdateRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateRelayServiceConnectionSlotResponder handles the response to the UpdateRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSitePushSettings updates the Push settings associated with web app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app pushSettings is push settings associated
// with web app
func (client AppsClient) UpdateSitePushSettings(resourceGroupName string, name string, pushSettings PushSettings) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: pushSettings,
			Constraints: []validation.Constraint{{Target: "pushSettings.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateSitePushSettings")
	}

	req, err := client.UpdateSitePushSettingsPreparer(resourceGroupName, name, pushSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSitePushSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSitePushSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateSitePushSettingsPreparer prepares the UpdateSitePushSettings request.
func (client AppsClient) UpdateSitePushSettingsPreparer(resourceGroupName string, name string, pushSettings PushSettings) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings", pathParameters),
		autorest.WithJSON(pushSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSitePushSettingsSender sends the UpdateSitePushSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateSitePushSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSitePushSettingsResponder handles the response to the UpdateSitePushSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateSitePushSettingsResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSitePushSettingsSlot updates the Push settings associated with web
// app.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of web app pushSettings is push settings associated
// with web app slot is name of web app slot. If not specified then will
// default to production slot.
func (client AppsClient) UpdateSitePushSettingsSlot(resourceGroupName string, name string, pushSettings PushSettings, slot string) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: pushSettings,
			Constraints: []validation.Constraint{{Target: "pushSettings.IsPushEnabled", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateSitePushSettingsSlot")
	}

	req, err := client.UpdateSitePushSettingsSlotPreparer(resourceGroupName, name, pushSettings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSitePushSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSitePushSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSitePushSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateSitePushSettingsSlotPreparer prepares the UpdateSitePushSettingsSlot request.
func (client AppsClient) UpdateSitePushSettingsSlotPreparer(resourceGroupName string, name string, pushSettings PushSettings, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings", pathParameters),
		autorest.WithJSON(pushSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSitePushSettingsSlotSender sends the UpdateSitePushSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateSitePushSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSitePushSettingsSlotResponder handles the response to the UpdateSitePushSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateSitePushSettingsSlotResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSlotConfigurationNames updates the names of application settings and
// connection string that remain with the slot during swap operation.
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. slotConfigNames is names of application
// settings and connection strings. See example.
func (client AppsClient) UpdateSlotConfigurationNames(resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (result SlotConfigNamesResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateSlotConfigurationNames")
	}

	req, err := client.UpdateSlotConfigurationNamesPreparer(resourceGroupName, name, slotConfigNames)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSlotConfigurationNames", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSlotConfigurationNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSlotConfigurationNames", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSlotConfigurationNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateSlotConfigurationNames", resp, "Failure responding to request")
	}

	return
}

// UpdateSlotConfigurationNamesPreparer prepares the UpdateSlotConfigurationNames request.
func (client AppsClient) UpdateSlotConfigurationNamesPreparer(resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithJSON(slotConfigNames),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateSlotConfigurationNamesSender sends the UpdateSlotConfigurationNames request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateSlotConfigurationNamesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateSlotConfigurationNamesResponder handles the response to the UpdateSlotConfigurationNames request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateSlotConfigurationNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetConnection adds a Virtual Network connection to an app or slot
// (PUT) or updates the connection properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of an existing Virtual
// Network. connectionEnvelope is properties of the Virtual Network connection.
// See example.
func (client AppsClient) UpdateVnetConnection(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateVnetConnection")
	}

	req, err := client.UpdateVnetConnectionPreparer(resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnection", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetConnectionPreparer prepares the UpdateVnetConnection request.
func (client AppsClient) UpdateVnetConnectionPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetConnectionSender sends the UpdateVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateVnetConnectionResponder handles the response to the UpdateVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetConnectionGateway adds a gateway to a connected Virtual Network
// (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary". connectionEnvelope is the properties to update this gateway with.
func (client AppsClient) UpdateVnetConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateVnetConnectionGateway")
	}

	req, err := client.UpdateVnetConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetConnectionGatewayPreparer prepares the UpdateVnetConnectionGateway request.
func (client AppsClient) UpdateVnetConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetConnectionGatewaySender sends the UpdateVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateVnetConnectionGatewayResponder handles the response to the UpdateVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetConnectionGatewaySlot adds a gateway to a connected Virtual
// Network (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of the Virtual Network.
// gatewayName is name of the gateway. Currently, the only supported string is
// "primary". connectionEnvelope is the properties to update this gateway with.
// slot is name of the deployment slot. If a slot is not specified, the API
// will add or update a gateway for the production slot's Virtual Network.
func (client AppsClient) UpdateVnetConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateVnetConnectionGatewaySlot")
	}

	req, err := client.UpdateVnetConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetConnectionGatewaySlotPreparer prepares the UpdateVnetConnectionGatewaySlot request.
func (client AppsClient) UpdateVnetConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetConnectionGatewaySlotSender sends the UpdateVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateVnetConnectionGatewaySlotResponder handles the response to the UpdateVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetConnectionSlot adds a Virtual Network connection to an app or slot
// (PUT) or updates the connection properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource
// belongs. name is name of the app. vnetName is name of an existing Virtual
// Network. connectionEnvelope is properties of the Virtual Network connection.
// See example. slot is name of the deployment slot. If a slot is not
// specified, the API will add or update connections for the production slot.
func (client AppsClient) UpdateVnetConnectionSlot(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "UpdateVnetConnectionSlot")
	}

	req, err := client.UpdateVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "UpdateVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetConnectionSlotPreparer prepares the UpdateVnetConnectionSlot request.
func (client AppsClient) UpdateVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetConnectionSlotSender sends the UpdateVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// UpdateVnetConnectionSlotResponder handles the response to the UpdateVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
