package storsimple8000series

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.1.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// CloudAppliancesClient is the client for the CloudAppliances methods of the
// Storsimple8000series service.
type CloudAppliancesClient struct {
	ManagementClient
}

// NewCloudAppliancesClient creates an instance of the CloudAppliancesClient
// client.
func NewCloudAppliancesClient(subscriptionID string) CloudAppliancesClient {
	return NewCloudAppliancesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCloudAppliancesClientWithBaseURI creates an instance of the
// CloudAppliancesClient client.
func NewCloudAppliancesClientWithBaseURI(baseURI string, subscriptionID string) CloudAppliancesClient {
	return CloudAppliancesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListSupportedConfigurations lists supported cloud appliance models and
// supported configurations.
//
// resourceGroupName is the resource group name managerName is the manager name
func (client CloudAppliancesClient) ListSupportedConfigurations(resourceGroupName string, managerName string) (result CloudApplianceConfigurationList, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.CloudAppliancesClient", "ListSupportedConfigurations")
	}

	req, err := client.ListSupportedConfigurationsPreparer(resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "ListSupportedConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListSupportedConfigurationsPreparer prepares the ListSupportedConfigurations request.
func (client CloudAppliancesClient) ListSupportedConfigurationsPreparer(resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/cloudApplianceConfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSupportedConfigurationsSender sends the ListSupportedConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ListSupportedConfigurationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListSupportedConfigurationsResponder handles the response to the ListSupportedConfigurations request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ListSupportedConfigurationsResponder(resp *http.Response) (result CloudApplianceConfigurationList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Provision provisions cloud appliance. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// parameters is the cloud appliance resourceGroupName is the resource group
// name managerName is the manager name
func (client CloudAppliancesClient) Provision(parameters CloudAppliance, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.VnetRegion", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.CloudAppliancesClient", "Provision")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result autorest.Response
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ProvisionPreparer(parameters, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "Provision", nil, "Failure preparing request")
			return
		}

		resp, err := client.ProvisionSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "Provision", resp, "Failure sending request")
			return
		}

		result, err = client.ProvisionResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.CloudAppliancesClient", "Provision", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ProvisionPreparer prepares the Provision request.
func (client CloudAppliancesClient) ProvisionPreparer(parameters CloudAppliance, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/provisionCloudAppliance", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ProvisionSender sends the Provision request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ProvisionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ProvisionResponder handles the response to the Provision request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ProvisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
