package apimanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"io"
	"net/http"
)

// APIProtocolContract enumerates the values for api protocol contract.
type APIProtocolContract string

const (
	// HTTP specifies the http state for api protocol contract.
	HTTP APIProtocolContract = "Http"
	// HTTPS specifies the https state for api protocol contract.
	HTTPS APIProtocolContract = "Https"
)

// APITypeContract enumerates the values for api type contract.
type APITypeContract string

const (
	// APITypeContractHTTP specifies the api type contract http state for api
	// type contract.
	APITypeContractHTTP APITypeContract = "Http"
	// APITypeContractSoap specifies the api type contract soap state for api
	// type contract.
	APITypeContractSoap APITypeContract = "Soap"
)

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// Failed specifies the failed state for async operation state.
	Failed AsyncOperationState = "Failed"
	// InProgress specifies the in progress state for async operation state.
	InProgress AsyncOperationState = "InProgress"
	// Started specifies the started state for async operation state.
	Started AsyncOperationState = "Started"
	// Succeeded specifies the succeeded state for async operation state.
	Succeeded AsyncOperationState = "Succeeded"
)

// BackendProtocol enumerates the values for backend protocol.
type BackendProtocol string

const (
	// BackendProtocolHTTP specifies the backend protocol http state for
	// backend protocol.
	BackendProtocolHTTP BackendProtocol = "http"
	// BackendProtocolSoap specifies the backend protocol soap state for
	// backend protocol.
	BackendProtocolSoap BackendProtocol = "soap"
)

// BearerTokenSendingMethodsContract enumerates the values for bearer token
// sending methods contract.
type BearerTokenSendingMethodsContract string

const (
	// AuthorizationHeader specifies the authorization header state for bearer
	// token sending methods contract.
	AuthorizationHeader BearerTokenSendingMethodsContract = "authorizationHeader"
	// Query specifies the query state for bearer token sending methods
	// contract.
	Query BearerTokenSendingMethodsContract = "query"
)

// ClientAuthenticationMethodContract enumerates the values for client
// authentication method contract.
type ClientAuthenticationMethodContract string

const (
	// Basic specifies the basic state for client authentication method
	// contract.
	Basic ClientAuthenticationMethodContract = "Basic"
	// Body specifies the body state for client authentication method contract.
	Body ClientAuthenticationMethodContract = "Body"
)

// ConnectivityStatusType enumerates the values for connectivity status type.
type ConnectivityStatusType string

const (
	// Failure specifies the failure state for connectivity status type.
	Failure ConnectivityStatusType = "failure"
	// Initializing specifies the initializing state for connectivity status
	// type.
	Initializing ConnectivityStatusType = "initializing"
	// Success specifies the success state for connectivity status type.
	Success ConnectivityStatusType = "success"
)

// GrantTypesContract enumerates the values for grant types contract.
type GrantTypesContract string

const (
	// AuthorizationCode specifies the authorization code state for grant types
	// contract.
	AuthorizationCode GrantTypesContract = "authorizationCode"
	// ClientCredentials specifies the client credentials state for grant types
	// contract.
	ClientCredentials GrantTypesContract = "clientCredentials"
	// Implicit specifies the implicit state for grant types contract.
	Implicit GrantTypesContract = "implicit"
	// ResourceOwnerPassword specifies the resource owner password state for
	// grant types contract.
	ResourceOwnerPassword GrantTypesContract = "resourceOwnerPassword"
)

// GroupTypeContract enumerates the values for group type contract.
type GroupTypeContract string

const (
	// Custom specifies the custom state for group type contract.
	Custom GroupTypeContract = "Custom"
	// External specifies the external state for group type contract.
	External GroupTypeContract = "External"
	// System specifies the system state for group type contract.
	System GroupTypeContract = "System"
)

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// Management specifies the management state for hostname type.
	Management HostnameType = "Management"
	// Portal specifies the portal state for hostname type.
	Portal HostnameType = "Portal"
	// Proxy specifies the proxy state for hostname type.
	Proxy HostnameType = "Proxy"
	// Scm specifies the scm state for hostname type.
	Scm HostnameType = "Scm"
)

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted specifies the accepted state for http status code.
	Accepted HTTPStatusCode = "Accepted"
	// Conflict specifies the conflict state for http status code.
	Conflict HTTPStatusCode = "Conflict"
	// Continue specifies the continue state for http status code.
	Continue HTTPStatusCode = "Continue"
	// Created specifies the created state for http status code.
	Created HTTPStatusCode = "Created"
	// NotFound specifies the not found state for http status code.
	NotFound HTTPStatusCode = "NotFound"
	// OK specifies the ok state for http status code.
	OK HTTPStatusCode = "OK"
)

// IdentityProviderNameType enumerates the values for identity provider name
// type.
type IdentityProviderNameType string

const (
	// Aad specifies the aad state for identity provider name type.
	Aad IdentityProviderNameType = "aad"
	// AadB2C specifies the aad b2c state for identity provider name type.
	AadB2C IdentityProviderNameType = "aadB2C"
	// Facebook specifies the facebook state for identity provider name type.
	Facebook IdentityProviderNameType = "facebook"
	// Google specifies the google state for identity provider name type.
	Google IdentityProviderNameType = "google"
	// Microsoft specifies the microsoft state for identity provider name type.
	Microsoft IdentityProviderNameType = "microsoft"
	// Twitter specifies the twitter state for identity provider name type.
	Twitter IdentityProviderNameType = "twitter"
)

// MethodContract enumerates the values for method contract.
type MethodContract string

const (
	// DELETE specifies the delete state for method contract.
	DELETE MethodContract = "DELETE"
	// GET specifies the get state for method contract.
	GET MethodContract = "GET"
	// HEAD specifies the head state for method contract.
	HEAD MethodContract = "HEAD"
	// OPTIONS specifies the options state for method contract.
	OPTIONS MethodContract = "OPTIONS"
	// PATCH specifies the patch state for method contract.
	PATCH MethodContract = "PATCH"
	// POST specifies the post state for method contract.
	POST MethodContract = "POST"
	// PUT specifies the put state for method contract.
	PUT MethodContract = "PUT"
	// TRACE specifies the trace state for method contract.
	TRACE MethodContract = "TRACE"
)

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists specifies the already exists state for name availability
	// reason.
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid specifies the invalid state for name availability reason.
	Invalid NameAvailabilityReason = "Invalid"
	// Valid specifies the valid state for name availability reason.
	Valid NameAvailabilityReason = "Valid"
)

// PolicyScopeContract enumerates the values for policy scope contract.
type PolicyScopeContract string

const (
	// PolicyScopeContractAll specifies the policy scope contract all state for
	// policy scope contract.
	PolicyScopeContractAll PolicyScopeContract = "All"
	// PolicyScopeContractAPI specifies the policy scope contract api state for
	// policy scope contract.
	PolicyScopeContractAPI PolicyScopeContract = "Api"
	// PolicyScopeContractOperation specifies the policy scope contract
	// operation state for policy scope contract.
	PolicyScopeContractOperation PolicyScopeContract = "Operation"
	// PolicyScopeContractProduct specifies the policy scope contract product
	// state for policy scope contract.
	PolicyScopeContractProduct PolicyScopeContract = "Product"
	// PolicyScopeContractTenant specifies the policy scope contract tenant
	// state for policy scope contract.
	PolicyScopeContractTenant PolicyScopeContract = "Tenant"
)

// ProductStateContract enumerates the values for product state contract.
type ProductStateContract string

const (
	// NotPublished specifies the not published state for product state
	// contract.
	NotPublished ProductStateContract = "NotPublished"
	// Published specifies the published state for product state contract.
	Published ProductStateContract = "Published"
)

// ReportsAggregation enumerates the values for reports aggregation.
type ReportsAggregation string

const (
	// ByAPI specifies the by api state for reports aggregation.
	ByAPI ReportsAggregation = "byApi"
	// ByGeo specifies the by geo state for reports aggregation.
	ByGeo ReportsAggregation = "byGeo"
	// ByOperation specifies the by operation state for reports aggregation.
	ByOperation ReportsAggregation = "byOperation"
	// ByProduct specifies the by product state for reports aggregation.
	ByProduct ReportsAggregation = "byProduct"
	// BySubscription specifies the by subscription state for reports
	// aggregation.
	BySubscription ReportsAggregation = "bySubscription"
	// ByTime specifies the by time state for reports aggregation.
	ByTime ReportsAggregation = "byTime"
	// ByUser specifies the by user state for reports aggregation.
	ByUser ReportsAggregation = "byUser"
)

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// Developer specifies the developer state for sku type.
	Developer SkuType = "Developer"
	// Premium specifies the premium state for sku type.
	Premium SkuType = "Premium"
	// Standard specifies the standard state for sku type.
	Standard SkuType = "Standard"
)

// SubscriptionStateContract enumerates the values for subscription state
// contract.
type SubscriptionStateContract string

const (
	// Active specifies the active state for subscription state contract.
	Active SubscriptionStateContract = "Active"
	// Cancelled specifies the cancelled state for subscription state contract.
	Cancelled SubscriptionStateContract = "Cancelled"
	// Expired specifies the expired state for subscription state contract.
	Expired SubscriptionStateContract = "Expired"
	// Rejected specifies the rejected state for subscription state contract.
	Rejected SubscriptionStateContract = "Rejected"
	// Submitted specifies the submitted state for subscription state contract.
	Submitted SubscriptionStateContract = "Submitted"
	// Suspended specifies the suspended state for subscription state contract.
	Suspended SubscriptionStateContract = "Suspended"
)

// UserStateContract enumerates the values for user state contract.
type UserStateContract string

const (
	// UserStateContractActive specifies the user state contract active state
	// for user state contract.
	UserStateContractActive UserStateContract = "Active"
	// UserStateContractBlocked specifies the user state contract blocked state
	// for user state contract.
	UserStateContractBlocked UserStateContract = "Blocked"
)

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// VirtualNetworkTypeExternal specifies the virtual network type external
	// state for virtual network type.
	VirtualNetworkTypeExternal VirtualNetworkType = "External"
	// VirtualNetworkTypeInternal specifies the virtual network type internal
	// state for virtual network type.
	VirtualNetworkTypeInternal VirtualNetworkType = "Internal"
	// VirtualNetworkTypeNone specifies the virtual network type none state for
	// virtual network type.
	VirtualNetworkTypeNone VirtualNetworkType = "None"
)

// AccessInformationContract is tenant access information contract of the API
// Management service.
type AccessInformationContract struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	PrimaryKey        *string `json:"primaryKey,omitempty"`
	SecondaryKey      *string `json:"secondaryKey,omitempty"`
	Enabled           *bool   `json:"enabled,omitempty"`
}

// AccessInformationUpdateParameters is tenant access information update
// parameters of the API Management service.
type AccessInformationUpdateParameters struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// AdditionalRegion is description of an additional API Management resource
// location.
type AdditionalRegion struct {
	Location         *string                      `json:"location,omitempty"`
	SkuType          SkuType                      `json:"skuType,omitempty"`
	SkuUnitCount     *int32                       `json:"skuUnitCount,omitempty"`
	StaticIPs        *[]string                    `json:"staticIPs,omitempty"`
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
}

// APICollection is paged Api list representation.
type APICollection struct {
	autorest.Response `json:"-"`
	Value             *[]APIContract `json:"value,omitempty"`
	Count             *int64         `json:"count,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// APICollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client APICollection) APICollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// APIContract is aPI details.
type APIContract struct {
	autorest.Response             `json:"-"`
	Description                   *string                                `json:"description,omitempty"`
	AuthenticationSettings        *AuthenticationSettingsContract        `json:"authenticationSettings,omitempty"`
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	Type                          APITypeContract                        `json:"type,omitempty"`
	ID                            *string                                `json:"id,omitempty"`
	Name                          *string                                `json:"name,omitempty"`
	ServiceURL                    *string                                `json:"serviceUrl,omitempty"`
	Path                          *string                                `json:"path,omitempty"`
	Protocols                     *[]APIProtocolContract                 `json:"protocols,omitempty"`
}

// APIEntityBaseContract is aPI base contract details.
type APIEntityBaseContract struct {
	Description                   *string                                `json:"description,omitempty"`
	AuthenticationSettings        *AuthenticationSettingsContract        `json:"authenticationSettings,omitempty"`
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	Type                          APITypeContract                        `json:"type,omitempty"`
}

// APIExportResult is the response model for the export API output operation.
type APIExportResult struct {
	autorest.Response `json:"-"`
	Content           *[]byte        `json:"content,omitempty"`
	StatusCode        HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID         *string        `json:"requestId,omitempty"`
}

// APIUpdateContract is aPI Update Contract details.
type APIUpdateContract struct {
	Description                   *string                                `json:"description,omitempty"`
	AuthenticationSettings        *AuthenticationSettingsContract        `json:"authenticationSettings,omitempty"`
	SubscriptionKeyParameterNames *SubscriptionKeyParameterNamesContract `json:"subscriptionKeyParameterNames,omitempty"`
	Type                          APITypeContract                        `json:"type,omitempty"`
	ID                            *string                                `json:"id,omitempty"`
	Name                          *string                                `json:"name,omitempty"`
	ServiceURL                    *string                                `json:"serviceUrl,omitempty"`
	Path                          *string                                `json:"path,omitempty"`
	Protocols                     *[]APIProtocolContract                 `json:"protocols,omitempty"`
}

// AuthenticationSettingsContract is aPI Authentication Settings.
type AuthenticationSettingsContract struct {
	OAuth2 *OAuth2AuthenticationSettingsContract `json:"oAuth2,omitempty"`
}

// AuthorizationServerCollection is paged OAuth2 Authorization Servers list
// representation.
type AuthorizationServerCollection struct {
	autorest.Response `json:"-"`
	Value             *[]OAuth2AuthorizationServerContract `json:"value,omitempty"`
	Count             *int64                               `json:"count,omitempty"`
	NextLink          *string                              `json:"nextLink,omitempty"`
}

// AuthorizationServerCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AuthorizationServerCollection) AuthorizationServerCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BackendAuthorizationHeaderCredentials is authorization header information.
type BackendAuthorizationHeaderCredentials struct {
	Scheme    *string `json:"scheme,omitempty"`
	Parameter *string `json:"parameter,omitempty"`
}

// BackendBaseParameters is backend entity base Parameter set.
type BackendBaseParameters struct {
	Certificate        *[]string            `json:"certificate,omitempty"`
	Query              *map[string][]string `json:"query,omitempty"`
	Header             *map[string][]string `json:"header,omitempty"`
	URL                *string              `json:"url,omitempty"`
	Username           *string              `json:"username,omitempty"`
	Password           *string              `json:"password,omitempty"`
	Title              *string              `json:"title,omitempty"`
	Description        *string              `json:"description,omitempty"`
	ResourceID         *string              `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
}

// BackendCollection is paged Backend list representation.
type BackendCollection struct {
	autorest.Response `json:"-"`
	Value             *[]BackendResponse `json:"value,omitempty"`
	Count             *int64             `json:"count,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// BackendCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client BackendCollection) BackendCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BackendContract is parameters supplied to the Create Backend operation.
type BackendContract struct {
	Certificate        *[]string            `json:"certificate,omitempty"`
	Query              *map[string][]string `json:"query,omitempty"`
	Header             *map[string][]string `json:"header,omitempty"`
	URL                *string              `json:"url,omitempty"`
	Username           *string              `json:"username,omitempty"`
	Password           *string              `json:"password,omitempty"`
	Title              *string              `json:"title,omitempty"`
	Description        *string              `json:"description,omitempty"`
	ResourceID         *string              `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
	ID                 *string         `json:"id,omitempty"`
	Protocol           BackendProtocol `json:"protocol,omitempty"`
}

// BackendCredentialsContract is details of the Credentials used to connect to
// Backend.
type BackendCredentialsContract struct {
	Scheme      *string              `json:"scheme,omitempty"`
	Parameter   *string              `json:"parameter,omitempty"`
	Certificate *[]string            `json:"certificate,omitempty"`
	Query       *map[string][]string `json:"query,omitempty"`
	Header      *map[string][]string `json:"header,omitempty"`
}

// BackendProperties is properties specific to a Backend.
type BackendProperties struct {
	SkipCertificateChainValidation *bool `json:"skipCertificateChainValidation,omitempty"`
	SkipCertificateNameValidation  *bool `json:"skipCertificateNameValidation,omitempty"`
}

// BackendProxyContract is details of the Backend WebProxy Server to use in the
// Request to Backend.
type BackendProxyContract struct {
	URL      *string `json:"url,omitempty"`
	Username *string `json:"username,omitempty"`
	Password *string `json:"password,omitempty"`
}

// BackendResponse is the Backend entity in API Management represents a backend
// service that is configured to skip certification chain validation when using
// a self-signed certificate to test mutual certificate authentication.
type BackendResponse struct {
	autorest.Response  `json:"-"`
	Certificate        *[]string            `json:"certificate,omitempty"`
	Query              *map[string][]string `json:"query,omitempty"`
	Header             *map[string][]string `json:"header,omitempty"`
	URL                *string              `json:"url,omitempty"`
	Username           *string              `json:"username,omitempty"`
	Password           *string              `json:"password,omitempty"`
	Title              *string              `json:"title,omitempty"`
	Description        *string              `json:"description,omitempty"`
	ResourceID         *string              `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
	ID                 *string         `json:"id,omitempty"`
	Protocol           BackendProtocol `json:"protocol,omitempty"`
}

// BackendUpdateParameters is parameters supplied to the Update Backend
// operation.
type BackendUpdateParameters struct {
	Certificate        *[]string            `json:"certificate,omitempty"`
	Query              *map[string][]string `json:"query,omitempty"`
	Header             *map[string][]string `json:"header,omitempty"`
	URL                *string              `json:"url,omitempty"`
	Username           *string              `json:"username,omitempty"`
	Password           *string              `json:"password,omitempty"`
	Title              *string              `json:"title,omitempty"`
	Description        *string              `json:"description,omitempty"`
	ResourceID         *string              `json:"resourceId,omitempty"`
	*BackendProperties `json:"properties,omitempty"`
	Protocol           BackendProtocol `json:"protocol,omitempty"`
}

// CertificateCollection is paged Certificates list representation.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateContract `json:"value,omitempty"`
	Count             *int64                 `json:"count,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// CertificateCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CertificateCollection) CertificateCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CertificateContract is certificate details.
type CertificateContract struct {
	autorest.Response `json:"-"`
	ID                *string    `json:"id,omitempty"`
	Subject           *string    `json:"subject,omitempty"`
	Thumbprint        *string    `json:"thumbprint,omitempty"`
	ExpirationDate    *date.Time `json:"expirationDate,omitempty"`
}

// CertificateCreateOrUpdateParameters is parameters supplied to the
// CreateOrUpdate certificate operation.
type CertificateCreateOrUpdateParameters struct {
	Data     *string `json:"data,omitempty"`
	Password *string `json:"password,omitempty"`
}

// CertificateInformation is sSL certificate information.
type CertificateInformation struct {
	autorest.Response `json:"-"`
	Expiry            *date.Time `json:"expiry,omitempty"`
	Thumbprint        *string    `json:"thumbprint,omitempty"`
	Subject           *string    `json:"subject,omitempty"`
}

// ConnectivityStatusContract is details about connectivity to a resource.
type ConnectivityStatusContract struct {
	Name             *string                `json:"name,omitempty"`
	Status           ConnectivityStatusType `json:"status,omitempty"`
	Error            *string                `json:"error,omitempty"`
	LastUpdated      *date.Time             `json:"lastUpdated,omitempty"`
	LastStatusChange *date.Time             `json:"lastStatusChange,omitempty"`
}

// DeployConfigurationParameters is parameters supplied to the Deploy
// Configuration operation.
type DeployConfigurationParameters struct {
	Branch *string `json:"branch,omitempty"`
	Force  *bool   `json:"force,omitempty"`
}

// ErrorBodyContract is error Body contract.
type ErrorBodyContract struct {
	autorest.Response `json:"-"`
	Code              *string               `json:"code,omitempty"`
	Message           *string               `json:"message,omitempty"`
	Details           *[]ErrorFieldContract `json:"details,omitempty"`
}

// ErrorFieldContract is error Field contract.
type ErrorFieldContract struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
}

// ErrorResponse is error Response.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// GenerateSsoURLResult is generate SSO Url operations response details.
type GenerateSsoURLResult struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// GroupCollection is paged Group list representation.
type GroupCollection struct {
	autorest.Response `json:"-"`
	Value             *[]GroupContract `json:"value,omitempty"`
	Count             *int64           `json:"count,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// GroupCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client GroupCollection) GroupCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// GroupContract is developer group.
type GroupContract struct {
	autorest.Response `json:"-"`
	ID                *string           `json:"id,omitempty"`
	Name              *string           `json:"name,omitempty"`
	Description       *string           `json:"description,omitempty"`
	BuiltIn           *bool             `json:"builtIn,omitempty"`
	Type              GroupTypeContract `json:"type,omitempty"`
	ExternalID        *string           `json:"externalId,omitempty"`
}

// GroupCreateParameters is parameters supplied to the Create Group operation.
type GroupCreateParameters struct {
	Name        *string           `json:"name,omitempty"`
	Description *string           `json:"description,omitempty"`
	Type        GroupTypeContract `json:"type,omitempty"`
	ExternalID  *string           `json:"externalId,omitempty"`
}

// GroupUpdateParameters is parameters supplied to the Update Group operation.
type GroupUpdateParameters struct {
	Name        *string           `json:"name,omitempty"`
	Description *string           `json:"description,omitempty"`
	Type        GroupTypeContract `json:"type,omitempty"`
	ExternalID  *string           `json:"externalId,omitempty"`
}

// HostnameConfiguration is custom hostname configuration.
type HostnameConfiguration struct {
	Type        HostnameType            `json:"type,omitempty"`
	Hostname    *string                 `json:"hostname,omitempty"`
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// IdentityProviderContract is the external Identity Providers like Facebook,
// Google, Microsoft, Twitter or Azure Active Directory which can be used to
// enable access to the API Management service developer portal for all users.
type IdentityProviderContract struct {
	autorest.Response `json:"-"`
	ClientID          *string                  `json:"clientId,omitempty"`
	ClientSecret      *string                  `json:"clientSecret,omitempty"`
	Type              IdentityProviderNameType `json:"type,omitempty"`
	AllowedTenants    *[]string                `json:"allowedTenants,omitempty"`
}

// IdentityProviderList is list of all the Identity Providers configured on the
// service instance.
type IdentityProviderList struct {
	autorest.Response `json:"-"`
	Value             *[]IdentityProviderContract `json:"value,omitempty"`
}

// IdentityProviderUpdateParameters is parameters supplied to the Update
// Identity Provider operation.
type IdentityProviderUpdateParameters struct {
	ClientID       *string   `json:"clientId,omitempty"`
	ClientSecret   *string   `json:"clientSecret,omitempty"`
	AllowedTenants *[]string `json:"allowedTenants,omitempty"`
}

// LoggerCollection is paged Logger list representation.
type LoggerCollection struct {
	autorest.Response `json:"-"`
	Value             *[]LoggerResponse `json:"value,omitempty"`
	Count             *int64            `json:"count,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// LoggerCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LoggerCollection) LoggerCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LoggerCreateParameters is parameters supplied to the Create Logger
// operation.
type LoggerCreateParameters struct {
	Type        *string             `json:"type,omitempty"`
	Description *string             `json:"description,omitempty"`
	Credentials *map[string]*string `json:"credentials,omitempty"`
	IsBuffered  *bool               `json:"isBuffered,omitempty"`
}

// LoggerResponse is the Logger entity in API Management represents an event
// sink that you can use to log API Management events. Currently the Logger
// entity supports logging API Management events to Azure Event Hubs.
type LoggerResponse struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Description       *string             `json:"description,omitempty"`
	Credentials       *map[string]*string `json:"credentials,omitempty"`
	IsBuffered        *bool               `json:"isBuffered,omitempty"`
}

// LoggerUpdateParameters is parameters supplied to the Update Logger
// operation.
type LoggerUpdateParameters struct {
	Type        *string             `json:"type,omitempty"`
	Description *string             `json:"description,omitempty"`
	Credentials *map[string]*string `json:"credentials,omitempty"`
	IsBuffered  *bool               `json:"isBuffered,omitempty"`
}

// NetworkStatusContract is network Status details.
type NetworkStatusContract struct {
	autorest.Response  `json:"-"`
	DNSServers         *[]string                     `json:"dnsServers,omitempty"`
	ConnectivityStatus *[]ConnectivityStatusContract `json:"connectivityStatus,omitempty"`
}

// OAuth2AuthenticationSettingsContract is aPI OAuth2 Authentication settings
// details.
type OAuth2AuthenticationSettingsContract struct {
	AuthorizationServerID *string `json:"authorizationServerId,omitempty"`
	Scope                 *string `json:"scope,omitempty"`
}

// OAuth2AuthorizationServerContract is external OAuth authorization server
// settings.
type OAuth2AuthorizationServerContract struct {
	autorest.Response          `json:"-"`
	ID                         *string                               `json:"id,omitempty"`
	Name                       *string                               `json:"name,omitempty"`
	Description                *string                               `json:"description,omitempty"`
	ClientRegistrationEndpoint *string                               `json:"clientRegistrationEndpoint,omitempty"`
	AuthorizationEndpoint      *string                               `json:"authorizationEndpoint,omitempty"`
	AuthorizationMethods       *[]MethodContract                     `json:"authorizationMethods,omitempty"`
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	TokenBodyParameters        *[]TokenBodyParameterContract         `json:"tokenBodyParameters,omitempty"`
	TokenEndpoint              *string                               `json:"tokenEndpoint,omitempty"`
	SupportState               *bool                                 `json:"supportState,omitempty"`
	DefaultScope               *string                               `json:"defaultScope,omitempty"`
	GrantTypes                 *[]GrantTypesContract                 `json:"grantTypes,omitempty"`
	BearerTokenSendingMethods  *[]BearerTokenSendingMethodsContract  `json:"bearerTokenSendingMethods,omitempty"`
	ClientID                   *string                               `json:"clientId,omitempty"`
	ClientSecret               *string                               `json:"clientSecret,omitempty"`
	ResourceOwnerUsername      *string                               `json:"resourceOwnerUsername,omitempty"`
	ResourceOwnerPassword      *string                               `json:"resourceOwnerPassword,omitempty"`
}

// OAuth2AuthorizationServerUpdateContract is external OAuth authorization
// server Update settings contract.
type OAuth2AuthorizationServerUpdateContract struct {
	Name                       *string                               `json:"name,omitempty"`
	Description                *string                               `json:"description,omitempty"`
	ClientRegistrationEndpoint *string                               `json:"clientRegistrationEndpoint,omitempty"`
	AuthorizationEndpoint      *string                               `json:"authorizationEndpoint,omitempty"`
	AuthorizationMethods       *[]MethodContract                     `json:"authorizationMethods,omitempty"`
	ClientAuthenticationMethod *[]ClientAuthenticationMethodContract `json:"clientAuthenticationMethod,omitempty"`
	TokenBodyParameters        *[]TokenBodyParameterContract         `json:"tokenBodyParameters,omitempty"`
	TokenEndpoint              *string                               `json:"tokenEndpoint,omitempty"`
	SupportState               *bool                                 `json:"supportState,omitempty"`
	DefaultScope               *string                               `json:"defaultScope,omitempty"`
	GrantTypes                 *[]GrantTypesContract                 `json:"grantTypes,omitempty"`
	BearerTokenSendingMethods  *[]BearerTokenSendingMethodsContract  `json:"bearerTokenSendingMethods,omitempty"`
	ClientID                   *string                               `json:"clientId,omitempty"`
	ClientSecret               *string                               `json:"clientSecret,omitempty"`
	ResourceOwnerUsername      *string                               `json:"resourceOwnerUsername,omitempty"`
	ResourceOwnerPassword      *string                               `json:"resourceOwnerPassword,omitempty"`
}

// OpenIDConnectProviderCollection is paged OpenIdProviders list
// representation.
type OpenIDConnectProviderCollection struct {
	autorest.Response `json:"-"`
	Value             *[]OpenidConnectProviderContract `json:"value,omitempty"`
	Count             *int64                           `json:"count,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// OpenIDConnectProviderCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OpenIDConnectProviderCollection) OpenIDConnectProviderCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OpenidConnectProviderContract is openID Connect Providers Contract.
type OpenidConnectProviderContract struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Description       *string `json:"description,omitempty"`
	MetadataEndpoint  *string `json:"metadataEndpoint,omitempty"`
	ClientID          *string `json:"clientId,omitempty"`
	ClientSecret      *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderCreateContract is parameters supplied to the Create
// OpenID Connect Provider operation.
type OpenidConnectProviderCreateContract struct {
	Name             *string `json:"name,omitempty"`
	Description      *string `json:"description,omitempty"`
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	ClientID         *string `json:"clientId,omitempty"`
	ClientSecret     *string `json:"clientSecret,omitempty"`
}

// OpenidConnectProviderUpdateContract is parameters supplied to the Update
// OpenID Connect Provider operation.
type OpenidConnectProviderUpdateContract struct {
	Name             *string `json:"name,omitempty"`
	Description      *string `json:"description,omitempty"`
	MetadataEndpoint *string `json:"metadataEndpoint,omitempty"`
	ClientID         *string `json:"clientId,omitempty"`
	ClientSecret     *string `json:"clientSecret,omitempty"`
}

// Operation is rEST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is the object that describes the operation.
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationCollection is paged Operation list representation.
type OperationCollection struct {
	autorest.Response `json:"-"`
	Value             *[]OperationContract `json:"value,omitempty"`
	Count             *int64               `json:"count,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// OperationCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationCollection) OperationCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OperationContract is api Operation details.
type OperationContract struct {
	autorest.Response  `json:"-"`
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	Description        *string              `json:"description,omitempty"`
	Request            *RequestContract     `json:"request,omitempty"`
	Responses          *[]ResultContract    `json:"responses,omitempty"`
	ID                 *string              `json:"id,omitempty"`
	Name               *string              `json:"name,omitempty"`
	Method             *string              `json:"method,omitempty"`
	URLTemplate        *string              `json:"urlTemplate,omitempty"`
}

// OperationEntityBaseContract is api Operation Entity Base Contract details.
type OperationEntityBaseContract struct {
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	Description        *string              `json:"description,omitempty"`
	Request            *RequestContract     `json:"request,omitempty"`
	Responses          *[]ResultContract    `json:"responses,omitempty"`
}

// OperationListResult is result of the request to list REST API operations. It
// contains a list of operations and a URL nextLink to get the next set of
// results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OperationResultContract is operation Result.
type OperationResultContract struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Status            AsyncOperationState `json:"status,omitempty"`
	Started           *date.Time          `json:"started,omitempty"`
	Updated           *date.Time          `json:"updated,omitempty"`
	ResultInfo        *string             `json:"resultInfo,omitempty"`
	Error             *ErrorBodyContract  `json:"error,omitempty"`
}

// OperationUpdateContract is api Operation Update Contract details.
type OperationUpdateContract struct {
	TemplateParameters *[]ParameterContract `json:"templateParameters,omitempty"`
	Description        *string              `json:"description,omitempty"`
	Request            *RequestContract     `json:"request,omitempty"`
	Responses          *[]ResultContract    `json:"responses,omitempty"`
	ID                 *string              `json:"id,omitempty"`
	Name               *string              `json:"name,omitempty"`
	Method             *string              `json:"method,omitempty"`
	URLTemplate        *string              `json:"urlTemplate,omitempty"`
}

// ParameterContract is operation parameters details.
type ParameterContract struct {
	Name         *string   `json:"name,omitempty"`
	Description  *string   `json:"description,omitempty"`
	Type         *string   `json:"type,omitempty"`
	DefaultValue *string   `json:"defaultValue,omitempty"`
	Required     *bool     `json:"required,omitempty"`
	Values       *[]string `json:"values,omitempty"`
}

// PolicySnippetContract is policy snippet.
type PolicySnippetContract struct {
	Name    *string             `json:"name,omitempty"`
	Content *string             `json:"content,omitempty"`
	ToolTip *string             `json:"toolTip,omitempty"`
	Scope   PolicyScopeContract `json:"scope,omitempty"`
}

// PolicySnippetsCollection is the response of the list policy snippets
// operation.
type PolicySnippetsCollection struct {
	autorest.Response `json:"-"`
	Value             *[]PolicySnippetContract `json:"value,omitempty"`
}

// ProductCollection is paged Products list representation.
type ProductCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProductContract `json:"value,omitempty"`
	Count             *int64             `json:"count,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// ProductCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProductCollection) ProductCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProductContract is product profile.
type ProductContract struct {
	autorest.Response    `json:"-"`
	ID                   *string              `json:"id,omitempty"`
	Name                 *string              `json:"name,omitempty"`
	Description          *string              `json:"description,omitempty"`
	Terms                *string              `json:"terms,omitempty"`
	SubscriptionRequired *bool                `json:"subscriptionRequired,omitempty"`
	ApprovalRequired     *bool                `json:"approvalRequired,omitempty"`
	SubscriptionsLimit   *int32               `json:"subscriptionsLimit,omitempty"`
	State                ProductStateContract `json:"state,omitempty"`
}

// ProductUpdateParameters is parameters supplied to the CreateOrUpdate Product
// operation.
type ProductUpdateParameters struct {
	Name                 *string              `json:"name,omitempty"`
	Description          *string              `json:"description,omitempty"`
	Terms                *string              `json:"terms,omitempty"`
	SubscriptionRequired *bool                `json:"subscriptionRequired,omitempty"`
	ApprovalRequired     *bool                `json:"approvalRequired,omitempty"`
	SubscriptionsLimit   *int32               `json:"subscriptionsLimit,omitempty"`
	State                ProductStateContract `json:"state,omitempty"`
}

// PropertyCollection is paged Property list representation.
type PropertyCollection struct {
	autorest.Response `json:"-"`
	Value             *[]PropertyContract `json:"value,omitempty"`
	Count             *int64              `json:"count,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// PropertyCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PropertyCollection) PropertyCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PropertyContract is property details.
type PropertyContract struct {
	autorest.Response `json:"-"`
	ID                *string   `json:"id,omitempty"`
	Name              *string   `json:"name,omitempty"`
	Value             *string   `json:"value,omitempty"`
	Tags              *[]string `json:"tags,omitempty"`
	Secret            *bool     `json:"secret,omitempty"`
}

// PropertyCreateParameters is parameters supplied to the Create Property
// operation.
type PropertyCreateParameters struct {
	Name   *string   `json:"name,omitempty"`
	Value  *string   `json:"value,omitempty"`
	Tags   *[]string `json:"tags,omitempty"`
	Secret *bool     `json:"secret,omitempty"`
}

// PropertyUpdateParameters is parameters supplied to the Update Property
// operation.
type PropertyUpdateParameters struct {
	Name   *string   `json:"name,omitempty"`
	Value  *string   `json:"value,omitempty"`
	Tags   *[]string `json:"tags,omitempty"`
	Secret *bool     `json:"secret,omitempty"`
}

// QuotaCounterCollection is paged Quota Counter list representation.
type QuotaCounterCollection struct {
	autorest.Response `json:"-"`
	Value             *[]QuotaCounterContract `json:"value,omitempty"`
	Count             *int64                  `json:"count,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// QuotaCounterContract is quota counter details.
type QuotaCounterContract struct {
	autorest.Response `json:"-"`
	CallsCount        *int32     `json:"callsCount,omitempty"`
	KbTransferred     *float64   `json:"kbTransferred,omitempty"`
	CounterKey        *string    `json:"counterKey,omitempty"`
	PeriodKey         *string    `json:"periodKey,omitempty"`
	PeriodStartTime   *date.Time `json:"periodStartTime,omitempty"`
	PeriodEndTime     *date.Time `json:"periodEndTime,omitempty"`
}

// QuotaCounterValueContract is quota counter value details.
type QuotaCounterValueContract struct {
	CallsCount    *int32   `json:"callsCount,omitempty"`
	KbTransferred *float64 `json:"kbTransferred,omitempty"`
}

// ReadCloser is
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RegionContract is region profile.
type RegionContract struct {
	Name           *string `json:"name,omitempty"`
	IsMasterRegion *bool   `json:"isMasterRegion,omitempty"`
}

// RegionListResult is lists Regions operation response details.
type RegionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RegionContract `json:"value,omitempty"`
}

// ReportCollection is paged Report records list representation.
type ReportCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ReportRecordContract `json:"value,omitempty"`
	Count             *int64                  `json:"count,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// ReportCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ReportCollection) ReportCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ReportRecordContract is report data.
type ReportRecordContract struct {
	Name             *string    `json:"name,omitempty"`
	Timestamp        *date.Time `json:"timestamp,omitempty"`
	Interval         *int64     `json:"interval,omitempty"`
	Country          *string    `json:"country,omitempty"`
	Region           *string    `json:"region,omitempty"`
	Zip              *string    `json:"zip,omitempty"`
	UserID           *string    `json:"userId,omitempty"`
	ProductID        *string    `json:"productId,omitempty"`
	APIID            *string    `json:"apiId,omitempty"`
	OperationID      *string    `json:"operationId,omitempty"`
	APIRegion        *string    `json:"apiRegion,omitempty"`
	SubscriptionID   *string    `json:"subscriptionId,omitempty"`
	CallCountSuccess *int32     `json:"callCountSuccess,omitempty"`
	CallCountBlocked *int32     `json:"callCountBlocked,omitempty"`
	CallCountFailed  *int32     `json:"callCountFailed,omitempty"`
	CallCountOther   *int32     `json:"callCountOther,omitempty"`
	CallCountTotal   *int32     `json:"callCountTotal,omitempty"`
	Bandwidth        *int64     `json:"bandwidth,omitempty"`
	CacheHitCount    *int32     `json:"cacheHitCount,omitempty"`
	CacheMissCount   *int32     `json:"cacheMissCount,omitempty"`
	APITimeAvg       *float64   `json:"apiTimeAvg,omitempty"`
	APITimeMin       *float64   `json:"apiTimeMin,omitempty"`
	APITimeMax       *float64   `json:"apiTimeMax,omitempty"`
	ServiceTimeAvg   *float64   `json:"serviceTimeAvg,omitempty"`
	ServiceTimeMin   *float64   `json:"serviceTimeMin,omitempty"`
	ServiceTimeMax   *float64   `json:"serviceTimeMax,omitempty"`
}

// RepresentationContract is operation request/response representation details.
type RepresentationContract struct {
	ContentType *string `json:"contentType,omitempty"`
	Sample      *string `json:"sample,omitempty"`
}

// RequestContract is operation request details.
type RequestContract struct {
	Description     *string                   `json:"description,omitempty"`
	QueryParameters *[]ParameterContract      `json:"queryParameters,omitempty"`
	Headers         *[]ParameterContract      `json:"headers,omitempty"`
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// Resource is the Resource definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResultContract is operation response details.
type ResultContract struct {
	StatusCode      *int32                    `json:"statusCode,omitempty"`
	Description     *string                   `json:"description,omitempty"`
	Representations *[]RepresentationContract `json:"representations,omitempty"`
}

// SaveConfigurationParameter is parameters supplied to the Save Tenant
// Configuration operation.
type SaveConfigurationParameter struct {
	Branch *string `json:"branch,omitempty"`
	Force  *bool   `json:"force,omitempty"`
}

// ServiceBackupRestoreParameters is parameters supplied to the Backup/Restore
// of an API Management service operation.
type ServiceBackupRestoreParameters struct {
	StorageAccount *string `json:"storageAccount,omitempty"`
	AccessKey      *string `json:"accessKey,omitempty"`
	ContainerName  *string `json:"containerName,omitempty"`
	BackupName     *string `json:"backupName,omitempty"`
}

// ServiceCheckNameAvailabilityParameters is parameters supplied to the
// CheckNameAvailability operation.
type ServiceCheckNameAvailabilityParameters struct {
	Name *string `json:"name,omitempty"`
}

// ServiceGetSsoTokenResult is the response of the GetSsoToken operation.
type ServiceGetSsoTokenResult struct {
	autorest.Response `json:"-"`
	RedirectURI       *string `json:"redirect_uri,omitempty"`
}

// ServiceListResult is the response of the List API Management services
// operation.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceResource `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// ServiceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ServiceListResult) ServiceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ServiceManageDeploymentsParameters is parameters supplied to the
// ManageDeployments operation.
type ServiceManageDeploymentsParameters struct {
	Location            *string                      `json:"location,omitempty"`
	SkuType             SkuType                      `json:"skuType,omitempty"`
	SkuUnitCount        *int32                       `json:"skuUnitCount,omitempty"`
	AdditionalLocations *[]AdditionalRegion          `json:"additionalLocations,omitempty"`
	VpnConfiguration    *VirtualNetworkConfiguration `json:"vpnConfiguration,omitempty"`
	VpnType             VirtualNetworkType           `json:"vpnType,omitempty"`
}

// ServiceNameAvailabilityResult is response of the CheckNameAvailability
// operation.
type ServiceNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool                  `json:"nameAvailable,omitempty"`
	Message           *string                `json:"message,omitempty"`
	Reason            NameAvailabilityReason `json:"reason,omitempty"`
}

// ServiceProperties is properties of an API Management service resource
// description.
type ServiceProperties struct {
	PublisherEmail          *string                      `json:"publisherEmail,omitempty"`
	PublisherName           *string                      `json:"publisherName,omitempty"`
	ProvisioningState       *string                      `json:"provisioningState,omitempty"`
	TargetProvisioningState *string                      `json:"targetProvisioningState,omitempty"`
	CreatedAtUtc            *date.Time                   `json:"createdAtUtc,omitempty"`
	RuntimeURL              *string                      `json:"runtimeUrl,omitempty"`
	PortalURL               *string                      `json:"portalUrl,omitempty"`
	ManagementAPIURL        *string                      `json:"managementApiUrl,omitempty"`
	ScmURL                  *string                      `json:"scmUrl,omitempty"`
	AddresserEmail          *string                      `json:"addresserEmail,omitempty"`
	HostnameConfigurations  *[]HostnameConfiguration     `json:"hostnameConfigurations,omitempty"`
	StaticIPs               *[]string                    `json:"staticIPs,omitempty"`
	Vpnconfiguration        *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
	AdditionalLocations     *[]AdditionalRegion          `json:"additionalLocations,omitempty"`
	CustomProperties        *map[string]*string          `json:"customProperties,omitempty"`
	VpnType                 VirtualNetworkType           `json:"vpnType,omitempty"`
}

// ServiceResource is a single API Management service resource in List or Get
// response.
type ServiceResource struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*ServiceProperties `json:"properties,omitempty"`
	Sku                *ServiceSkuProperties `json:"sku,omitempty"`
	Etag               *string               `json:"etag,omitempty"`
}

// ServiceSkuProperties is aPI Management service resource SKU properties.
type ServiceSkuProperties struct {
	Name     SkuType `json:"name,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// ServiceUpdateHostnameParameters is parameters supplied to the UpdateHostname
// operation.
type ServiceUpdateHostnameParameters struct {
	Update *[]HostnameConfiguration `json:"update,omitempty"`
	Delete *[]HostnameType          `json:"delete,omitempty"`
}

// ServiceUpdateParameters is parameters supplied to the Update API Management
// service operation.
type ServiceUpdateParameters struct {
	*ServiceProperties `json:"properties,omitempty"`
	Sku                *ServiceSkuProperties `json:"sku,omitempty"`
	Tags               *map[string]*string   `json:"tags,omitempty"`
}

// ServiceUploadCertificateParameters is parameters supplied to the Upload SSL
// certificate for an API Management service operation.
type ServiceUploadCertificateParameters struct {
	Type                HostnameType `json:"type,omitempty"`
	Certificate         *string      `json:"certificate,omitempty"`
	CertificatePassword *string      `json:"certificate_password,omitempty"`
}

// SubscriptionCollection is paged Subscriptions list representation.
type SubscriptionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SubscriptionContract `json:"value,omitempty"`
	Count             *int64                  `json:"count,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// SubscriptionCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SubscriptionCollection) SubscriptionCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SubscriptionContract is subscription details.
type SubscriptionContract struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	UserID            *string                   `json:"userId,omitempty"`
	ProductID         *string                   `json:"productId,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	State             SubscriptionStateContract `json:"state,omitempty"`
	CreatedDate       *date.Time                `json:"createdDate,omitempty"`
	StartDate         *date.Time                `json:"startDate,omitempty"`
	ExpirationDate    *date.Time                `json:"expirationDate,omitempty"`
	EndDate           *date.Time                `json:"endDate,omitempty"`
	NotificationDate  *date.Time                `json:"notificationDate,omitempty"`
	PrimaryKey        *string                   `json:"primaryKey,omitempty"`
	SecondaryKey      *string                   `json:"secondaryKey,omitempty"`
	StateComment      *string                   `json:"stateComment,omitempty"`
}

// SubscriptionCreateParameters is parameters supplied to the Create
// subscription operation.
type SubscriptionCreateParameters struct {
	UserID       *string                   `json:"userId,omitempty"`
	ProductID    *string                   `json:"productId,omitempty"`
	Name         *string                   `json:"name,omitempty"`
	PrimaryKey   *string                   `json:"primaryKey,omitempty"`
	SecondaryKey *string                   `json:"secondaryKey,omitempty"`
	State        SubscriptionStateContract `json:"state,omitempty"`
}

// SubscriptionKeyParameterNamesContract is subscription key parameter names
// details.
type SubscriptionKeyParameterNamesContract struct {
	Header *string `json:"header,omitempty"`
	Query  *string `json:"query,omitempty"`
}

// SubscriptionUpdateParameters is parameters supplied to the Update
// subscription operation.
type SubscriptionUpdateParameters struct {
	UserID         *string                   `json:"userId,omitempty"`
	ProductID      *string                   `json:"productId,omitempty"`
	ExpirationDate *date.Time                `json:"expirationDate,omitempty"`
	Name           *string                   `json:"name,omitempty"`
	PrimaryKey     *string                   `json:"primaryKey,omitempty"`
	SecondaryKey   *string                   `json:"secondaryKey,omitempty"`
	State          SubscriptionStateContract `json:"state,omitempty"`
	StateComment   *string                   `json:"stateComment,omitempty"`
}

// TenantConfigurationSyncStateContract is tenant Configuration Synchronization
// State.
type TenantConfigurationSyncStateContract struct {
	autorest.Response       `json:"-"`
	Branch                  *string    `json:"branch,omitempty"`
	CommitID                *string    `json:"commitId,omitempty"`
	IsExport                *bool      `json:"isExport,omitempty"`
	IsSynced                *bool      `json:"isSynced,omitempty"`
	IsGitEnabled            *bool      `json:"isGitEnabled,omitempty"`
	SyncDate                *date.Time `json:"syncDate,omitempty"`
	ConfigurationChangeDate *date.Time `json:"configurationChangeDate,omitempty"`
}

// TokenBodyParameterContract is oAuth acquire token request body parameter
// (www-url-form-encoded).
type TokenBodyParameterContract struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// UserCollection is paged Users list representation.
type UserCollection struct {
	autorest.Response `json:"-"`
	Value             *[]UserContract `json:"value,omitempty"`
	Count             *int64          `json:"count,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// UserCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client UserCollection) UserCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// UserContract is user profile.
type UserContract struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	FirstName         *string                 `json:"firstName,omitempty"`
	LastName          *string                 `json:"lastName,omitempty"`
	Email             *string                 `json:"email,omitempty"`
	State             UserStateContract       `json:"state,omitempty"`
	RegistrationDate  *date.Time              `json:"registrationDate,omitempty"`
	Note              *string                 `json:"note,omitempty"`
	Identities        *[]UserIdentityContract `json:"identities,omitempty"`
}

// UserCreateParameters is parameters supplied to the Create User operation.
type UserCreateParameters struct {
	Email     *string           `json:"email,omitempty"`
	Password  *string           `json:"password,omitempty"`
	FirstName *string           `json:"firstName,omitempty"`
	LastName  *string           `json:"lastName,omitempty"`
	State     UserStateContract `json:"state,omitempty"`
	Note      *string           `json:"note,omitempty"`
}

// UserIdentityCollection is list of Users Identity list representation.
type UserIdentityCollection struct {
	autorest.Response `json:"-"`
	Value             *[]UserIdentityContract `json:"value,omitempty"`
}

// UserIdentityContract is user identity details.
type UserIdentityContract struct {
	Provider *string `json:"provider,omitempty"`
	ID       *string `json:"id,omitempty"`
}

// UserUpdateParameters is parameters supplied to the Update User operation.
type UserUpdateParameters struct {
	Email     *string           `json:"email,omitempty"`
	Password  *string           `json:"password,omitempty"`
	FirstName *string           `json:"firstName,omitempty"`
	LastName  *string           `json:"lastName,omitempty"`
	State     UserStateContract `json:"state,omitempty"`
	Note      *string           `json:"note,omitempty"`
}

// VirtualNetworkConfiguration is configuration of a virtual network to which
// API Management service is deployed.
type VirtualNetworkConfiguration struct {
	Vnetid           *string `json:"vnetid,omitempty"`
	Subnetname       *string `json:"subnetname,omitempty"`
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
	Location         *string `json:"location,omitempty"`
}
