# gorilla/mux instrumentation example

An HTTP server using gorilla/mux and instrumentation. The server has a
`/users/{id:[0-9]+}` endpoint. The server generates span information to
`stdout`.

These instructions expect you have
[docker-compose](https://docs.docker.com/compose/) installed.

Bring up the `mux-server` and `mux-client` services to run the
example:

```sh
docker-compose up --detach mux-server mux-client
```

The `mux-client` service sends just one HTTP request to `mux-server`
and then exits. View the span generated by `mux-server` in the logs:

```sh
docker-compose logs mux-server
```

Shut down the services when you are finished with the example:

```sh
docker-compose down
```
