package datacollection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/monitor/mgmt/2021-09-01-preview/datacollection"

// AzureMonitorMetricsDestination azure Monitor Metrics destination.
type AzureMonitorMetricsDestination struct {
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// ColumnDefinition definition of custom data column.
type ColumnDefinition struct {
	// Name - The name of the column.
	Name *string `json:"name,omitempty"`
	// Type - The type of the column data. Possible values include: 'KnownColumnDefinitionTypeString', 'KnownColumnDefinitionTypeInt', 'KnownColumnDefinitionTypeLong', 'KnownColumnDefinitionTypeReal', 'KnownColumnDefinitionTypeBoolean', 'KnownColumnDefinitionTypeDatetime', 'KnownColumnDefinitionTypeDynamic'
	Type KnownColumnDefinitionType `json:"type,omitempty"`
}

// ConfigurationAccessEndpointSpec definition of the endpoint used for accessing configuration.
type ConfigurationAccessEndpointSpec struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationAccessEndpointSpec.
func (caes ConfigurationAccessEndpointSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataFlow definition of which streams are sent to which destinations.
type DataFlow struct {
	// Streams - List of streams for this data flow.
	Streams *[]KnownDataFlowStreams `json:"streams,omitempty"`
	// Destinations - List of destinations for this data flow.
	Destinations *[]string `json:"destinations,omitempty"`
	// TransformKql - The KQL query to transform stream data.
	TransformKql *string `json:"transformKql,omitempty"`
	// OutputStream - The output stream of the transform. Only required if the transform changes data to a different stream.
	OutputStream *string `json:"outputStream,omitempty"`
}

// DataSourcesSpec specification of data sources that will be collected.
type DataSourcesSpec struct {
	// PerformanceCounters - The list of performance counter data source configurations.
	PerformanceCounters *[]PerfCounterDataSource `json:"performanceCounters,omitempty"`
	// WindowsEventLogs - The list of Windows Event Log data source configurations.
	WindowsEventLogs *[]WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
	// Syslog - The list of Syslog data source configurations.
	Syslog *[]SyslogDataSource `json:"syslog,omitempty"`
	// Extensions - The list of Azure VM extension data source configurations.
	Extensions *[]ExtensionDataSource `json:"extensions,omitempty"`
	// LogFiles - The list of Log files source configurations.
	LogFiles *[]LogFilesDataSource `json:"logFiles,omitempty"`
	// IisLogs - The list of IIS logs source configurations.
	IisLogs *[]IisLogsDataSource `json:"iisLogs,omitempty"`
}

// DestinationsSpec specification of destinations that can be used in data flows.
type DestinationsSpec struct {
	// LogAnalytics - List of Log Analytics destinations.
	LogAnalytics *[]LogAnalyticsDestination `json:"logAnalytics,omitempty"`
	// AzureMonitorMetrics - Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`
}

// DestinationsSpecAzureMonitorMetrics azure Monitor Metrics destination.
type DestinationsSpecAzureMonitorMetrics struct {
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// Endpoint definition of data collection endpoint.
type Endpoint struct {
	// Description - Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`
	// ImmutableID - The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// ConfigurationAccess - The endpoint used by clients to access their configuration.
	ConfigurationAccess *EndpointConfigurationAccess `json:"configurationAccess,omitempty"`
	// LogsIngestion - The endpoint used by clients to ingest logs.
	LogsIngestion *EndpointLogsIngestion `json:"logsIngestion,omitempty"`
	// NetworkAcls - Network access control rules for the endpoints.
	NetworkAcls *EndpointNetworkAcls `json:"networkAcls,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. This property is READ-ONLY. Possible values include: 'KnownDataCollectionEndpointProvisioningStateCreating', 'KnownDataCollectionEndpointProvisioningStateUpdating', 'KnownDataCollectionEndpointProvisioningStateDeleting', 'KnownDataCollectionEndpointProvisioningStateSucceeded', 'KnownDataCollectionEndpointProvisioningStateFailed'
	ProvisioningState KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.Description != nil {
		objectMap["description"] = e.Description
	}
	if e.ImmutableID != nil {
		objectMap["immutableId"] = e.ImmutableID
	}
	if e.ConfigurationAccess != nil {
		objectMap["configurationAccess"] = e.ConfigurationAccess
	}
	if e.LogsIngestion != nil {
		objectMap["logsIngestion"] = e.LogsIngestion
	}
	if e.NetworkAcls != nil {
		objectMap["networkAcls"] = e.NetworkAcls
	}
	return json.Marshal(objectMap)
}

// EndpointConfigurationAccess the endpoint used by clients to access their configuration.
type EndpointConfigurationAccess struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointConfigurationAccess.
func (eA EndpointConfigurationAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EndpointLogsIngestion the endpoint used by clients to ingest logs.
type EndpointLogsIngestion struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointLogsIngestion.
func (eI EndpointLogsIngestion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EndpointNetworkAcls network access control rules for the endpoints.
type EndpointNetworkAcls struct {
	// PublicNetworkAccess - The configuration to set whether network access from public internet to the endpoints are allowed. Possible values include: 'KnownPublicNetworkAccessOptionsEnabled', 'KnownPublicNetworkAccessOptionsDisabled'
	PublicNetworkAccess KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// EndpointResource definition of ARM tracked top level resource.
type EndpointResource struct {
	autorest.Response `json:"-"`
	// EndpointResourceProperties - Resource properties.
	*EndpointResourceProperties `json:"properties,omitempty"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Kind - The kind of the resource. Possible values include: 'KnownDataCollectionEndpointResourceKindLinux', 'KnownDataCollectionEndpointResourceKindWindows'
	Kind KnownDataCollectionEndpointResourceKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *EndpointResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointResource.
func (er EndpointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.EndpointResourceProperties != nil {
		objectMap["properties"] = er.EndpointResourceProperties
	}
	if er.Location != nil {
		objectMap["location"] = er.Location
	}
	if er.Tags != nil {
		objectMap["tags"] = er.Tags
	}
	if er.Kind != "" {
		objectMap["kind"] = er.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointResource struct.
func (er *EndpointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointResourceProperties EndpointResourceProperties
				err = json.Unmarshal(*v, &endpointResourceProperties)
				if err != nil {
					return err
				}
				er.EndpointResourceProperties = &endpointResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				er.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				er.Tags = tags
			}
		case "kind":
			if v != nil {
				var kind KnownDataCollectionEndpointResourceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				er.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				er.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				er.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				er.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				er.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData EndpointResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				er.SystemData = &systemData
			}
		}
	}

	return nil
}

// EndpointResourceListResult a pageable list of resources.
type EndpointResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]EndpointResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointResourceListResultIterator provides access to a complete listing of EndpointResource values.
type EndpointResourceListResultIterator struct {
	i    int
	page EndpointResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointResourceListResultIterator) Response() EndpointResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointResourceListResultIterator) Value() EndpointResource {
	if !iter.page.NotDone() {
		return EndpointResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointResourceListResultIterator type.
func NewEndpointResourceListResultIterator(page EndpointResourceListResultPage) EndpointResourceListResultIterator {
	return EndpointResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erlr EndpointResourceListResult) IsEmpty() bool {
	return erlr.Value == nil || len(*erlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erlr EndpointResourceListResult) hasNextLink() bool {
	return erlr.NextLink != nil && len(*erlr.NextLink) != 0
}

// endpointResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erlr EndpointResourceListResult) endpointResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erlr.NextLink)))
}

// EndpointResourceListResultPage contains a page of EndpointResource values.
type EndpointResourceListResultPage struct {
	fn   func(context.Context, EndpointResourceListResult) (EndpointResourceListResult, error)
	erlr EndpointResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erlr)
		if err != nil {
			return err
		}
		page.erlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointResourceListResultPage) NotDone() bool {
	return !page.erlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointResourceListResultPage) Response() EndpointResourceListResult {
	return page.erlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointResourceListResultPage) Values() []EndpointResource {
	if page.erlr.IsEmpty() {
		return nil
	}
	return *page.erlr.Value
}

// Creates a new instance of the EndpointResourceListResultPage type.
func NewEndpointResourceListResultPage(cur EndpointResourceListResult, getNextPage func(context.Context, EndpointResourceListResult) (EndpointResourceListResult, error)) EndpointResourceListResultPage {
	return EndpointResourceListResultPage{
		fn:   getNextPage,
		erlr: cur,
	}
}

// EndpointResourceProperties resource properties.
type EndpointResourceProperties struct {
	// Description - Description of the data collection endpoint.
	Description *string `json:"description,omitempty"`
	// ImmutableID - The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// ConfigurationAccess - The endpoint used by clients to access their configuration.
	ConfigurationAccess *EndpointConfigurationAccess `json:"configurationAccess,omitempty"`
	// LogsIngestion - The endpoint used by clients to ingest logs.
	LogsIngestion *EndpointLogsIngestion `json:"logsIngestion,omitempty"`
	// NetworkAcls - Network access control rules for the endpoints.
	NetworkAcls *EndpointNetworkAcls `json:"networkAcls,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. This property is READ-ONLY. Possible values include: 'KnownDataCollectionEndpointProvisioningStateCreating', 'KnownDataCollectionEndpointProvisioningStateUpdating', 'KnownDataCollectionEndpointProvisioningStateDeleting', 'KnownDataCollectionEndpointProvisioningStateSucceeded', 'KnownDataCollectionEndpointProvisioningStateFailed'
	ProvisioningState KnownDataCollectionEndpointProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointResourceProperties.
func (er EndpointResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.Description != nil {
		objectMap["description"] = er.Description
	}
	if er.ImmutableID != nil {
		objectMap["immutableId"] = er.ImmutableID
	}
	if er.ConfigurationAccess != nil {
		objectMap["configurationAccess"] = er.ConfigurationAccess
	}
	if er.LogsIngestion != nil {
		objectMap["logsIngestion"] = er.LogsIngestion
	}
	if er.NetworkAcls != nil {
		objectMap["networkAcls"] = er.NetworkAcls
	}
	return json.Marshal(objectMap)
}

// EndpointResourceSystemData metadata pertaining to creation and last modification of the resource.
type EndpointResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponseCommonV2 common error response for all Azure Resource Manager APIs to return error details
// for failed operations. (This also follows the OData error response format.).
type ErrorResponseCommonV2 struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExtensionDataSource definition of which data will be collected from a separate VM extension that
// integrates with the Azure Monitor Agent.
// Collected from either Windows and Linux machines, depending on which extension is defined.
type ExtensionDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownExtensionDataSourceStreams `json:"streams,omitempty"`
	// ExtensionName - The name of the VM extension.
	ExtensionName *string `json:"extensionName,omitempty"`
	// ExtensionSettings - The extension settings. The format is specific for particular extension.
	ExtensionSettings interface{} `json:"extensionSettings,omitempty"`
	// InputDataSources - The list of data sources this extension needs data from.
	InputDataSources *[]string `json:"inputDataSources,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// IisLogsDataSource enables IIS logs to be collected by this data collection rule.
type IisLogsDataSource struct {
	// Streams - IIS streams
	Streams *[]string `json:"streams,omitempty"`
	// LogDirectories - Absolute paths file location
	LogDirectories *[]string `json:"logDirectories,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// LogAnalyticsDestination log Analytics destination.
type LogAnalyticsDestination struct {
	// WorkspaceResourceID - The resource ID of the Log Analytics workspace.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// WorkspaceID - READ-ONLY; The Customer ID of the Log Analytics workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Name - A friendly name for the destination.
	// This name should be unique across all destinations (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsDestination.
func (lad LogAnalyticsDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lad.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = lad.WorkspaceResourceID
	}
	if lad.Name != nil {
		objectMap["name"] = lad.Name
	}
	return json.Marshal(objectMap)
}

// LogFilesDataSource definition of which custom log files will be collected by this data collection rule
type LogFilesDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data source
	Streams *[]string `json:"streams,omitempty"`
	// FilePatterns - File Patterns where the log files are located
	FilePatterns *[]string `json:"filePatterns,omitempty"`
	// Format - The data format of the log files
	Format *string `json:"format,omitempty"`
	// Settings - The log files specific settings.
	Settings *LogFilesDataSourceSettings `json:"settings,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// LogFilesDataSourceSettings the log files specific settings.
type LogFilesDataSourceSettings struct {
	// Text - Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogFileSettings settings for different log file formats
type LogFileSettings struct {
	// Text - Text settings
	Text *LogFileSettingsText `json:"text,omitempty"`
}

// LogFileSettingsText text settings
type LogFileSettingsText struct {
	// RecordStartTimestampFormat - One of the supported timestamp formats. Possible values include: 'KnownLogFileTextSettingsRecordStartTimestampFormatISO8601', 'KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS', 'KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM', 'KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS', 'KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz', 'KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK'
	RecordStartTimestampFormat KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogFileTextSettings settings for text log files
type LogFileTextSettings struct {
	// RecordStartTimestampFormat - One of the supported timestamp formats. Possible values include: 'KnownLogFileTextSettingsRecordStartTimestampFormatISO8601', 'KnownLogFileTextSettingsRecordStartTimestampFormatYYYYMMDDHHMMSS', 'KnownLogFileTextSettingsRecordStartTimestampFormatMDYYYYHHMMSSAMPM', 'KnownLogFileTextSettingsRecordStartTimestampFormatMonDDYYYYHHMMSS', 'KnownLogFileTextSettingsRecordStartTimestampFormatYyMMddHHmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatDdMMyyHHmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatMMMdhhmmss', 'KnownLogFileTextSettingsRecordStartTimestampFormatDdMMMyyyyHHmmsszzz', 'KnownLogFileTextSettingsRecordStartTimestampFormatYyyyMMDdTHHmmssK'
	RecordStartTimestampFormat KnownLogFileTextSettingsRecordStartTimestampFormat `json:"recordStartTimestampFormat,omitempty"`
}

// LogsIngestionEndpointSpec definition of the endpoint used for ingesting logs.
type LogsIngestionEndpointSpec struct {
	// Endpoint - READ-ONLY; The endpoint. This property is READ-ONLY.
	Endpoint *string `json:"endpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for LogsIngestionEndpointSpec.
func (lies LogsIngestionEndpointSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Metadata metadata about the resource
type Metadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for Metadata.
func (mVar Metadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// NetworkRuleSet definition of the network rules.
type NetworkRuleSet struct {
	// PublicNetworkAccess - The configuration to set whether network access from public internet to the endpoints are allowed. Possible values include: 'KnownPublicNetworkAccessOptionsEnabled', 'KnownPublicNetworkAccessOptionsDisabled'
	PublicNetworkAccess KnownPublicNetworkAccessOptions `json:"publicNetworkAccess,omitempty"`
}

// PerfCounterDataSource definition of which performance counters will be collected and how they will be
// collected by this data collection rule.
// Collected from both Windows and Linux machines where the counter is present.
type PerfCounterDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownPerfCounterDataSourceStreams `json:"streams,omitempty"`
	// SamplingFrequencyInSeconds - The number of seconds between consecutive counter measurements (samples).
	SamplingFrequencyInSeconds *int32 `json:"samplingFrequencyInSeconds,omitempty"`
	// CounterSpecifiers - A list of specifier names of the performance counters you want to collect.
	// Use a wildcard (*) to collect a counter for all instances.
	// To get a list of performance counters on Windows, run the command 'typeperf'.
	CounterSpecifiers *[]string `json:"counterSpecifiers,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// ResourceForUpdate definition of ARM tracked top level resource properties for update operation.
type ResourceForUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceForUpdate.
func (rfu ResourceForUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rfu.Tags != nil {
		objectMap["tags"] = rfu.Tags
	}
	return json.Marshal(objectMap)
}

// Rule definition of what monitoring data to collect and where that data should be sent.
type Rule struct {
	// Description - Description of the data collection rule.
	Description *string `json:"description,omitempty"`
	// ImmutableID - READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *RuleMetadata `json:"metadata,omitempty"`
	// StreamDeclarations - Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations"`
	// DataSources - The specification of data sources.
	// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
	DataSources *RuleDataSources `json:"dataSources,omitempty"`
	// Destinations - The specification of destinations.
	Destinations *RuleDestinations `json:"destinations,omitempty"`
	// DataFlows - The specification of data flows.
	DataFlows *[]DataFlow `json:"dataFlows,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleProvisioningStateCreating', 'KnownDataCollectionRuleProvisioningStateUpdating', 'KnownDataCollectionRuleProvisioningStateDeleting', 'KnownDataCollectionRuleProvisioningStateSucceeded', 'KnownDataCollectionRuleProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for Rule.
func (r Rule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Description != nil {
		objectMap["description"] = r.Description
	}
	if r.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = r.DataCollectionEndpointID
	}
	if r.StreamDeclarations != nil {
		objectMap["streamDeclarations"] = r.StreamDeclarations
	}
	if r.DataSources != nil {
		objectMap["dataSources"] = r.DataSources
	}
	if r.Destinations != nil {
		objectMap["destinations"] = r.Destinations
	}
	if r.DataFlows != nil {
		objectMap["dataFlows"] = r.DataFlows
	}
	return json.Marshal(objectMap)
}

// RuleAssociation definition of association of a data collection rule with a monitored Azure resource.
type RuleAssociation struct {
	// Description - Description of the association.
	Description *string `json:"description,omitempty"`
	// DataCollectionRuleID - The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleAssociationProvisioningStateCreating', 'KnownDataCollectionRuleAssociationProvisioningStateUpdating', 'KnownDataCollectionRuleAssociationProvisioningStateDeleting', 'KnownDataCollectionRuleAssociationProvisioningStateSucceeded', 'KnownDataCollectionRuleAssociationProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *RuleAssociationMetadata `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleAssociation.
func (ra RuleAssociation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.Description != nil {
		objectMap["description"] = ra.Description
	}
	if ra.DataCollectionRuleID != nil {
		objectMap["dataCollectionRuleId"] = ra.DataCollectionRuleID
	}
	if ra.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = ra.DataCollectionEndpointID
	}
	return json.Marshal(objectMap)
}

// RuleAssociationMetadata metadata about the resource
type RuleAssociationMetadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleAssociationMetadata.
func (ra RuleAssociationMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RuleAssociationProxyOnlyResource definition of generic ARM proxy resource.
type RuleAssociationProxyOnlyResource struct {
	autorest.Response `json:"-"`
	// RuleAssociationProxyOnlyResourceProperties - Resource properties.
	*RuleAssociationProxyOnlyResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *RuleAssociationProxyOnlyResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleAssociationProxyOnlyResource.
func (rapor RuleAssociationProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rapor.RuleAssociationProxyOnlyResourceProperties != nil {
		objectMap["properties"] = rapor.RuleAssociationProxyOnlyResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleAssociationProxyOnlyResource struct.
func (rapor *RuleAssociationProxyOnlyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleAssociationProxyOnlyResourceProperties RuleAssociationProxyOnlyResourceProperties
				err = json.Unmarshal(*v, &ruleAssociationProxyOnlyResourceProperties)
				if err != nil {
					return err
				}
				rapor.RuleAssociationProxyOnlyResourceProperties = &ruleAssociationProxyOnlyResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rapor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rapor.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rapor.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rapor.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData RuleAssociationProxyOnlyResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rapor.SystemData = &systemData
			}
		}
	}

	return nil
}

// RuleAssociationProxyOnlyResourceListResult a pageable list of resources.
type RuleAssociationProxyOnlyResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]RuleAssociationProxyOnlyResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RuleAssociationProxyOnlyResourceListResultIterator provides access to a complete listing of
// RuleAssociationProxyOnlyResource values.
type RuleAssociationProxyOnlyResourceListResultIterator struct {
	i    int
	page RuleAssociationProxyOnlyResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RuleAssociationProxyOnlyResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationProxyOnlyResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RuleAssociationProxyOnlyResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RuleAssociationProxyOnlyResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RuleAssociationProxyOnlyResourceListResultIterator) Response() RuleAssociationProxyOnlyResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RuleAssociationProxyOnlyResourceListResultIterator) Value() RuleAssociationProxyOnlyResource {
	if !iter.page.NotDone() {
		return RuleAssociationProxyOnlyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RuleAssociationProxyOnlyResourceListResultIterator type.
func NewRuleAssociationProxyOnlyResourceListResultIterator(page RuleAssociationProxyOnlyResourceListResultPage) RuleAssociationProxyOnlyResourceListResultIterator {
	return RuleAssociationProxyOnlyResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (raporlr RuleAssociationProxyOnlyResourceListResult) IsEmpty() bool {
	return raporlr.Value == nil || len(*raporlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (raporlr RuleAssociationProxyOnlyResourceListResult) hasNextLink() bool {
	return raporlr.NextLink != nil && len(*raporlr.NextLink) != 0
}

// ruleAssociationProxyOnlyResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (raporlr RuleAssociationProxyOnlyResourceListResult) ruleAssociationProxyOnlyResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !raporlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(raporlr.NextLink)))
}

// RuleAssociationProxyOnlyResourceListResultPage contains a page of RuleAssociationProxyOnlyResource
// values.
type RuleAssociationProxyOnlyResourceListResultPage struct {
	fn      func(context.Context, RuleAssociationProxyOnlyResourceListResult) (RuleAssociationProxyOnlyResourceListResult, error)
	raporlr RuleAssociationProxyOnlyResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RuleAssociationProxyOnlyResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationProxyOnlyResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.raporlr)
		if err != nil {
			return err
		}
		page.raporlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RuleAssociationProxyOnlyResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RuleAssociationProxyOnlyResourceListResultPage) NotDone() bool {
	return !page.raporlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RuleAssociationProxyOnlyResourceListResultPage) Response() RuleAssociationProxyOnlyResourceListResult {
	return page.raporlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RuleAssociationProxyOnlyResourceListResultPage) Values() []RuleAssociationProxyOnlyResource {
	if page.raporlr.IsEmpty() {
		return nil
	}
	return *page.raporlr.Value
}

// Creates a new instance of the RuleAssociationProxyOnlyResourceListResultPage type.
func NewRuleAssociationProxyOnlyResourceListResultPage(cur RuleAssociationProxyOnlyResourceListResult, getNextPage func(context.Context, RuleAssociationProxyOnlyResourceListResult) (RuleAssociationProxyOnlyResourceListResult, error)) RuleAssociationProxyOnlyResourceListResultPage {
	return RuleAssociationProxyOnlyResourceListResultPage{
		fn:      getNextPage,
		raporlr: cur,
	}
}

// RuleAssociationProxyOnlyResourceProperties resource properties.
type RuleAssociationProxyOnlyResourceProperties struct {
	// Description - Description of the association.
	Description *string `json:"description,omitempty"`
	// DataCollectionRuleID - The resource ID of the data collection rule that is to be associated.
	DataCollectionRuleID *string `json:"dataCollectionRuleId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that is to be associated.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleAssociationProvisioningStateCreating', 'KnownDataCollectionRuleAssociationProvisioningStateUpdating', 'KnownDataCollectionRuleAssociationProvisioningStateDeleting', 'KnownDataCollectionRuleAssociationProvisioningStateSucceeded', 'KnownDataCollectionRuleAssociationProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleAssociationProvisioningState `json:"provisioningState,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *RuleAssociationMetadata `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleAssociationProxyOnlyResourceProperties.
func (rapor RuleAssociationProxyOnlyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rapor.Description != nil {
		objectMap["description"] = rapor.Description
	}
	if rapor.DataCollectionRuleID != nil {
		objectMap["dataCollectionRuleId"] = rapor.DataCollectionRuleID
	}
	if rapor.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = rapor.DataCollectionEndpointID
	}
	return json.Marshal(objectMap)
}

// RuleAssociationProxyOnlyResourceSystemData metadata pertaining to creation and last modification of the
// resource.
type RuleAssociationProxyOnlyResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// RuleDataSources the specification of data sources.
// This property is optional and can be omitted if the rule is meant to be used via direct calls to the
// provisioned endpoint.
type RuleDataSources struct {
	// PerformanceCounters - The list of performance counter data source configurations.
	PerformanceCounters *[]PerfCounterDataSource `json:"performanceCounters,omitempty"`
	// WindowsEventLogs - The list of Windows Event Log data source configurations.
	WindowsEventLogs *[]WindowsEventLogDataSource `json:"windowsEventLogs,omitempty"`
	// Syslog - The list of Syslog data source configurations.
	Syslog *[]SyslogDataSource `json:"syslog,omitempty"`
	// Extensions - The list of Azure VM extension data source configurations.
	Extensions *[]ExtensionDataSource `json:"extensions,omitempty"`
	// LogFiles - The list of Log files source configurations.
	LogFiles *[]LogFilesDataSource `json:"logFiles,omitempty"`
	// IisLogs - The list of IIS logs source configurations.
	IisLogs *[]IisLogsDataSource `json:"iisLogs,omitempty"`
}

// RuleDestinations the specification of destinations.
type RuleDestinations struct {
	// LogAnalytics - List of Log Analytics destinations.
	LogAnalytics *[]LogAnalyticsDestination `json:"logAnalytics,omitempty"`
	// AzureMonitorMetrics - Azure Monitor Metrics destination.
	AzureMonitorMetrics *DestinationsSpecAzureMonitorMetrics `json:"azureMonitorMetrics,omitempty"`
}

// RuleMetadata metadata about the resource
type RuleMetadata struct {
	// ProvisionedBy - READ-ONLY; Azure offering managing this resource on-behalf-of customer.
	ProvisionedBy *string `json:"provisionedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleMetadata.
func (r RuleMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RuleResource definition of ARM tracked top level resource.
type RuleResource struct {
	autorest.Response `json:"-"`
	// RuleResourceProperties - Resource properties.
	*RuleResourceProperties `json:"properties,omitempty"`
	// Location - The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Kind - The kind of the resource. Possible values include: 'KnownDataCollectionRuleResourceKindLinux', 'KnownDataCollectionRuleResourceKindWindows'
	Kind KnownDataCollectionRuleResourceKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Fully qualified ID of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; Resource entity tag (ETag).
	Etag *string `json:"etag,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *RuleResourceSystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleResource.
func (rr RuleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RuleResourceProperties != nil {
		objectMap["properties"] = rr.RuleResourceProperties
	}
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	if rr.Kind != "" {
		objectMap["kind"] = rr.Kind
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RuleResource struct.
func (rr *RuleResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ruleResourceProperties RuleResourceProperties
				err = json.Unmarshal(*v, &ruleResourceProperties)
				if err != nil {
					return err
				}
				rr.RuleResourceProperties = &ruleResourceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		case "kind":
			if v != nil {
				var kind KnownDataCollectionRuleResourceKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				rr.Etag = &etag
			}
		case "systemData":
			if v != nil {
				var systemData RuleResourceSystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rr.SystemData = &systemData
			}
		}
	}

	return nil
}

// RuleResourceListResult a pageable list of resources.
type RuleResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of resources.
	Value *[]RuleResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RuleResourceListResultIterator provides access to a complete listing of RuleResource values.
type RuleResourceListResultIterator struct {
	i    int
	page RuleResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RuleResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RuleResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RuleResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RuleResourceListResultIterator) Response() RuleResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RuleResourceListResultIterator) Value() RuleResource {
	if !iter.page.NotDone() {
		return RuleResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RuleResourceListResultIterator type.
func NewRuleResourceListResultIterator(page RuleResourceListResultPage) RuleResourceListResultIterator {
	return RuleResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rrlr RuleResourceListResult) IsEmpty() bool {
	return rrlr.Value == nil || len(*rrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rrlr RuleResourceListResult) hasNextLink() bool {
	return rrlr.NextLink != nil && len(*rrlr.NextLink) != 0
}

// ruleResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rrlr RuleResourceListResult) ruleResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rrlr.NextLink)))
}

// RuleResourceListResultPage contains a page of RuleResource values.
type RuleResourceListResultPage struct {
	fn   func(context.Context, RuleResourceListResult) (RuleResourceListResult, error)
	rrlr RuleResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RuleResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rrlr)
		if err != nil {
			return err
		}
		page.rrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RuleResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RuleResourceListResultPage) NotDone() bool {
	return !page.rrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RuleResourceListResultPage) Response() RuleResourceListResult {
	return page.rrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RuleResourceListResultPage) Values() []RuleResource {
	if page.rrlr.IsEmpty() {
		return nil
	}
	return *page.rrlr.Value
}

// Creates a new instance of the RuleResourceListResultPage type.
func NewRuleResourceListResultPage(cur RuleResourceListResult, getNextPage func(context.Context, RuleResourceListResult) (RuleResourceListResult, error)) RuleResourceListResultPage {
	return RuleResourceListResultPage{
		fn:   getNextPage,
		rrlr: cur,
	}
}

// RuleResourceProperties resource properties.
type RuleResourceProperties struct {
	// Description - Description of the data collection rule.
	Description *string `json:"description,omitempty"`
	// ImmutableID - READ-ONLY; The immutable ID of this data collection rule. This property is READ-ONLY.
	ImmutableID *string `json:"immutableId,omitempty"`
	// DataCollectionEndpointID - The resource ID of the data collection endpoint that this rule can be used with.
	DataCollectionEndpointID *string `json:"dataCollectionEndpointId,omitempty"`
	// Metadata - READ-ONLY; Metadata about the resource
	Metadata *RuleMetadata `json:"metadata,omitempty"`
	// StreamDeclarations - Declaration of custom streams used in this rule.
	StreamDeclarations map[string]*StreamDeclaration `json:"streamDeclarations"`
	// DataSources - The specification of data sources.
	// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
	DataSources *RuleDataSources `json:"dataSources,omitempty"`
	// Destinations - The specification of destinations.
	Destinations *RuleDestinations `json:"destinations,omitempty"`
	// DataFlows - The specification of data flows.
	DataFlows *[]DataFlow `json:"dataFlows,omitempty"`
	// ProvisioningState - READ-ONLY; The resource provisioning state. Possible values include: 'KnownDataCollectionRuleProvisioningStateCreating', 'KnownDataCollectionRuleProvisioningStateUpdating', 'KnownDataCollectionRuleProvisioningStateDeleting', 'KnownDataCollectionRuleProvisioningStateSucceeded', 'KnownDataCollectionRuleProvisioningStateFailed'
	ProvisioningState KnownDataCollectionRuleProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleResourceProperties.
func (rr RuleResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.Description != nil {
		objectMap["description"] = rr.Description
	}
	if rr.DataCollectionEndpointID != nil {
		objectMap["dataCollectionEndpointId"] = rr.DataCollectionEndpointID
	}
	if rr.StreamDeclarations != nil {
		objectMap["streamDeclarations"] = rr.StreamDeclarations
	}
	if rr.DataSources != nil {
		objectMap["dataSources"] = rr.DataSources
	}
	if rr.Destinations != nil {
		objectMap["destinations"] = rr.Destinations
	}
	if rr.DataFlows != nil {
		objectMap["dataFlows"] = rr.DataFlows
	}
	return json.Marshal(objectMap)
}

// RuleResourceSystemData metadata pertaining to creation and last modification of the resource.
type RuleResourceSystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// StreamDeclaration declaration of a custom stream.
type StreamDeclaration struct {
	// Columns - List of columns used by data in this stream.
	Columns *[]ColumnDefinition `json:"columns,omitempty"`
}

// SyslogDataSource definition of which syslog data will be collected and how it will be collected.
// Only collected from Linux machines.
type SyslogDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownSyslogDataSourceStreams `json:"streams,omitempty"`
	// FacilityNames - The list of facility names.
	FacilityNames *[]KnownSyslogDataSourceFacilityNames `json:"facilityNames,omitempty"`
	// LogLevels - The log levels to collect.
	LogLevels *[]KnownSyslogDataSourceLogLevels `json:"logLevels,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// WindowsEventLogDataSource definition of which Windows Event Log events will be collected and how they
// will be collected.
// Only collected from Windows machines.
type WindowsEventLogDataSource struct {
	// Streams - List of streams that this data source will be sent to.
	// A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
	Streams *[]KnownWindowsEventLogDataSourceStreams `json:"streams,omitempty"`
	// XPathQueries - A list of Windows Event Log queries in XPATH format.
	XPathQueries *[]string `json:"xPathQueries,omitempty"`
	// Name - A friendly name for the data source.
	// This name should be unique across all data sources (regardless of type) within the data collection rule.
	Name *string `json:"name,omitempty"`
}
