#pragma once


#ifndef __d3dcommon_h__

typedef enum D3D_MIN_PRECISION {
    D3D_MIN_PRECISION_DEFAULT = 0,
    D3D_MIN_PRECISION_FLOAT_16 = 1,
    D3D_MIN_PRECISION_FLOAT_2_8 = 2,
    D3D_MIN_PRECISION_RESERVED = 3,
    D3D_MIN_PRECISION_SINT_16 = 4,
    D3D_MIN_PRECISION_UINT_16 = 5,
    D3D_MIN_PRECISION_ANY_16 = 0xf0,
    D3D_MIN_PRECISION_ANY_10 = 0xf1
} D3D_MIN_PRECISION;

typedef enum D3D_NAME {
    D3D_NAME_UNDEFINED = 0,
    D3D_NAME_POSITION = 1,
    D3D_NAME_CLIP_DISTANCE = 2,
    D3D_NAME_CULL_DISTANCE = 3,
    D3D_NAME_RENDER_TARGET_ARRAY_INDEX = 4,
    D3D_NAME_VIEWPORT_ARRAY_INDEX = 5,
    D3D_NAME_VERTEX_ID = 6,
    D3D_NAME_PRIMITIVE_ID = 7,
    D3D_NAME_INSTANCE_ID = 8,
    D3D_NAME_IS_FRONT_FACE = 9,
    D3D_NAME_SAMPLE_INDEX = 10,
    D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR = 11,
    D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR = 12,
    D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR = 13,
    D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR = 14,
    D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR = 15,
    D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR = 16,
    D3D_NAME_BARYCENTRICS = 23,
    D3D_NAME_SHADINGRATE = 24,
    D3D_NAME_CULLPRIMITIVE = 25,
    D3D_NAME_TARGET = 64,
    D3D_NAME_DEPTH = 65,
    D3D_NAME_COVERAGE = 66,
    D3D_NAME_DEPTH_GREATER_EQUAL = 67,
    D3D_NAME_DEPTH_LESS_EQUAL = 68,
    D3D10_NAME_UNDEFINED = 0,
    D3D10_NAME_POSITION = 1,
    D3D10_NAME_CLIP_DISTANCE = 2,
    D3D10_NAME_CULL_DISTANCE = 3,
    D3D10_NAME_RENDER_TARGET_ARRAY_INDEX = 4,
    D3D10_NAME_VIEWPORT_ARRAY_INDEX = 5,
    D3D10_NAME_VERTEX_ID = 6,
    D3D10_NAME_PRIMITIVE_ID = 7,
    D3D10_NAME_INSTANCE_ID = 8,
    D3D10_NAME_IS_FRONT_FACE = 9,
    D3D10_NAME_SAMPLE_INDEX = 10,
    D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR = 11,
    D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR = 12,
    D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR = 13,
    D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR = 14,
    D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR = 15,
    D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR = 16,
    D3D10_NAME_TARGET = 64,
    D3D10_NAME_DEPTH = 65,
    D3D10_NAME_COVERAGE = 66,
    D3D11_NAME_DEPTH_GREATER_EQUAL = 67,
    D3D11_NAME_DEPTH_LESS_EQUAL = 68
} D3D_NAME;


typedef enum D3D_REGISTER_COMPONENT_TYPE {
    D3D_REGISTER_COMPONENT_UNKNOWN = 0,
    D3D_REGISTER_COMPONENT_UINT32 = 1,
    D3D_REGISTER_COMPONENT_SINT32 = 2,
    D3D_REGISTER_COMPONENT_FLOAT32 = 3,
    D3D10_REGISTER_COMPONENT_UNKNOWN = 0,
    D3D10_REGISTER_COMPONENT_UINT32 = 1,
    D3D10_REGISTER_COMPONENT_SINT32 = 2,
    D3D10_REGISTER_COMPONENT_FLOAT32 = 3
} D3D_REGISTER_COMPONENT_TYPE;

typedef enum D3D_SRV_DIMENSION {
    D3D_SRV_DIMENSION_UNKNOWN = 0,
    D3D_SRV_DIMENSION_BUFFER = 1,
    D3D_SRV_DIMENSION_TEXTURE1D = 2,
    D3D_SRV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D_SRV_DIMENSION_TEXTURE2D = 4,
    D3D_SRV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D_SRV_DIMENSION_TEXTURE2DMS = 6,
    D3D_SRV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D_SRV_DIMENSION_TEXTURE3D = 8,
    D3D_SRV_DIMENSION_TEXTURECUBE = 9,
    D3D_SRV_DIMENSION_TEXTURECUBEARRAY = 10,
    D3D_SRV_DIMENSION_BUFFEREX = 11,
    D3D10_SRV_DIMENSION_UNKNOWN = 0,
    D3D10_SRV_DIMENSION_BUFFER = 1,
    D3D10_SRV_DIMENSION_TEXTURE1D = 2,
    D3D10_SRV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D10_SRV_DIMENSION_TEXTURE2D = 4,
    D3D10_SRV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D10_SRV_DIMENSION_TEXTURE2DMS = 6,
    D3D10_SRV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D10_SRV_DIMENSION_TEXTURE3D = 8,
    D3D10_SRV_DIMENSION_TEXTURECUBE = 9,
    D3D10_1_SRV_DIMENSION_UNKNOWN = 0,
    D3D10_1_SRV_DIMENSION_BUFFER = 1,
    D3D10_1_SRV_DIMENSION_TEXTURE1D = 2,
    D3D10_1_SRV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D10_1_SRV_DIMENSION_TEXTURE2D = 4,
    D3D10_1_SRV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D10_1_SRV_DIMENSION_TEXTURE2DMS = 6,
    D3D10_1_SRV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D10_1_SRV_DIMENSION_TEXTURE3D = 8,
    D3D10_1_SRV_DIMENSION_TEXTURECUBE = 9,
    D3D10_1_SRV_DIMENSION_TEXTURECUBEARRAY = 10,
    D3D11_SRV_DIMENSION_UNKNOWN = 0,
    D3D11_SRV_DIMENSION_BUFFER = 1,
    D3D11_SRV_DIMENSION_TEXTURE1D = 2,
    D3D11_SRV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_SRV_DIMENSION_TEXTURE2D = 4,
    D3D11_SRV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_SRV_DIMENSION_TEXTURE2DMS = 6,
    D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D11_SRV_DIMENSION_TEXTURE3D = 8,
    D3D11_SRV_DIMENSION_TEXTURECUBE = 9,
    D3D11_SRV_DIMENSION_TEXTURECUBEARRAY = 10,
    D3D11_SRV_DIMENSION_BUFFEREX = 11
} D3D_SRV_DIMENSION;

#endif


#ifndef _D3D11_CONSTANTS
#define _D3D11_CONSTANTS
#define D3D11_16BIT_INDEX_STRIP_CUT_VALUE (0xffff)

#define D3D11_32BIT_INDEX_STRIP_CUT_VALUE (0xffffffff)

#define D3D11_8BIT_INDEX_STRIP_CUT_VALUE (0xff)

#define D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT (9)

#define D3D11_CLIP_OR_CULL_DISTANCE_COUNT (8)

#define D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT (2)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT (14)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS (4)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT (32)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT (15)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT (16)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS (4)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT (15)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST (1)

#define D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS (1)

#define D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT (64)

#define D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS (4)

#define D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT (1)

#define D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST (1)

#define D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS (1)

#define D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT (32)

#define D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS (1)

#define D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT (128)

#define D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST (1)

#define D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS (1)

#define D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT (128)

#define D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS (1)

#define D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT (16)

#define D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST (1)

#define D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS (1)

#define D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT (16)

#define D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT (32)

#define D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS (4)

#define D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT (32)

#define D3D11_COMMONSHADER_TEMP_REGISTER_COUNT (4096)

#define D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST (3)

#define D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS (3)

#define D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX (10)

#define D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN (-10)

#define D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE (-8)

#define D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE (7)

#define D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (256)

#define D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP (64)

#define D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (240)

#define D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP (68)

#define D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (224)

#define D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP (72)

#define D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (208)

#define D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP (76)

#define D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (192)

#define D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP (84)

#define D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (176)

#define D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP (92)

#define D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (160)

#define D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP (100)

#define D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (144)

#define D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP (112)

#define D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (128)

#define D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP (128)

#define D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (112)

#define D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP (144)

#define D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (96)

#define D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP (168)

#define D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (80)

#define D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP (204)

#define D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (64)

#define D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP (256)

#define D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (48)

#define D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP (340)

#define D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (32)

#define D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP (512)

#define D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD (16)

#define D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP (768)

#define D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION (1)

#define D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT (256)

#define D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP (768)

#define D3D11_CS_4_X_THREAD_GROUP_MAX_X (768)

#define D3D11_CS_4_X_THREAD_GROUP_MAX_Y (768)

#define D3D11_CS_4_X_UAV_REGISTER_COUNT (1)

#define D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION (65535)

#define D3D11_CS_TGSM_REGISTER_COUNT (8192)

#define D3D11_CS_TGSM_REGISTER_READS_PER_INST (1)

#define D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS (1)

#define D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS (1)

#define D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP (1024)

#define D3D11_CS_THREAD_GROUP_MAX_X (1024)

#define D3D11_CS_THREAD_GROUP_MAX_Y (1024)

#define D3D11_CS_THREAD_GROUP_MAX_Z (64)

#define D3D11_CS_THREAD_GROUP_MIN_X (1)

#define D3D11_CS_THREAD_GROUP_MIN_Y (1)

#define D3D11_CS_THREAD_GROUP_MIN_Z (1)

#define D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL (16384)

#define D3D11_DEFAULT_DEPTH_BIAS (0)

#define D3D11_DEFAULT_DEPTH_BIAS_CLAMP 0.0f
#define D3D11_DEFAULT_MAX_ANISOTROPY (16)

#define D3D11_DEFAULT_MIP_LOD_BIAS 0.0f
#define D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX (0)

#define D3D11_DEFAULT_SAMPLE_MASK (0xffffffff)

#define D3D11_DEFAULT_SCISSOR_ENDX (0)

#define D3D11_DEFAULT_SCISSOR_ENDY (0)

#define D3D11_DEFAULT_SCISSOR_STARTX (0)

#define D3D11_DEFAULT_SCISSOR_STARTY (0)

#define D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS 0.0f
#define D3D11_DEFAULT_STENCIL_READ_MASK (0xff)

#define D3D11_DEFAULT_STENCIL_REFERENCE (0)

#define D3D11_DEFAULT_STENCIL_WRITE_MASK (0xff)

#define D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX (0)

#define D3D11_DEFAULT_VIEWPORT_HEIGHT (0)

#define D3D11_DEFAULT_VIEWPORT_MAX_DEPTH 0.0f
#define D3D11_DEFAULT_VIEWPORT_MIN_DEPTH 0.0f
#define D3D11_DEFAULT_VIEWPORT_TOPLEFTX (0)

#define D3D11_DEFAULT_VIEWPORT_TOPLEFTY (0)

#define D3D11_DEFAULT_VIEWPORT_WIDTH (0)

#define D3D11_FLOAT32_MAX         (3.402823466e+38f)
#define D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT (32)

#define D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT (8)

#define D3D11_MAX_MAXANISOTROPY (16)

#define D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT (32)

#define D3D11_VIEWPORT_BOUNDS_MAX (32767)

#define D3D11_VIEWPORT_BOUNDS_MIN (-32768)

#define D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX (15)

#define D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE (16)

#define D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL (0xffffffff)

#define D3D11_KEEP_UNORDERED_ACCESS_VIEWS (0xffffffff)

#define D3D11_SHADER_MAJOR_VERSION (5)

#define D3D11_SHADER_MAX_INSTANCES (65535)

#define D3D11_SHADER_MAX_INTERFACES (253)

#define D3D11_SHADER_MAX_INTERFACE_CALL_SITES (4096)

#define D3D11_SHADER_MAX_TYPES (65535)

#define D3D11_SHADER_MINOR_VERSION (0)

#define D3D11_VS_OUTPUT_REGISTER_COUNT (32)

#define D3D11_OMAC_SIZE (16)

#define D3D11_PS_CS_UAV_REGISTER_COMPONENTS (1)

#define D3D11_PS_CS_UAV_REGISTER_COUNT (8)

#define D3D11_PS_CS_UAV_REGISTER_READS_PER_INST (1)

#define D3D11_PS_CS_UAV_REGISTER_READ_PORTS (1)

#define D3D11_PS_FRONTFACING_DEFAULT_VALUE (0xffffffff)

#define D3D11_PS_FRONTFACING_FALSE_VALUE (0)

#define D3D11_PS_FRONTFACING_TRUE_VALUE (0xffffffff)

#define D3D11_PS_INPUT_REGISTER_COMPONENTS (4)

#define D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT (32)

#define D3D11_PS_INPUT_REGISTER_COUNT (32)

#define D3D11_PS_INPUT_REGISTER_READS_PER_INST (2)

#define D3D11_PS_INPUT_REGISTER_READ_PORTS (1)

#define D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT (0.0f)
#define D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS (1)

#define D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT (32)

#define D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT (1)

#define D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS (1)

#define D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT (32)

#define D3D11_PS_OUTPUT_MASK_REGISTER_COUNT (1)

#define D3D11_PS_OUTPUT_REGISTER_COMPONENTS (4)

#define D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT (32)

#define D3D11_PS_OUTPUT_REGISTER_COUNT (8)

#define D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT (0.5f)
#define D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT (16)

#define D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE (4096)

#define D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP (27)

#define D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT (4096)

#define D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE (4096)

#define D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP (32)

#define D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP (32)

#define D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION (16384)

#define D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT (1024)

#define D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT (4096)

#define D3D11_REQ_MAXANISOTROPY (16)

#define D3D11_REQ_MIP_LEVELS (15)

#define D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES (2048)

#define D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE (4096)

#define D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH (16384)

#define D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM (128)

#define D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM (0.25f)
#define D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM (2048)

#define D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP (20)

#define D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE (4096)

#define D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION (2048)

#define D3D11_REQ_TEXTURE1D_U_DIMENSION (16384)

#define D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION (2048)

#define D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION (16384)

#define D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION (2048)

#define D3D11_REQ_TEXTURECUBE_DIMENSION (16384)

#define D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL (0)

#define D3D11_SHIFT_INSTRUCTION_PAD_VALUE (0)

#define D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT (5)

#define D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES (2048)

#define D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES (512)

#define D3D11_SO_BUFFER_SLOT_COUNT (4)

#define D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP (0xffffffff)

#define D3D11_SO_NO_RASTERIZED_STREAM (0xffffffff)

#define D3D11_SO_OUTPUT_COMPONENT_COUNT (128)

#define D3D11_SO_STREAM_COUNT (4)

#define D3D11_SPEC_DATE_DAY (16)

#define D3D11_SPEC_DATE_MONTH (5)

#define D3D11_SPEC_DATE_YEAR (2011)

#define D3D11_SPEC_VERSION                   (1.07)
#define D3D11_SRGB_GAMMA                     (2.2f)
#define D3D11_SRGB_TO_FLOAT_DENOMINATOR_1    (12.92f)
#define D3D11_SRGB_TO_FLOAT_DENOMINATOR_2    (1.055f)
#define D3D11_SRGB_TO_FLOAT_EXPONENT         (2.4f)
#define D3D11_SRGB_TO_FLOAT_OFFSET           (0.055f)
#define D3D11_SRGB_TO_FLOAT_THRESHOLD        (0.04045f)
#define D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP (0.5f)
#define D3D11_STANDARD_COMPONENT_BIT_COUNT (32)

#define D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED (64)

#define D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE (4)

#define D3D11_STANDARD_PIXEL_COMPONENT_COUNT (128)

#define D3D11_STANDARD_PIXEL_ELEMENT_COUNT (32)

#define D3D11_STANDARD_VECTOR_SIZE (4)

#define D3D11_STANDARD_VERTEX_ELEMENT_COUNT (32)

#define D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT (64)


typedef D3D_NAME D3D10_NAME;
typedef D3D_REGISTER_COMPONENT_TYPE D3D10_REGISTER_COMPONENT_TYPE;
typedef D3D_SRV_DIMENSION D3D11_SRV_DIMENSION;

typedef enum D3D11_UAV_DIMENSION {
    D3D11_UAV_DIMENSION_UNKNOWN = 0,
    D3D11_UAV_DIMENSION_BUFFER = 1,
    D3D11_UAV_DIMENSION_TEXTURE1D = 2,
    D3D11_UAV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D11_UAV_DIMENSION_TEXTURE2D = 4,
    D3D11_UAV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D11_UAV_DIMENSION_TEXTURE3D = 8
} D3D11_UAV_DIMENSION;

#endif