/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.util;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.InstrumentationException;
import alt.jiapi.MethodInstrumentor;
import alt.jiapi.Rule;
import alt.jiapi.reflect.BranchInstruction;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.InstructionFactory;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.instruction.Invocation;
import alt.jiapi.reflect.instruction.OpcodeGroups;
import alt.jiapi.util.HotSpot;
import alt.jiapi.util.HotSpotAdvice;
import alt.jiapi.util.HotSpotLocator;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.apache.log4j.Category;

public class HotSpotAdvisor {
    private static Category log = Category.getInstance(HotSpotAdvisor.class);
    public static final byte[] INVOCATIONS = OpcodeGroups.INVOKE_INSTRUCTIONS;
    public static final byte[] RETURNS = OpcodeGroups.RETURN_INSTRUCTIONS;
    public static final byte[] FIELD_ACCESSES = OpcodeGroups.FIELD_ACCESS_INSTRUCTIONS;

    public HotSpotAdvisor(InstrumentationDescriptor id, HotSpotAdvice advice, byte hotSpot) {
        this(id, advice, new byte[]{hotSpot});
    }

    public HotSpotAdvisor(InstrumentationDescriptor id, HotSpotAdvice advice, byte[] hotSpots) {
        this(id, advice, hotSpots, "*");
    }

    public HotSpotAdvisor(InstrumentationDescriptor id, HotSpotAdvice advice, byte[] hotSpots, String resolution) {
        try {
            id.addExclusionRule(advice.getClass().getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        id.addInstrumentor(new HSInstrumentor(advice, hotSpots, resolution));
    }

    public void checkForBranchTarget(Instruction firstHotSpotInstruction, InstructionList methodList, Instruction firstBeforeInstruction) {
        for (int idx = 0; idx < methodList.size(); ++idx) {
            BranchInstruction bi;
            Instruction i = methodList.get(idx);
            if (!(i instanceof BranchInstruction) || (bi = (BranchInstruction)i).getTarget() != firstHotSpotInstruction) continue;
            bi.setTarget(firstBeforeInstruction);
        }
    }

    private class HSInstrumentor
    extends MethodInstrumentor {
        private byte[] hotSpots;
        private JiapiMethod adviceMethod;
        private Rule rule;

        HSInstrumentor(HotSpotAdvice advice, byte[] hotSpots, String resolution) {
            try {
                this.rule = new Rule(resolution);
                Loader l = new Loader();
                log.debug((Object)("Loading advice " + advice.getClass().getName()));
                JiapiClass clazz = l.loadClass(advice.getClass().getName());
                log.debug((Object)"Getting advice() method ");
                this.adviceMethod = clazz.getDeclaredMethod("advice", new String[0]);
                this.hotSpots = hotSpots;
            }
            catch (NoSuchMethodException nsme) {
                log.error((Object)"Internal error: Could not find HotSpotAdvice.advice() method", (Throwable)nsme);
                throw new InstrumentationException("Could not find method advice() from " + advice.getClass() + ": " + nsme);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)"Internal error: Could load class HotSpotAdvice", (Throwable)cnfe);
                throw new InstrumentationException("Could not load class " + advice.getClass() + ": " + cnfe);
            }
            catch (IOException ioe) {
                log.error((Object)"Internal error: Could load class HotSpotAdvice", (Throwable)ioe);
                throw new InstrumentationException("Could not load class " + advice.getClass() + ": " + ioe);
            }
            catch (Exception e) {
                log.error((Object)"Failed to initialize HotSpotAdvisor", (Throwable)e);
                throw new InstrumentationException("Failed to initialize HotSpotAdvisor: " + e);
            }
        }

        public void instrument(JiapiMethod m) throws InstrumentationException {
            log.debug((Object)("Instrumenting " + m.getDeclaringClass().getName() + "#" + m));
            HotSpotLocator hsl = new HotSpotLocator(m.getInstructionList(), this.hotSpots);
            HotSpot[] hsa = hsl.getHotSpots();
            for (int i = 0; i < hsa.length; ++i) {
                HotSpot hs = hsa[i];
                if (!this.rule.match(hs.getName())) continue;
                this.copyInstructions(hs);
            }
        }

        private void copyInstructions(HotSpot hs) {
            InstructionList am_il = this.adviceMethod.getInstructionList();
            InstructionList il = hs.getInstructionList();
            Instruction firstHotSpotInstruction = il.get(0);
            am_il = this.changeLocalVars(am_il, il.getDeclaringMethod().getMaxLocals() - 1);
            int idx = this.indexOfDoHotSpot();
            if (idx == -1) {
                log.debug((Object)"Replacing hotspot with advice-method");
                il.clear();
                il.add(am_il);
                return;
            }
            InstructionList before = am_il.createView(0, idx - 1);
            if (before.size() > 0) {
                HotSpotAdvisor.this.checkForBranchTarget(firstHotSpotInstruction, il.getDeclaringMethod().getInstructionList(), before.get(0));
            }
            InstructionList after = null;
            if (idx + 1 < am_il.size()) {
                after = am_il.createView(idx + 1, am_il.size() - 1);
            }
            il.insert(0, before);
            if (after != null) {
                il.add(after);
            }
            this.processAdviceTriggers(il, hs);
        }

        private int indexOfDoHotSpot() {
            InstructionList il = this.adviceMethod.getInstructionList();
            HotSpotLocator hsl = new HotSpotLocator(il, -74);
            HotSpot[] dohsCandidates = hsl.getHotSpots();
            for (int i = 0; i < dohsCandidates.length; ++i) {
                Invocation inv = (Invocation)dohsCandidates[i].getHotSpotInstruction();
                if (!inv.getClassName().equals(this.adviceMethod.getDeclaringClass().getName()) || !"doHotSpot".equals(inv.getMethodName())) continue;
                return il.indexOf(inv);
            }
            return -1;
        }

        private InstructionList changeLocalVars(InstructionList advice, int maxLocalsInOtherList) {
            --maxLocalsInOtherList;
            InstructionList newList = new InstructionList();
            InstructionFactory factory = new InstructionFactory();
            block52: for (int i = 0; i < advice.size(); ++i) {
                Instruction ins = advice.get(i);
                newList.add(ins);
                switch (ins.getOpcode()) {
                    case 42: {
                        newList.replace(i, factory.aload(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 43: {
                        newList.replace(i, factory.aload(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 44: {
                        newList.replace(i, factory.aload(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 45: {
                        newList.replace(i, factory.aload(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 25: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 75: {
                        newList.replace(i, factory.astore(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 76: {
                        newList.replace(i, factory.astore(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 77: {
                        newList.replace(i, factory.astore(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 78: {
                        newList.replace(i, factory.astore(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 58: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 26: {
                        newList.replace(i, factory.iload(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 27: {
                        newList.replace(i, factory.iload(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 28: {
                        newList.replace(i, factory.iload(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 29: {
                        newList.replace(i, factory.iload(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 21: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 59: {
                        newList.replace(i, factory.istore(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 60: {
                        newList.replace(i, factory.istore(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 61: {
                        newList.replace(i, factory.istore(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 62: {
                        newList.replace(i, factory.istore(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 54: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 38: {
                        newList.replace(i, factory.dload(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 39: {
                        newList.replace(i, factory.dload(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 40: {
                        newList.replace(i, factory.dload(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 41: {
                        newList.replace(i, factory.dload(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 24: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 71: {
                        newList.replace(i, factory.dstore(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 72: {
                        newList.replace(i, factory.dstore(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 73: {
                        newList.replace(i, factory.dstore(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 74: {
                        newList.replace(i, factory.dstore(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 57: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 30: {
                        newList.replace(i, factory.lload(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 31: {
                        newList.replace(i, factory.lload(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 32: {
                        newList.replace(i, factory.lload(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 33: {
                        newList.replace(i, factory.lload(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 22: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 63: {
                        newList.replace(i, factory.lstore(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 64: {
                        newList.replace(i, factory.lstore(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 65: {
                        newList.replace(i, factory.lstore(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 66: {
                        newList.replace(i, factory.lstore(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 55: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 34: {
                        newList.replace(i, factory.fload(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 35: {
                        newList.replace(i, factory.fload(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 36: {
                        newList.replace(i, factory.fload(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 37: {
                        newList.replace(i, factory.fload(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 23: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                        continue block52;
                    }
                    case 67: {
                        newList.replace(i, factory.fstore(maxLocalsInOtherList));
                        continue block52;
                    }
                    case 68: {
                        newList.replace(i, factory.fstore(maxLocalsInOtherList + 1));
                        continue block52;
                    }
                    case 69: {
                        newList.replace(i, factory.fstore(maxLocalsInOtherList + 2));
                        continue block52;
                    }
                    case 70: {
                        newList.replace(i, factory.fstore(maxLocalsInOtherList + 3));
                        continue block52;
                    }
                    case 56: {
                        byte[] byArray = ins.getBytes();
                        byArray[1] = (byte)(byArray[1] + (byte)maxLocalsInOtherList);
                    }
                }
            }
            return newList;
        }

        private void processAdviceTriggers(InstructionList il, HotSpot hs) {
            InstructionFactory factory = il.getInstructionFactory();
            HotSpotLocator hsl = new HotSpotLocator(il, -74);
            HotSpot[] triggerCandidates = hsl.getHotSpots();
            for (int i = 0; i < triggerCandidates.length; ++i) {
                Invocation inv = (Invocation)triggerCandidates[i].getHotSpotInstruction();
                if (!inv.getClassName().equals(this.adviceMethod.getDeclaringClass().getName())) continue;
                int idx = il.indexOf(inv);
                InstructionList view = il.createView(idx - 1, idx + 1);
                view.clear();
                if ("getHotSpotName".equals(inv.getMethodName())) {
                    view.add(factory.pushConstant(hs.getName()));
                    continue;
                }
                if ("getArguments".equals(inv.getMethodName()) || !"getInstrumentedObject".equals(inv.getMethodName())) continue;
                JiapiMethod jm = il.getDeclaringMethod();
                int modifiers = jm.getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    view.add(factory.pushConstant(jm.getDeclaringClass().getName()));
                    view.add(factory.invoke(8, "java.lang.Class", "forName", new Signature("java.lang.Class", new String[]{"java.lang.String"})));
                    continue;
                }
                view.add(factory.aload(0));
            }
        }
    }
}

