/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleNodeConstructor
extends ExprInstruction {
    protected Expression select = null;
    protected Expression separator = null;

    public final void setSelect(Expression expression) {
        this.select = expression;
    }

    public final void setSeparator(Expression expression) {
        this.separator = expression;
    }

    public abstract void typeCheck(StaticContext var1) throws XPathException;

    public Expression analyze(StaticContext staticContext) throws XPathException {
        RoleLocator roleLocator;
        this.typeCheck(staticContext);
        if (this.separator != null) {
            this.separator = this.separator.analyze(staticContext);
            roleLocator = new RoleLocator(4, "xsl:" + this.getInstructionName() + "/separator", 0);
            this.separator = TypeChecker.staticTypeCheck(this.separator, SequenceType.SINGLE_STRING, false, roleLocator);
        }
        if (this.select != null) {
            this.select = this.select.analyze(staticContext);
            roleLocator = new RoleLocator(4, "xsl:" + this.getInstructionName() + "/content", 0);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, roleLocator);
        } else if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
                ++n;
            }
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        if (this.select != null) {
            list.add(this.select);
        }
        if (this.separator != null && !(this.separator instanceof StringValue)) {
            list.add(this.separator);
        }
    }

    public CharSequence expandChildren(XPathContext xPathContext) throws TransformerException {
        String string = " ";
        if (this.separator != null) {
            string = this.separator.evaluateAsString(xPathContext);
        }
        if (this.select != null) {
            return this.flatten(this.select.iterate(xPathContext), string);
        }
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        SequenceOutputter sequenceOutputter = new SequenceOutputter();
        sequenceOutputter.setNamePool(controller.getNamePool());
        controller.changeToSequenceOutputDestination(sequenceOutputter);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        return this.flatten(sequenceOutputter.getSequence().iterate(xPathContext), string);
    }

    private StringBuffer flatten(SequenceIterator sequenceIterator, String string) throws XPathException {
        Item item;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while ((item = sequenceIterator.next()) != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(item.getStringValue());
        }
        return stringBuffer;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.select == null ? "" : this.select.evaluateAsString(xPathContext);
        Orphan orphan = new Orphan(xPathContext.getController().getNamePool());
        orphan.setNodeKind((short)this.getItemType().getPrimitiveType());
        orphan.setStringValue(string);
        try {
            orphan.setNameCode(this.evaluateNameCode(xPathContext));
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
        return orphan;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, TransformerException {
        return -1;
    }

    public void display(int n, NamePool namePool) {
        if (this.select != null) {
            this.select.display(n, namePool);
        } else if (this.children.length == 0) {
            System.err.println(ExpressionTool.indent(n) + "empty content");
        } else {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1, namePool);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

